/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.logging;

import io.trino.plugin.base.logging.FormatInterpolator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFormatInterpolator {
    @Test
    public void testNullInterpolation() {
        FormatInterpolator interpolator = new FormatInterpolator(null, (FormatInterpolator.InterpolatedValue[])SingleTestValue.values());
        Assertions.assertThat((String)interpolator.interpolate((Object)"!")).isEqualTo("");
    }

    @Test
    public void testSingleValueInterpolation() {
        FormatInterpolator interpolator = new FormatInterpolator("TEST_VALUE is $TEST_VALUE", (FormatInterpolator.InterpolatedValue[])SingleTestValue.values());
        Assertions.assertThat((String)interpolator.interpolate((Object)"!")).isEqualTo("TEST_VALUE is singleValue!");
    }

    @Test
    public void testMultipleValueInterpolation() {
        FormatInterpolator interpolator = new FormatInterpolator("TEST_VALUE is $TEST_VALUE and ANOTHER_VALUE is $ANOTHER_VALUE", (FormatInterpolator.InterpolatedValue[])MultipleTestValues.values());
        Assertions.assertThat((String)interpolator.interpolate((Object)"!")).isEqualTo("TEST_VALUE is first! and ANOTHER_VALUE is second!");
    }

    @Test
    public void testUnknownValueInterpolation() {
        FormatInterpolator interpolator = new FormatInterpolator("UNKNOWN_VALUE is $UNKNOWN_VALUE", (FormatInterpolator.InterpolatedValue[])MultipleTestValues.values());
        Assertions.assertThat((String)interpolator.interpolate((Object)"!")).isEqualTo("UNKNOWN_VALUE is $UNKNOWN_VALUE");
    }

    @Test
    public void testValidation() {
        Assertions.assertThat((boolean)FormatInterpolator.hasValidPlaceholders((String)"$UNKNOWN_VALUE", (FormatInterpolator.InterpolatedValue[])MultipleTestValues.values())).isFalse();
        Assertions.assertThat((boolean)FormatInterpolator.hasValidPlaceholders((String)"$TEST_VALUE", (FormatInterpolator.InterpolatedValue[])MultipleTestValues.values())).isTrue();
        Assertions.assertThat((boolean)FormatInterpolator.hasValidPlaceholders((String)"$TEST_VALUE and $UNKNOWN_VALUE", (FormatInterpolator.InterpolatedValue[])MultipleTestValues.values())).isFalse();
        Assertions.assertThat((boolean)FormatInterpolator.hasValidPlaceholders((String)"$TEST_VALUE and $ANOTHER_VALUE", (FormatInterpolator.InterpolatedValue[])MultipleTestValues.values())).isTrue();
        Assertions.assertThat((boolean)FormatInterpolator.hasValidPlaceholders((String)"$TEST_VALUE and $TEST_VALUE", (FormatInterpolator.InterpolatedValue[])MultipleTestValues.values())).isTrue();
    }

    public static enum SingleTestValue implements FormatInterpolator.InterpolatedValue<String>
    {
        TEST_VALUE;


        public String value(String value) {
            return "singleValue" + value;
        }
    }

    public static enum MultipleTestValues implements FormatInterpolator.InterpolatedValue<String>
    {
        TEST_VALUE("first"),
        ANOTHER_VALUE("second");

        private final String value;

        private MultipleTestValues(String value) {
            this.value = value;
        }

        public String value(String value) {
            return this.value + value;
        }
    }
}

