/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.testing.ValidationAssertions;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import io.trino.plugin.base.security.FileBasedAccessControlConfig;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFileBasedAccessControlConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FileBasedAccessControlConfig)ConfigAssertions.recordDefaults(FileBasedAccessControlConfig.class)).setConfigFile(null).setJsonPointer("").setRefreshPeriod(null));
    }

    @Test
    public void testExplicitPropertyMappingsWithLocalFile() throws IOException {
        Path securityConfigFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"security.config-file", (Object)securityConfigFile.toString()).put((Object)"security.json-pointer", (Object)"/a/b").put((Object)"security.refresh-period", (Object)"1s").buildOrThrow();
        FileBasedAccessControlConfig expected = new FileBasedAccessControlConfig().setConfigFile(securityConfigFile.toString()).setJsonPointer("/a/b").setRefreshPeriod(new Duration(1.0, TimeUnit.SECONDS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testExplicitPropertyMappingsWithUrl() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"security.config-file", (Object)"http://test:1234/example").put((Object)"security.json-pointer", (Object)"/data").put((Object)"security.refresh-period", (Object)"1s").buildOrThrow();
        FileBasedAccessControlConfig expected = new FileBasedAccessControlConfig().setConfigFile("http://test:1234/example").setJsonPointer("/data").setRefreshPeriod(new Duration(1.0, TimeUnit.SECONDS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testValidationWithLocalFile() throws IOException {
        String securityConfigFile = Files.createTempFile(null, null, new FileAttribute[0]).toString();
        ValidationAssertions.assertFailsValidation((Object)new FileBasedAccessControlConfig().setRefreshPeriod(Duration.valueOf((String)"1ms")), (String)"configFile", (String)"must not be null", NotNull.class);
        ValidationAssertions.assertFailsValidation((Object)new FileBasedAccessControlConfig().setRefreshPeriod(Duration.valueOf((String)"0ms")).setConfigFile(securityConfigFile), (String)"refreshPeriod", (String)"must be greater than or equal to 1ms", MinDuration.class);
        ValidationAssertions.assertFailsValidation((Object)new FileBasedAccessControlConfig().setRefreshPeriod(Duration.valueOf((String)"1ms")).setConfigFile("not_existing_file"), (String)"configFileValid", (String)"Config file does not exist.", AssertTrue.class);
        ValidationAssertions.assertValidates((Object)new FileBasedAccessControlConfig().setConfigFile(securityConfigFile));
        ValidationAssertions.assertValidates((Object)new FileBasedAccessControlConfig().setConfigFile(securityConfigFile).setRefreshPeriod(Duration.valueOf((String)"1ms")));
    }

    @Test
    public void testValidationWithUrl() {
        String securityConfigUrl = "http://test:1234/example";
        ValidationAssertions.assertFailsValidation((Object)new FileBasedAccessControlConfig().setRefreshPeriod(Duration.valueOf((String)"1ms")), (String)"configFile", (String)"must not be null", NotNull.class);
        ValidationAssertions.assertFailsValidation((Object)new FileBasedAccessControlConfig().setRefreshPeriod(Duration.valueOf((String)"0ms")).setConfigFile(securityConfigUrl), (String)"refreshPeriod", (String)"must be greater than or equal to 1ms", MinDuration.class);
        ValidationAssertions.assertFailsValidation((Object)new FileBasedAccessControlConfig().setConfigFile(securityConfigUrl).setJsonPointer(null), (String)"jsonPointer", (String)"must not be null", NotNull.class);
        ValidationAssertions.assertValidates((Object)new FileBasedAccessControlConfig().setConfigFile(securityConfigUrl));
        ValidationAssertions.assertValidates((Object)new FileBasedAccessControlConfig().setConfigFile(securityConfigUrl).setRefreshPeriod(Duration.valueOf((String)"1ms")));
        ValidationAssertions.assertValidates((Object)new FileBasedAccessControlConfig().setConfigFile(securityConfigUrl).setRefreshPeriod(Duration.valueOf((String)"1ms")).setJsonPointer("/data"));
    }

    @Test
    public void testConfigSource() {
        FileBasedAccessControlConfig fileBasedAccessControlConfig = new FileBasedAccessControlConfig().setConfigFile("/etc/access-control");
        Assertions.assertThat((boolean)fileBasedAccessControlConfig.isHttp()).isEqualTo(false);
        fileBasedAccessControlConfig = new FileBasedAccessControlConfig().setConfigFile("http://trino.example/config");
        Assertions.assertThat((boolean)fileBasedAccessControlConfig.isHttp()).isEqualTo(true);
        fileBasedAccessControlConfig = new FileBasedAccessControlConfig().setConfigFile("https://trino.example/config");
        Assertions.assertThat((boolean)fileBasedAccessControlConfig.isHttp()).isEqualTo(true);
    }
}

