/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import io.trino.plugin.base.util.Closables;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestClosables {
    @Test
    public void testCloseAllSuppressNonThrowing() {
        RuntimeException rootException = new RuntimeException("root");
        TestClosable closable = new TestClosable(Optional.empty());
        Closables.closeAllSuppress((Throwable)rootException, (AutoCloseable[])new AutoCloseable[]{closable});
        Assertions.assertThat((boolean)closable.isClosed()).isTrue();
        Assertions.assertThat((Object[])rootException.getSuppressed()).isEmpty();
    }

    @Test
    public void testCloseAllSuppressThrowingOther() {
        RuntimeException rootException = new RuntimeException("root");
        RuntimeException closeException = new RuntimeException("close");
        TestClosable closable = new TestClosable(Optional.of(closeException));
        Closables.closeAllSuppress((Throwable)rootException, (AutoCloseable[])new AutoCloseable[]{closable});
        Assertions.assertThat((boolean)closable.isClosed()).isTrue();
        Assertions.assertThat((Object[])rootException.getSuppressed()).containsExactly((Object[])new Throwable[]{closeException});
    }

    @Test
    public void testCloseAllSuppressThrowingRoot() {
        RuntimeException rootException = new RuntimeException("root");
        TestClosable closable = new TestClosable(Optional.of(rootException));
        Closables.closeAllSuppress((Throwable)rootException, (AutoCloseable[])new AutoCloseable[]{closable});
        Assertions.assertThat((boolean)closable.isClosed()).isTrue();
        Assertions.assertThat((Object[])rootException.getSuppressed()).isEmpty();
    }

    @Test
    public void testCloseAllSuppressNullClosable() {
        RuntimeException rootException = new RuntimeException("root");
        Closables.closeAllSuppress((Throwable)rootException, (AutoCloseable[])new AutoCloseable[]{null});
        Assertions.assertThat((Object[])rootException.getSuppressed()).isEmpty();
    }

    @Test
    public void testCloseAllSuppressMultipleClosables() {
        RuntimeException rootException = new RuntimeException("root");
        RuntimeException closeException1 = new RuntimeException("close");
        RuntimeException closeException2 = new RuntimeException("close2");
        TestClosable closable1 = new TestClosable(Optional.of(closeException1));
        TestClosable closable2 = new TestClosable(Optional.of(closeException2));
        TestClosable closable3 = new TestClosable(Optional.empty());
        TestClosable closable4 = new TestClosable(Optional.of(rootException));
        Closables.closeAllSuppress((Throwable)rootException, (AutoCloseable[])new AutoCloseable[]{closable1, closable2, closable3, closable4, null});
        Assertions.assertThat((boolean)closable1.isClosed()).isTrue();
        Assertions.assertThat((boolean)closable2.isClosed()).isTrue();
        Assertions.assertThat((boolean)closable3.isClosed()).isTrue();
        Assertions.assertThat((boolean)closable4.isClosed()).isTrue();
        Assertions.assertThat((Object[])rootException.getSuppressed()).containsExactly((Object[])new Throwable[]{closeException1, closeException2});
    }

    private static class TestClosable
    implements AutoCloseable {
        private final Optional<Exception> closeException;
        private boolean closed;

        public TestClosable(Optional<Exception> closeException) {
            this.closeException = Objects.requireNonNull(closeException, "closeException is null");
        }

        @Override
        public void close() throws Exception {
            this.closed = true;
            if (this.closeException.isPresent()) {
                throw this.closeException.get();
            }
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

