/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import com.google.common.base.Throwables;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class AutoCloseableCloser
implements AutoCloseable {
    @GuardedBy(value="this")
    private boolean closed;
    @GuardedBy(value="this")
    private final ArrayList<AutoCloseable> closeables = new ArrayList(4);

    private AutoCloseableCloser() {
    }

    public static AutoCloseableCloser create() {
        return new AutoCloseableCloser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends AutoCloseable> C register(C closeable) {
        Objects.requireNonNull(closeable, "closeable is null");
        boolean registered = false;
        AutoCloseableCloser autoCloseableCloser = this;
        synchronized (autoCloseableCloser) {
            if (!this.closed) {
                this.closeables.add(closeable);
                registered = true;
            }
        }
        if (!registered) {
            IllegalStateException failure = new IllegalStateException("Already closed");
            try {
                closeable.close();
            }
            catch (Exception e) {
                failure.addSuppressed(e);
            }
            throw failure;
        }
        return closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        List<AutoCloseable> closeables;
        AutoCloseableCloser autoCloseableCloser = this;
        synchronized (autoCloseableCloser) {
            this.closed = true;
            closeables = List.copyOf(this.closeables.reversed());
            this.closeables.clear();
            this.closeables.trimToSize();
        }
        Throwable rootCause = null;
        for (AutoCloseable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                if (rootCause == null) {
                    rootCause = t;
                    continue;
                }
                if (rootCause == t) continue;
                rootCause.addSuppressed(t);
            }
        }
        if (rootCause != null) {
            Throwables.throwIfInstanceOf(rootCause, Exception.class);
            Throwables.throwIfUnchecked(rootCause);
            throw new AssertionError((Object)rootCause);
        }
    }
}

