/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.jmx;

import com.google.common.base.MoreObjects;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.jmx.ObjectNameGeneratorConfig;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.ObjectNameBuilder;
import org.weakref.jmx.ObjectNameGenerator;

public class PrefixObjectNameGeneratorModule
implements Module {
    private final String packageName;
    private final String defaultDomainBase;

    public PrefixObjectNameGeneratorModule(String packageName, String defaultDomainBase) {
        this.packageName = Objects.requireNonNull(packageName, "packageName is null");
        this.defaultDomainBase = Objects.requireNonNull(defaultDomainBase, "defaultDomainBase is null");
    }

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(ObjectNameGeneratorConfig.class);
    }

    @Provides
    ObjectNameGenerator createPrefixObjectNameGenerator(ObjectNameGeneratorConfig config) {
        String domainBase = (String)MoreObjects.firstNonNull((Object)config.getDomainBase(), (Object)this.defaultDomainBase);
        return new PrefixObjectNameGenerator(this.packageName, domainBase);
    }

    public static final class PrefixObjectNameGenerator
    implements ObjectNameGenerator {
        private final String packageName;
        private final String domainBase;

        public PrefixObjectNameGenerator(String packageName, String domainBase) {
            this.packageName = Objects.requireNonNull(packageName, "packageName is null");
            this.domainBase = Objects.requireNonNull(domainBase, "domainBase is null");
        }

        public String generatedNameOf(Class<?> type, Map<String, String> properties) {
            return new ObjectNameBuilder(this.toDomain(type)).withProperties(properties).build();
        }

        private String toDomain(Class<?> type) {
            Object domain = type.getPackage().getName();
            if (((String)domain).startsWith(this.packageName)) {
                domain = this.domainBase + ((String)domain).substring(this.packageName.length());
            }
            return domain;
        }
    }
}

