/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.base.ClosingBinder;
import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestClosingBinder {
    @Test
    public void testExecutorShutdown() {
        Module module = binder -> {
            binder.bind(ExecutorService.class).toInstance((Object)Executors.newCachedThreadPool());
            ClosingBinder.closingBinder((Binder)binder).registerExecutor(ExecutorService.class);
        };
        Injector injector = TestClosingBinder.getInjector(module);
        ExecutorService executorService = (ExecutorService)injector.getInstance(ExecutorService.class);
        Assertions.assertThat((boolean)executorService.isShutdown()).isFalse();
        TestClosingBinder.stop(injector);
        Assertions.assertThat((boolean)executorService.isShutdown()).isTrue();
    }

    @Test
    public void testCloseableShutdown() {
        AtomicBoolean closed = new AtomicBoolean();
        Injector injector = TestClosingBinder.getInjector(binder -> {
            binder.bind(Closeable.class).toInstance(() -> closed.set(true));
            ClosingBinder.closingBinder((Binder)binder).registerCloseable(Closeable.class);
        });
        Assertions.assertThat((boolean)closed.get()).isFalse();
        TestClosingBinder.stop(injector);
        Assertions.assertThat((boolean)closed.get()).isTrue();
    }

    private static Injector getInjector(Module module) {
        Bootstrap app = new Bootstrap(new Module[]{module});
        return app.doNotInitializeLogging().quiet().initialize();
    }

    private static void stop(Injector injector) {
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.stop();
    }
}

