/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Module;
import io.trino.plugin.base.JdkCompatibilityChecks;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJdkCompatibilityChecks {
    @Test
    public void shouldThrowWhenAccessIsNotGranted() {
        ThrowableSettableMock errorSink = new ThrowableSettableMock();
        new JdkCompatibilityChecks(List.of()).verifyAccessOpened((JdkCompatibilityChecks.ThrowableSettable)errorSink, "Connector 'snowflake'", (Multimap)ImmutableMultimap.of((Object)"java.base", (Object)"java.nio"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)errorSink.getThrowable()).isInstanceOf(IllegalStateException.class)).hasMessage("Connector 'snowflake' requires additional JVM argument(s). Please add the following to the JVM configuration: '--add-opens=java.base/java.nio=ALL-UNNAMED'");
    }

    @Test
    public void shouldThrowWhenOneOfAccessGrantsIsMissing() {
        ThrowableSettableMock errorSink = new ThrowableSettableMock();
        new JdkCompatibilityChecks(List.of("--add-opens", "java.base/java.nio=ALL-UNNAMED")).verifyAccessOpened((JdkCompatibilityChecks.ThrowableSettable)errorSink, "Connector 'snowflake'", (Multimap)ImmutableMultimap.of((Object)"java.base", (Object)"java.nio", (Object)"java.base", (Object)"java.lang"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)errorSink.getThrowable()).isInstanceOf(IllegalStateException.class)).hasMessage("Connector 'snowflake' requires additional JVM argument(s). Please add the following to the JVM configuration: '--add-opens=java.base/java.lang=ALL-UNNAMED'");
    }

    @Test
    public void shouldSetErrorOnBinder() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Guice.createInjector((Module[])new Module[]{new TestingModule()})).isInstanceOf(CreationException.class)).hasMessageContaining("Unable to create injector, see the following errors:").hasMessageContaining("1) Connector 'Testing' requires additional JVM argument(s). Please add the following to the JVM configuration: '--add-opens=java.base/java.non.existing=ALL-UNNAMED --add-opens=java.base/java.this.should.fail=ALL-UNNAMED'");
    }

    @Test
    public void shouldNotThrowWhenAllAccessGrantsArePresent() {
        ThrowableSettableMock errorSink = new ThrowableSettableMock();
        new JdkCompatibilityChecks(List.of("--add-opens=java.base/java.nio=ALL-UNNAMED", "--add-opens java.base/java.lang=ALL-UNNAMED")).verifyAccessOpened((JdkCompatibilityChecks.ThrowableSettable)errorSink, "Connector 'snowflake'", (Multimap)ImmutableMultimap.of((Object)"java.base", (Object)"java.nio", (Object)"java.base", (Object)"java.lang"));
        Assertions.assertThat((Throwable)errorSink.getThrowable()).isNull();
    }

    @Test
    public void shouldThrowWhenUnsafeIsNotAllowed() {
        ThrowableSettableMock errorSink = new ThrowableSettableMock();
        new JdkCompatibilityChecks(List.of()).verifyUnsafeAllowed((JdkCompatibilityChecks.ThrowableSettable)errorSink, "Connector 'bigquery'");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)errorSink.getThrowable()).isInstanceOf(IllegalStateException.class)).hasMessage("Connector 'bigquery' requires additional JVM argument(s). Please add the following to the JVM configuration: '--sun-misc-unsafe-memory-access=allow'");
    }

    @Test
    public void shouldNotThrowWhenUnsafeIsAllowed() {
        ThrowableSettableMock errorSink = new ThrowableSettableMock();
        new JdkCompatibilityChecks(List.of("--sun-misc-unsafe-memory-access=allow")).verifyUnsafeAllowed((JdkCompatibilityChecks.ThrowableSettable)errorSink, "Connector 'bigquery'");
        Assertions.assertThat((Throwable)errorSink.getThrowable()).isNull();
    }

    private static class ThrowableSettableMock
    implements JdkCompatibilityChecks.ThrowableSettable {
        private Throwable throwable;

        private ThrowableSettableMock() {
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = Objects.requireNonNull(throwable, "throwable is null");
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    private static class TestingModule
    implements Module {
        private TestingModule() {
        }

        public void configure(Binder binder) {
            JdkCompatibilityChecks.verifyConnectorAccessOpened((Binder)binder, (String)"Testing", (Multimap)ImmutableMultimap.of((Object)"java.base", (Object)"java.non.existing", (Object)"java.base", (Object)"java.this.should.fail"));
        }
    }
}

