/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.trino.plugin.base.CatalogNameModule;
import io.trino.plugin.base.security.FileBasedAccessControl;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.spi.QueryId;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.testing.InterfaceTestUtils;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class BaseFileBasedConnectorAccessControlTest {
    private static final ConnectorSecurityContext ADMIN = BaseFileBasedConnectorAccessControlTest.user("admin", (Set<String>)ImmutableSet.of((Object)"admin", (Object)"staff"));
    private static final ConnectorSecurityContext ALICE = BaseFileBasedConnectorAccessControlTest.user("alice", (Set<String>)ImmutableSet.of((Object)"staff"));
    private static final ConnectorSecurityContext BOB = BaseFileBasedConnectorAccessControlTest.user("bob", (Set<String>)ImmutableSet.of((Object)"staff"));
    private static final ConnectorSecurityContext CHARLIE = BaseFileBasedConnectorAccessControlTest.user("charlie", (Set<String>)ImmutableSet.of((Object)"guests"));
    private static final ConnectorSecurityContext JOE = BaseFileBasedConnectorAccessControlTest.user("joe", (Set<String>)ImmutableSet.of());
    private static final ConnectorSecurityContext UNKNOWN = BaseFileBasedConnectorAccessControlTest.user("unknown", (Set<String>)ImmutableSet.of());

    protected abstract ConnectorAccessControl createAccessControl(Path var1, Map<String, String> var2);

    @Test
    public void testEmptyFile() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("empty.json");
        accessControl.checkCanCreateSchema(UNKNOWN, "unknown", (Map)ImmutableMap.of());
        accessControl.checkCanDropSchema(UNKNOWN, "unknown");
        accessControl.checkCanRenameSchema(UNKNOWN, "unknown", "new_unknown");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(UNKNOWN, "unknown", new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        accessControl.checkCanShowCreateSchema(UNKNOWN, "unknown");
        accessControl.checkCanSelectFromColumns(UNKNOWN, new SchemaTableName("unknown", "unknown"), (Set)ImmutableSet.of());
        accessControl.checkCanShowColumns(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanInsertIntoTable(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanDeleteFromTable(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanCreateTable(UNKNOWN, new SchemaTableName("unknown", "unknown"), Map.of());
        accessControl.checkCanDropTable(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanTruncateTable(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanRenameTable(UNKNOWN, new SchemaTableName("unknown", "unknown"), new SchemaTableName("unknown", "new_unknown"));
        accessControl.checkCanAlterColumn(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanSetCatalogSessionProperty(UNKNOWN, "anything");
        ImmutableSet tables = ImmutableSet.builder().add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("any", "any")).build();
        Assertions.assertThat((Collection)accessControl.filterTables(UNKNOWN, (Set)tables)).isEqualTo((Object)tables);
        TrinoPrincipal someUser = new TrinoPrincipal(PrincipalType.USER, "some_user");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantTablePrivilege(ADMIN, Privilege.SELECT, new SchemaTableName("any", "any"), someUser, false));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDenyTablePrivilege(ADMIN, Privilege.SELECT, new SchemaTableName("any", "any"), someUser));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeTablePrivilege(ADMIN, Privilege.SELECT, new SchemaTableName("any", "any"), someUser, false));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateRole(ADMIN, "role", Optional.empty()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropRole(ADMIN, "role"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantRoles(ADMIN, (Set)ImmutableSet.of((Object)"test"), (Set)ImmutableSet.of((Object)someUser), false, Optional.empty()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeRoles(ADMIN, (Set)ImmutableSet.of((Object)"test"), (Set)ImmutableSet.of((Object)someUser), false, Optional.empty()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetRole(ADMIN, "role"));
        accessControl.checkCanShowRoles(UNKNOWN);
        accessControl.checkCanShowCurrentRoles(UNKNOWN);
        accessControl.checkCanShowRoleGrants(UNKNOWN);
    }

    @Test
    public void testSchemaRules() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("schema.json");
        ImmutableMap properties = ImmutableMap.of();
        accessControl.checkCanCreateSchema(ADMIN, "bob", (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, "staff", (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, "authenticated", (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, "test", (Map)properties);
        accessControl.checkCanCreateSchema(BOB, "bob", (Map)properties);
        accessControl.checkCanCreateSchema(BOB, "staff", (Map)properties);
        accessControl.checkCanCreateSchema(BOB, "authenticated", (Map)properties);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> BaseFileBasedConnectorAccessControlTest.lambda$testSchemaRules$0(accessControl, (Map)properties));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> BaseFileBasedConnectorAccessControlTest.lambda$testSchemaRules$1(accessControl, (Map)properties));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> BaseFileBasedConnectorAccessControlTest.lambda$testSchemaRules$2(accessControl, (Map)properties));
        accessControl.checkCanCreateSchema(CHARLIE, "authenticated", (Map)properties);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> BaseFileBasedConnectorAccessControlTest.lambda$testSchemaRules$3(accessControl, (Map)properties));
        accessControl.checkCanDropSchema(ADMIN, "bob");
        accessControl.checkCanDropSchema(ADMIN, "staff");
        accessControl.checkCanDropSchema(ADMIN, "authenticated");
        accessControl.checkCanDropSchema(ADMIN, "test");
        accessControl.checkCanDropSchema(BOB, "bob");
        accessControl.checkCanDropSchema(BOB, "staff");
        accessControl.checkCanDropSchema(BOB, "authenticated");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropSchema(BOB, "test"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropSchema(CHARLIE, "bob"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropSchema(CHARLIE, "staff"));
        accessControl.checkCanDropSchema(CHARLIE, "authenticated");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropSchema(CHARLIE, "test"));
        accessControl.checkCanRenameSchema(ADMIN, "bob", "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, "staff", "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, "authenticated", "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, "test", "new_schema");
        accessControl.checkCanRenameSchema(BOB, "bob", "staff");
        accessControl.checkCanRenameSchema(BOB, "staff", "authenticated");
        accessControl.checkCanRenameSchema(BOB, "authenticated", "bob");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameSchema(BOB, "test", "bob"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameSchema(BOB, "bob", "test"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, "bob", "new_schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, "staff", "new_schema"));
        accessControl.checkCanRenameSchema(CHARLIE, "authenticated", "authenticated");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, "test", "new_schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(ADMIN, "test", new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(ADMIN, "test", new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BOB, "bob", new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BOB, "bob", new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BOB, "test", new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BOB, "test", new TrinoPrincipal(PrincipalType.USER, "some_user")));
        accessControl.checkCanShowCreateSchema(ADMIN, "bob");
        accessControl.checkCanShowCreateSchema(ADMIN, "staff");
        accessControl.checkCanShowCreateSchema(ADMIN, "authenticated");
        accessControl.checkCanShowCreateSchema(ADMIN, "test");
        accessControl.checkCanShowCreateSchema(BOB, "bob");
        accessControl.checkCanShowCreateSchema(BOB, "staff");
        accessControl.checkCanShowCreateSchema(BOB, "authenticated");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowCreateSchema(BOB, "test"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, "bob"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, "staff"));
        accessControl.checkCanShowCreateSchema(CHARLIE, "authenticated");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, "test"));
    }

    @Test
    public void testGrantSchemaPrivilege() throws Exception {
        for (Privilege privilege : Privilege.values()) {
            this.testGrantSchemaPrivilege(privilege, false);
            this.testGrantSchemaPrivilege(privilege, true);
        }
    }

    private void testGrantSchemaPrivilege(Privilege privilege, boolean grantOption) throws URISyntaxException {
        ConnectorAccessControl accessControl = this.createAccessControl("schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, "bob", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, "staff", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, "authenticated", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, "test", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, "bob", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, "staff", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, "authenticated", grantee, grantOption);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, "test", grantee, grantOption));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, "bob", grantee, grantOption));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, "staff", grantee, grantOption));
        accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, "authenticated", grantee, grantOption);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, "test", grantee, grantOption));
    }

    @Test
    public void testDenySchemaPrivilege() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, "bob", grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, "staff", grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, "authenticated", grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, "test", grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, "bob", grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, "staff", grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, "authenticated", grantee);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, "test", grantee));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, "bob", grantee));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, "staff", grantee));
        accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, "authenticated", grantee);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, "test", grantee));
    }

    @Test
    public void testRevokeSchemaPrivilege() throws Exception {
        for (Privilege privilege : Privilege.values()) {
            this.testRevokeSchemaPrivilege(privilege, false);
            this.testRevokeSchemaPrivilege(privilege, true);
        }
    }

    private void testRevokeSchemaPrivilege(Privilege privilege, boolean grantOption) throws URISyntaxException {
        ConnectorAccessControl accessControl = this.createAccessControl("schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, "bob", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, "staff", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, "authenticated", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, "test", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, "bob", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, "staff", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, "authenticated", grantee, grantOption);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, "test", grantee, grantOption));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, "bob", grantee, grantOption));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, "staff", grantee, grantOption));
        accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, "authenticated", grantee, grantOption);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, "test", grantee, grantOption));
    }

    @Test
    public void testTableRules() throws Exception {
        SchemaTableName testTable = new SchemaTableName("test", "test");
        SchemaTableName aliceTable = new SchemaTableName("aliceschema", "alicetable");
        SchemaTableName bobTable = new SchemaTableName("bobschema", "bobtable");
        ConnectorAccessControl accessControl = this.createAccessControl("table.json");
        accessControl.checkCanSelectFromColumns(ALICE, testTable, (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(ALICE, bobTable, (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(ALICE, bobTable, (Set)ImmutableSet.of((Object)"bobcolumn"));
        accessControl.checkCanShowColumns(ALICE, bobTable);
        Assertions.assertThat((Map)accessControl.filterColumns(ALICE, Map.of(bobTable, ImmutableSet.of((Object)"a")))).isEqualTo(Map.of(bobTable, ImmutableSet.of((Object)"a")));
        accessControl.checkCanSelectFromColumns(BOB, bobTable, (Set)ImmutableSet.of());
        accessControl.checkCanShowColumns(BOB, bobTable);
        Assertions.assertThat((Map)accessControl.filterColumns(BOB, Map.of(bobTable, ImmutableSet.of((Object)"a")))).isEqualTo(Map.of(bobTable, ImmutableSet.of((Object)"a")));
        accessControl.checkCanInsertIntoTable(BOB, bobTable);
        accessControl.checkCanDeleteFromTable(BOB, bobTable);
        accessControl.checkCanTruncateTable(BOB, bobTable);
        accessControl.checkCanSelectFromColumns(CHARLIE, bobTable, (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(CHARLIE, bobTable, (Set)ImmutableSet.of((Object)"bobcolumn"));
        accessControl.checkCanInsertIntoTable(CHARLIE, bobTable);
        accessControl.checkCanSelectFromColumns(JOE, bobTable, (Set)ImmutableSet.of());
        accessControl.checkCanCreateTable(ADMIN, new SchemaTableName("bob", "test"), Map.of());
        accessControl.checkCanCreateTable(ADMIN, testTable, Map.of());
        accessControl.checkCanCreateTable(ADMIN, new SchemaTableName("authenticated", "test"), Map.of());
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(ADMIN, new SchemaTableName("secret", "test"), Map.of()));
        accessControl.checkCanCreateTable(ALICE, new SchemaTableName("aliceschema", "test"), Map.of());
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(ALICE, testTable, Map.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(CHARLIE, new SchemaTableName("aliceschema", "test"), Map.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(CHARLIE, testTable, Map.of()));
        accessControl.checkCanCreateViewWithSelectFromColumns(BOB, bobTable, (Set)ImmutableSet.of());
        accessControl.checkCanDropTable(ADMIN, bobTable);
        accessControl.checkCanTruncateTable(ADMIN, bobTable);
        accessControl.checkCanRenameTable(ADMIN, bobTable, new SchemaTableName("aliceschema", "newbobtable"));
        accessControl.checkCanRenameTable(ALICE, aliceTable, new SchemaTableName("aliceschema", "newalicetable"));
        accessControl.checkCanRenameView(ADMIN, new SchemaTableName("bobschema", "bobview"), new SchemaTableName("aliceschema", "newbobview"));
        accessControl.checkCanRenameView(ALICE, new SchemaTableName("aliceschema", "aliceview"), new SchemaTableName("aliceschema", "newaliceview"));
        accessControl.checkCanRenameMaterializedView(ADMIN, new SchemaTableName("bobschema", "bobmaterializedview"), new SchemaTableName("aliceschema", "newbobaterializedview"));
        accessControl.checkCanRenameMaterializedView(ALICE, new SchemaTableName("aliceschema", "alicevaterializediew"), new SchemaTableName("aliceschema", "newaliceaterializedview"));
        accessControl.checkCanSetMaterializedViewProperties(ADMIN, new SchemaTableName("bobschema", "bobmaterializedview"), (Map)ImmutableMap.of());
        accessControl.checkCanSetMaterializedViewProperties(ALICE, new SchemaTableName("aliceschema", "alicevaterializediew"), (Map)ImmutableMap.of());
        accessControl.checkCanSetViewComment(ALICE, new SchemaTableName("aliceschema", "aliceview"));
        accessControl.checkCanAlterColumn(ADMIN, bobTable);
        accessControl.checkCanAlterColumn(ALICE, aliceTable);
        accessControl.checkCanSetTableProperties(ADMIN, bobTable, (Map)ImmutableMap.of());
        accessControl.checkCanSetTableProperties(ALICE, aliceTable, (Map)ImmutableMap.of());
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanInsertIntoTable(ALICE, bobTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropTable(BOB, bobTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameTable(BOB, bobTable, new SchemaTableName("bobschema", "newbobtable")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameTable(ALICE, aliceTable, new SchemaTableName("bobschema", "newalicetable")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewComment(ALICE, new SchemaTableName("bobschema", "newalicetable")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanAlterColumn(BOB, bobTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableProperties(BOB, bobTable, (Map)ImmutableMap.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanInsertIntoTable(BOB, testTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSelectFromColumns(ADMIN, new SchemaTableName("secret", "secret"), (Set)ImmutableSet.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSelectFromColumns(JOE, new SchemaTableName("secret", "secret"), (Set)ImmutableSet.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateViewWithSelectFromColumns(JOE, bobTable, (Set)ImmutableSet.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameView(BOB, new SchemaTableName("bobschema", "bobview"), new SchemaTableName("bobschema", "newbobview")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameView(ALICE, aliceTable, new SchemaTableName("bobschema", "newalicetable")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameMaterializedView(BOB, new SchemaTableName("bobschema", "bobmaterializedview"), new SchemaTableName("bobschema", "newbobaterializedview")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameMaterializedView(ALICE, aliceTable, new SchemaTableName("bobschema", "newaliceaterializedview")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetMaterializedViewProperties(ALICE, new SchemaTableName("bobschema", "bobmaterializedview"), (Map)ImmutableMap.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetMaterializedViewProperties(BOB, new SchemaTableName("bobschema", "bobmaterializedview"), (Map)ImmutableMap.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ADMIN, testTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ADMIN, testTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ALICE, aliceTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ALICE, aliceTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ALICE, bobTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ALICE, bobTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ADMIN, testTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ADMIN, testTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ALICE, aliceTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ALICE, aliceTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ALICE, bobTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ALICE, bobTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
    }

    @Test
    public void testTableRulesForMixedGroupUsers() throws Exception {
        SchemaTableName myTable = new SchemaTableName("my_schema", "my_table");
        ConnectorAccessControl accessControl = this.createAccessControl("table-mixed-groups.json");
        ConnectorSecurityContext userGroup1Group2 = BaseFileBasedConnectorAccessControlTest.user("user_1_2", (Set<String>)ImmutableSet.of((Object)"group1", (Object)"group2"));
        ConnectorSecurityContext userGroup2 = BaseFileBasedConnectorAccessControlTest.user("user_2", (Set<String>)ImmutableSet.of((Object)"group2"));
        accessControl.checkCanCreateTable(userGroup1Group2, myTable, Map.of());
        accessControl.checkCanInsertIntoTable(userGroup1Group2, myTable);
        accessControl.checkCanDeleteFromTable(userGroup1Group2, myTable);
        accessControl.checkCanDropTable(userGroup1Group2, myTable);
        accessControl.checkCanSelectFromColumns(userGroup1Group2, myTable, (Set)ImmutableSet.of());
        Assertions.assertThat((Optional)accessControl.getColumnMask(userGroup1Group2, myTable, "col_a", (Type)VarcharType.VARCHAR)).isEqualTo(Optional.empty());
        Assertions.assertThat((List)accessControl.getRowFilters(userGroup1Group2, myTable)).isEqualTo((Object)ImmutableList.of());
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(userGroup2, myTable, Map.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanInsertIntoTable(userGroup2, myTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDeleteFromTable(userGroup2, myTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropTable(userGroup2, myTable));
        accessControl.checkCanSelectFromColumns(userGroup2, myTable, (Set)ImmutableSet.of());
        BaseFileBasedConnectorAccessControlTest.assertViewExpressionEquals((ViewExpression)accessControl.getColumnMask(userGroup2, myTable, "col_a", (Type)VarcharType.VARCHAR).orElseThrow(), ViewExpression.builder().catalog("test_catalog").schema("my_schema").expression("'mask_a'").build());
        Assertions.assertThat((List)accessControl.getRowFilters(userGroup2, myTable)).isEqualTo((Object)ImmutableList.of());
        ConnectorSecurityContext userGroup1Group3 = BaseFileBasedConnectorAccessControlTest.user("user_1_3", (Set<String>)ImmutableSet.of((Object)"group1", (Object)"group3"));
        ConnectorSecurityContext userGroup3 = BaseFileBasedConnectorAccessControlTest.user("user_3", (Set<String>)ImmutableSet.of((Object)"group3"));
        accessControl.checkCanCreateTable(userGroup1Group3, myTable, Map.of());
        accessControl.checkCanInsertIntoTable(userGroup1Group3, myTable);
        accessControl.checkCanDeleteFromTable(userGroup1Group3, myTable);
        accessControl.checkCanDropTable(userGroup1Group3, myTable);
        accessControl.checkCanSelectFromColumns(userGroup1Group3, myTable, (Set)ImmutableSet.of());
        Assertions.assertThat((Optional)accessControl.getColumnMask(userGroup1Group3, myTable, "col_a", (Type)VarcharType.VARCHAR)).isEqualTo(Optional.empty());
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(userGroup3, myTable, Map.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanInsertIntoTable(userGroup3, myTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDeleteFromTable(userGroup3, myTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropTable(userGroup3, myTable));
        accessControl.checkCanSelectFromColumns(userGroup3, myTable, (Set)ImmutableSet.of());
        BaseFileBasedConnectorAccessControlTest.assertViewExpressionEquals((ViewExpression)accessControl.getColumnMask(userGroup3, myTable, "col_a", (Type)VarcharType.VARCHAR).orElseThrow(), ViewExpression.builder().catalog("test_catalog").schema("my_schema").expression("'mask_a'").build());
        List rowFilters = accessControl.getRowFilters(userGroup3, myTable);
        Assertions.assertThat((List)rowFilters).hasSize(1);
        BaseFileBasedConnectorAccessControlTest.assertViewExpressionEquals((ViewExpression)rowFilters.get(0), ViewExpression.builder().catalog("test_catalog").schema("my_schema").expression("country='US'").build());
    }

    private static void assertViewExpressionEquals(ViewExpression actual, ViewExpression expected) {
        ((OptionalAssert)Assertions.assertThat((Optional)actual.getSecurityIdentity()).describedAs("Identity", new Object[0])).isEqualTo((Object)expected.getSecurityIdentity());
        ((OptionalAssert)Assertions.assertThat((Optional)actual.getCatalog()).describedAs("Catalog", new Object[0])).isEqualTo((Object)expected.getCatalog());
        ((OptionalAssert)Assertions.assertThat((Optional)actual.getSchema()).describedAs("Schema", new Object[0])).isEqualTo((Object)expected.getSchema());
        ((AbstractStringAssert)Assertions.assertThat((String)actual.getExpression()).describedAs("Expression", new Object[0])).isEqualTo(expected.getExpression());
        ((ListAssert)Assertions.assertThat((List)actual.getPath()).describedAs("Path", new Object[0])).isEqualTo((Object)expected.getPath());
    }

    @Test
    public void testTableFilter() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("table-filter.json");
        ImmutableSet tables = ImmutableSet.builder().add((Object)new SchemaTableName("restricted", "any")).add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).add((Object)new SchemaTableName("bobschema", "any")).add((Object)new SchemaTableName("any", "any")).build();
        Assertions.assertThat((Collection)accessControl.filterTables(ALICE, (Set)tables)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).build());
        Assertions.assertThat((Collection)accessControl.filterTables(BOB, (Set)tables)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).build());
        Assertions.assertThat((Collection)accessControl.filterTables(ADMIN, (Set)tables)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).add((Object)new SchemaTableName("bobschema", "any")).add((Object)new SchemaTableName("any", "any")).build());
    }

    @Test
    public void testNoTableRules() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("no-access.json");
        SchemaTableName bobTable = new SchemaTableName("bobschema", "bobtable");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowColumns(BOB, bobTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(BOB, "bobschema"));
        Assertions.assertThat((Map)accessControl.filterColumns(BOB, Map.of(bobTable, ImmutableSet.of((Object)"a")))).isEqualTo(Map.of(bobTable, ImmutableSet.of()));
        ImmutableSet tables = ImmutableSet.builder().add((Object)new SchemaTableName("restricted", "any")).add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("any", "any")).build();
        Assertions.assertThat((Collection)accessControl.filterTables(ALICE, (Set)tables)).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterTables(BOB, (Set)tables)).isEqualTo((Object)ImmutableSet.of());
    }

    @Test
    public void testNoFunctionRules() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("no-access.json");
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ALICE, new SchemaRoutineName("schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ALICE, new SchemaRoutineName("schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ALICE, new SchemaRoutineName("ptf_schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ALICE, new SchemaRoutineName("schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(ALICE, new SchemaRoutineName("schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(ALICE, new SchemaRoutineName("schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(ALICE, new SchemaRoutineName("ptf_schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(ALICE, new SchemaRoutineName("schema", "some_function"))).isFalse();
        ImmutableSet functions = ImmutableSet.builder().add((Object)new SchemaFunctionName("restricted", "any")).add((Object)new SchemaFunctionName("secret", "any")).add((Object)new SchemaFunctionName("any", "any")).build();
        Assertions.assertThat((Collection)accessControl.filterFunctions(ALICE, (Set)functions)).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterFunctions(BOB, (Set)functions)).isEqualTo((Object)ImmutableSet.of());
    }

    @Test
    public void testSessionPropertyRules() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("session_property.json");
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "dangerous");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "safe");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "unsafe");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "staff");
        accessControl.checkCanSetCatalogSessionProperty(BOB, "safe");
        accessControl.checkCanSetCatalogSessionProperty(BOB, "staff");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(BOB, "unsafe"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(ALICE, "dangerous"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(CHARLIE, "safe"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(CHARLIE, "staff"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(JOE, "staff"));
    }

    @Test
    public void testFilterSchemas() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("visibility.json");
        BaseFileBasedConnectorAccessControlTest.assertFilterSchemas(accessControl);
    }

    private static void assertFilterSchemas(ConnectorAccessControl accessControl) {
        ImmutableSet allSchemas = ImmutableSet.of((Object)"specific-schema", (Object)"alice-schema", (Object)"bob-schema", (Object)"unknown", (Object)"ptf_schema", (Object)"procedure-schema", (Object[])new String[0]);
        Assertions.assertThat((Collection)accessControl.filterSchemas(ADMIN, (Set)allSchemas)).isEqualTo((Object)allSchemas);
        Assertions.assertThat((Collection)accessControl.filterSchemas(ALICE, (Set)allSchemas)).isEqualTo((Object)ImmutableSet.of((Object)"specific-schema", (Object)"alice-schema", (Object)"ptf_schema"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(BOB, (Set)allSchemas)).isEqualTo((Object)ImmutableSet.of((Object)"specific-schema", (Object)"bob-schema", (Object)"procedure-schema"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(CHARLIE, (Set)allSchemas)).isEqualTo((Object)ImmutableSet.of((Object)"specific-schema"));
    }

    @Test
    public void testSchemaRulesForCheckCanShowTables() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("visibility.json");
        accessControl.checkCanShowTables(ADMIN, "specific-schema");
        accessControl.checkCanShowTables(ADMIN, "bob-schema");
        accessControl.checkCanShowTables(ADMIN, "alice-schema");
        accessControl.checkCanShowTables(ADMIN, "secret");
        accessControl.checkCanShowTables(ADMIN, "any");
        accessControl.checkCanShowTables(ALICE, "specific-schema");
        accessControl.checkCanShowTables(ALICE, "alice-schema");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(ALICE, "bob-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(ALICE, "secret"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(ALICE, "any"));
        accessControl.checkCanShowTables(BOB, "specific-schema");
        accessControl.checkCanShowTables(BOB, "bob-schema");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(BOB, "alice-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(BOB, "secret"));
        accessControl.checkCanShowTables(BOB, "any");
        accessControl.checkCanShowTables(CHARLIE, "specific-schema");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(CHARLIE, "bob-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(CHARLIE, "alice-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(CHARLIE, "secret"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(CHARLIE, "any"));
    }

    @Test
    public void testSchemaRulesForCheckCanShowFunctions() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("visibility.json");
        accessControl.checkCanShowFunctions(ADMIN, "specific-schema");
        accessControl.checkCanShowFunctions(ADMIN, "bob-schema");
        accessControl.checkCanShowFunctions(ADMIN, "alice-schema");
        accessControl.checkCanShowFunctions(ADMIN, "secret");
        accessControl.checkCanShowFunctions(ADMIN, "any");
        accessControl.checkCanShowFunctions(ALICE, "specific-schema");
        accessControl.checkCanShowFunctions(ALICE, "alice-schema");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowFunctions(ALICE, "bob-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowFunctions(ALICE, "secret"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowFunctions(ALICE, "any"));
        accessControl.checkCanShowFunctions(BOB, "specific-schema");
        accessControl.checkCanShowFunctions(BOB, "bob-schema");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowFunctions(BOB, "alice-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowFunctions(BOB, "secret"));
        accessControl.checkCanShowFunctions(BOB, "any");
        accessControl.checkCanShowFunctions(CHARLIE, "specific-schema");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, "bob-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, "alice-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, "secret"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, "any"));
    }

    @Test
    public void testFunctionRulesForCheckCanExecute() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("visibility.json");
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ADMIN, new SchemaRoutineName("ptf_schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ADMIN, new SchemaRoutineName("any", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ADMIN, new SchemaRoutineName("any", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ADMIN, new SchemaRoutineName("any", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ALICE, new SchemaRoutineName("ptf_schema", "some_function"))).isTrue();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ALICE, new SchemaRoutineName("any", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ALICE, new SchemaRoutineName("any", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ALICE, new SchemaRoutineName("any", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(BOB, new SchemaRoutineName("ptf_schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(BOB, new SchemaRoutineName("any", "some_function"))).isTrue();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(BOB, new SchemaRoutineName("any", "some_function"))).isTrue();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(BOB, new SchemaRoutineName("any", "some_function"))).isTrue();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(CHARLIE, new SchemaRoutineName("ptf_schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(CHARLIE, new SchemaRoutineName("any", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(CHARLIE, new SchemaRoutineName("any", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(CHARLIE, new SchemaRoutineName("any", "some_function"))).isFalse();
    }

    @Test
    public void testProcedureRulesForCheckCanExecute() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("visibility.json");
        accessControl.checkCanExecuteProcedure(BOB, new SchemaRoutineName("procedure-schema", "some_procedure"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteProcedure(BOB, new SchemaRoutineName("some-schema", "some_procedure")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteProcedure(BOB, new SchemaRoutineName("procedure-schema", "another_procedure")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteProcedure(CHARLIE, new SchemaRoutineName("procedure-schema", "some_procedure")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteProcedure(ALICE, new SchemaRoutineName("procedure-schema", "some_procedure")));
    }

    @Test
    public void testInvalidRules() {
        Assertions.assertThatThrownBy(() -> this.createAccessControl("invalid.json")).hasMessageContaining("Failed to convert JSON tree node");
    }

    @Test
    public void testFilterSchemasWithJsonPointer() throws Exception {
        Path configFile = this.getResourcePath("visibility-with-json-pointer.json");
        ConnectorAccessControl accessControl = this.createAccessControl(configFile, (Map<String, String>)ImmutableMap.of((Object)"security.json-pointer", (Object)"/data"));
        BaseFileBasedConnectorAccessControlTest.assertFilterSchemas(accessControl);
    }

    @Test
    public void testSchemaAuthorization() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("authorization-no-roles.json");
        String schema = "test";
        String ownedByUser = "owned_by_user";
        String ownedByGroup = "owned_by_group";
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "group"), schema, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_DENY_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("DENY_authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
    }

    @Test
    public void testTableAuthorization() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("authorization-no-roles.json");
        SchemaTableName table = new SchemaTableName("test", "table");
        SchemaTableName ownedByUser = new SchemaTableName("test", "owned_by_user");
        SchemaTableName ownedByGroup = new SchemaTableName("test", "owned_by_group");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "group"), table, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_DENY_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("DENY_authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
    }

    @Test
    public void testViewAuthorization() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("authorization-no-roles.json");
        SchemaTableName table = new SchemaTableName("test", "table");
        SchemaTableName ownedByUser = new SchemaTableName("test", "owned_by_user");
        SchemaTableName ownedByGroup = new SchemaTableName("test", "owned_by_group");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "group"), table, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_DENY_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("DENY_authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
    }

    @Test
    public void testFunctionFilter() throws Exception {
        ConnectorAccessControl accessControl = this.createAccessControl("function-filter.json");
        ImmutableSet functions = ImmutableSet.builder().add((Object)new SchemaFunctionName("restricted", "any")).add((Object)new SchemaFunctionName("secret", "any")).add((Object)new SchemaFunctionName("aliceschema", "any")).add((Object)new SchemaFunctionName("aliceschema", "bobfunction")).add((Object)new SchemaFunctionName("bobschema", "bob_any")).add((Object)new SchemaFunctionName("bobschema", "any")).add((Object)new SchemaFunctionName("any", "any")).build();
        Assertions.assertThat((Collection)accessControl.filterFunctions(ALICE, (Set)functions)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaFunctionName("aliceschema", "any")).add((Object)new SchemaFunctionName("aliceschema", "bobfunction")).build());
        Assertions.assertThat((Collection)accessControl.filterFunctions(BOB, (Set)functions)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaFunctionName("aliceschema", "bobfunction")).add((Object)new SchemaFunctionName("bobschema", "bob_any")).build());
        Assertions.assertThat((Collection)accessControl.filterFunctions(ADMIN, (Set)functions)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaFunctionName("secret", "any")).add((Object)new SchemaFunctionName("aliceschema", "any")).add((Object)new SchemaFunctionName("aliceschema", "bobfunction")).add((Object)new SchemaFunctionName("bobschema", "bob_any")).add((Object)new SchemaFunctionName("bobschema", "any")).add((Object)new SchemaFunctionName("any", "any")).build());
    }

    @Test
    public void testEverythingImplemented() throws NoSuchMethodException {
        InterfaceTestUtils.assertAllMethodsOverridden(ConnectorAccessControl.class, FileBasedAccessControl.class);
    }

    @Test
    public void testRefreshing(@TempDir Path tempDir) throws Exception {
        Path configFile = tempDir.resolve("visibility.json");
        Files.copy(this.getResourcePath("visibility.json"), configFile, StandardCopyOption.REPLACE_EXISTING);
        ConnectorAccessControl accessControl = this.createAccessControl(configFile, (Map<String, String>)ImmutableMap.of((Object)"security.refresh-period", (Object)"1ms"));
        accessControl.checkCanShowTables(ALICE, "alice-schema");
        accessControl.checkCanShowTables(ALICE, "alice-schema");
        accessControl.checkCanShowTables(ALICE, "alice-schema");
        Files.copy(this.getResourcePath("no-access.json"), configFile, StandardCopyOption.REPLACE_EXISTING);
        Thread.sleep(2L);
        Assertions.assertThatThrownBy(() -> accessControl.checkCanShowTables(ALICE, "alice-schema")).hasMessageContaining("Access Denied");
        Files.copy(this.getResourcePath("visibility.json"), configFile, StandardCopyOption.REPLACE_EXISTING);
        Thread.sleep(2L);
        accessControl.checkCanShowTables(ALICE, "alice-schema");
    }

    protected ConnectorAccessControl createAccessControl(Map<String, String> configProperties) {
        Bootstrap bootstrap = new Bootstrap(new Module[]{new CatalogNameModule("test_catalog"), new FileBasedAccessControlModule()});
        Injector injector = bootstrap.doNotInitializeLogging().quiet().setRequiredConfigurationProperties(configProperties).initialize();
        return (ConnectorAccessControl)injector.getInstance(ConnectorAccessControl.class);
    }

    private ConnectorAccessControl createAccessControl(String rulesName) throws URISyntaxException {
        Path configFile = this.getResourcePath(rulesName);
        return this.createAccessControl(configFile, (Map<String, String>)ImmutableMap.of());
    }

    private Path getResourcePath(String resourceName) throws URISyntaxException {
        return Paths.get(Objects.requireNonNull(this.getClass().getClassLoader().getResource(resourceName), "Resource does not exist: " + resourceName).toURI());
    }

    private static ConnectorSecurityContext user(String user, String group) {
        return BaseFileBasedConnectorAccessControlTest.user(user, (Set<String>)ImmutableSet.of((Object)group));
    }

    private static ConnectorSecurityContext user(String name, Set<String> groups) {
        return new ConnectorSecurityContext(new ConnectorTransactionHandle(){}, ConnectorIdentity.forUser((String)name).withGroups(groups).build(), new QueryId("query_id"));
    }

    private static void assertDenied(ThrowingRunnable runnable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(runnable::run).isInstanceOf(AccessDeniedException.class)).hasMessageStartingWith("Access Denied");
    }

    private static /* synthetic */ void lambda$testSchemaRules$3(ConnectorAccessControl accessControl, Map properties) throws Exception {
        accessControl.checkCanCreateSchema(CHARLIE, "test", properties);
    }

    private static /* synthetic */ void lambda$testSchemaRules$2(ConnectorAccessControl accessControl, Map properties) throws Exception {
        accessControl.checkCanCreateSchema(CHARLIE, "staff", properties);
    }

    private static /* synthetic */ void lambda$testSchemaRules$1(ConnectorAccessControl accessControl, Map properties) throws Exception {
        accessControl.checkCanCreateSchema(CHARLIE, "bob", properties);
    }

    private static /* synthetic */ void lambda$testSchemaRules$0(ConnectorAccessControl accessControl, Map properties) throws Exception {
        accessControl.checkCanCreateSchema(BOB, "test", properties);
    }

    static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

