/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.plugin.base.security.FileBasedSystemAccessControl;
import io.trino.plugin.base.security.TestingSystemAccessControlContext;
import io.trino.spi.QueryId;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemAccessControlFactory;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.testing.InterfaceTestUtils;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class BaseFileBasedSystemAccessControlTest {
    private static final Identity alice = Identity.forUser((String)"alice").withGroups((Set)ImmutableSet.of((Object)"staff")).build();
    private static final Identity kerberosValidAlice = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("alice/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosValidNonAsciiUser = Identity.forUser((String)"\u0194\u0194\u0194").withPrincipal((Principal)new KerberosPrincipal("\u0194\u0194\u0194/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosInvalidAlice = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("mallory/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosValidShare = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("valid/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosInValidShare = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("invalid/example.com@EXAMPLE.COM")).build();
    private static final Identity validSpecialRegexWildDot = Identity.forUser((String)".*").withPrincipal((Principal)new KerberosPrincipal("special/.*@EXAMPLE.COM")).build();
    private static final Identity validSpecialRegexEndQuote = Identity.forUser((String)"\\E").withPrincipal((Principal)new KerberosPrincipal("special/\\E@EXAMPLE.COM")).build();
    private static final Identity invalidSpecialRegex = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("special/.*@EXAMPLE.COM")).build();
    private static final Identity bob = Identity.forUser((String)"bob").withGroups((Set)ImmutableSet.of((Object)"staff")).build();
    private static final Identity admin = Identity.forUser((String)"alberto").withEnabledRoles((Set)ImmutableSet.of((Object)"admin")).withGroups((Set)ImmutableSet.of((Object)"staff")).build();
    private static final Identity nonAsciiUser = Identity.ofUser((String)"\u0194\u0194\u0194");
    private static final CatalogSchemaTableName aliceView = new CatalogSchemaTableName("alice-catalog", "schema", "view");
    private static final QueryId queryId = new QueryId("test_query");
    private static final Instant queryStart = Instant.now();
    private static final Identity charlie = Identity.forUser((String)"charlie").withGroups((Set)ImmutableSet.of((Object)"guests")).build();
    private static final Identity dave = Identity.forUser((String)"dave").withGroups((Set)ImmutableSet.of((Object)"contractors")).build();
    private static final Identity joe = Identity.ofUser((String)"joe");
    private static final Identity any = Identity.ofUser((String)"any");
    private static final Identity anyone = Identity.ofUser((String)"anyone");
    private static final Identity unknown = Identity.ofUser((String)"some-unknown-user-id");
    private static final SystemSecurityContext ADMIN = new SystemSecurityContext(admin, queryId, queryStart);
    private static final SystemSecurityContext BOB = new SystemSecurityContext(bob, queryId, queryStart);
    private static final SystemSecurityContext CHARLIE = new SystemSecurityContext(charlie, queryId, queryStart);
    private static final SystemSecurityContext ALICE = new SystemSecurityContext(alice, queryId, queryStart);
    private static final SystemSecurityContext JOE = new SystemSecurityContext(joe, queryId, queryStart);
    private static final SystemSecurityContext UNKNOWN = new SystemSecurityContext(unknown, queryId, queryStart);
    private static final String SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE = "Cannot show schemas";
    private static final String CREATE_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot create schema .*";
    private static final String DROP_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot drop schema .*";
    private static final String RENAME_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot rename schema from .* to .*";
    private static final String SHOW_CREATE_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot show create schema for .*";
    private static final String GRANT_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot grant privilege %s on schema %s%s";
    private static final String DENY_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot deny privilege %s on schema %s%s";
    private static final String REVOKE_SCHEMA_ACCESS_DENIED_MESSAGE = "Cannot revoke privilege %s on schema %s%s";
    private static final String SHOWN_TABLES_ACCESS_DENIED_MESSAGE = "Cannot show tables of .*";
    private static final String SELECT_TABLE_ACCESS_DENIED_MESSAGE = "Cannot select from table .*";
    private static final String SHOW_COLUMNS_ACCESS_DENIED_MESSAGE = "Cannot show columns of table .*";
    private static final String ADD_COLUMNS_ACCESS_DENIED_MESSAGE = "Cannot add a column to table .*";
    private static final String DROP_COLUMNS_ACCESS_DENIED_MESSAGE = "Cannot drop a column from table .*";
    private static final String RENAME_COLUMNS_ACCESS_DENIED_MESSAGE = "Cannot rename a column in table .*";
    private static final String TABLE_COMMENT_ACCESS_DENIED_MESSAGE = "Cannot comment table to .*";
    private static final String INSERT_TABLE_ACCESS_DENIED_MESSAGE = "Cannot insert into table .*";
    private static final String DELETE_TABLE_ACCESS_DENIED_MESSAGE = "Cannot delete from table .*";
    private static final String TRUNCATE_TABLE_ACCESS_DENIED_MESSAGE = "Cannot truncate table .*";
    private static final String DROP_TABLE_ACCESS_DENIED_MESSAGE = "Cannot drop table .*";
    private static final String CREATE_TABLE_ACCESS_DENIED_MESSAGE = "Cannot show create table for .*";
    private static final String RENAME_TABLE_ACCESS_DENIED_MESSAGE = "Cannot rename table .*";
    private static final String SET_TABLE_PROPERTIES_ACCESS_DENIED_MESSAGE = "Cannot set table properties to .*";
    private static final String CREATE_VIEW_ACCESS_DENIED_MESSAGE = "View owner '.*' cannot create view that selects from .*";
    private static final String CREATE_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE = "Cannot create materialized view .*";
    private static final String DROP_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE = "Cannot drop materialized view .*";
    private static final String REFRESH_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE = "Cannot refresh materialized view .*";
    private static final String SET_MATERIALIZED_VIEW_PROPERTIES_ACCESS_DENIED_MESSAGE = "Cannot set properties of materialized view .*";
    private static final String GRANT_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE = "Cannot grant privilege DELETE on table .*";
    private static final String DENY_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE = "Cannot deny privilege DELETE on table .*";
    private static final String REVOKE_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE = "Cannot revoke privilege DELETE on table .*";
    private static final String SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE = "Cannot show functions of .*";
    private static final String SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE = "Cannot set system session property .*";
    private static final String SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE = "Cannot set catalog session property .*";
    private static final String EXECUTE_PROCEDURE_ACCESS_DENIED_MESSAGE = "Cannot execute procedure .*";

    protected abstract SystemAccessControl newFileBasedSystemAccessControl(Path var1, Map<String, String> var2);

    @Test
    public void testEverythingImplemented() {
        InterfaceTestUtils.assertAllMethodsOverridden(SystemAccessControl.class, FileBasedSystemAccessControl.class);
    }

    @Test
    public void testRefreshing(@TempDir Path tempDir) throws Exception {
        Path configFile = tempDir.resolve("file-based-system-catalog.json");
        Files.copy(this.getResourcePath("file-based-system-catalog.json"), configFile, StandardCopyOption.REPLACE_EXISTING);
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl(configFile, (Map<String, String>)ImmutableMap.of((Object)"security.refresh-period", (Object)"1ms"));
        SystemSecurityContext alice = new SystemSecurityContext(BaseFileBasedSystemAccessControlTest.alice, queryId, queryStart);
        accessControl.checkCanCreateView(alice, aliceView);
        accessControl.checkCanCreateView(alice, aliceView);
        accessControl.checkCanCreateView(alice, aliceView);
        Files.copy(this.getResourcePath("file-based-system-security-config-file-with-unknown-rules.json"), configFile, StandardCopyOption.REPLACE_EXISTING);
        Thread.sleep(2L);
        Assertions.assertThatThrownBy(() -> accessControl.checkCanCreateView(alice, aliceView)).hasMessageContaining("Failed to convert JSON tree node");
        Assertions.assertThatThrownBy(() -> accessControl.checkCanCreateView(alice, aliceView)).hasMessageContaining("Failed to convert JSON tree node");
        Files.copy(this.getResourcePath("file-based-system-catalog.json"), configFile, StandardCopyOption.REPLACE_EXISTING);
        Thread.sleep(2L);
        accessControl.checkCanCreateView(alice, aliceView);
    }

    @Test
    public void testEmptyFile() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("empty.json");
        accessControl.checkCanCreateSchema(UNKNOWN, new CatalogSchemaName("some-catalog", "unknown"), (Map)ImmutableMap.of());
        accessControl.checkCanDropSchema(UNKNOWN, new CatalogSchemaName("some-catalog", "unknown"));
        accessControl.checkCanRenameSchema(UNKNOWN, new CatalogSchemaName("some-catalog", "unknown"), "new_unknown");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(UNKNOWN, new EntityKindAndName("SCHEMA", List.of("some-catalog", "unknown")), new TrinoPrincipal(PrincipalType.ROLE, "some_role")), "Cannot set authorization for schema some-catalog.unknown to ROLE some_role");
        accessControl.checkCanShowCreateSchema(UNKNOWN, new CatalogSchemaName("some-catalog", "unknown"));
        accessControl.checkCanSelectFromColumns(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"), (Set)ImmutableSet.of());
        accessControl.checkCanShowColumns(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanInsertIntoTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanDeleteFromTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanTruncateTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanCreateTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"), Map.of());
        accessControl.checkCanDropTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanTruncateTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanRenameTable(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"), new CatalogSchemaTableName("some-catalog", "unknown", "new_unknown"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(UNKNOWN, new EntityKindAndName("TABLE", List.of("some-catalog", "unknown", "unknown")), new TrinoPrincipal(PrincipalType.ROLE, "some_role")), "Cannot set authorization for table some-catalog.unknown.unknown to ROLE some_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(UNKNOWN, new EntityKindAndName("VIEW", List.of("some-catalog", "unknown", "unknown")), new TrinoPrincipal(PrincipalType.ROLE, "some_role")), "Cannot set authorization for view some-catalog.unknown.unknown to ROLE some_role");
        accessControl.checkCanCreateMaterializedView(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"), Map.of());
        accessControl.checkCanDropMaterializedView(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        accessControl.checkCanRefreshMaterializedView(UNKNOWN, new CatalogSchemaTableName("some-catalog", "unknown", "unknown"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(UNKNOWN, new EntityKindAndName("VIEW", List.of("some-catalog", "unknown", "unknown")), new TrinoPrincipal(PrincipalType.ROLE, "some_role")), "Cannot set authorization for view some-catalog.unknown.unknown to ROLE some_role");
        accessControl.checkCanSetUser(Optional.empty(), "unknown");
        accessControl.checkCanSetUser(Optional.of(new KerberosPrincipal("stuff@example.com")), "unknown");
        accessControl.checkCanSetSystemSessionProperty(unknown, queryId, "anything");
        accessControl.checkCanSetCatalogSessionProperty(UNKNOWN, "unknown", "anything");
        accessControl.checkCanExecuteQuery(unknown, queryId);
        accessControl.checkCanViewQueryOwnedBy(unknown, anyone);
        accessControl.checkCanKillQueryOwnedBy(unknown, anyone);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanReadSystemInformation(unknown), "Cannot read system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanWriteSystemInformation(unknown), "Cannot write system information");
    }

    @Test
    public void testSchemaRulesForCheckCanCreateSchema() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        ImmutableMap properties = ImmutableMap.of();
        accessControl.checkCanCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "bob"), (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "staff"), (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "authenticated"), (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "test"), (Map)properties);
        accessControl.checkCanCreateSchema(BOB, new CatalogSchemaName("some-catalog", "bob"), (Map)properties);
        accessControl.checkCanCreateSchema(BOB, new CatalogSchemaName("some-catalog", "staff"), (Map)properties);
        accessControl.checkCanCreateSchema(BOB, new CatalogSchemaName("some-catalog", "authenticated"), (Map)properties);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> BaseFileBasedSystemAccessControlTest.lambda$testSchemaRulesForCheckCanCreateSchema$0(accessControl, (Map)properties), CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "authenticated"), (Map)properties);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> BaseFileBasedSystemAccessControlTest.lambda$testSchemaRulesForCheckCanCreateSchema$1(accessControl, (Map)properties), CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> BaseFileBasedSystemAccessControlTest.lambda$testSchemaRulesForCheckCanCreateSchema$2(accessControl, (Map)properties), CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> BaseFileBasedSystemAccessControlTest.lambda$testSchemaRulesForCheckCanCreateSchema$3(accessControl, (Map)properties), CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testSchemaRulesForCheckCanDropSchema() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        accessControl.checkCanDropSchema(ADMIN, new CatalogSchemaName("some-catalog", "bob"));
        accessControl.checkCanDropSchema(ADMIN, new CatalogSchemaName("some-catalog", "staff"));
        accessControl.checkCanDropSchema(ADMIN, new CatalogSchemaName("some-catalog", "authenticated"));
        accessControl.checkCanDropSchema(ADMIN, new CatalogSchemaName("some-catalog", "test"));
        accessControl.checkCanDropSchema(BOB, new CatalogSchemaName("some-catalog", "bob"));
        accessControl.checkCanDropSchema(BOB, new CatalogSchemaName("some-catalog", "staff"));
        accessControl.checkCanDropSchema(BOB, new CatalogSchemaName("some-catalog", "authenticated"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropSchema(BOB, new CatalogSchemaName("some-catalog", "test")), DROP_SCHEMA_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanDropSchema(CHARLIE, new CatalogSchemaName("some-catalog", "authenticated"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropSchema(CHARLIE, new CatalogSchemaName("some-catalog", "bob")), DROP_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropSchema(CHARLIE, new CatalogSchemaName("some-catalog", "staff")), DROP_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropSchema(CHARLIE, new CatalogSchemaName("some-catalog", "test")), DROP_SCHEMA_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testSchemaRulesForCheckCanRenameSchema() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        accessControl.checkCanRenameSchema(ADMIN, new CatalogSchemaName("some-catalog", "bob"), "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, new CatalogSchemaName("some-catalog", "staff"), "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, new CatalogSchemaName("some-catalog", "authenticated"), "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, new CatalogSchemaName("some-catalog", "test"), "new_schema");
        accessControl.checkCanRenameSchema(BOB, new CatalogSchemaName("some-catalog", "bob"), "staff");
        accessControl.checkCanRenameSchema(BOB, new CatalogSchemaName("some-catalog", "staff"), "authenticated");
        accessControl.checkCanRenameSchema(BOB, new CatalogSchemaName("some-catalog", "authenticated"), "bob");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameSchema(BOB, new CatalogSchemaName("some-catalog", "test"), "bob"), RENAME_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameSchema(BOB, new CatalogSchemaName("some-catalog", "bob"), "test"), RENAME_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, new CatalogSchemaName("some-catalog", "bob"), "new_schema"), RENAME_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, new CatalogSchemaName("some-catalog", "staff"), "new_schema"), RENAME_SCHEMA_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanRenameSchema(CHARLIE, new CatalogSchemaName("some-catalog", "authenticated"), "authenticated");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, new CatalogSchemaName("some-catalog", "test"), "new_schema"), RENAME_SCHEMA_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testSchemaRulesForCheckCanShowCreateSchema() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        accessControl.checkCanShowCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "bob"));
        accessControl.checkCanShowCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "staff"));
        accessControl.checkCanShowCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "authenticated"));
        accessControl.checkCanShowCreateSchema(ADMIN, new CatalogSchemaName("some-catalog", "test"));
        accessControl.checkCanShowCreateSchema(BOB, new CatalogSchemaName("some-catalog", "bob"));
        accessControl.checkCanShowCreateSchema(BOB, new CatalogSchemaName("some-catalog", "staff"));
        accessControl.checkCanShowCreateSchema(BOB, new CatalogSchemaName("some-catalog", "authenticated"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowCreateSchema(BOB, new CatalogSchemaName("some-catalog", "test")), SHOW_CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "authenticated"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "bob")), SHOW_CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "staff")), SHOW_CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "test")), SHOW_CREATE_SCHEMA_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testGrantSchemaPrivilege() throws Exception {
        for (Privilege privilege : Privilege.values()) {
            this.testGrantSchemaPrivilege(privilege, false);
            this.testGrantSchemaPrivilege(privilege, true);
        }
    }

    private void testGrantSchemaPrivilege(Privilege privilege, boolean grantOption) throws URISyntaxException {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption), String.format(GRANT_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.test", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption), String.format(GRANT_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.bob", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption), String.format(GRANT_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.staff", ""));
        accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption), String.format(GRANT_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.test", ""));
    }

    @Test
    public void testDenySchemaPrivilege() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "bob"), grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "staff"), grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "authenticated"), grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "test"), grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "bob"), grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "staff"), grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "authenticated"), grantee);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "test"), grantee), String.format(DENY_SCHEMA_ACCESS_DENIED_MESSAGE, Privilege.UPDATE, "some-catalog.test", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "bob"), grantee), String.format(DENY_SCHEMA_ACCESS_DENIED_MESSAGE, Privilege.UPDATE, "some-catalog.bob", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "staff"), grantee), String.format(DENY_SCHEMA_ACCESS_DENIED_MESSAGE, Privilege.UPDATE, "some-catalog.staff", ""));
        accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "authenticated"), grantee);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, new CatalogSchemaName("some-catalog", "test"), grantee), String.format(DENY_SCHEMA_ACCESS_DENIED_MESSAGE, Privilege.UPDATE, "some-catalog.test", ""));
    }

    @Test
    public void testRevokeSchemaPrivilege() throws Exception {
        for (Privilege privilege : Privilege.values()) {
            this.testRevokeSchemaPrivilege(privilege, false);
            this.testRevokeSchemaPrivilege(privilege, true);
        }
    }

    private void testRevokeSchemaPrivilege(Privilege privilege, boolean grantOption) throws URISyntaxException {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption), String.format(REVOKE_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.test", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "bob"), grantee, grantOption), String.format(REVOKE_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.bob", ""));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "staff"), grantee, grantOption), String.format(REVOKE_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.staff", ""));
        accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "authenticated"), grantee, grantOption);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, new CatalogSchemaName("some-catalog", "test"), grantee, grantOption), String.format(REVOKE_SCHEMA_ACCESS_DENIED_MESSAGE, privilege, "some-catalog.test", ""));
    }

    @Test
    public void testTableRulesForCheckCanSelectFromColumns() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanSelectFromColumns(ALICE, new CatalogSchemaTableName("some-catalog", "test", "test"), (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"bobcolumn", (Object)"private", (Object)"restricted"));
        accessControl.checkCanSelectFromColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"bobcolumn"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSelectFromColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"bobcolumn", (Object)"private")), SELECT_TABLE_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanSelectFromColumns(JOE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSelectFromColumns(ADMIN, new CatalogSchemaTableName("secret", "secret", "secret"), (Set)ImmutableSet.of()), SELECT_TABLE_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSelectFromColumns(JOE, new CatalogSchemaTableName("secret", "secret", "secret"), (Set)ImmutableSet.of()), SELECT_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanCreateViewWithSelectFromColumns() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanCreateViewWithSelectFromColumns(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns_with_grant"), (Set)ImmutableSet.of()), CREATE_VIEW_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanCreateViewWithSelectFromColumns(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns_with_grant"), (Set)ImmutableSet.of((Object)"bobcolumn", (Object)"private"));
        accessControl.checkCanCreateViewWithSelectFromColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns_with_grant"), (Set)ImmutableSet.of((Object)"bobcolumn"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanCreateViewWithSelectFromColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns_with_grant"), (Set)ImmutableSet.of((Object)"bobcolumn", (Object)"private")), SELECT_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanShowColumns() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanShowColumns(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        accessControl.checkCanShowColumns(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
    }

    @Test
    public void testTableRulesForCheckCanShowColumnsWithNoAccess() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-no-access.json");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowColumns(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), SHOW_COLUMNS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("some-catalog", "bobschema")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testFunctionRulesForCheckExecuteAndGrantExecuteFunctionWithNoAccess() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-no-access.json");
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ALICE, new CatalogSchemaRoutineName("alice-catalog", "schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(ALICE, new CatalogSchemaRoutineName("alice-catalog", "schema", "some_function"))).isFalse();
    }

    @Test
    public void testTableRulesForFilterColumns() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        Assertions.assertThat((Collection)accessControl.filterColumns(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"private", (Object)"a", (Object)"restricted", (Object)"b"))).isEqualTo((Object)ImmutableSet.of((Object)"private", (Object)"a", (Object)"restricted", (Object)"b"));
        Assertions.assertThat((Collection)accessControl.filterColumns(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"private", (Object)"a", (Object)"restricted", (Object)"b"))).isEqualTo((Object)ImmutableSet.of((Object)"private", (Object)"a", (Object)"restricted", (Object)"b"));
        Assertions.assertThat((Collection)accessControl.filterColumns(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), (Set)ImmutableSet.of((Object)"private", (Object)"a", (Object)"restricted", (Object)"b"))).isEqualTo((Object)ImmutableSet.of((Object)"a", (Object)"b"));
    }

    @Test
    public void testTableFilter() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table-filter.json");
        ImmutableSet tables = ImmutableSet.builder().add((Object)new SchemaTableName("restricted", "any")).add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).add((Object)new SchemaTableName("bobschema", "any")).add((Object)new SchemaTableName("any", "any")).build();
        Assertions.assertThat((Collection)accessControl.filterTables(ALICE, "any", (Set)tables)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).build());
        Assertions.assertThat((Collection)accessControl.filterTables(BOB, "any", (Set)tables)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).build());
        Assertions.assertThat((Collection)accessControl.filterTables(ADMIN, "any", (Set)tables)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).add((Object)new SchemaTableName("bobschema", "any")).add((Object)new SchemaTableName("any", "any")).build());
    }

    @Test
    public void testTableFilterNoAccess() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-no-access.json");
        ImmutableSet tables = ImmutableSet.builder().add((Object)new SchemaTableName("restricted", "any")).add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("any", "any")).build();
        Assertions.assertThat((Collection)accessControl.filterTables(ALICE, "any", (Set)tables)).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterTables(BOB, "any", (Set)tables)).isEqualTo((Object)ImmutableSet.of());
    }

    @Test
    public void testTableRulesForFilterColumnsWithNoAccess() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-no-access.json");
        Assertions.assertThat((Collection)accessControl.filterColumns(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), (Set)ImmutableSet.of((Object)"a"))).isEqualTo((Object)ImmutableSet.of());
    }

    @Test
    public void testTableRulesForCheckCanInsertIntoTable() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        BaseFileBasedSystemAccessControlTest.assertTableRulesForCheckCanInsertIntoTable(accessControl);
    }

    private static void assertTableRulesForCheckCanInsertIntoTable(SystemAccessControl accessControl) {
        accessControl.checkCanInsertIntoTable(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        accessControl.checkCanInsertIntoTable(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanInsertIntoTable(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), INSERT_TABLE_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanInsertIntoTable(BOB, new CatalogSchemaTableName("some-catalog", "test", "test")), INSERT_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanDropTable() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanDropTable(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropTable(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), DROP_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanDropMaterializedView() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanDropMaterializedView(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropMaterializedView(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view")), DROP_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanCreateMaterializedView() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanCreateMaterializedView(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"), Map.of());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanCreateMaterializedView(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"), Map.of()), CREATE_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanRefreshMaterializedView() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanRefreshMaterializedView(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRefreshMaterializedView(UNKNOWN, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view")), REFRESH_MATERIALIZED_VIEW_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanSetMaterializedViewProperties() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanSetMaterializedViewProperties(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"), (Map)ImmutableMap.of());
        accessControl.checkCanSetMaterializedViewProperties(ALICE, new CatalogSchemaTableName("some-catalog", "aliceschema", "alice-materialized-view"), (Map)ImmutableMap.of());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetMaterializedViewProperties(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"), (Map)ImmutableMap.of()), SET_MATERIALIZED_VIEW_PROPERTIES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetMaterializedViewProperties(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bob-materialized-view"), (Map)ImmutableMap.of()), SET_MATERIALIZED_VIEW_PROPERTIES_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanDeleteFromTable() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanDeleteFromTable(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDeleteFromTable(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), DELETE_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanTruncateTable() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanTruncateTable(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanTruncateTable(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), TRUNCATE_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanGrantTablePrivilege() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanGrantTablePrivilege(ADMIN, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null, false);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanGrantTablePrivilege(BOB, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null, false), GRANT_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanDenyTablePrivilege() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanDenyTablePrivilege(ADMIN, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDenyTablePrivilege(BOB, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null), DENY_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanRevokeTablePrivilege() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanRevokeTablePrivilege(ADMIN, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null, false);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRevokeTablePrivilege(BOB, Privilege.DELETE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), null, false), REVOKE_DELETE_PRIVILEGE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanShowCreateTable() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanShowCreateTable(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowCreateTable(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), CREATE_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanAddColumn() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanAddColumn(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanAddColumn(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), ADD_COLUMNS_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanDropColumn() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanDropColumn(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanDropColumn(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), DROP_COLUMNS_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanRenameColumn() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanRenameColumn(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameColumn(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), RENAME_COLUMNS_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForMixedGroupUsers() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table-mixed-groups.json");
        SystemSecurityContext userGroup1Group2 = new SystemSecurityContext(Identity.forUser((String)"user_1_2").withGroups((Set)ImmutableSet.of((Object)"group1", (Object)"group2")).build(), queryId, queryStart);
        SystemSecurityContext userGroup2 = new SystemSecurityContext(Identity.forUser((String)"user_2").withGroups((Set)ImmutableSet.of((Object)"group2")).build(), queryId, queryStart);
        Assertions.assertThat((Optional)accessControl.getColumnMask(userGroup1Group2, new CatalogSchemaTableName("some-catalog", "my_schema", "my_table"), "col_a", (Type)VarcharType.VARCHAR)).isEqualTo(Optional.empty());
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)accessControl.getColumnMask(userGroup2, new CatalogSchemaTableName("some-catalog", "my_schema", "my_table"), "col_a", (Type)VarcharType.VARCHAR).orElseThrow(), ViewExpression.builder().catalog("some-catalog").schema("my_schema").expression("'mask_a'").build());
        SystemSecurityContext userGroup1Group3 = new SystemSecurityContext(Identity.forUser((String)"user_1_3").withGroups((Set)ImmutableSet.of((Object)"group1", (Object)"group3")).build(), queryId, queryStart);
        SystemSecurityContext userGroup3 = new SystemSecurityContext(Identity.forUser((String)"user_3").withGroups((Set)ImmutableSet.of((Object)"group3")).build(), queryId, queryStart);
        Assertions.assertThat((List)accessControl.getRowFilters(userGroup1Group3, new CatalogSchemaTableName("some-catalog", "my_schema", "my_table"))).isEqualTo((Object)ImmutableList.of());
        List rowFilters = accessControl.getRowFilters(userGroup3, new CatalogSchemaTableName("some-catalog", "my_schema", "my_table"));
        Assertions.assertThat((List)rowFilters).hasSize(1);
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)rowFilters.get(0), ViewExpression.builder().catalog("some-catalog").schema("my_schema").expression("country='US'").build());
    }

    @Test
    public void testTableRulesForCheckCanSetTableComment() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanSetTableComment(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableComment(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable")), TABLE_COMMENT_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanRenameTable() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanRenameTable(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), new CatalogSchemaTableName("some-catalog", "aliceschema", "newbobtable"));
        accessControl.checkCanRenameTable(ALICE, new CatalogSchemaTableName("some-catalog", "aliceschema", "alicetable"), new CatalogSchemaTableName("some-catalog", "aliceschema", "newalicetable"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameTable(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), new CatalogSchemaTableName("some-catalog", "bobschema", "newbobtable")), RENAME_TABLE_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanRenameTable(ALICE, new CatalogSchemaTableName("some-catalog", "aliceschema", "alicetable"), new CatalogSchemaTableName("some-catalog", "bobschema", "newalicetable")), RENAME_TABLE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testTableRulesForCheckCanSetTableProperties() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        accessControl.checkCanSetTableProperties(ADMIN, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), (Map)ImmutableMap.of());
        accessControl.checkCanSetTableProperties(ALICE, new CatalogSchemaTableName("some-catalog", "aliceschema", "alicetable"), (Map)ImmutableMap.of());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetTableProperties(BOB, new CatalogSchemaTableName("some-catalog", "bobschema", "bobtable"), (Map)ImmutableMap.of()), SET_TABLE_PROPERTIES_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testCanSetUserOperations() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-catalog_principal.json");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetUser(Optional.empty(), alice.getUser()), "Principal null cannot become user alice");
        accessControl.checkCanSetUser(kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
        accessControl.checkCanSetUser(kerberosValidNonAsciiUser.getPrincipal(), kerberosValidNonAsciiUser.getUser());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetUser(kerberosInvalidAlice.getPrincipal(), kerberosInvalidAlice.getUser()), "Principal mallory/example.com@EXAMPLE.COM cannot become user alice");
        accessControl.checkCanSetUser(kerberosValidShare.getPrincipal(), kerberosValidShare.getUser());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetUser(kerberosInValidShare.getPrincipal(), kerberosInValidShare.getUser()), "Principal invalid/example.com@EXAMPLE.COM cannot become user alice");
        accessControl.checkCanSetUser(validSpecialRegexWildDot.getPrincipal(), validSpecialRegexWildDot.getUser());
        accessControl.checkCanSetUser(validSpecialRegexEndQuote.getPrincipal(), validSpecialRegexEndQuote.getUser());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetUser(invalidSpecialRegex.getPrincipal(), invalidSpecialRegex.getUser()), "Principal special/.*@EXAMPLE.COM cannot become user alice");
        SystemAccessControl accessControlNoPatterns = this.newFileBasedSystemAccessControl("file-based-system-catalog.json");
        accessControlNoPatterns.checkCanSetUser(kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
    }

    @Test
    public void testQuery() throws Exception {
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl("query.json");
        accessControlManager.checkCanExecuteQuery(admin, queryId);
        accessControlManager.checkCanViewQueryOwnedBy(admin, any);
        Assertions.assertThat((Collection)accessControlManager.filterViewQueryOwnedBy(admin, (Collection)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")))).isEqualTo((Object)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")));
        accessControlManager.checkCanKillQueryOwnedBy(admin, any);
        accessControlManager.checkCanExecuteQuery(alice, queryId);
        accessControlManager.checkCanViewQueryOwnedBy(alice, any);
        Assertions.assertThat((Collection)accessControlManager.filterViewQueryOwnedBy(alice, (Collection)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")))).isEqualTo((Object)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(alice, any), "Cannot kill query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanExecuteQuery(bob, queryId), "Cannot execute query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(bob, any), "Cannot view query");
        Assertions.assertThat((Collection)accessControlManager.filterViewQueryOwnedBy(bob, (Collection)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")))).isEqualTo((Object)ImmutableSet.of());
        accessControlManager.checkCanKillQueryOwnedBy(bob, any);
        accessControlManager.checkCanExecuteQuery(dave, queryId);
        accessControlManager.checkCanViewQueryOwnedBy(dave, alice);
        accessControlManager.checkCanViewQueryOwnedBy(dave, dave);
        Assertions.assertThat((Collection)accessControlManager.filterViewQueryOwnedBy(dave, (Collection)ImmutableSet.of((Object)Identity.ofUser((String)"alice"), (Object)Identity.ofUser((String)"bob"), (Object)Identity.ofUser((String)"dave"), (Object)Identity.ofUser((String)"admin")))).isEqualTo((Object)ImmutableSet.of((Object)Identity.ofUser((String)"alice"), (Object)Identity.ofUser((String)"dave")));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(dave, alice), "Cannot kill query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(dave, bob), "Cannot kill query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(dave, bob), "Cannot view query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(dave, admin), "Cannot view query");
        Identity contractor = Identity.forUser((String)"some-other-contractor").withGroups((Set)ImmutableSet.of((Object)"contractors")).build();
        accessControlManager.checkCanExecuteQuery(contractor, queryId);
        accessControlManager.checkCanViewQueryOwnedBy(contractor, dave);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(contractor, dave), "Cannot kill query");
        accessControlManager.checkCanExecuteQuery(nonAsciiUser, queryId);
        accessControlManager.checkCanViewQueryOwnedBy(nonAsciiUser, any);
        Assertions.assertThat((Collection)accessControlManager.filterViewQueryOwnedBy(nonAsciiUser, (Collection)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")))).isEqualTo((Object)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")));
        accessControlManager.checkCanKillQueryOwnedBy(nonAsciiUser, any);
    }

    @Test
    public void testInvalidQuery() {
        Assertions.assertThatThrownBy(() -> this.newFileBasedSystemAccessControl("query-invalid.json")).rootCause().hasMessage("A valid query rule cannot combine an queryOwner condition with access mode 'execute'");
    }

    @Test
    public void testQueryNotSet() throws Exception {
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl("file-based-system-catalog.json");
        accessControlManager.checkCanExecuteQuery(bob, queryId);
        accessControlManager.checkCanViewQueryOwnedBy(bob, any);
        Assertions.assertThat((Collection)accessControlManager.filterViewQueryOwnedBy(bob, (Collection)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")))).isEqualTo((Object)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")));
        accessControlManager.checkCanKillQueryOwnedBy(bob, any);
    }

    @Test
    public void testQueryDocsExample() {
        Path rulesFile = Paths.get("../../docs/src/main/sphinx/security/query-access.json", new String[0]);
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl(rulesFile, (Map<String, String>)ImmutableMap.of());
        accessControlManager.checkCanExecuteQuery(admin, queryId);
        accessControlManager.checkCanViewQueryOwnedBy(admin, any);
        Assertions.assertThat((Collection)accessControlManager.filterViewQueryOwnedBy(admin, (Collection)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")))).isEqualTo((Object)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")));
        accessControlManager.checkCanKillQueryOwnedBy(admin, any);
        accessControlManager.checkCanExecuteQuery(alice, queryId);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(alice, any), "Cannot view query");
        Assertions.assertThat((Collection)accessControlManager.filterViewQueryOwnedBy(alice, (Collection)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")))).isEqualTo((Object)ImmutableSet.of());
        accessControlManager.checkCanKillQueryOwnedBy(alice, any);
        accessControlManager.checkCanExecuteQuery(alice, queryId);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(bob, any), "Cannot view query");
        Assertions.assertThat((Collection)accessControlManager.filterViewQueryOwnedBy(bob, (Collection)ImmutableSet.of((Object)Identity.ofUser((String)"a"), (Object)Identity.ofUser((String)"b")))).isEqualTo((Object)ImmutableSet.of());
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(bob, any), "Cannot kill query");
        accessControlManager.checkCanExecuteQuery(dave, queryId);
        accessControlManager.checkCanViewQueryOwnedBy(dave, alice);
        accessControlManager.checkCanViewQueryOwnedBy(dave, dave);
        Assertions.assertThat((Collection)accessControlManager.filterViewQueryOwnedBy(dave, (Collection)ImmutableSet.of((Object)Identity.ofUser((String)"alice"), (Object)Identity.ofUser((String)"bob"), (Object)Identity.ofUser((String)"dave"), (Object)Identity.ofUser((String)"admin")))).isEqualTo((Object)ImmutableSet.of((Object)Identity.ofUser((String)"alice"), (Object)Identity.ofUser((String)"dave")));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(dave, alice), "Cannot kill query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(dave, bob), "Cannot kill query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(dave, bob), "Cannot view query");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanViewQueryOwnedBy(dave, admin), "Cannot view query");
        Identity contractor = Identity.forUser((String)"some-other-contractor").withGroups((Set)ImmutableSet.of((Object)"contractors")).build();
        accessControlManager.checkCanExecuteQuery(contractor, queryId);
        accessControlManager.checkCanViewQueryOwnedBy(contractor, dave);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanKillQueryOwnedBy(contractor, dave), "Cannot kill query");
    }

    @Test
    public void testSystemInformation() throws Exception {
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl("system-information.json");
        accessControlManager.checkCanReadSystemInformation(admin);
        accessControlManager.checkCanWriteSystemInformation(admin);
        accessControlManager.checkCanReadSystemInformation(alice);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanWriteSystemInformation(alice), "Cannot write system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanReadSystemInformation(bob), "Cannot read system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanWriteSystemInformation(bob), "Cannot write system information");
        accessControlManager.checkCanReadSystemInformation(nonAsciiUser);
        accessControlManager.checkCanWriteSystemInformation(nonAsciiUser);
    }

    @Test
    public void testSystemInformationNotSet() throws Exception {
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl("file-based-system-catalog.json");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanReadSystemInformation(bob), "Cannot read system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanWriteSystemInformation(bob), "Cannot write system information");
    }

    @Test
    public void testSystemInformationDocsExample() {
        Path rulesFile = Paths.get("../../docs/src/main/sphinx/security/system-information-access.json", new String[0]);
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl(rulesFile, (Map<String, String>)ImmutableMap.of());
        accessControlManager.checkCanReadSystemInformation(admin);
        accessControlManager.checkCanWriteSystemInformation(admin);
        accessControlManager.checkCanReadSystemInformation(alice);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanWriteSystemInformation(alice), "Cannot write system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanReadSystemInformation(bob), "Cannot read system information");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanWriteSystemInformation(bob), "Cannot write system information");
    }

    @Test
    public void testSessionPropertyRules() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-session-property.json");
        accessControl.checkCanSetSystemSessionProperty(admin, queryId, "dangerous");
        accessControl.checkCanSetSystemSessionProperty(admin, queryId, "any");
        accessControl.checkCanSetSystemSessionProperty(alice, queryId, "safe");
        accessControl.checkCanSetSystemSessionProperty(alice, queryId, "unsafe");
        accessControl.checkCanSetSystemSessionProperty(alice, queryId, "staff");
        accessControl.checkCanSetSystemSessionProperty(bob, queryId, "safe");
        accessControl.checkCanSetSystemSessionProperty(bob, queryId, "staff");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(bob, queryId, "unsafe"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(alice, queryId, "dangerous"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(charlie, queryId, "safe"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(charlie, queryId, "staff"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(joe, queryId, "staff"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "any", "dangerous");
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "alice-catalog", "dangerous");
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "any", "any");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "alice-catalog", "safe");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "alice-catalog", "unsafe");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "staff-catalog", "staff");
        accessControl.checkCanSetCatalogSessionProperty(BOB, "bob-catalog", "safe");
        accessControl.checkCanSetCatalogSessionProperty(BOB, "staff-catalog", "staff");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(BOB, "bob-catalog", "any"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(BOB, "alice-catalog", "any"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(BOB, "staff-catalog", "any"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(ALICE, "alice-catalog", "dangerous"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(CHARLIE, "bob-catalog", "safe"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(CHARLIE, "staff-catalog", "staff"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(JOE, "staff-catalog", "staff"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testSessionPropertyDocsExample() {
        Path rulesFile = Paths.get("../../docs/src/main/sphinx/security/session-property-access.json", new String[0]);
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl(rulesFile, (Map<String, String>)ImmutableMap.of());
        Identity bannedUser = Identity.ofUser((String)"banned_user");
        SystemSecurityContext bannedUserContext = new SystemSecurityContext(Identity.ofUser((String)"banned_user"), queryId, queryStart);
        accessControl.checkCanSetSystemSessionProperty(admin, queryId, "any");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(alice, queryId, "any"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(bannedUser, queryId, "any"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanSetSystemSessionProperty(admin, queryId, "resource_overcommit");
        accessControl.checkCanSetSystemSessionProperty(alice, queryId, "resource_overcommit");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetSystemSessionProperty(bannedUser, queryId, "resource_overcommit"), SET_SYSTEM_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "hive", "any");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(ALICE, "hive", "any"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(bannedUserContext, "hive", "any"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "hive", "bucket_execution_enabled");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "hive", "bucket_execution_enabled");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetCatalogSessionProperty(bannedUserContext, "hive", "bucket_execution_enabled"), SET_CATALOG_SESSION_PROPERTY_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testFilterCatalogs() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        ImmutableSet allCatalogs = ImmutableSet.of((Object)"alice-catalog", (Object)"bob-catalog", (Object)"specific-catalog", (Object)"secret", (Object)"hidden", (Object)"open-to-all", (Object[])new String[]{"blocked-catalog", "unknown", "ptf-catalog"});
        Assertions.assertThat((Collection)accessControl.filterCatalogs(ADMIN, (Set)allCatalogs)).isEqualTo((Object)Sets.difference((Set)allCatalogs, (Set)ImmutableSet.of((Object)"blocked-catalog")));
        ImmutableSet aliceCatalogs = ImmutableSet.of((Object)"specific-catalog", (Object)"alice-catalog", (Object)"ptf-catalog");
        Assertions.assertThat((Collection)accessControl.filterCatalogs(ALICE, (Set)allCatalogs)).isEqualTo((Object)aliceCatalogs);
        ImmutableSet bobCatalogs = ImmutableSet.of((Object)"specific-catalog", (Object)"alice-catalog", (Object)"bob-catalog");
        Assertions.assertThat((Collection)accessControl.filterCatalogs(BOB, (Set)allCatalogs)).isEqualTo((Object)bobCatalogs);
        ImmutableSet charlieCatalogs = ImmutableSet.of((Object)"specific-catalog");
        Assertions.assertThat((Collection)accessControl.filterCatalogs(CHARLIE, (Set)allCatalogs)).isEqualTo((Object)charlieCatalogs);
    }

    @Test
    public void testSchemaRulesForCheckCanShowSchemas() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        accessControl.checkCanShowSchemas(ADMIN, "specific-catalog");
        accessControl.checkCanShowSchemas(ADMIN, "session-catalog");
        accessControl.checkCanShowSchemas(ADMIN, "secret");
        accessControl.checkCanShowSchemas(ADMIN, "hidden");
        accessControl.checkCanShowSchemas(ADMIN, "open-to-all");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ADMIN, "blocked-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowSchemas(ADMIN, "unknown");
        accessControl.checkCanShowSchemas(ALICE, "specific-catalog");
        accessControl.checkCanShowSchemas(ALICE, "session-catalog");
        accessControl.checkCanShowSchemas(ALICE, "alice-catalog");
        accessControl.checkCanShowSchemas(ALICE, "alice-catalog-session");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "bob-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "bob-catalog-session"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "secret"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "hidden"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "open-to-all"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "blocked-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(ALICE, "unknown"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowSchemas(BOB, "specific-catalog");
        accessControl.checkCanShowSchemas(BOB, "session-catalog");
        accessControl.checkCanShowSchemas(BOB, "bob-catalog");
        accessControl.checkCanShowSchemas(BOB, "bob-catalog-session");
        accessControl.checkCanShowSchemas(BOB, "alice-catalog");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "alice-catalog-session"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "secret"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "hidden"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "open-to-all"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "blocked-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(BOB, "unknown"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowSchemas(CHARLIE, "session-catalog");
        accessControl.checkCanShowSchemas(CHARLIE, "specific-catalog");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "alice-catalog-session"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "alice-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "bob-catalog-session"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "bob-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "secret"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "hidden"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "open-to-all"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "blocked-catalog"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowSchemas(CHARLIE, "unknown"), SHOWN_SCHEMAS_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testFilterSchemas() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        Assertions.assertThat((Collection)accessControl.filterSchemas(ADMIN, "specific-catalog", (Set)ImmutableSet.of((Object)"specific-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"specific-schema", (Object)"unknown"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(ALICE, "specific-catalog", (Set)ImmutableSet.of((Object)"specific-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"specific-schema"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(BOB, "specific-catalog", (Set)ImmutableSet.of((Object)"specific-schema"))).isEqualTo((Object)ImmutableSet.of((Object)"specific-schema"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(CHARLIE, "specific-catalog", (Set)ImmutableSet.of((Object)"specific-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"specific-schema"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(ADMIN, "alice-catalog", (Set)ImmutableSet.of((Object)"alice-schema", (Object)"bob-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"alice-schema", (Object)"bob-schema", (Object)"unknown"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(ALICE, "alice-catalog", (Set)ImmutableSet.of((Object)"alice-schema", (Object)"bob-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"alice-schema"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(BOB, "alice-catalog", (Set)ImmutableSet.of((Object)"alice-schema", (Object)"bob-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"bob-schema"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(CHARLIE, "alice-catalog", (Set)ImmutableSet.of((Object)"alice-schema", (Object)"bob-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(ADMIN, "bob-catalog", (Set)ImmutableSet.of((Object)"bob-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"bob-schema", (Object)"unknown"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(ALICE, "bob-catalog", (Set)ImmutableSet.of((Object)"bob-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(BOB, "bob-catalog", (Set)ImmutableSet.of((Object)"bob-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"bob-schema"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(CHARLIE, "bob-catalog", (Set)ImmutableSet.of((Object)"bob-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(ADMIN, "secret", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"unknown"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(ALICE, "secret", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(BOB, "secret", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(CHARLIE, "secret", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(ADMIN, "hidden", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"unknown"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(ALICE, "hidden", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(BOB, "hidden", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(CHARLIE, "hidden", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(ADMIN, "open-to-all", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"unknown"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(ALICE, "open-to-all", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(BOB, "open-to-all", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(CHARLIE, "open-to-all", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(ADMIN, "blocked-catalog", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(ALICE, "blocked-catalog", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(BOB, "blocked-catalog", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(CHARLIE, "blocked-catalog", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(ADMIN, "unknown", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"unknown"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(ALICE, "unknown", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(BOB, "unknown", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(CHARLIE, "unknown", (Set)ImmutableSet.of((Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(ADMIN, "session-catalog", (Set)ImmutableSet.of((Object)"session-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of((Object)"session-schema", (Object)"unknown"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(ALICE, "session-catalog", (Set)ImmutableSet.of((Object)"session-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(BOB, "session-catalog", (Set)ImmutableSet.of((Object)"session-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(CHARLIE, "session-catalog", (Set)ImmutableSet.of((Object)"session-schema", (Object)"unknown"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(ADMIN, "ptf-catalog", (Set)ImmutableSet.of((Object)"ptf_schema"))).isEqualTo((Object)ImmutableSet.of((Object)"ptf_schema"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(ALICE, "ptf-catalog", (Set)ImmutableSet.of((Object)"ptf_schema"))).isEqualTo((Object)ImmutableSet.of((Object)"ptf_schema"));
        Assertions.assertThat((Collection)accessControl.filterSchemas(BOB, "ptf-catalog", (Set)ImmutableSet.of((Object)"ptf_schema"))).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterSchemas(CHARLIE, "ptf-catalog", (Set)ImmutableSet.of((Object)"ptf_schema"))).isEqualTo((Object)ImmutableSet.of());
    }

    @Test
    public void testSchemaRulesForCheckCanShowTables() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("specific-catalog", "specific-schema"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("bob-catalog", "bob-schema"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("bob-catalog", "any"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("alice-catalog", "alice-schema"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("alice-catalog", "any"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("secret", "secret"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("hidden", "any"));
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("open-to-all", "any"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowTables(ADMIN, new CatalogSchemaName("unknown", "any"));
        accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("specific-catalog", "specific-schema"));
        accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("alice-catalog", "alice-schema"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("bob-catalog", "bob-schema")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("secret", "secret")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("hidden", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("open-to-all", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(ALICE, new CatalogSchemaName("unknown", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowTables(BOB, new CatalogSchemaName("specific-catalog", "specific-schema"));
        accessControl.checkCanShowTables(BOB, new CatalogSchemaName("bob-catalog", "bob-schema"));
        accessControl.checkCanShowTables(BOB, new CatalogSchemaName("alice-catalog", "bob-schema"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("bob-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("alice-catalog", "alice-schema")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("alice-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("secret", "secret")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("hidden", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("open-to-all", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(BOB, new CatalogSchemaName("unknown", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("specific-catalog", "specific-schema"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("bob-catalog", "bob-schema")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("bob-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("alice-catalog", "alice-schema")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("alice-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("secret", "secret")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("hidden", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("open-to-all", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowTables(CHARLIE, new CatalogSchemaName("unknown", "any")), SHOWN_TABLES_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testSchemaRulesForCheckCanShowFunctions() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        accessControl.checkCanShowFunctions(ADMIN, new CatalogSchemaName("specific-catalog", "specific-schema"));
        accessControl.checkCanShowFunctions(ADMIN, new CatalogSchemaName("bob-catalog", "bob-schema"));
        accessControl.checkCanShowFunctions(ADMIN, new CatalogSchemaName("bob-catalog", "any"));
        accessControl.checkCanShowFunctions(ADMIN, new CatalogSchemaName("alice-catalog", "alice-schema"));
        accessControl.checkCanShowFunctions(ADMIN, new CatalogSchemaName("alice-catalog", "any"));
        accessControl.checkCanShowFunctions(ADMIN, new CatalogSchemaName("secret", "secret"));
        accessControl.checkCanShowFunctions(ADMIN, new CatalogSchemaName("hidden", "any"));
        accessControl.checkCanShowFunctions(ADMIN, new CatalogSchemaName("open-to-all", "any"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(ADMIN, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowFunctions(ADMIN, new CatalogSchemaName("unknown", "any"));
        accessControl.checkCanShowFunctions(ALICE, new CatalogSchemaName("specific-catalog", "specific-schema"));
        accessControl.checkCanShowFunctions(ALICE, new CatalogSchemaName("alice-catalog", "alice-schema"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(ALICE, new CatalogSchemaName("bob-catalog", "bob-schema")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(ALICE, new CatalogSchemaName("secret", "secret")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(ALICE, new CatalogSchemaName("hidden", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(ALICE, new CatalogSchemaName("open-to-all", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(ALICE, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(ALICE, new CatalogSchemaName("unknown", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowFunctions(BOB, new CatalogSchemaName("specific-catalog", "specific-schema"));
        accessControl.checkCanShowFunctions(BOB, new CatalogSchemaName("bob-catalog", "bob-schema"));
        accessControl.checkCanShowFunctions(BOB, new CatalogSchemaName("alice-catalog", "bob-schema"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(BOB, new CatalogSchemaName("bob-catalog", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(BOB, new CatalogSchemaName("alice-catalog", "alice-schema")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(BOB, new CatalogSchemaName("alice-catalog", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(BOB, new CatalogSchemaName("secret", "secret")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(BOB, new CatalogSchemaName("hidden", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(BOB, new CatalogSchemaName("open-to-all", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(BOB, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(BOB, new CatalogSchemaName("unknown", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        accessControl.checkCanShowFunctions(CHARLIE, new CatalogSchemaName("specific-catalog", "specific-schema"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, new CatalogSchemaName("bob-catalog", "bob-schema")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, new CatalogSchemaName("bob-catalog", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, new CatalogSchemaName("alice-catalog", "alice-schema")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, new CatalogSchemaName("alice-catalog", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, new CatalogSchemaName("secret", "secret")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, new CatalogSchemaName("hidden", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, new CatalogSchemaName("open-to-all", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, new CatalogSchemaName("blocked-catalog", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanShowFunctions(CHARLIE, new CatalogSchemaName("unknown", "any")), SHOWN_FUNCTIONS_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testGetColumnMask() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        Assertions.assertThat((Optional)accessControl.getColumnMask(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), "masked", (Type)VarcharType.VARCHAR)).isEqualTo(Optional.empty());
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)accessControl.getColumnMask(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), "masked", (Type)VarcharType.VARCHAR).orElseThrow(), ViewExpression.builder().catalog("some-catalog").schema("bobschema").expression("'mask'").build());
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)accessControl.getColumnMask(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), "masked_with_user", (Type)VarcharType.VARCHAR).orElseThrow(), ViewExpression.builder().identity("mask-user").catalog("some-catalog").schema("bobschema").expression("'mask-with-user'").build());
    }

    @Test
    public void testGetColumnMasks() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        List columns = (List)Stream.of("private", "restricted", "masked", "masked_with_user").map(BaseFileBasedSystemAccessControlTest::createColumnSchema).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((Map)accessControl.getColumnMasks(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), columns)).isEmpty();
        Map charlieColumnMasks = accessControl.getColumnMasks(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"), columns);
        Assertions.assertThat((Map)charlieColumnMasks).doesNotContainKey((Object)BaseFileBasedSystemAccessControlTest.createColumnSchema("private"));
        Assertions.assertThat((Map)charlieColumnMasks).doesNotContainKey((Object)BaseFileBasedSystemAccessControlTest.createColumnSchema("restricted"));
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)charlieColumnMasks.get(BaseFileBasedSystemAccessControlTest.createColumnSchema("masked")), ViewExpression.builder().catalog("some-catalog").schema("bobschema").expression("'mask'").build());
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)charlieColumnMasks.get(BaseFileBasedSystemAccessControlTest.createColumnSchema("masked_with_user")), ViewExpression.builder().identity("mask-user").catalog("some-catalog").schema("bobschema").expression("'mask-with-user'").build());
    }

    public static ColumnSchema createColumnSchema(String columnName) {
        return ColumnSchema.builder().setName(columnName).setType((Type)VarcharType.VARCHAR).build();
    }

    @Test
    public void testGetRowFilter() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-table.json");
        Assertions.assertThat((List)accessControl.getRowFilters(ALICE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"))).isEqualTo((Object)ImmutableList.of());
        List rowFilters = accessControl.getRowFilters(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns"));
        Assertions.assertThat((List)rowFilters).hasSize(1);
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)rowFilters.get(0), ViewExpression.builder().catalog("some-catalog").schema("bobschema").expression("starts_with(value, 'filter')").build());
        rowFilters = accessControl.getRowFilters(CHARLIE, new CatalogSchemaTableName("some-catalog", "bobschema", "bobcolumns_with_grant"));
        Assertions.assertThat((List)rowFilters).hasSize(1);
        BaseFileBasedSystemAccessControlTest.assertViewExpressionEquals((ViewExpression)rowFilters.get(0), ViewExpression.builder().identity("filter-user").catalog("some-catalog").schema("bobschema").expression("starts_with(value, 'filter-with-user')").build());
    }

    private static void assertViewExpressionEquals(ViewExpression actual, ViewExpression expected) {
        ((OptionalAssert)Assertions.assertThat((Optional)actual.getSecurityIdentity()).describedAs("Identity", new Object[0])).isEqualTo((Object)expected.getSecurityIdentity());
        ((OptionalAssert)Assertions.assertThat((Optional)actual.getCatalog()).describedAs("Catalog", new Object[0])).isEqualTo((Object)expected.getCatalog());
        ((OptionalAssert)Assertions.assertThat((Optional)actual.getSchema()).describedAs("Schema", new Object[0])).isEqualTo((Object)expected.getSchema());
        ((AbstractStringAssert)Assertions.assertThat((String)actual.getExpression()).describedAs("Expression", new Object[0])).isEqualTo(expected.getExpression());
        ((ListAssert)Assertions.assertThat((List)actual.getPath()).describedAs("Path", new Object[0])).isEqualTo((Object)expected.getPath());
    }

    @Test
    public void testProcedureRulesForCheckCanExecute() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        accessControl.checkCanExecuteProcedure(BOB, new CatalogSchemaRoutineName("alice-catalog", new SchemaRoutineName("procedure-schema", "some_procedure")));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteProcedure(BOB, new CatalogSchemaRoutineName("alice-catalog", new SchemaRoutineName("some-schema", "some_procedure"))), EXECUTE_PROCEDURE_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteProcedure(BOB, new CatalogSchemaRoutineName("alice-catalog", new SchemaRoutineName("procedure-schema", "another_procedure"))), EXECUTE_PROCEDURE_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteProcedure(CHARLIE, new CatalogSchemaRoutineName("open-to-all", new SchemaRoutineName("some-schema", "some_procedure"))), EXECUTE_PROCEDURE_ACCESS_DENIED_MESSAGE);
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanExecuteProcedure(ALICE, new CatalogSchemaRoutineName("alice-catalog", new SchemaRoutineName("procedure-schema", "some_procedure"))), EXECUTE_PROCEDURE_ACCESS_DENIED_MESSAGE);
    }

    @Test
    public void testFunctionRulesForCheckCanExecute() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(BOB, new CatalogSchemaRoutineName("specific-catalog", "system", "some_function"))).isTrue();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ADMIN, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ADMIN, new CatalogSchemaRoutineName("specific-catalog", "system", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ALICE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"))).isTrue();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(ALICE, new CatalogSchemaRoutineName("specific-catalog", "system", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(BOB, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(BOB, new CatalogSchemaRoutineName("specific-catalog", "system", "some_function"))).isTrue();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(CHARLIE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canExecuteFunction(CHARLIE, new CatalogSchemaRoutineName("specific-catalog", "system", "some_function"))).isFalse();
    }

    @Test
    public void testFunctionRulesForCheckCanCreateView() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-visibility.json");
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(ALICE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"))).isTrue();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(ALICE, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(ALICE, new CatalogSchemaRoutineName("specific-catalog", "builtin", "some_table_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(ALICE, new CatalogSchemaRoutineName("specific-catalog", "builtin", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(BOB, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_table_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(BOB, new CatalogSchemaRoutineName("ptf-catalog", "ptf_schema", "some_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(BOB, new CatalogSchemaRoutineName("specific-catalog", "builtin", "some_table_function"))).isFalse();
        Assertions.assertThat((boolean)accessControl.canCreateViewWithExecuteFunction(BOB, new CatalogSchemaRoutineName("specific-catalog", "builtin", "some_function"))).isTrue();
    }

    @Test
    public void testSchemaAuthorization() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("authorization.json");
        CatalogSchemaName schema = new CatalogSchemaName("some-catalog", "test");
        List<String> ownedByUser = List.of("some-catalog", "owned_by_user");
        List<String> ownedByGroup = List.of("some-catalog", "owned_by_group");
        List<String> ownedByRole = List.of("some-catalog", "owned_by_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "role"), new EntityKindAndName("SCHEMA", List.of(schema.getCatalogName(), schema.getSchemaName())), new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.test to ROLE new_role");
        EntityKindAndName schemaOwnedByUser = new EntityKindAndName("SCHEMA", ownedByUser);
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_authorized", "group", "role"), schemaOwnedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "authorized", "role"), schemaOwnedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), schemaOwnedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_without_authorization_access", "group", "role"), schemaOwnedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_DENY_authorized", "group", "role"), schemaOwnedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_user to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "DENY_authorized", "role"), schemaOwnedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "DENY_authorized"), schemaOwnedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), schemaOwnedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_user to USER new_user");
        EntityKindAndName schemaOwnedByGroup = new EntityKindAndName("SCHEMA", ownedByGroup);
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "owner", "role"), schemaOwnedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), schemaOwnedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "role"), schemaOwnedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "owner", "role"), schemaOwnedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_group to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "DENY_authorized"), schemaOwnedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), schemaOwnedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_group to USER new_user");
        EntityKindAndName schemaOwnedByRole = new EntityKindAndName("SCHEMA", ownedByRole);
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "group", "owner"), schemaOwnedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), schemaOwnedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner"), schemaOwnedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "group", "owner"), schemaOwnedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_role to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_DENY_authorized"), schemaOwnedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for schema some-catalog.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), schemaOwnedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for schema some-catalog.owned_by_role to USER new_user");
    }

    @Test
    public void testTableAuthorization() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("authorization.json");
        List<String> table = List.of("some-catalog", "test", "table");
        List<String> ownedByUser = List.of("some-catalog", "test", "owned_by_user");
        List<String> ownedByGroup = List.of("some-catalog", "test", "owned_by_group");
        List<String> ownedByRole = List.of("some-catalog", "test", "owned_by_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "role"), new EntityKindAndName("TABLE", table), new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.table to ROLE new_role");
        EntityKindAndName tableOwnedByUser = new EntityKindAndName("TABLE", ownedByUser);
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_authorized", "group", "role"), tableOwnedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), tableOwnedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_without_authorization_access", "group", "role"), tableOwnedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_DENY_authorized", "group", "role"), tableOwnedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_user to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "DENY_authorized"), tableOwnedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), tableOwnedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_user to USER new_user");
        EntityKindAndName tableOwnedByGroup = new EntityKindAndName("TABLE", ownedByGroup);
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "owner", "role"), tableOwnedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), tableOwnedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "role"), tableOwnedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "owner", "role"), tableOwnedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_group to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "DENY_authorized"), tableOwnedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), tableOwnedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_group to USER new_user");
        EntityKindAndName tableOwnedByRole = new EntityKindAndName("TABLE", ownedByRole);
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "group", "owner"), tableOwnedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), tableOwnedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner"), tableOwnedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "group", "owner"), tableOwnedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_role to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_DENY_authorized"), tableOwnedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for table some-catalog.test.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), tableOwnedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for table some-catalog.test.owned_by_role to USER new_user");
    }

    @Test
    public void testViewAuthorization() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("authorization.json");
        List<String> table = List.of("some-catalog", "test", "table");
        List<String> ownedByUser = List.of("some-catalog", "test", "owned_by_user");
        List<String> ownedByGroup = List.of("some-catalog", "test", "owned_by_group");
        List<String> ownedByRole = List.of("some-catalog", "test", "owned_by_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "role"), new EntityKindAndName("VIEW", table), new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.table to ROLE new_role");
        EntityKindAndName viewOwnedByUser = new EntityKindAndName("VIEW", ownedByUser);
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_authorized", "group", "role"), viewOwnedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), viewOwnedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_without_authorization_access", "group", "role"), viewOwnedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner_DENY_authorized", "group", "role"), viewOwnedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_user to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "DENY_authorized"), viewOwnedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_user to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("owner", "group", "authorized"), viewOwnedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_user to USER new_user");
        EntityKindAndName viewOwnedByGroup = new EntityKindAndName("VIEW", ownedByGroup);
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "owner", "role"), viewOwnedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), viewOwnedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "role"), viewOwnedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "owner", "role"), viewOwnedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_group to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "DENY_authorized"), viewOwnedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_group to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "owner", "authorized"), viewOwnedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_group to USER new_user");
        EntityKindAndName viewOwnedByRole = new EntityKindAndName("VIEW", ownedByRole);
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("authorized", "group", "owner"), viewOwnedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), viewOwnedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner"), viewOwnedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("DENY_authorized", "group", "owner"), viewOwnedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_role to USER new_user");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_DENY_authorized"), viewOwnedByRole, new TrinoPrincipal(PrincipalType.ROLE, "new_role")), "Cannot set authorization for view some-catalog.test.owned_by_role to ROLE new_role");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControl.checkCanSetEntityAuthorization(BaseFileBasedSystemAccessControlTest.user("user", "group", "owner_authorized"), viewOwnedByRole, new TrinoPrincipal(PrincipalType.USER, "new_user")), "Cannot set authorization for view some-catalog.test.owned_by_role to USER new_user");
    }

    @Test
    public void testFunctionsFilter() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-access-function-filter.json");
        ImmutableSet functions = ImmutableSet.builder().add((Object)new SchemaFunctionName("restricted", "any")).add((Object)new SchemaFunctionName("secret", "any")).add((Object)new SchemaFunctionName("aliceschema", "any")).add((Object)new SchemaFunctionName("aliceschema", "bobfunction")).add((Object)new SchemaFunctionName("bobschema", "bob_any")).add((Object)new SchemaFunctionName("bobschema", "any")).add((Object)new SchemaFunctionName("any", "any")).build();
        Assertions.assertThat((Collection)accessControl.filterFunctions(ALICE, "any", (Set)functions)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaFunctionName("aliceschema", "any")).add((Object)new SchemaFunctionName("aliceschema", "bobfunction")).build());
        Assertions.assertThat((Collection)accessControl.filterFunctions(BOB, "any", (Set)functions)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaFunctionName("aliceschema", "bobfunction")).add((Object)new SchemaFunctionName("bobschema", "bob_any")).build());
        Assertions.assertThat((Collection)accessControl.filterFunctions(ADMIN, "any", (Set)functions)).isEqualTo((Object)ImmutableSet.builder().add((Object)new SchemaFunctionName("secret", "any")).add((Object)new SchemaFunctionName("aliceschema", "any")).add((Object)new SchemaFunctionName("aliceschema", "bobfunction")).add((Object)new SchemaFunctionName("bobschema", "bob_any")).add((Object)new SchemaFunctionName("bobschema", "any")).add((Object)new SchemaFunctionName("any", "any")).build());
    }

    @Test
    public void testFunctionsFilterNoAccess() throws Exception {
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl("file-based-system-no-access.json");
        ImmutableSet functions = ImmutableSet.builder().add((Object)new SchemaFunctionName("restricted", "any")).add((Object)new SchemaFunctionName("secret", "any")).add((Object)new SchemaFunctionName("any", "any")).build();
        Assertions.assertThat((Collection)accessControl.filterFunctions(ALICE, "any", (Set)functions)).isEqualTo((Object)ImmutableSet.of());
        Assertions.assertThat((Collection)accessControl.filterFunctions(BOB, "any", (Set)functions)).isEqualTo((Object)ImmutableSet.of());
    }

    @Test
    public void testAuthorizationDocsExample() {
        Path rulesFile = Paths.get("../../docs/src/main/sphinx/security/authorization.json", new String[0]);
        SystemAccessControl accessControlManager = this.newFileBasedSystemAccessControl(rulesFile, (Map<String, String>)ImmutableMap.of());
        List<String> schema = List.of("catalog", "schema");
        List<String> tableOrView = List.of("catalog", "schema", "table_or_view");
        accessControlManager.checkCanSetEntityAuthorization(ADMIN, new EntityKindAndName("SCHEMA", schema), new TrinoPrincipal(PrincipalType.USER, "alice"));
        accessControlManager.checkCanSetEntityAuthorization(ADMIN, new EntityKindAndName("SCHEMA", schema), new TrinoPrincipal(PrincipalType.ROLE, "role"));
        accessControlManager.checkCanSetEntityAuthorization(ADMIN, new EntityKindAndName("TABLE", tableOrView), new TrinoPrincipal(PrincipalType.USER, "alice"));
        accessControlManager.checkCanSetEntityAuthorization(ADMIN, new EntityKindAndName("TABLE", tableOrView), new TrinoPrincipal(PrincipalType.ROLE, "role"));
        accessControlManager.checkCanSetEntityAuthorization(ADMIN, new EntityKindAndName("VIEW", tableOrView), new TrinoPrincipal(PrincipalType.USER, "alice"));
        accessControlManager.checkCanSetEntityAuthorization(ADMIN, new EntityKindAndName("VIEW", tableOrView), new TrinoPrincipal(PrincipalType.ROLE, "role"));
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanSetEntityAuthorization(ADMIN, new EntityKindAndName("SCHEMA", schema), new TrinoPrincipal(PrincipalType.USER, "bob")), "Cannot set authorization for schema catalog.schema to USER bob");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanSetEntityAuthorization(ADMIN, new EntityKindAndName("TABLE", tableOrView), new TrinoPrincipal(PrincipalType.USER, "bob")), "Cannot set authorization for table catalog.schema.table_or_view to USER bob");
        BaseFileBasedSystemAccessControlTest.assertAccessDenied(() -> accessControlManager.checkCanSetEntityAuthorization(ADMIN, new EntityKindAndName("VIEW", tableOrView), new TrinoPrincipal(PrincipalType.USER, "bob")), "Cannot set authorization for view catalog.schema.table_or_view to USER bob");
    }

    private static SystemSecurityContext user(String user, String group, String role) {
        Identity identity = Identity.forUser((String)user).withGroups((Set)ImmutableSet.of((Object)group)).withEnabledRoles((Set)ImmutableSet.of((Object)role)).build();
        return new SystemSecurityContext(identity, queryId, queryStart);
    }

    @Test
    public void parseUnknownRules() {
        Assertions.assertThatThrownBy(() -> this.newFileBasedSystemAccessControl("file-based-system-security-config-file-with-unknown-rules.json")).hasMessageContaining("Failed to convert JSON tree node");
    }

    @Test
    public void testTableRulesForCheckCanInsertIntoTableWithJsonPointer() throws Exception {
        Path configFile = this.getResourcePath("file-based-system-access-table-with-json-pointer.json");
        SystemAccessControl accessControl = this.newFileBasedSystemAccessControl(configFile, (Map<String, String>)ImmutableMap.of((Object)"security.json-pointer", (Object)"/data"));
        BaseFileBasedSystemAccessControlTest.assertTableRulesForCheckCanInsertIntoTable(accessControl);
    }

    protected SystemAccessControl newFileBasedSystemAccessControl(String rulesName) throws URISyntaxException {
        Path configFile = this.getResourcePath(rulesName);
        return this.newFileBasedSystemAccessControl(configFile, (Map<String, String>)ImmutableMap.of());
    }

    protected SystemAccessControl newFileBasedSystemAccessControl(Map<String, String> config) {
        return new FileBasedSystemAccessControl.Factory().create(config, (SystemAccessControlFactory.SystemAccessControlContext)new TestingSystemAccessControlContext());
    }

    protected Path getResourcePath(String resourceName) throws URISyntaxException {
        return Paths.get(Objects.requireNonNull(this.getClass().getClassLoader().getResource(resourceName), "Resource does not exist: " + resourceName).toURI());
    }

    private static void assertAccessDenied(ThrowableAssert.ThrowingCallable callable, String expectedMessage) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(AccessDeniedException.class)).hasMessageMatching("Access Denied: " + expectedMessage);
    }

    private static /* synthetic */ void lambda$testSchemaRulesForCheckCanCreateSchema$3(SystemAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "test"), properties);
    }

    private static /* synthetic */ void lambda$testSchemaRulesForCheckCanCreateSchema$2(SystemAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "staff"), properties);
    }

    private static /* synthetic */ void lambda$testSchemaRulesForCheckCanCreateSchema$1(SystemAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(CHARLIE, new CatalogSchemaName("some-catalog", "bob"), properties);
    }

    private static /* synthetic */ void lambda$testSchemaRulesForCheckCanCreateSchema$0(SystemAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(BOB, new CatalogSchemaName("some-catalog", "test"), properties);
    }
}

