/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import com.google.common.io.ByteSource;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.node.testing.TestingNodeModule;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;

public class TestingHttpServer
implements Closeable {
    private final LifeCycleManager lifeCycleManager;
    private final URI baseUri;

    public TestingHttpServer() {
        Bootstrap app = new Bootstrap(new Module[]{new TestingNodeModule(), new TestingHttpServerModule(), binder -> binder.bind(Servlet.class).toInstance((Object)new TestingHttpServlet())});
        Injector injector = app.doNotInitializeLogging().quiet().initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        HttpServerInfo httpServerInfo = (HttpServerInfo)injector.getInstance(HttpServerInfo.class);
        this.baseUri = httpServerInfo.getHttpUri();
    }

    @Override
    public void close() throws IOException {
        this.lifeCycleManager.stop();
    }

    public URI resource(String path) {
        return this.baseUri.resolve(path);
    }

    private static class TestingHttpServlet
    extends HttpServlet {
        private TestingHttpServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            byte[] responseAsBytes = Files.readAllBytes(Paths.get(request.getPathInfo(), new String[0]));
            ByteSource.wrap((byte[])responseAsBytes).copyTo((OutputStream)response.getOutputStream());
        }
    }
}

