/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.plugin.jdbc.BooleanReadFunction;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.DoubleReadFunction;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectReadFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.ReadFunction;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.spi.type.Type;
import java.util.Objects;

public final class ColumnMapping {
    private final Type type;
    private final ReadFunction readFunction;
    private final WriteFunction writeFunction;
    private final PredicatePushdownController predicatePushdownController;

    public static ColumnMapping booleanMapping(Type trinoType, BooleanReadFunction readFunction, BooleanWriteFunction writeFunction) {
        return ColumnMapping.booleanMapping(trinoType, readFunction, writeFunction, PredicatePushdownController.FULL_PUSHDOWN);
    }

    public static ColumnMapping booleanMapping(Type trinoType, BooleanReadFunction readFunction, BooleanWriteFunction writeFunction, PredicatePushdownController predicatePushdownController) {
        return new ColumnMapping(trinoType, readFunction, writeFunction, predicatePushdownController);
    }

    public static ColumnMapping longMapping(Type trinoType, LongReadFunction readFunction, LongWriteFunction writeFunction) {
        return ColumnMapping.longMapping(trinoType, readFunction, writeFunction, PredicatePushdownController.FULL_PUSHDOWN);
    }

    public static ColumnMapping longMapping(Type trinoType, LongReadFunction readFunction, LongWriteFunction writeFunction, PredicatePushdownController predicatePushdownController) {
        return new ColumnMapping(trinoType, readFunction, writeFunction, predicatePushdownController);
    }

    public static ColumnMapping doubleMapping(Type trinoType, DoubleReadFunction readFunction, DoubleWriteFunction writeFunction) {
        return ColumnMapping.doubleMapping(trinoType, readFunction, writeFunction, PredicatePushdownController.FULL_PUSHDOWN);
    }

    public static ColumnMapping doubleMapping(Type trinoType, DoubleReadFunction readFunction, DoubleWriteFunction writeFunction, PredicatePushdownController predicatePushdownController) {
        return new ColumnMapping(trinoType, readFunction, writeFunction, predicatePushdownController);
    }

    public static ColumnMapping sliceMapping(Type trinoType, SliceReadFunction readFunction, SliceWriteFunction writeFunction) {
        return ColumnMapping.sliceMapping(trinoType, readFunction, writeFunction, PredicatePushdownController.FULL_PUSHDOWN);
    }

    public static ColumnMapping sliceMapping(Type trinoType, SliceReadFunction readFunction, SliceWriteFunction writeFunction, PredicatePushdownController predicatePushdownController) {
        return new ColumnMapping(trinoType, readFunction, writeFunction, predicatePushdownController);
    }

    public static ColumnMapping objectMapping(Type trinoType, ObjectReadFunction readFunction, ObjectWriteFunction writeFunction) {
        return ColumnMapping.objectMapping(trinoType, readFunction, writeFunction, PredicatePushdownController.FULL_PUSHDOWN);
    }

    public static ColumnMapping objectMapping(Type trinoType, ObjectReadFunction readFunction, ObjectWriteFunction writeFunction, PredicatePushdownController predicatePushdownController) {
        return new ColumnMapping(trinoType, readFunction, writeFunction, predicatePushdownController);
    }

    public static ColumnMapping mapping(Type trinoType, ReadFunction readFunction, WriteFunction writeFunction, PredicatePushdownController predicatePushdownController) {
        return new ColumnMapping(trinoType, readFunction, writeFunction, predicatePushdownController);
    }

    @Deprecated
    public ColumnMapping(Type type, ReadFunction readFunction, WriteFunction writeFunction, PredicatePushdownController predicatePushdownController) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.readFunction = Objects.requireNonNull(readFunction, "readFunction is null");
        this.writeFunction = Objects.requireNonNull(writeFunction, "writeFunction is null");
        Preconditions.checkArgument((type.getJavaType() == readFunction.getJavaType() ? 1 : 0) != 0, (String)"Trino type %s is not compatible with read function %s returning %s", (Object)type, (Object)readFunction, readFunction.getJavaType());
        Preconditions.checkArgument((type.getJavaType() == writeFunction.getJavaType() ? 1 : 0) != 0, (String)"Trino type %s is not compatible with write function %s accepting %s", (Object)type, (Object)writeFunction, writeFunction.getJavaType());
        this.predicatePushdownController = Objects.requireNonNull(predicatePushdownController, "predicatePushdownController is null");
    }

    public Type getType() {
        return this.type;
    }

    public ReadFunction getReadFunction() {
        return this.readFunction;
    }

    public WriteFunction getWriteFunction() {
        return this.writeFunction;
    }

    public PredicatePushdownController getPredicatePushdownController() {
        return this.predicatePushdownController;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
    }
}

