/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.jdbc.datasource.JdbcTelemetry;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class TracingDataSource {
    private final JdbcTelemetry jdbcTelemetry;
    private final Driver driver;
    private final String connectionUrl;

    public TracingDataSource(OpenTelemetry openTelemetry, Driver driver, String connectionUrl) {
        this.jdbcTelemetry = JdbcTelemetry.builder((OpenTelemetry)Objects.requireNonNull(openTelemetry, "openTelemetry is null")).build();
        this.driver = Objects.requireNonNull(driver, "driver is null");
        this.connectionUrl = Objects.requireNonNull(connectionUrl, "connectionUrl is null");
    }

    public Connection getConnection(Properties properties) throws SQLException {
        JdbcDataSource dataSource = new JdbcDataSource(this.driver, this.connectionUrl, properties);
        return this.jdbcTelemetry.wrap((DataSource)dataSource).getConnection();
    }

    private static class JdbcDataSource
    implements DataSource {
        private final Driver driver;
        private final String connectionUrl;
        private final Properties properties;

        public JdbcDataSource(Driver driver, String connectionUrl, Properties properties) {
            this.driver = Objects.requireNonNull(driver, "driver is null");
            this.connectionUrl = Objects.requireNonNull(connectionUrl, "connectionUrl is null");
            this.properties = Objects.requireNonNull(properties, "properties is null");
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection connection = this.driver.connect(this.connectionUrl, this.properties);
            Preconditions.checkState((connection != null ? 1 : 0) != 0, (String)"Driver returned null connection, make sure the connection URL '%s' is valid for the driver %s", (Object)this.connectionUrl, (Object)this.driver);
            return connection;
        }

        @Override
        public Connection getConnection(String username, String password) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PrintWriter getLogWriter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLogWriter(PrintWriter out) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLoginTimeout(int seconds) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLoginTimeout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Logger getParentLogger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            throw new UnsupportedOperationException();
        }
    }
}

