/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.jdbc.expression.ConnectorExpressionPatternLexer;
import io.trino.plugin.jdbc.expression.ConnectorExpressionPatternParser;
import io.trino.plugin.jdbc.expression.ExpressionPattern;
import io.trino.plugin.jdbc.expression.ExpressionPatternBuilder;
import io.trino.plugin.jdbc.expression.TypePattern;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;

public class ExpressionMappingParser {
    private static final ANTLRErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new IllegalArgumentException(String.format("Error at %s:%s: %s", line, charPositionInLine, message), e);
        }
    };
    private final Map<String, Set<String>> typeClasses;

    public ExpressionMappingParser(Map<String, Set<String>> typeClasses) {
        this.typeClasses = ImmutableMap.copyOf(Objects.requireNonNull(typeClasses, "typeClasses is null"));
    }

    public ExpressionPattern createExpressionPattern(String expressionPattern) {
        return (ExpressionPattern)this.invokeParser(expressionPattern, ConnectorExpressionPatternParser::standaloneExpression);
    }

    public TypePattern createTypePattern(String typePattern) {
        return (TypePattern)this.invokeParser(typePattern, ConnectorExpressionPatternParser::standaloneType);
    }

    public Object invokeParser(String input, Function<ConnectorExpressionPatternParser, ParserRuleContext> parseFunction) {
        try {
            ParserRuleContext tree;
            ConnectorExpressionPatternLexer lexer = new ConnectorExpressionPatternLexer((CharStream)CharStreams.fromString((String)input));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            ConnectorExpressionPatternParser parser = new ConnectorExpressionPatternParser((TokenStream)tokenStream);
            lexer.removeErrorListeners();
            lexer.addErrorListener(ERROR_LISTENER);
            parser.removeErrorListeners();
            parser.addErrorListener(ERROR_LISTENER);
            try {
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                tree = parseFunction.apply(parser);
            }
            catch (IllegalArgumentException ex) {
                tokenStream.seek(0);
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                tree = parseFunction.apply(parser);
            }
            return new ExpressionPatternBuilder(this.typeClasses).visit((ParseTree)tree);
        }
        catch (StackOverflowError e) {
            throw new IllegalArgumentException("expression pattern is too large (stack overflow while parsing)");
        }
    }
}

