/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.locator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jdbi.v3.core.inlined.org.antlr.v4.runtime.$CharStreams;
import org.jdbi.v3.core.internal.SqlScriptParser;
import org.jdbi.v3.core.internal.exceptions.CheckedFunction;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.locator.internal.ClasspathBuilder;

public final class ClasspathSqlLocator {
    private static final String SQL_EXTENSION = "sql";
    private final Map<ClassLoader, Map<String, String>> cache = Collections.synchronizedMap(new WeakHashMap());
    private final Function<InputStream, String> parser;

    private ClasspathSqlLocator(CheckedFunction<InputStream, String> parser) {
        this.parser = Unchecked.function(parser);
    }

    @Deprecated
    public static String findSqlOnClasspath(Class<?> type, String methodName) {
        return Holder.INSTANCE.locate(type, methodName);
    }

    @Deprecated
    public static String findSqlOnClasspath(String name) {
        return Holder.INSTANCE.locate(name);
    }

    @Deprecated
    public static String getResourceOnClasspath(String path) {
        return Holder.INSTANCE.getResource(path);
    }

    @Deprecated
    public static String getResourceOnClasspath(ClassLoader classLoader, String path) {
        return Holder.INSTANCE.getResource(classLoader, path);
    }

    public static ClasspathSqlLocator removingComments() {
        SqlScriptParser commentStripper = new SqlScriptParser((t, sb) -> sb.append(t.getText()));
        return new ClasspathSqlLocator(r -> commentStripper.parse($CharStreams.fromStream(r)));
    }

    public static ClasspathSqlLocator create() {
        return new ClasspathSqlLocator(ClasspathSqlLocator::readAsString);
    }

    public String locate(Class<?> type, String methodName) {
        return this.getResource(type.getClassLoader(), new ClasspathBuilder().appendFullyQualifiedClassName(type).appendVerbatim(methodName).setExtension(SQL_EXTENSION).build());
    }

    public String locate(String name) {
        return this.getResource(ClasspathSqlLocator.selectClassLoader(), new ClasspathBuilder().appendDotPath(name).setExtension(SQL_EXTENSION).build());
    }

    public String getResource(String path) {
        return this.getResource(ClasspathSqlLocator.selectClassLoader(), path);
    }

    public String getResource(ClassLoader classLoader, String path) {
        return this.cache.computeIfAbsent(classLoader, x -> new ConcurrentHashMap()).computeIfAbsent(path, x -> this.readResource(classLoader, path));
    }

    private String readResource(ClassLoader classLoader, String path) {
        String string;
        block8: {
            InputStream is = ClasspathSqlLocator.openStream(classLoader, path);
            try {
                string = this.parser.apply(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to read classpath resource at " + path, e);
                }
            }
            is.close();
        }
        return string;
    }

    private static String readAsString(InputStream is) throws IOException {
        try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
            int n;
            StringBuilder result = new StringBuilder();
            char[] buffer = new char[256];
            while (-1 != (n = r.read(buffer))) {
                result.append(buffer, 0, n);
            }
            String string = result.toString();
            return string;
        }
    }

    private static InputStream openStream(ClassLoader classLoader, String path) {
        InputStream is = classLoader.getResourceAsStream(path);
        if (is == null) {
            throw new IllegalArgumentException("Cannot find classpath resource at " + path);
        }
        return is;
    }

    private static ClassLoader selectClassLoader() {
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClasspathSqlLocator.class::getClassLoader);
    }

    static class Holder {
        static final ClasspathSqlLocator INSTANCE = ClasspathSqlLocator.removingComments();

        Holder() {
        }
    }
}

