/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.freebuilder;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.function.Supplier;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.internal.exceptions.CheckedSupplier;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.reflect.internal.BuilderPojoPropertiesFactory;
import org.jdbi.v3.core.mapper.reflect.internal.PojoPropertiesFactory;
import org.jdbi.v3.core.mapper.reflect.internal.PojoTypes;
import org.jdbi.v3.meta.Beta;

@Beta
public class JdbiFreeBuilders
implements JdbiConfig<JdbiFreeBuilders> {
    private ConfigRegistry registry;

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    @Override
    public JdbiFreeBuilders createCopy() {
        return new JdbiFreeBuilders();
    }

    public <S> JdbiFreeBuilders registerFreeBuilder(Class<S> spec) {
        Class<S> impl = this.valueClass(spec);
        return this.registerFreeBuilder(spec, impl, this.builderConstructor(spec));
    }

    public JdbiFreeBuilders registerFreeBuilder(Class<?> ... specs) {
        return this.registerFreeBuilder(Arrays.asList(specs));
    }

    public JdbiFreeBuilders registerFreeBuilder(Iterable<Class<?>> specs) {
        specs.forEach(this::registerFreeBuilder);
        return this;
    }

    public <S, I extends S> JdbiFreeBuilders registerFreeBuilder(Class<S> spec, Class<I> impl, Supplier<?> builderConstructor) {
        return this.register(spec, impl, BuilderPojoPropertiesFactory.builder(spec, builderConstructor));
    }

    private <S> JdbiFreeBuilders register(Class<S> spec, Class<? extends S> impl, PojoPropertiesFactory factory) {
        this.registry.get(PojoTypes.class).register(spec, factory).register(impl, factory);
        return this;
    }

    private <S> Class<? extends S> valueClass(Class<S> spec) {
        String valueName;
        if (spec.getEnclosingClass() == null) {
            valueName = spec.getPackage().getName() + "." + spec.getSimpleName() + "_Builder$Value";
        } else {
            String enclosingName = spec.getEnclosingClass().getSimpleName();
            valueName = spec.getPackage().getName() + "." + enclosingName + "_" + spec.getSimpleName() + "_Builder$Value";
        }
        try {
            return Class.forName(valueName).asSubclass(spec);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't locate value class " + valueName, e);
        }
    }

    private <S> Supplier<?> builderConstructor(Class<S> spec) {
        Class builderClass = this.builderClass(spec);
        try {
            return Unchecked.supplier((CheckedSupplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invoke(), ()Ljava/lang/Object;)((MethodHandle)MethodHandles.lookup().findConstructor(builderClass, MethodType.methodType(Void.TYPE))));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Couldn't find public constructor of " + String.valueOf(spec), e);
        }
    }

    private <S> Class builderClass(Class<S> spec) {
        String builderName;
        if (spec.getEnclosingClass() == null) {
            builderName = spec.getPackage().getName() + "." + spec.getSimpleName() + "$Builder";
        } else {
            String enclosingName = spec.getEnclosingClass().getSimpleName();
            builderName = spec.getPackage().getName() + "." + enclosingName + "$" + spec.getSimpleName() + "$Builder";
        }
        try {
            return Class.forName(builderName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't locate builder class " + builderName, e);
        }
    }
}

