/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import io.trino.Session;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.exchange.filesystem.FileSystemExchangePlugin;
import io.trino.plugin.jdbc.BaseJdbcFailureRecoveryTest;
import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.spi.Plugin;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public abstract class BasePostgresFailureRecoveryTest
extends BaseJdbcFailureRecoveryTest {
    private TestingPostgreSqlServer postgreSqlServer;

    public BasePostgresFailureRecoveryTest(RetryPolicy retryPolicy) {
        super(retryPolicy);
    }

    protected QueryRunner createQueryRunner(List<TpchTable<?>> requiredTpchTables, Map<String, String> configProperties, Map<String, String> coordinatorProperties, Module failureInjectionModule) throws Exception {
        this.postgreSqlServer = new TestingPostgreSqlServer();
        return ((PostgreSqlQueryRunner.Builder)((PostgreSqlQueryRunner.Builder)((PostgreSqlQueryRunner.Builder)PostgreSqlQueryRunner.builder((TestingPostgreSqlServer)this.closeAfterClass(this.postgreSqlServer)).setExtraProperties(configProperties)).setCoordinatorProperties(configProperties)).setAdditionalSetup(runner -> {
            runner.installPlugin((Plugin)new FileSystemExchangePlugin());
            runner.loadExchangeManager("filesystem", (Map)ImmutableMap.of((Object)"exchange.base-directories", (Object)(System.getProperty("java.io.tmpdir") + "/trino-local-file-system-exchange-manager")));
        }).setAdditionalModule(failureInjectionModule)).setInitialTables(requiredTpchTables).build();
    }

    @Test
    protected void testUpdate() {
        Optional<String> setupQuery = Optional.of("CREATE TABLE <table> AS SELECT * FROM orders");
        String testQuery = "UPDATE <table> SET shippriority = 101 WHERE custkey = 1";
        Optional<String> cleanupQuery = Optional.of("DROP TABLE <table>");
        this.assertThatQuery(testQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).isCoordinatorOnly();
    }

    protected void addPrimaryKeyForMergeTarget(Session session, String tableName, String primaryKey) {
        this.postgreSqlServer.execute("ALTER TABLE %s ADD CONSTRAINT pk_%s PRIMARY KEY (%s)".formatted(tableName, tableName, primaryKey));
    }

    protected boolean supportsMerge() {
        return true;
    }
}

