/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.log.Logger;
import io.trino.plugin.geospatial.GeoPlugin;
import io.trino.plugin.jmx.JmxPlugin;
import io.trino.plugin.postgresql.PostgreSqlPlugin;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public final class PostgreSqlQueryRunner {
    private static final String TPCH_SCHEMA = "tpch";

    private PostgreSqlQueryRunner() {
    }

    public static Builder builder(TestingPostgreSqlServer server) {
        return new Builder().addConnectorProperties(Map.of("connection-url", server.getJdbcUrl(), "connection-user", server.getUser(), "connection-password", server.getPassword(), "postgresql.include-system-tables", "true"));
    }

    public static void main(String[] args) throws Exception {
        DistributedQueryRunner queryRunner = ((Builder)PostgreSqlQueryRunner.builder(new TestingPostgreSqlServer(System.getProperty("testing.postgresql-image-name", "postgres:12"), true)).addCoordinatorProperty("http-server.http.port", "8080")).setInitialTables(TpchTable.getTables()).build();
        queryRunner.installPlugin((Plugin)new JmxPlugin());
        queryRunner.createCatalog("jmx", "jmx");
        Logger log = Logger.get(PostgreSqlQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }

    public static final class Builder
    extends DistributedQueryRunner.Builder<Builder> {
        private final Map<String, String> connectorProperties = new HashMap<String, String>();
        private List<TpchTable<?>> initialTables = ImmutableList.of();
        private Consumer<QueryRunner> additionalSetup = queryRunner -> {};

        private Builder() {
            super(TestingSession.testSessionBuilder().setCatalog("postgresql").setSchema(PostgreSqlQueryRunner.TPCH_SCHEMA).build());
        }

        @CanIgnoreReturnValue
        public Builder setAdditionalSetup(Consumer<QueryRunner> additionalSetup) {
            this.additionalSetup = Objects.requireNonNull(additionalSetup, "additionalSetup is null");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addConnectorProperties(Map<String, String> connectorProperties) {
            this.connectorProperties.putAll(connectorProperties);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInitialTables(Iterable<TpchTable<?>> initialTables) {
            this.initialTables = ImmutableList.copyOf(Objects.requireNonNull(initialTables, "initialTables is null"));
            return this;
        }

        public DistributedQueryRunner build() throws Exception {
            super.setAdditionalSetup(runner -> {
                runner.installPlugin((Plugin)new GeoPlugin());
                this.additionalSetup.accept((QueryRunner)runner);
                runner.installPlugin((Plugin)new TpchPlugin());
                runner.createCatalog(PostgreSqlQueryRunner.TPCH_SCHEMA, PostgreSqlQueryRunner.TPCH_SCHEMA);
                runner.installPlugin((Plugin)new PostgreSqlPlugin());
                runner.createCatalog("postgresql", "postgresql", this.connectorProperties);
                QueryAssertions.copyTpchTables((QueryRunner)runner, (String)PostgreSqlQueryRunner.TPCH_SCHEMA, (String)"tiny", this.initialTables);
            });
            return super.build();
        }
    }
}

