/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import io.trino.Session;
import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJoinReorderingWithJoinPushdown
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        TestingPostgreSqlServer postgreSqlServer = (TestingPostgreSqlServer)this.closeAfterClass(new TestingPostgreSqlServer());
        DistributedQueryRunner queryRunner = PostgreSqlQueryRunner.builder(postgreSqlServer).setInitialTables(List.of(TpchTable.CUSTOMER, TpchTable.NATION)).build();
        postgreSqlServer.execute("ANALYZE " + TpchTable.CUSTOMER.getTableName());
        postgreSqlServer.execute("ANALYZE " + TpchTable.NATION.getTableName());
        return queryRunner;
    }

    @Test
    public void testJoinReordering() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("enable_dynamic_filtering", "false").setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "join_pushdown_enabled", "false").build();
        Session joinPushdownEnabled = Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "join_pushdown_enabled", "true").setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "join_pushdown_strategy", "EAGER").build();
        String sql = "SELECT c.name, o.clerk, n.name FROM customer c INNER JOIN nation n ON c.nationkey = n.nationkey INNER JOIN tpch.tiny.orders o ON c.custkey = o.custkey";
        PlanMatchPattern joinWithoutFilter = PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> builder.equiCriteria("o_custkey", "c_custkey").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders", Map.of("o_custkey", "custkey"))})).right(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinType)JoinType.INNER, rightJoinBuilder -> rightJoinBuilder.equiCriteria("c_nationkey", "n_nationkey").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"customer", Map.of("c_custkey", "custkey", "c_nationkey", "nationkey"))})).right(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"nation", Map.of("n_nationkey", "nationkey"))})))})));
        PlanMatchPattern joinWithoutFilterPushedDown = PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders")}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"_generated_query")})});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, sql))).isNotFullyPushedDown(joinWithoutFilter);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, sql))).isNotFullyPushedDown(joinWithoutFilterPushedDown);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, sql + " WHERE o.orderkey >= 0"))).isNotFullyPushedDown(joinWithoutFilter);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, sql + " WHERE o.orderkey >= 0"))).isNotFullyPushedDown(joinWithoutFilterPushedDown);
        PlanMatchPattern joinWithSelectiveFilterReordered = PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> builder.equiCriteria("n_nationkey", "c_nationkey").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"nation", Map.of("n_nationkey", "nationkey"))})).right(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinType)JoinType.INNER, rightJoinBuilder -> rightJoinBuilder.equiCriteria("c_custkey", "o_custkey").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"customer", Map.of("c_custkey", "custkey", "c_nationkey", "nationkey"))})).right(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders", Map.of("o_custkey", "custkey"))})))})));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, sql + " WHERE o.orderkey = 1"))).isNotFullyPushedDown(joinWithSelectiveFilterReordered);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, sql + " WHERE o.orderkey = 1"))).isNotFullyPushedDown(joinWithSelectiveFilterReordered);
        PlanMatchPattern joinWithFilterReordered = PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> builder.equiCriteria("c_nationkey", "n_nationkey").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinType)JoinType.INNER, leftJoinBuilder -> leftJoinBuilder.equiCriteria("c_custkey", "o_custkey").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"customer", Map.of("c_custkey", "custkey", "c_nationkey", "nationkey"))})).right(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"orders", Map.of("o_custkey", "custkey"))})))})).right(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"nation", Map.of("n_nationkey", "nationkey"))})));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, sql + " WHERE o.orderkey < 500"))).isNotFullyPushedDown(joinWithFilterReordered);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, sql + " WHERE o.orderkey < 500"))).isNotFullyPushedDown(joinWithFilterReordered);
    }
}

