/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.base.mapping.RuleBasedIdentifierMappingUtils;
import io.trino.plugin.jdbc.BaseCaseInsensitiveMappingTest;
import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.SqlExecutor;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;

public class TestPostgreSqlCaseInsensitiveMapping
extends BaseCaseInsensitiveMappingTest {
    private Path mappingFile;
    private TestingPostgreSqlServer postgreSqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.mappingFile = RuleBasedIdentifierMappingUtils.createRuleBasedIdentifierMappingFile();
        this.postgreSqlServer = (TestingPostgreSqlServer)this.closeAfterClass(new TestingPostgreSqlServer());
        return PostgreSqlQueryRunner.builder(this.postgreSqlServer).addConnectorProperties((Map<String, String>)ImmutableMap.builder().put((Object)"case-insensitive-name-matching", (Object)"true").put((Object)"case-insensitive-name-matching.config-file", (Object)this.mappingFile.toFile().getAbsolutePath()).put((Object)"case-insensitive-name-matching.config-file.refresh-period", (Object)RuleBasedIdentifierMappingUtils.REFRESH_PERIOD_DURATION.toString()).buildOrThrow()).build();
    }

    protected Path getMappingFile() {
        return Objects.requireNonNull(this.mappingFile, "mappingFile is null");
    }

    protected SqlExecutor onRemoteDatabase() {
        return this.postgreSqlServer::execute;
    }
}

