/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.plugin.base.mapping.DefaultIdentifierMapping;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.DefaultQueryBuilder;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.postgresql.PostgreSqlClient;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.plugin.postgresql.PostgreSqlSessionProperties;
import io.trino.plugin.postgresql.TestingPostgreSqlConnectorContext;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.testing.TestingConnectorSession;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPostgreSqlClient {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction NEGATION_BIGINT = FUNCTIONS.resolveOperator(OperatorType.NEGATION, (List)ImmutableList.of((Object)BigintType.BIGINT));
    private static final JdbcColumnHandle BIGINT_COLUMN = JdbcColumnHandle.builder().setColumnName("c_bigint").setColumnType((Type)BigintType.BIGINT).setJdbcTypeHandle(new JdbcTypeHandle(-5, Optional.of("int8"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).build();
    private static final JdbcColumnHandle DOUBLE_COLUMN = JdbcColumnHandle.builder().setColumnName("c_double").setColumnType((Type)DoubleType.DOUBLE).setJdbcTypeHandle(new JdbcTypeHandle(8, Optional.of("double"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).build();
    private static final JdbcColumnHandle VARCHAR_COLUMN = JdbcColumnHandle.builder().setColumnName("c_varchar").setColumnType((Type)VarcharType.createVarcharType((int)10)).setJdbcTypeHandle(new JdbcTypeHandle(12, Optional.of("varchar"), Optional.of(10), Optional.empty(), Optional.empty(), Optional.empty())).build();
    private static final JdbcColumnHandle VARCHAR_COLUMN2 = JdbcColumnHandle.builder().setColumnName("c_varchar2").setColumnType((Type)VarcharType.createVarcharType((int)10)).setJdbcTypeHandle(new JdbcTypeHandle(12, Optional.of("varchar"), Optional.of(10), Optional.empty(), Optional.empty(), Optional.empty())).build();
    private static final JdbcClient JDBC_CLIENT = new PostgreSqlClient(new BaseJdbcConfig(), new PostgreSqlConfig(), new JdbcStatisticsConfig(), session -> {
        throw new UnsupportedOperationException();
    }, (QueryBuilder)new DefaultQueryBuilder(RemoteQueryModifier.NONE), new TestingPostgreSqlConnectorContext().getTypeManager(), (IdentifierMapping)new DefaultIdentifierMapping(), RemoteQueryModifier.NONE);
    private static final ConnectorSession SESSION = TestingConnectorSession.builder().setPropertyMetadata((List)ImmutableList.builder().addAll((Iterable)new JdbcMetadataSessionProperties(new JdbcMetadataConfig(), Optional.empty()).getSessionProperties()).addAll((Iterable)new PostgreSqlSessionProperties(new PostgreSqlConfig()).getSessionProperties()).build()).build();

    @Test
    public void testImplementCount() {
        Variable bigintVariable = new Variable("v_bigint", (Type)BigintType.BIGINT);
        Variable doubleVariable = new Variable("v_double", (Type)BigintType.BIGINT);
        Optional<Variable> filter = Optional.of(new Variable("a_filter", (Type)BooleanType.BOOLEAN));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, Optional.empty()), Map.of(), Optional.of("count(*)"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.of("count(\"c_bigint\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(doubleVariable), List.of(), false, Optional.empty()), Map.of(doubleVariable.getName(), DOUBLE_COLUMN), Optional.of("count(\"c_double\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), true, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.of("count(DISTINCT \"c_bigint\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, filter), Map.of(), Optional.empty());
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, filter), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.empty());
    }

    @Test
    public void testImplementSum() {
        Variable bigintVariable = new Variable("v_bigint", (Type)BigintType.BIGINT);
        Variable doubleVariable = new Variable("v_double", (Type)DoubleType.DOUBLE);
        Optional<Variable> filter = Optional.of(new Variable("a_filter", (Type)BooleanType.BOOLEAN));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("sum", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.of("sum(\"c_bigint\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("sum", (Type)DoubleType.DOUBLE, List.of(doubleVariable), List.of(), false, Optional.empty()), Map.of(doubleVariable.getName(), DOUBLE_COLUMN), Optional.of("sum(\"c_double\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("sum", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), true, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.of("sum(DISTINCT \"c_bigint\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("sum", (Type)DoubleType.DOUBLE, List.of(bigintVariable), List.of(), true, Optional.empty()), Map.of(bigintVariable.getName(), DOUBLE_COLUMN), Optional.of("sum(DISTINCT \"c_double\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("sum", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, filter), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.empty());
    }

    private static void testImplementAggregation(AggregateFunction aggregateFunction, Map<String, ColumnHandle> assignments, Optional<String> expectedExpression) {
        Optional result = JDBC_CLIENT.implementAggregation(SESSION, aggregateFunction, assignments);
        if (expectedExpression.isEmpty()) {
            Assertions.assertThat((Optional)result).isEmpty();
        } else {
            Assertions.assertThat((Optional)result).isPresent();
            Assertions.assertThat((String)((JdbcExpression)result.get()).getExpression()).isEqualTo(expectedExpression.get());
            Optional columnMapping = JDBC_CLIENT.toColumnMapping(SESSION, null, ((JdbcExpression)result.get()).getJdbcTypeHandle());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)columnMapping.isPresent()).describedAs("No mapping for: " + String.valueOf(((JdbcExpression)result.get()).getJdbcTypeHandle()), new Object[0])).isTrue();
            Assertions.assertThat((Object)((ColumnMapping)columnMapping.get()).getType()).isEqualTo((Object)aggregateFunction.getOutputType());
        }
    }

    @Test
    public void testConvertOr() {
        ParameterizedExpression converted = (ParameterizedExpression)JDBC_CLIENT.convertPredicate(SESSION, this.translateToConnectorExpression((Expression)new Logical(Logical.Operator.OR, List.of(new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "c_bigint_symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)42L)), new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "c_bigint_symbol_2"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)415L))))), Map.of("c_bigint_symbol", BIGINT_COLUMN, "c_bigint_symbol_2", BIGINT_COLUMN)).orElseThrow();
        Assertions.assertThat((String)converted.expression()).isEqualTo("((\"c_bigint\") = (?)) OR ((\"c_bigint\") = (?))");
        Assertions.assertThat((List)converted.parameters()).isEqualTo(List.of(new QueryParameter((Type)BigintType.BIGINT, Optional.of(42L)), new QueryParameter((Type)BigintType.BIGINT, Optional.of(415L))));
    }

    @Test
    public void testConvertOrWithAnd() {
        ParameterizedExpression converted = (ParameterizedExpression)JDBC_CLIENT.convertPredicate(SESSION, this.translateToConnectorExpression((Expression)new Logical(Logical.Operator.OR, List.of(new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "c_bigint_symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)42L)), new Logical(Logical.Operator.AND, List.of(new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "c_bigint_symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)43L)), new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "c_bigint_symbol_2"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)44L))))))), Map.of("c_bigint_symbol", BIGINT_COLUMN, "c_bigint_symbol_2", BIGINT_COLUMN)).orElseThrow();
        Assertions.assertThat((String)converted.expression()).isEqualTo("((\"c_bigint\") = (?)) OR (((\"c_bigint\") = (?)) AND ((\"c_bigint\") = (?)))");
        Assertions.assertThat((List)converted.parameters()).isEqualTo(List.of(new QueryParameter((Type)BigintType.BIGINT, Optional.of(42L)), new QueryParameter((Type)BigintType.BIGINT, Optional.of(43L)), new QueryParameter((Type)BigintType.BIGINT, Optional.of(44L))));
    }

    @Test
    public void testConvertComparison() {
        block4: for (Comparison.Operator operator : Comparison.Operator.values()) {
            Optional converted = JDBC_CLIENT.convertPredicate(SESSION, this.translateToConnectorExpression((Expression)new Comparison(operator, (Expression)new Reference((Type)BigintType.BIGINT, "c_bigint_symbol"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)42L))), Map.of("c_bigint_symbol", BIGINT_COLUMN));
            switch (operator) {
                case EQUAL: 
                case NOT_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    Assertions.assertThat((Optional)converted).isPresent();
                    Assertions.assertThat((String)((ParameterizedExpression)converted.get()).expression()).isEqualTo(String.format("(\"c_bigint\") %s (?)", operator.getValue()));
                    Assertions.assertThat((List)((ParameterizedExpression)converted.get()).parameters()).isEqualTo(List.of(new QueryParameter((Type)BigintType.BIGINT, Optional.of(42L))));
                    continue block4;
                }
                case IDENTICAL: {
                    Assertions.assertThat((Optional)converted).isPresent();
                    Assertions.assertThat((String)((ParameterizedExpression)converted.get()).expression()).isEqualTo(String.format("(\"c_bigint\") IS NOT DISTINCT FROM (?)", new Object[0]));
                    Assertions.assertThat((List)((ParameterizedExpression)converted.get()).parameters()).isEqualTo(List.of(new QueryParameter((Type)BigintType.BIGINT, Optional.of(42L))));
                }
            }
        }
    }

    @Test
    public void testConvertArithmeticBinary() {
        TestingFunctionResolution resolver = new TestingFunctionResolution();
        for (OperatorType operator : EnumSet.of(OperatorType.ADD, OperatorType.SUBTRACT, OperatorType.MULTIPLY, OperatorType.DIVIDE, OperatorType.MODULUS)) {
            ParameterizedExpression converted = (ParameterizedExpression)JDBC_CLIENT.convertPredicate(SESSION, this.translateToConnectorExpression((Expression)new Call(resolver.resolveOperator(operator, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c_bigint_symbol"), (Object)new Constant((Type)BigintType.BIGINT, (Object)42L)))), Map.of("c_bigint_symbol", BIGINT_COLUMN)).orElseThrow();
            Assertions.assertThat((List)converted.parameters()).isEqualTo(List.of(new QueryParameter((Type)BigintType.BIGINT, Optional.of(42L))));
        }
    }

    @Test
    public void testConvertArithmeticUnaryMinus() {
        ParameterizedExpression converted = (ParameterizedExpression)JDBC_CLIENT.convertPredicate(SESSION, this.translateToConnectorExpression((Expression)new Call(NEGATION_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c_bigint_symbol")))), Map.of("c_bigint_symbol", BIGINT_COLUMN)).orElseThrow();
        Assertions.assertThat((String)converted.expression()).isEqualTo("-(\"c_bigint\")");
        Assertions.assertThat((List)converted.parameters()).isEqualTo(List.of());
    }

    @Test
    public void testConvertIsNull() {
        ParameterizedExpression converted = (ParameterizedExpression)JDBC_CLIENT.convertPredicate(SESSION, this.translateToConnectorExpression((Expression)new IsNull((Expression)new Reference((Type)VarcharType.VARCHAR, "c_varchar_symbol"))), Map.of("c_varchar_symbol", VARCHAR_COLUMN)).orElseThrow();
        Assertions.assertThat((String)converted.expression()).isEqualTo("(\"c_varchar\") IS NULL");
        Assertions.assertThat((List)converted.parameters()).isEqualTo(List.of());
    }

    @Test
    public void testConvertIsNotNull() {
        ParameterizedExpression converted = (ParameterizedExpression)JDBC_CLIENT.convertPredicate(SESSION, this.translateToConnectorExpression(IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)VarcharType.VARCHAR, "c_varchar_symbol")))), Map.of("c_varchar_symbol", VARCHAR_COLUMN)).orElseThrow();
        Assertions.assertThat((String)converted.expression()).isEqualTo("(\"c_varchar\") IS NOT NULL");
        Assertions.assertThat((List)converted.parameters()).isEqualTo(List.of());
    }

    @Test
    public void testConvertNullIf() {
        ParameterizedExpression converted = (ParameterizedExpression)JDBC_CLIENT.convertPredicate(SESSION, this.translateToConnectorExpression((Expression)new NullIf((Expression)new Reference((Type)VarcharType.VARCHAR, "a_varchar_symbol"), (Expression)new Reference((Type)VarcharType.VARCHAR, "b_varchar_symbol"))), (Map)ImmutableMap.of((Object)"a_varchar_symbol", (Object)VARCHAR_COLUMN, (Object)"b_varchar_symbol", (Object)VARCHAR_COLUMN)).orElseThrow();
        Assertions.assertThat((String)converted.expression()).isEqualTo("NULLIF((\"c_varchar\"), (\"c_varchar\"))");
        Assertions.assertThat((List)converted.parameters()).isEqualTo(List.of());
    }

    @Test
    public void testConvertNotExpression() {
        ParameterizedExpression converted = (ParameterizedExpression)JDBC_CLIENT.convertPredicate(SESSION, this.translateToConnectorExpression(IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)VarcharType.VARCHAR, "c_varchar_symbol"))))), Map.of("c_varchar_symbol", VARCHAR_COLUMN)).orElseThrow();
        Assertions.assertThat((String)converted.expression()).isEqualTo("NOT ((\"c_varchar\") IS NOT NULL)");
        Assertions.assertThat((List)converted.parameters()).isEqualTo(List.of());
    }

    @Test
    public void testConvertIn() {
        ParameterizedExpression converted = (ParameterizedExpression)JDBC_CLIENT.convertPredicate(SESSION, this.translateToConnectorExpression((Expression)new In((Expression)new Reference((Type)VarcharType.createVarcharType((int)10), "c_varchar"), List.of(new Constant(VARCHAR_COLUMN.getColumnType(), (Object)Slices.utf8Slice((String)"value1")), new Constant(VARCHAR_COLUMN.getColumnType(), (Object)Slices.utf8Slice((String)"value2")), new Reference((Type)VarcharType.createVarcharType((int)10), "c_varchar2")))), Map.of(VARCHAR_COLUMN.getColumnName(), VARCHAR_COLUMN, VARCHAR_COLUMN2.getColumnName(), VARCHAR_COLUMN2)).orElseThrow();
        Assertions.assertThat((String)converted.expression()).isEqualTo("(\"c_varchar\") IN (?, ?, \"c_varchar2\")");
        Assertions.assertThat((List)converted.parameters()).isEqualTo(List.of(new QueryParameter((Type)VarcharType.createVarcharType((int)10), Optional.of(Slices.utf8Slice((String)"value1"))), new QueryParameter((Type)VarcharType.createVarcharType((int)10), Optional.of(Slices.utf8Slice((String)"value2")))));
    }

    private ConnectorExpression translateToConnectorExpression(Expression expression) {
        return (ConnectorExpression)ConnectorExpressionTranslator.translate((Session)SessionTestUtils.TEST_SESSION, (Expression)expression).orElseThrow();
    }
}

