/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPostgreSqlConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((PostgreSqlConfig)ConfigAssertions.recordDefaults(PostgreSqlConfig.class)).setArrayMapping(PostgreSqlConfig.ArrayMapping.DISABLED).setIncludeSystemTables(false).setEnableStringPushdownWithCollate(false).setFetchSize(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"postgresql.array-mapping", (Object)"AS_ARRAY").put((Object)"postgresql.include-system-tables", (Object)"true").put((Object)"postgresql.experimental.enable-string-pushdown-with-collate", (Object)"true").put((Object)"postgresql.fetch-size", (Object)"2000").buildOrThrow();
        PostgreSqlConfig expected = new PostgreSqlConfig().setArrayMapping(PostgreSqlConfig.ArrayMapping.AS_ARRAY).setIncludeSystemTables(true).setEnableStringPushdownWithCollate(true).setFetchSize(Integer.valueOf(2000));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

