/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import io.airlift.log.Logger;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.plugin.jdbc.BaseJdbcConnectorTest;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcQueryRelationHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.RemoteLogTracingEvent;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.BaseConnectorTest;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.JdbcSqlExecutor;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TestView;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestPostgreSqlConnectorTest
extends BaseJdbcConnectorTest {
    private static final Logger log = Logger.get(TestPostgreSqlConnectorTest.class);
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    protected TestingPostgreSqlServer postgreSqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.postgreSqlServer = (TestingPostgreSqlServer)this.closeAfterClass(new TestingPostgreSqlServer());
        return ((PostgreSqlQueryRunner.Builder)PostgreSqlQueryRunner.builder(this.postgreSqlServer).setInitialTables(REQUIRED_TPCH_TABLES).withProtocolSpooling("json")).build();
    }

    @BeforeAll
    public void setExtensions() {
        this.onRemoteDatabase().execute("CREATE EXTENSION IF NOT EXISTS file_fdw");
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_PREDICATE_EXPRESSION_PUSHDOWN -> {
                Verify.verify((!super.hasBehavior(connectorBehavior) ? 1 : 0) != 0);
                yield true;
            }
            case TestingConnectorBehavior.SUPPORTS_ARRAY -> {
                if (new PostgreSqlConfig().getArrayMapping() != PostgreSqlConfig.ArrayMapping.DISABLED) {
                    yield true;
                }
                yield false;
            }
            case TestingConnectorBehavior.SUPPORTS_CANCELLATION, TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_EQUALITY, TestingConnectorBehavior.SUPPORTS_MERGE, TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE, TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN_WITH_VARCHAR -> true;
            case TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_WITH_COMMENT, TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT, TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_FULL_JOIN, TestingConnectorBehavior.SUPPORTS_MAP_TYPE, TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY, TestingConnectorBehavior.SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS, TestingConnectorBehavior.SUPPORTS_ROW_TYPE -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    protected TestTable createTableWithDefaultColumns() {
        return new TestTable((SqlExecutor)new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties()), "table", "(col_required BIGINT NOT NULL,col_nullable BIGINT,col_default BIGINT DEFAULT 43,col_nonnull_default BIGINT NOT NULL DEFAULT 42,col_required2 BIGINT NOT NULL)");
    }

    protected TestTable createTableWithUnsupportedColumn() {
        return new TestTable(this.onRemoteDatabase(), "tpch.test_unsupported_column_present", "(one bigint, two decimal(50,0), three varchar(10))");
    }

    @Test
    public void testTimestampPrecisionOnCreateTable() {
        this.testTimestampPrecisionOnCreateTable("timestamp(0)", "timestamp(0)");
        this.testTimestampPrecisionOnCreateTable("timestamp(1)", "timestamp(1)");
        this.testTimestampPrecisionOnCreateTable("timestamp(2)", "timestamp(2)");
        this.testTimestampPrecisionOnCreateTable("timestamp(3)", "timestamp(3)");
        this.testTimestampPrecisionOnCreateTable("timestamp(4)", "timestamp(4)");
        this.testTimestampPrecisionOnCreateTable("timestamp(5)", "timestamp(5)");
        this.testTimestampPrecisionOnCreateTable("timestamp(6)", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTable("timestamp(7)", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTable("timestamp(8)", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTable("timestamp(9)", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTable("timestamp(10)", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTable("timestamp(11)", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTable("timestamp(12)", "timestamp(6)");
    }

    private void testTimestampPrecisionOnCreateTable(String inputType, String expectedType) {
        try (TestTable testTable = this.newTrinoTable("test_coercion_show_create_table", String.format("(a %s)", inputType));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "a")).isEqualTo(expectedType);
        }
    }

    @Test
    public void testTimestampPrecisionOnCreateTableAsSelect() {
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00'", "timestamp(0)", "TIMESTAMP '1970-01-01 00:00:00'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.9'", "timestamp(1)", "TIMESTAMP '1970-01-01 00:00:00.9'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.56'", "timestamp(2)", "TIMESTAMP '1970-01-01 00:00:00.56'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.123'", "timestamp(3)", "TIMESTAMP '1970-01-01 00:00:00.123'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.4896'", "timestamp(4)", "TIMESTAMP '1970-01-01 00:00:00.4896'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.89356'", "timestamp(5)", "TIMESTAMP '1970-01-01 00:00:00.89356'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.123000'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123000'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.999'", "timestamp(3)", "TIMESTAMP '1970-01-01 00:00:00.999'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.123456'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.1'", "timestamp(1)", "TIMESTAMP '2020-09-27 12:34:56.1'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.9'", "timestamp(1)", "TIMESTAMP '2020-09-27 12:34:56.9'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.123'", "timestamp(3)", "TIMESTAMP '2020-09-27 12:34:56.123'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.123000'", "timestamp(6)", "TIMESTAMP '2020-09-27 12:34:56.123000'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.999'", "timestamp(3)", "TIMESTAMP '2020-09-27 12:34:56.999'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.123456'", "timestamp(6)", "TIMESTAMP '2020-09-27 12:34:56.123456'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.1234561'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.123456499'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.123456499999'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.1234565'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123457'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.111222333444'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.111222'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.9999995'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:01.000000'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 23:59:59.9999995'", "timestamp(6)", "TIMESTAMP '1970-01-02 00:00:00.000000'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1969-12-31 23:59:59.9999995'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.000000'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1969-12-31 23:59:59.999999499999'", "timestamp(6)", "TIMESTAMP '1969-12-31 23:59:59.999999'");
        this.testTimestampPrecisionOnCreateTableAsSelect("TIMESTAMP '1969-12-31 23:59:59.9999994'", "timestamp(6)", "TIMESTAMP '1969-12-31 23:59:59.999999'");
    }

    private void testTimestampPrecisionOnCreateTableAsSelect(String inputType, String tableType, String tableValue) {
        try (TestTable testTable = this.newTrinoTable("test_coercion_show_create_table", String.format("AS SELECT %s a", inputType));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "a")).isEqualTo(tableType);
            this.assertQuery(String.format("SELECT * FROM %s", testTable.getName()), String.format("VALUES (%s)", tableValue));
        }
    }

    @Test
    public void testTimestampPrecisionOnCreateTableAsSelectWithNoData() {
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00'", "timestamp(0)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.9'", "timestamp(1)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.56'", "timestamp(2)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.123'", "timestamp(3)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.4896'", "timestamp(4)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.89356'", "timestamp(5)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.123000'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.999'", "timestamp(3)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.123456'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.1'", "timestamp(1)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.9'", "timestamp(1)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.123'", "timestamp(3)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.123000'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.999'", "timestamp(3)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.123456'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.1234561'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.123456499'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.123456499999'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.1234565'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.111222333444'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.9999995'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 23:59:59.9999995'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1969-12-31 23:59:59.9999995'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1969-12-31 23:59:59.999999499999'", "timestamp(6)");
        this.testTimestampPrecisionOnCreateTableAsSelectWithNoData("TIMESTAMP '1969-12-31 23:59:59.9999994'", "timestamp(6)");
    }

    private void testTimestampPrecisionOnCreateTableAsSelectWithNoData(String inputType, String tableType) {
        try (TestTable testTable = this.newTrinoTable("test_coercion_show_create_table", String.format("AS SELECT %s a WITH NO DATA", inputType));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "a")).isEqualTo(tableType);
        }
    }

    protected void verifyAddNotNullColumnToNonEmptyTableFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("ERROR: column \".*\" contains null values");
    }

    @Test
    public void testViews() {
        this.onRemoteDatabase().execute("CREATE OR REPLACE VIEW test_view AS SELECT * FROM orders");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_view")).isTrue();
        this.assertQuery("SELECT orderkey FROM test_view", "SELECT orderkey FROM orders");
        this.onRemoteDatabase().execute("DROP VIEW IF EXISTS test_view");
    }

    @Test
    public void testPostgreSqlMaterializedView() {
        this.onRemoteDatabase().execute("CREATE MATERIALIZED VIEW test_mv as SELECT * FROM orders");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_mv")).isTrue();
        this.assertQuery("SELECT orderkey FROM test_mv", "SELECT orderkey FROM orders");
        this.onRemoteDatabase().execute("DROP MATERIALIZED VIEW test_mv");
    }

    @Test
    public void testForeignTable() {
        this.onRemoteDatabase().execute("CREATE SERVER devnull FOREIGN DATA WRAPPER file_fdw");
        this.onRemoteDatabase().execute("CREATE FOREIGN TABLE test_ft (x bigint) SERVER devnull OPTIONS (filename '/dev/null')");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_ft")).isTrue();
        this.computeActual("SELECT * FROM test_ft");
        this.onRemoteDatabase().execute("DROP FOREIGN TABLE test_ft");
        this.onRemoteDatabase().execute("DROP SERVER devnull");
    }

    @Test
    public void testErrorDuringInsert() {
        this.onRemoteDatabase().execute("CREATE TABLE test_with_constraint (x bigint primary key)");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_with_constraint")).isTrue();
        Session nonTransactional = Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "non_transactional_insert", "true").build();
        this.assertUpdate(nonTransactional, "INSERT INTO test_with_constraint VALUES (1)", 1L);
        this.assertQueryFails(nonTransactional, "INSERT INTO test_with_constraint VALUES (1)", "[\\s\\S]*ERROR: duplicate key value[\\s\\S]*");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_with_constraint")).isTrue();
        this.onRemoteDatabase().execute("DROP TABLE test_with_constraint");
    }

    @Test
    public void testSystemTable() {
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES FROM pg_catalog").getOnlyColumnAsSet()).contains(new Object[]{"pg_tables", "pg_views", "pg_type", "pg_index"});
        Assertions.assertThat((Collection)this.computeActual("SELECT typname FROM pg_catalog.pg_type").getOnlyColumnAsSet()).contains(new Object[]{"char", "text"});
        Assertions.assertThat((Stream)this.computeActual("SELECT tablename FROM pg_catalog.pg_tables WHERE schemaname = 'tpch'").getOnlyColumn()).contains(new Object[]{"orders"});
    }

    @Test
    public void testPartitionedTables() {
        try (TestTable testTable = new TestTable(this.postgreSqlServer::execute, "test_part_tbl", "(id int NOT NULL, payload varchar, logdate date NOT NULL) PARTITION BY RANGE (logdate)");){
            String values202111 = "(1, 'A', '2021-11-01'), (2, 'B', '2021-11-25')";
            String values202112 = "(3, 'C', '2021-12-01')";
            this.onRemoteDatabase().execute(String.format("CREATE TABLE %s_2021_11 PARTITION OF %s FOR VALUES FROM ('2021-11-01') TO ('2021-12-01')", testTable.getName(), testTable.getName()));
            this.onRemoteDatabase().execute(String.format("CREATE TABLE %s_2021_12 PARTITION OF %s FOR VALUES FROM ('2021-12-01') TO ('2022-01-01')", testTable.getName(), testTable.getName()));
            this.onRemoteDatabase().execute(String.format("INSERT INTO %s VALUES %s ,%s", testTable.getName(), values202111, values202112));
            Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).contains(new Object[]{testTable.getName(), testTable.getName() + "_2021_11", testTable.getName() + "_2021_12"});
            this.assertQuery(String.format("SELECT * FROM %s", testTable.getName()), String.format("VALUES %s, %s", values202111, values202112));
            this.assertQuery(String.format("SELECT * FROM %s_2021_12", testTable.getName()), "VALUES " + values202112);
        }
        testTable = new TestTable(this.postgreSqlServer::execute, "test_part_tbl", "(id int NOT NULL, type varchar, logdate varchar) PARTITION BY LIST (type)");
        try {
            String valuesA = "(1, 'A', '2021-11-11'), (4, 'A', '2021-12-25')";
            String valuesB = "(3, 'B', '2021-12-12'), (2, 'B', '2021-12-28')";
            this.onRemoteDatabase().execute(String.format("CREATE TABLE %s_a PARTITION OF %s FOR VALUES IN ('A')", testTable.getName(), testTable.getName()));
            this.onRemoteDatabase().execute(String.format("CREATE TABLE %s_b PARTITION OF %s FOR VALUES IN ('B')", testTable.getName(), testTable.getName()));
            this.assertUpdate(String.format("INSERT INTO %s VALUES %s ,%s", testTable.getName(), valuesA, valuesB), 4L);
            Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).contains(new Object[]{testTable.getName(), testTable.getName() + "_a", testTable.getName() + "_b"});
            this.assertQuery(String.format("SELECT * FROM %s", testTable.getName()), String.format("VALUES %s, %s", valuesA, valuesB));
            this.assertQuery(String.format("SELECT * FROM %s_a", testTable.getName()), "VALUES " + valuesA);
        }
        finally {
            testTable.close();
        }
    }

    @Test
    public void testTableWithNoSupportedColumns() {
        String unsupportedDataType = "interval";
        String supportedDataType = "varchar(5)";
        try (TestTable noSupportedColumns = new TestTable(this.onRemoteDatabase(), "no_supported_columns", String.format("(c %s)", unsupportedDataType));
             TestTable supportedColumns = new TestTable(this.onRemoteDatabase(), "supported_columns", String.format("(good %s)", supportedDataType));
             TestTable noColumns = new TestTable(this.onRemoteDatabase(), "no_columns", "()");){
            Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).contains(new Object[]{"orders", noSupportedColumns.getName(), supportedColumns.getName(), noColumns.getName()});
            this.assertQueryFails("SELECT c FROM " + noSupportedColumns.getName(), "\\QTable 'tpch." + noSupportedColumns.getName() + "' has no supported columns (all 1 columns are not supported)");
            this.assertQueryFails("SELECT * FROM " + noSupportedColumns.getName(), "\\QTable 'tpch." + noSupportedColumns.getName() + "' has no supported columns (all 1 columns are not supported)");
            this.assertQueryFails("SELECT 'a' FROM " + noSupportedColumns.getName(), "\\QTable 'tpch." + noSupportedColumns.getName() + "' has no supported columns (all 1 columns are not supported)");
            this.assertQueryFails("SELECT c FROM " + noColumns.getName(), "\\QTable 'tpch." + noColumns.getName() + "' has no supported columns (all 0 columns are not supported)");
            this.assertQueryFails("SELECT * FROM " + noColumns.getName(), "\\QTable 'tpch." + noColumns.getName() + "' has no supported columns (all 0 columns are not supported)");
            this.assertQueryFails("SELECT 'a' FROM " + noColumns.getName(), "\\QTable 'tpch." + noColumns.getName() + "' has no supported columns (all 0 columns are not supported)");
            this.assertQueryFails("SELECT c FROM non_existent", ".* Table .*tpch.non_existent.* does not exist");
            this.assertQueryFails("SELECT * FROM non_existent", ".* Table .*tpch.non_existent.* does not exist");
            this.assertQueryFails("SELECT 'a' FROM non_existent", ".* Table .*tpch.non_existent.* does not exist");
            this.assertQueryFails("SHOW COLUMNS FROM " + noSupportedColumns.getName(), "\\QTable 'tpch." + noSupportedColumns.getName() + "' has no supported columns (all 1 columns are not supported)");
            this.assertQueryFails("SHOW COLUMNS FROM " + noColumns.getName(), "\\QTable 'tpch." + noColumns.getName() + "' has no supported columns (all 0 columns are not supported)");
            Assertions.assertThat((Stream)this.computeActual("SHOW TABLES").getOnlyColumn()).contains(new Object[]{"orders", noSupportedColumns.getName(), supportedColumns.getName(), noColumns.getName()});
            Assertions.assertThat((Stream)this.computeActual("SELECT table_name FROM information_schema.tables WHERE table_schema = 'tpch'").getOnlyColumn()).contains(new Object[]{"orders", noSupportedColumns.getName(), supportedColumns.getName(), noColumns.getName()});
            this.assertQuery("SHOW COLUMNS FROM " + supportedColumns.getName(), "VALUES ('good', 'varchar(5)', '', '')");
            this.computeActual("SELECT column_name FROM information_schema.columns WHERE table_schema = 'tpch'");
        }
    }

    @Test
    public void testInsertWithFailureDoesNotLeaveBehindOrphanedTable() throws Exception {
        String schemaName = String.format("tmp_schema_%s", UUID.randomUUID().toString().replaceAll("-", ""));
        try (AutoCloseable schema = this.withSchema(schemaName);
             TestTable table = new TestTable(this.onRemoteDatabase(), String.format("%s.test_cleanup", schemaName), "(x INTEGER)");){
            this.assertQuery(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", schemaName), "VALUES '" + table.getName().replace(schemaName + ".", "") + "'");
            this.onRemoteDatabase().execute("ALTER TABLE " + table.getName() + " ADD CHECK (x > 0)");
            this.assertQueryFails("INSERT INTO " + table.getName() + " (x) VALUES (0)", "ERROR: new row .* violates check constraint [\\s\\S]*");
            this.assertQuery(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", schemaName), "VALUES '" + table.getName().replace(schemaName + ".", "") + "'");
        }
    }

    @Test
    public void testPredicatePushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name = 'ROMANIA'"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name BETWEEN 'POLAND' AND 'RPA'"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name IN ('POLAND', 'ROMANIA', 'VIETNAM')"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25))), (BIGINT '2', BIGINT '21', CAST('VIETNAM' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "domain_compaction_threshold", "1").build(), "SELECT regionkey, nationkey, name FROM nation WHERE name IN ('POLAND', 'ROMANIA', 'VIETNAM')"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25))), (BIGINT '2', BIGINT '21', CAST('VIETNAM' AS varchar(25)))").isNotFullyPushedDown(PlanMatchPattern.node(FilterNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan(tableHandle -> ((JdbcTableHandle)tableHandle).getConstraint().isAll(), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of())}));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name = 'romania'"))).returnsEmptyResult().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE nationkey = 19"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "domain_compaction_threshold", "1").build(), "SELECT regionkey, nationkey, name FROM nation WHERE nationkey IN (19, 21)"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25))), (BIGINT '2', BIGINT '21', CAST('VIETNAM' AS varchar(25)))").isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE nationkey BETWEEN 18.5 AND 19.5"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey FROM orders WHERE orderdate = DATE '1992-09-29'"))).matches("VALUES BIGINT '1250', 34406, 38436, 57570").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM (SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey) WHERE regionkey = 3"))).matches("VALUES (BIGINT '3', BIGINT '77')").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey HAVING sum(nationkey) = 77"))).matches("VALUES (BIGINT '3', BIGINT '77')").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey FROM (SELECT * FROM orders ORDER BY orderdate DESC, orderkey ASC LIMIT 10)WHERE orderdate = DATE '1998-08-01'"))).matches("VALUES BIGINT '27588', 22403, 37735").ordered().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT custkey FROM (SELECT SUM(totalprice) as sum, custkey, COUNT(*) as cnt FROM orders GROUP BY custkey order by sum desc limit 10) WHERE cnt > 30"))).matches("VALUES BIGINT '643', 898").ordered().isFullyPushedDown();
        Session joinPushdownEnabled = this.joinPushdownEnabled(this.getSession());
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, "SELECT c.name, n.name FROM customer c JOIN nation n ON c.custkey = n.nationkey WHERE acctbal > 8000"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, "SELECT c.name, n.name FROM customer c JOIN nation n ON c.custkey = n.nationkey WHERE address = 'TcGe5gaZNgVePxU5kRrvXBfkasDTea'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, "SELECT c.name, n.name FROM customer c JOIN nation n ON c.custkey = n.nationkey WHERE address < 'TcGe5gaZNgVePxU5kRrvXBfkasDTea'"))).isNotFullyPushedDown(PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})}));
    }

    @Test
    public void testStringPushdownWithCollate() {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "enable_string_pushdown_with_collate", "true").build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT regionkey, nationkey, name FROM nation WHERE name BETWEEN 'POLAND' AND 'RPA'"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)session).setCatalogSessionProperty("postgresql", "domain_compaction_threshold", "1").build(), "SELECT regionkey, nationkey, name FROM nation WHERE name IN ('POLAND', 'ROMANIA', 'VIETNAM')"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25))), (BIGINT '2', BIGINT '21', CAST('VIETNAM' AS varchar(25)))").isNotFullyPushedDown(PlanMatchPattern.node(FilterNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan(tableHandle -> {
            TupleDomain constraint = ((JdbcTableHandle)tableHandle).getConstraint();
            ColumnHandle nameColumn = (ColumnHandle)((Map)constraint.getDomains().orElseThrow()).keySet().stream().map(JdbcColumnHandle.class::cast).filter(column -> column.getColumnName().equals("name")).collect(MoreCollectors.onlyElement());
            return ((Domain)((Map)constraint.getDomains().get()).get(nameColumn)).getValues().getRanges().getOrderedRanges().equals(ImmutableList.of((Object)Range.range((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"POLAND"), (boolean)true, (Object)Slices.utf8Slice((String)"VIETNAM"), (boolean)true)));
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of())}));
        Session joinPushdownEnabled = this.joinPushdownEnabled(session);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, "SELECT c.name, n.name FROM customer c JOIN nation n ON c.custkey = n.nationkey WHERE address < 'TcGe5gaZNgVePxU5kRrvXBfkasDTea'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, "SELECT c.name, n.name FROM customer c JOIN nation n ON c.address = n.name"))).isNotFullyPushedDown(PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})}));
    }

    @Test
    public void testStringJoinPushdownWithCollate() {
        PlanMatchPattern joinOverTableScans = PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})});
        PlanMatchPattern broadcastJoinOverTableScans = PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0]), PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPLICATE, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})});
        Session sessionWithCollatePushdown = Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "enable_string_pushdown_with_collate", "true").build();
        Session session = this.joinPushdownEnabled(sessionWithCollatePushdown);
        Session withoutDynamicFiltering = Session.builder((Session)this.getSession()).setSystemProperty("enable_dynamic_filtering", "false").setCatalogSessionProperty("postgresql", "enable_string_pushdown_with_collate", "true").build();
        List nonEqualities = (List)Stream.concat(Stream.of(JoinCondition.Operator.values()).filter(operator -> operator != JoinCondition.Operator.EQUAL && operator != JoinCondition.Operator.IDENTICAL).map(JoinCondition.Operator::getValue), Stream.of("IS DISTINCT FROM", "IS NOT DISTINCT FROM")).collect(ImmutableList.toImmutableList());
        try (TestTable nationLowercaseTable = this.newTrinoTable("nation_lowercase", "AS SELECT nationkey, lower(name) name, regionkey FROM nation");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT r.name, n.name FROM nation n JOIN region r ON n.regionkey = r.regionkey"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT r.name, n.name FROM nation n JOIN region r ON n.nationkey = r.regionkey"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT r.name, n.name FROM nation n JOIN region r USING(regionkey)"))).isFullyPushedDown();
            this.assertConditionallyPushedDown(session, "SELECT n.name, n2.regionkey FROM nation n JOIN nation n2 ON n.name = n2.name", true, joinOverTableScans);
            this.assertConditionallyPushedDown(session, String.format("SELECT n.name, nl.regionkey FROM nation n JOIN %s nl ON n.name = nl.name", nationLowercaseTable.getName()), true, joinOverTableScans);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT n.name, c.name FROM nation n JOIN customer c ON n.nationkey = c.nationkey and n.regionkey = c.custkey"))).isFullyPushedDown();
            for (String operator2 : nonEqualities) {
                log.info("Testing operator=%s", new Object[]{operator2});
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(withoutDynamicFiltering, String.format("SELECT r.name, n.name FROM nation n JOIN region r ON n.regionkey %s r.regionkey", operator2)))).isNotFullyPushedDown(broadcastJoinOverTableScans);
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(withoutDynamicFiltering, String.format("SELECT n.name, nl.name FROM nation n JOIN %s nl ON n.name %s nl.name", nationLowercaseTable.getName(), operator2)))).isNotFullyPushedDown(broadcastJoinOverTableScans);
            }
            for (String operator2 : nonEqualities) {
                log.info("Testing operator=%s", new Object[]{operator2});
                this.assertConditionallyPushedDown(session, String.format("SELECT n.name, c.name FROM nation n JOIN customer c ON n.nationkey = c.nationkey AND n.regionkey %s c.custkey", operator2), this.expectJoinPushdown(operator2), joinOverTableScans);
            }
            for (String operator2 : nonEqualities) {
                log.info("Testing operator=%s", new Object[]{operator2});
                this.assertConditionallyPushedDown(session, String.format("SELECT n.name, nl.name FROM nation n JOIN %s nl ON n.regionkey = nl.regionkey AND n.name %s nl.name", nationLowercaseTable.getName(), operator2), this.expectJoinPushdown(operator2), joinOverTableScans);
            }
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT r.name, n.name FROM nation n LEFT JOIN region r ON n.nationkey = r.regionkey"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT r.name, n.name FROM region r LEFT JOIN nation n ON n.nationkey = r.regionkey"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT r.name, n.name FROM nation n RIGHT JOIN region r ON n.nationkey = r.regionkey"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT r.name, n.name FROM region r RIGHT JOIN nation n ON n.nationkey = r.regionkey"))).isFullyPushedDown();
            this.assertConditionallyPushedDown(session, "SELECT r.name, n.name FROM nation n FULL JOIN region r ON n.nationkey = r.regionkey", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_FULL_JOIN), joinOverTableScans);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT c.name, n.name FROM (SELECT * FROM customer WHERE acctbal > 8000) c JOIN nation n ON c.custkey = n.nationkey"))).isFullyPushedDown();
            this.assertConditionallyPushedDown(session, "SELECT c.name, n.name FROM (SELECT * FROM customer WHERE address = 'TcGe5gaZNgVePxU5kRrvXBfkasDTea') c JOIN nation n ON c.custkey = n.nationkey", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY), joinOverTableScans);
            this.assertConditionallyPushedDown(session, "SELECT * FROM (SELECT regionkey rk, count(nationkey) c FROM nation GROUP BY regionkey) n JOIN region r ON n.rk = r.regionkey", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN), joinOverTableScans);
            this.assertConditionallyPushedDown(session, "SELECT * FROM (SELECT nationkey FROM nation LIMIT 30) n JOIN region r ON n.nationkey = r.regionkey", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_LIMIT_PUSHDOWN), joinOverTableScans);
            this.assertConditionallyPushedDown(session, "SELECT * FROM (SELECT nationkey FROM nation ORDER BY regionkey LIMIT 5) n JOIN region r ON n.nationkey = r.regionkey", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN), joinOverTableScans);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT * FROM nation n, region r, customer c WHERE n.regionkey = r.regionkey AND r.regionkey = c.custkey"))).isFullyPushedDown();
        }
    }

    @Test
    public void testDecimalPredicatePushdown() {
        try (TestTable table = new TestTable(this.onRemoteDatabase(), "test_decimal_pushdown", "(short_decimal decimal(9, 3), long_decimal decimal(30, 10))", List.of("123.321, 123456789.987654321"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE short_decimal <= 124"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE short_decimal <= 124"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE long_decimal <= 123456790"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE short_decimal <= 123.321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE long_decimal <= 123456789.987654321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE short_decimal = 123.321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE long_decimal = 123456789.987654321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
        }
    }

    @Test
    public void testCharPredicatePushdown() {
        try (TestTable table = new TestTable(this.onRemoteDatabase(), "test_char_pushdown", "(char_1 char(1), char_5 char(5), char_10 char(10))", List.of("'0', '0', '0'", "'1', '12345', '1234567890'"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE char_1 = '0' AND char_5 = '0'"))).matches("VALUES (CHAR'0', CHAR'0    ', CHAR'0         ')").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE char_5 = CHAR'12345' AND char_10 = '1234567890'"))).matches("VALUES (CHAR'1', CHAR'12345', CHAR'1234567890')").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE char_10 = CHAR'0'"))).matches("VALUES (CHAR'0', CHAR'0    ', CHAR'0         ')").isFullyPushedDown();
        }
    }

    @Test
    public void testOrPredicatePushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM nation WHERE nationkey != 3 OR regionkey = 4"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM nation WHERE nationkey != 3 OR regionkey != 4"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM nation WHERE name = 'ALGERIA' OR regionkey = 4"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM nation WHERE name IS NULL OR regionkey = 4"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM nation WHERE name = NULL OR regionkey = 4"))).isFullyPushedDown();
    }

    @Test
    public void testLikePredicatePushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey FROM nation WHERE name LIKE '%A%'"))).isFullyPushedDown();
        try (TestTable table = this.newTrinoTable("test_like_predicate_pushdown", "(id integer, a_varchar varchar(1))", List.of("1, 'A'", "2, 'a'", "3, 'B'", "4, '\u0105'", "5, '\u0104'"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE a_varchar LIKE '%A%'"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE a_varchar LIKE '%\u0105%'"))).isFullyPushedDown();
        }
    }

    @Test
    public void testLikeWithEscapePredicatePushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey FROM nation WHERE name LIKE '%A%' ESCAPE '\\'"))).isFullyPushedDown();
        try (TestTable table = this.newTrinoTable("test_like_with_escape_predicate_pushdown", "(id integer, a_varchar varchar(4))", List.of("1, 'A%b'", "2, 'Asth'", "3, '\u0105%b'", "4, '\u0105sth'"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE a_varchar LIKE '%A\\%%' ESCAPE '\\'"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE a_varchar LIKE '%\u0105\\%%' ESCAPE '\\'"))).isFullyPushedDown();
        }
    }

    @Test
    public void testIsNullPredicatePushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey FROM nation WHERE name IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey FROM nation WHERE name IS NULL OR regionkey = 4"))).isFullyPushedDown();
        try (TestTable table = this.newTrinoTable("test_is_null_predicate_pushdown", "(a_int integer, a_varchar varchar(1))", List.of("1, 'A'", "2, 'B'", "1, NULL", "2, NULL"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a_int FROM " + table.getName() + " WHERE a_varchar IS NULL OR a_int = 1"))).isFullyPushedDown();
        }
    }

    @Test
    public void testIsNotNullPredicatePushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey FROM nation WHERE name IS NOT NULL OR regionkey = 4"))).isFullyPushedDown();
        try (TestTable table = this.newTrinoTable("test_is_not_null_predicate_pushdown", "(a_int integer, a_varchar varchar(1))", List.of("1, 'A'", "2, 'B'", "1, NULL", "2, NULL"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a_int FROM " + table.getName() + " WHERE a_varchar IS NOT NULL OR a_int = 1"))).isFullyPushedDown();
        }
    }

    @Test
    public void testNullIfPredicatePushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey FROM nation WHERE NULLIF(name, 'ALGERIA') IS NULL"))).matches("VALUES BIGINT '0'").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation WHERE NULLIF(nationkey, 0) IS NULL"))).matches("VALUES CAST('ALGERIA' AS varchar(25))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey FROM nation WHERE NULLIF(name, 'Algeria') IS NULL"))).returnsEmptyResult().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey FROM nation WHERE NULLIF(name, 'Name not found') = name"))).matches("SELECT nationkey FROM nation").isFullyPushedDown();
    }

    @Test
    public void testNotExpressionPushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey FROM nation WHERE NOT(name LIKE '%A%' ESCAPE '\\')"))).isFullyPushedDown();
        try (TestTable table = this.newTrinoTable("test_is_not_predicate_pushdown", "(a_int integer, a_varchar varchar(2))", List.of("1, 'Aa'", "2, 'Bb'", "1, NULL", "2, NULL"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a_int FROM " + table.getName() + " WHERE NOT(a_varchar LIKE 'A%') OR a_int = 2"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a_int FROM " + table.getName() + " WHERE NOT(a_varchar LIKE 'A%' OR a_int = 2)"))).isFullyPushedDown();
        }
    }

    @Test
    public void testInPredicatePushdown() {
        try (TestTable table = this.newTrinoTable("test_in_predicate_pushdown", "(id varchar(1), id2 varchar(1))", List.of("'a', 'b'", "'b', 'c'", "'c', 'c'", "'d', 'd'", "'a', 'f'"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE id IN ('a', id2)"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE id IN ('a', 'b') OR id2 IN ('c', 'd')"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE id IN ('a', 'B') OR id2 IN ('c', 'D')"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE id IN ('a', 'B', NULL) OR id2 IN ('C', 'd')"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testNonLowercaseUserDefinedTypeName() {
        String enumType = "TEST_ENUM_" + TestingNames.randomNameSuffix();
        this.onRemoteDatabase().execute("CREATE TYPE public.\"" + enumType + "\" AS ENUM ('A', 'B')");
        try (TestTable testTable = new TestTable(this.onRemoteDatabase(), "test_case_sensitive_", "(id int, user_type public.\"" + enumType + "\")", List.of("1, 'A'", "2, 'B'"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + testTable.getName() + " WHERE user_type = 'A'"))).matches("VALUES 1");
        }
        finally {
            this.onRemoteDatabase().execute("DROP TYPE public.\"" + enumType + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testUserDefinedTypeNameContainsDoubleQuotes() {
        String enumType = "test_double_\"\"_quotes_" + TestingNames.randomNameSuffix();
        this.onRemoteDatabase().execute("CREATE TYPE public.\"" + enumType + "\" AS ENUM ('A', 'B')");
        try (TestTable testTable = new TestTable(this.onRemoteDatabase(), "test_case_sensitive_", "(id int, user_type public.\"" + enumType + "\")", List.of("1, 'A'", "2, 'B'"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + testTable.getName() + " WHERE user_type = 'A'"))).matches("VALUES 1");
        }
        finally {
            this.onRemoteDatabase().execute("DROP TYPE public.\"" + enumType + "\"");
        }
    }

    protected String errorMessageForInsertIntoNotNullColumn(String columnName) {
        return String.format("(?s).*null value in column \"%s\" violates not-null constraint.*", columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopNWithEnum() {
        String enumType = "test_enum_" + TestingNames.randomNameSuffix();
        this.onRemoteDatabase().execute("CREATE TYPE " + enumType + " AS ENUM ('A', 'b', 'B', 'a')");
        try (TestTable testTable = new TestTable(this.onRemoteDatabase(), "test_case_sensitive_topn_pushdown_with_enums", "(an_enum " + enumType + ", a_bigint bigint)", List.of("'A', 1", "'B', 2", "'a', 3", "'b', 4"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a_bigint FROM " + testTable.getName() + " ORDER BY an_enum ASC LIMIT 2"))).ordered().isNotFullyPushedDown(TopNNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a_bigint FROM " + testTable.getName() + " ORDER BY an_enum DESC LIMIT 2"))).ordered().isNotFullyPushedDown(TopNNode.class, new Class[0]);
        }
        finally {
            this.onRemoteDatabase().execute("DROP TYPE " + enumType);
        }
    }

    @Test
    public void testNativeLargeIn() {
        this.onRemoteDatabase().execute("SELECT count(*) FROM orders WHERE " + this.getLongInClause(0, 500000));
    }

    @Test
    public void testNativeMultipleInClauses() {
        String longInClauses = IntStream.range(0, 20).mapToObj(value -> this.getLongInClause(value * 10000, 10000)).collect(Collectors.joining(" OR "));
        this.onRemoteDatabase().execute("SELECT count(*) FROM orders WHERE " + longInClauses);
    }

    @Test
    public void testTimestampColumnAndTimestampWithTimeZoneConstant() {
        try (TestTable table = new TestTable(this.onRemoteDatabase(), "test_timestamptz_unwrap_cast", "(id integer, ts_col timestamp(6))");){
            this.onRemoteDatabase().execute("INSERT INTO " + table.getName() + " (id, ts_col) VALUES (1, timestamp '2020-01-01 01:01:01.000'),(2, timestamp '2019-01-01 01:01:01.000')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT id FROM %s WHERE ts_col >= TIMESTAMP '2019-01-01 00:00:00 %s'", table.getName(), this.getSession().getTimeZoneKey().getId())))).matches("VALUES 1, 2").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT id FROM %s WHERE ts_col >= TIMESTAMP '2019-01-01 00:00:00 %s'", table.getName(), "UTC")))).matches("VALUES 1").isFullyPushedDown();
        }
    }

    @Test
    public void testReverseFunctionProjectionPushDown() {
        try (TestTable table = this.newTrinoTable("test_reverse_pushdown_for_project", "(id BIGINT, varchar_col VARCHAR)", (List)ImmutableList.of((Object)"1, 'abc'", (Object)"2, null"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT reverse(varchar_col) FROM " + table.getName()))).skippingTypesCheck().matches("VALUES 'cba', NULL").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT reverse(varchar_col) FROM " + table.getName() + " WHERE id = 1"))).skippingTypesCheck().matches("VALUES 'cba'").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, reverse(reverse(reverse(reverse(reverse(varchar_col))))) FROM " + table.getName()))).skippingTypesCheck().matches("VALUES (BIGINT '1', 'cba'), (BIGINT '2', NULL)").isFullyPushedDown().hasPlan(PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.tableScan(tableHandle -> {
                JdbcTableHandle jdbcTableHandle = (JdbcTableHandle)tableHandle;
                Assertions.assertThat((boolean)jdbcTableHandle.isSynthetic()).isTrue();
                return ((JdbcQueryRelationHandle)jdbcTableHandle.getRelationHandle()).getPreparedQuery().equals((Object)new PreparedQuery("SELECT \"id\", REVERSE(\"_pfgnrtd_3\") AS \"_pfgnrtd_4\" FROM (SELECT \"id\", REVERSE(\"_pfgnrtd_2\") AS \"_pfgnrtd_3\" FROM (SELECT \"id\", REVERSE(\"_pfgnrtd_1\") AS \"_pfgnrtd_2\" FROM (SELECT \"id\", REVERSE(\"_pfgnrtd_0\") AS \"_pfgnrtd_1\" FROM " + "(SELECT \"id\", REVERSE(\"varchar_col\") AS \"_pfgnrtd_0\" FROM \"tpch\".\"tpch\".\"%s\") o) o) o) o".formatted(table.getName()), (List)ImmutableList.of()));
            }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"id", columnHandle -> ((JdbcColumnHandle)columnHandle).getColumnName().equals("id"), (Object)"pfgnrtd", columnHandle -> ((JdbcColumnHandle)columnHandle).getColumnName().startsWith("_pfgnrtd_")))));
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT reverse(lower(varchar_col)) FROM " + table.getName()))).skippingTypesCheck().matches("VALUES 'cba', NULL").isNotFullyPushedDown(ProjectNode.class, new Class[0]).hasPlan(PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Call(FUNCTIONS.resolveFunction("reverse", (List)ImmutableList.of((Object)new TypeSignatureProvider(VarcharType.VARCHAR.getTypeSignature()))), (List)ImmutableList.of((Object)new Call(FUNCTIONS.resolveFunction("lower", (List)ImmutableList.of((Object)new TypeSignatureProvider(VarcharType.VARCHAR.getTypeSignature()))), (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "varchar_col"))))))), (PlanMatchPattern)PlanMatchPattern.tableScan((String)table.getName(), (Map)ImmutableMap.of((Object)"varchar_col", (Object)"varchar_col")))));
        }
    }

    @Test
    public void testPartialProjectionPushDown() {
        try (TestTable table = this.newTrinoTable("test_partial_projection_pushdown", "(id BIGINT, cola VARCHAR, colb VARCHAR)", (List)ImmutableList.of((Object)"1, 'abc', 'def'"));){
            ResolvedFunction concatFunction = FUNCTIONS.resolveFunction("concat", (List)ImmutableList.of((Object)new TypeSignatureProvider(VarcharType.VARCHAR.getTypeSignature()), (Object)new TypeSignatureProvider(VarcharType.VARCHAR.getTypeSignature())));
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT round(id), concat(reverse(cola), reverse(colb)), concat(reverse(cola), reverse(cola)), concat(reverse(cola), upper(reverse(cola))) FROM " + table.getName()))).matches("VALUES (BIGINT '1', VARCHAR 'cbafed', VARCHAR 'cbacba', VARCHAR 'cbaCBA')").hasPlan(PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"round_expr", (Object)PlanMatchPattern.expression((Expression)new Call(FUNCTIONS.resolveFunction("round", (List)ImmutableList.of((Object)new TypeSignatureProvider(BigintType.BIGINT.getTypeSignature()))), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "id")))), (Object)"concat_expr", (Object)PlanMatchPattern.expression((Expression)new Call(concatFunction, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "reverse_cola"), (Object)new Reference((Type)VarcharType.VARCHAR, "reverse_colb")))), (Object)"concat_on_same_col", (Object)PlanMatchPattern.expression((Expression)new Call(concatFunction, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "reverse_cola"), (Object)new Reference((Type)VarcharType.VARCHAR, "reverse_cola")))), (Object)"concat_on_same_col_with_lower", (Object)PlanMatchPattern.expression((Expression)new Call(concatFunction, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "reverse_cola"), (Object)new Call(FUNCTIONS.resolveFunction("upper", (List)ImmutableList.of((Object)new TypeSignatureProvider(VarcharType.VARCHAR.getTypeSignature()))), (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "reverse_cola"))))))), (PlanMatchPattern)PlanMatchPattern.tableScan(tableHandle -> {
                JdbcTableHandle jdbcTableHandle = (JdbcTableHandle)tableHandle;
                Assertions.assertThat((boolean)jdbcTableHandle.isSynthetic()).isTrue();
                return ((JdbcQueryRelationHandle)jdbcTableHandle.getRelationHandle()).getPreparedQuery().equals((Object)new PreparedQuery("SELECT \"id\", REVERSE(\"cola\") AS \"_pfgnrtd_0\", REVERSE(\"colb\") AS \"_pfgnrtd_1\" FROM \"tpch\".\"tpch\".\"%s\"".formatted(table.getName()), (List)ImmutableList.of()));
            }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"reverse_cola", columnHandle -> ((JdbcColumnHandle)columnHandle).getColumnName().equals("_pfgnrtd_0"), (Object)"reverse_colb", columnHandle -> ((JdbcColumnHandle)columnHandle).getColumnName().equals("_pfgnrtd_1"), (Object)"id", columnHandle -> ((JdbcColumnHandle)columnHandle).getColumnName().equals("id"))))));
        }
    }

    @Test
    public void testProjectionsNotPushDownWhenFilterAppliedOnProjectedColumn() {
        try (TestTable table = this.newTrinoTable("test_projection_push_down_with_filter", "(id BIGINT, cola VARCHAR, colb VARCHAR)", (List)ImmutableList.of((Object)"1, 'abc', 'def'"));){
            ResolvedFunction concatFunction = FUNCTIONS.resolveFunction("concat", (List)ImmutableList.of((Object)new TypeSignatureProvider(VarcharType.VARCHAR.getTypeSignature()), (Object)new TypeSignatureProvider(VarcharType.VARCHAR.getTypeSignature())));
            ResolvedFunction reverseFunction = FUNCTIONS.resolveFunction("reverse", (List)ImmutableList.of((Object)new TypeSignatureProvider(VarcharType.VARCHAR.getTypeSignature())));
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT reverse_col, concat_col FROM (SELECT reverse(cola) AS reverse_col, CONCAT(reverse(cola), colb) AS concat_col FROM " + table.getName() + ") WHERE concat_col = 'cbadef'"))).skippingTypesCheck().matches("VALUES ('cba', 'cbadef')").hasPlan(PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"reverse_col", (Object)PlanMatchPattern.expression((Expression)new Call(reverseFunction, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "cola")))), (Object)"concat_col", (Object)PlanMatchPattern.expression((Expression)new Call(concatFunction, (List)ImmutableList.of((Object)new Call(reverseFunction, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "cola"))), (Object)new Reference((Type)VarcharType.VARCHAR, "colb"))))), (PlanMatchPattern)PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(concatFunction, (List)ImmutableList.of((Object)new Call(reverseFunction, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "cola"))), (Object)new Reference((Type)VarcharType.VARCHAR, "colb"))), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"cbadef"))), (PlanMatchPattern)PlanMatchPattern.tableScan((String)table.getName(), (Map)ImmutableMap.of((Object)"cola", (Object)"cola", (Object)"colb", (Object)"colb"))))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReverseFunctionOnSpecialColumn() {
        String enumType = "test_enum_" + TestingNames.randomNameSuffix();
        this.onRemoteDatabase().execute("CREATE TYPE " + enumType + " AS ENUM ('abc')");
        try (TestTable table = new TestTable(this.onRemoteDatabase(), "table_with_special_column", "(id BIGINT, col_money money, col_enum %s)".formatted(enumType), (List)ImmutableList.of((Object)"1, 10.0, 'abc'"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT reverse(col_money) AS reverse_col_money, reverse(col_enum) AS reverse_col_enum FROM " + table.getName()))).skippingTypesCheck().matches("VALUES ('00.01$', 'cba')").isNotFullyPushedDown(ProjectNode.class, new Class[0]).hasPlan(PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.project((Map)ImmutableMap.of((Object)"reverse_col_money", (Object)PlanMatchPattern.expression((Expression)new Call(FUNCTIONS.resolveFunction("reverse", (List)ImmutableList.of((Object)new TypeSignatureProvider(VarcharType.VARCHAR.getTypeSignature()))), (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "col_money")))), (Object)"reverse_col_enum", (Object)PlanMatchPattern.expression((Expression)new Call(FUNCTIONS.resolveFunction("reverse", (List)ImmutableList.of((Object)new TypeSignatureProvider(VarcharType.VARCHAR.getTypeSignature()))), (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "col_enum"))))), (PlanMatchPattern)PlanMatchPattern.tableScan((String)table.getName(), (Map)ImmutableMap.of((Object)"col_money", (Object)"col_money", (Object)"col_enum", (Object)"col_enum")))));
        }
        finally {
            this.onRemoteDatabase().execute("DROP TYPE " + enumType);
        }
    }

    @Test
    void testVectorDistanceNotPushdown() {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "array_mapping", PostgreSqlConfig.ArrayMapping.AS_ARRAY.name()).build();
        try (TestTable table = new TestTable(this.onRemoteDatabase(), "test_vector", "(id int, v real[])");){
            this.onRemoteDatabase().execute("INSERT INTO " + table.getName() + " VALUES (1, '{1,2,3}'), (2, '{4,5,6}')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT euclidean_distance(v, CAST(ARRAY[4.0,5.0,6.0] AS array(real))) FROM " + table.getName()))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT -dot_product(v, CAST(ARRAY[4.0,5.0,6.0] AS array(real))) FROM " + table.getName()))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT cosine_distance(v, CAST(ARRAY[4.0,5.0,6.0] AS array(real))) FROM " + table.getName()))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
        }
    }

    @Test
    public void testJoinPushdownWithImplicitCast() {
        try (TestTable leftTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "left_table_", "(id int, c_tinyint tinyint, c_smallint smallint, c_integer integer, c_bigint bigint, c_real real, c_double_precision double precision, c_decimal_10_2 decimal(10, 2))", (List)ImmutableList.of((Object)"(11, 12, 12, 12, 12, 12.34, 12.34, 12.34)", (Object)"(12, 123, 123, 123, 123, 123.67, 123.67, 123.67)"));
             TestTable rightTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "right_table_", "(id int, c_tinyint tinyint, c_smallint smallint, c_integer integer, c_bigint bigint, c_real real, c_double_precision double precision, c_decimal_10_2 decimal(10, 2))", (List)ImmutableList.of((Object)"(21, 12, 12, 12, 12, 12.34, 12.34, 12.34)", (Object)"(22, 234, 234, 234, 234, 234.67, 234.67, 234.67)"));){
            Session session = this.joinPushdownEnabled(this.getSession());
            String joinQuery = "SELECT l.id FROM " + leftTable.getName() + " l %s " + rightTable.getName() + " r ON %s";
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("LEFT JOIN", "l.c_tinyint = r.c_bigint")))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("RIGHT JOIN", "l.c_tinyint = r.c_bigint")))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("INNER JOIN", "l.c_tinyint = r.c_bigint")))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("FULL JOIN", "l.c_tinyint = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("LEFT JOIN", "l.c_smallint = r.c_bigint")))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("RIGHT JOIN", "l.c_smallint = r.c_bigint")))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("INNER JOIN", "l.c_smallint = r.c_bigint")))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("FULL JOIN", "l.c_smallint = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("LEFT JOIN", "l.c_integer = r.c_bigint")))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("RIGHT JOIN", "l.c_integer = r.c_bigint")))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("INNER JOIN", "l.c_integer = r.c_bigint")))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("FULL JOIN", "l.c_integer = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("LEFT JOIN", "l.c_real = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("RIGHT JOIN", "l.c_real = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("INNER JOIN", "l.c_real = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("FULL JOIN", "l.c_real = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("LEFT JOIN", "l.c_double_precision = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("RIGHT JOIN", "l.c_double_precision = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("INNER JOIN", "l.c_double_precision = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("FULL JOIN", "l.c_double_precision = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("LEFT JOIN", "l.c_decimal_10_2 = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("RIGHT JOIN", "l.c_decimal_10_2 = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("INNER JOIN", "l.c_decimal_10_2 = r.c_bigint")))).joinIsNotFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, joinQuery.formatted("FULL JOIN", "l.c_decimal_10_2 = r.c_bigint")))).joinIsNotFullyPushedDown();
        }
    }

    @Test
    public void testMergeTargetWithNoPrimaryKeys() {
        String tableName = "test_merge_target_no_pks_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a int, b int)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES(1, 1), (2, 2)", 2L);
        this.assertQueryFails(String.format("DELETE FROM %s WHERE a IS NOT NULL AND abs(a + b) > 10", tableName), "The connector can not perform merge on the target table without primary keys");
        this.assertQueryFails(String.format("UPDATE %s SET a = a+b WHERE a IS NOT NULL AND (a + b) > 10", tableName), "The connector can not perform merge on the target table without primary keys");
        this.assertQueryFails(String.format("MERGE INTO %s t USING (VALUES (3, 3)) AS s(x, y)    ON t.a = s.x    WHEN MATCHED THEN UPDATE SET b = y    WHEN NOT MATCHED THEN INSERT (a, b) VALUES (s.x, s.y) ", tableName), "The connector can not perform merge on the target table without primary keys");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private String getLongInClause(int start, int length) {
        String longValues = IntStream.range(start, start + length).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        return "orderkey IN (" + longValues + ")";
    }

    private AutoCloseable withSchema(String schema) {
        this.onRemoteDatabase().execute(String.format("CREATE SCHEMA %s", schema));
        return () -> this.onRemoteDatabase().execute(String.format("DROP SCHEMA %s", schema));
    }

    protected SqlExecutor onRemoteDatabase() {
        return this.postgreSqlServer::execute;
    }

    protected void startTracingDatabaseEvent(RemoteLogTracingEvent event) {
        this.postgreSqlServer.startTracingDatabaseEvent(event);
    }

    protected void stopTracingDatabaseEvent(RemoteLogTracingEvent event) {
        this.postgreSqlServer.stopTracingDatabaseEvent(event);
    }

    protected TestView createSleepingView(Duration minimalQueryDuration) {
        long secondsToSleep = Math.round(minimalQueryDuration.convertTo(TimeUnit.SECONDS).getValue() + 1.0);
        return new TestView(this.onRemoteDatabase(), "test_sleeping_view", String.format("SELECT 1 FROM pg_sleep(%d)", secondsToSleep));
    }

    protected Session joinPushdownEnabled(Session session) {
        return Session.builder((Session)super.joinPushdownEnabled(session)).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "join_pushdown_strategy", "EAGER").build();
    }

    protected OptionalInt maxSchemaNameLength() {
        return OptionalInt.of(63);
    }

    protected void verifySchemaNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessage("Schema name must be shorter than or equal to '63' characters but got '64'");
    }

    protected OptionalInt maxTableNameLength() {
        return OptionalInt.of(63);
    }

    protected void verifyTableNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessage("Table name must be shorter than or equal to '63' characters but got '64'");
    }

    protected OptionalInt maxColumnNameLength() {
        return OptionalInt.of(63);
    }

    protected void verifyColumnNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("Column name must be shorter than or equal to '63' characters but got '64': '.*'");
    }

    protected void verifySetColumnTypeFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("(?s)ERROR: .*(cannot be cast automatically to type|out of range).*");
    }

    protected Optional<BaseConnectorTest.SetColumnTypeSetup> filterSetColumnTypesDataProvider(BaseConnectorTest.SetColumnTypeSetup setup) {
        if (setup.sourceColumnType().equals("bigint") && setup.newColumnType().equals("tinyint")) {
            return Optional.of(setup.withNewColumnType("smallint"));
        }
        if (setup.sourceColumnType().equals("timestamp(3) with time zone")) {
            return Optional.of(setup.withNewValueLiteral("TIMESTAMP '2020-02-12 14:03:00.123000 +00:00'"));
        }
        if (setup.sourceColumnType().equals("char(20)") && setup.newColumnType().equals("varchar")) {
            return Optional.of(setup.withNewValueLiteral("rtrim(%s)".formatted(setup.newValueLiteral())));
        }
        return Optional.of(setup);
    }

    protected void createTableForWrites(String createTable, String tableName, Optional<String> primaryKey, OptionalInt updateCount) {
        super.createTableForWrites(createTable, tableName, primaryKey, updateCount);
        primaryKey.ifPresent(key -> this.onRemoteDatabase().execute(String.format("ALTER TABLE %s ADD CONSTRAINT %s PRIMARY KEY (%s)", tableName, "pk_" + tableName, key)));
    }

    protected TestTable createTestTableForWrites(String namePrefix, String tableDefinition, String primaryKey) {
        TestTable testTable = super.createTestTableForWrites(namePrefix, tableDefinition, primaryKey);
        String tableName = testTable.getName();
        this.onRemoteDatabase().execute(String.format("ALTER TABLE %s ADD CONSTRAINT %s PRIMARY KEY (%s)", tableName, "pk_" + tableName, primaryKey));
        return testTable;
    }

    protected TestTable createTestTableForWrites(String namePrefix, String tableDefinition, List<String> rowsToInsert, String primaryKey) {
        TestTable testTable = super.createTestTableForWrites(namePrefix, tableDefinition, rowsToInsert, primaryKey);
        String tableName = testTable.getName();
        this.onRemoteDatabase().execute(String.format("ALTER TABLE %s ADD CONSTRAINT %s PRIMARY KEY (%s)", tableName, "pk_" + tableName, primaryKey));
        return testTable;
    }
}

