/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.TestTable;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.utility.DockerImageName;

final class TestPostgreSqlGeometryType
extends AbstractTestQueryFramework {
    private TestingPostgreSqlServer postgreSqlServer;

    TestPostgreSqlGeometryType() {
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.postgreSqlServer = (TestingPostgreSqlServer)this.closeAfterClass(new TestingPostgreSqlServer(DockerImageName.parse((String)"postgis/postgis:17-3.4-alpine").asCompatibleSubstituteFor("postgres"), false));
        return PostgreSqlQueryRunner.builder(this.postgreSqlServer).build();
    }

    @Test
    void testGeometryRead() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_geometry_read", "(geom geometry)");){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (ST_Point(1, 1))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES ST_Point(1, 1)");
        }
    }

    @Test
    void testGeometryReadWithSrid() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_geometry_read", "(geom geometry(point, 4326))");){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (ST_SetSRID(ST_Point(1, 1), 4326))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES ST_Point(1, 1)");
        }
    }

    @Test
    void testGeometryWrite() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_geometry_write", "(geom geometry)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (ST_Point(1, 1))", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES ST_Point(1, 1)");
        }
    }

    @Test
    void testGeometryNullRead() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_geometry_null_read", "(id int, geom geometry)");){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (1, NULL), (2, ST_Point(1, 1))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT geom FROM " + table.getName()))).matches("VALUES CAST(NULL AS Geometry), ST_Point(1,1)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE geom IS NULL"))).matches("VALUES 1");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE geom IS NOT NULL"))).matches("VALUES 2");
        }
    }

    @Test
    void testGeometryNullWrite() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_geometry_null_write", "(id int, geom geometry)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1, NULL), (2, ST_Point(1, 1))", 2L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE geom IS NULL"))).matches("VALUES 1");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE geom IS NOT NULL"))).matches("VALUES 2");
        }
    }
}

