/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigurationAwareModule;
import io.trino.Session;
import io.trino.plugin.jdbc.BaseJdbcConnectionCreationTest;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcPlugin;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.StaticCredentialProvider;
import io.trino.plugin.postgresql.PostgreSqlClientModule;
import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.junit.jupiter.api.Test;
import org.postgresql.Driver;

public class TestPostgreSqlJdbcConnectionAccesses
extends BaseJdbcConnectionCreationTest {
    private TestingPostgreSqlServer postgreSqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        TestingPostgreSqlServer postgreSqlServer = (TestingPostgreSqlServer)this.closeAfterClass(new TestingPostgreSqlServer());
        this.postgreSqlServer = Objects.requireNonNull(postgreSqlServer, "postgreSqlServer is null");
        this.connectionFactory = TestPostgreSqlJdbcConnectionAccesses.getConnectionCountingConnectionFactory(postgreSqlServer);
        DistributedQueryRunner queryRunner = ((PostgreSqlQueryRunner.Builder)((PostgreSqlQueryRunner.Builder)PostgreSqlQueryRunner.builder(postgreSqlServer).addCoordinatorProperty("node-scheduler.include-coordinator", "false")).amendSession(sessionBuilder -> sessionBuilder.setCatalog("counting_postgresql"))).setAdditionalSetup(runner -> {
            runner.installPlugin((Plugin)new JdbcPlugin("counting_postgresql", () -> ConfigurationAwareModule.combine((Module[])new Module[]{new PostgreSqlClientModule(), new TestingPostgreSqlModule(this.connectionFactory)})));
            runner.createCatalog("counting_postgresql", "counting_postgresql", (Map)ImmutableMap.of((Object)"connection-url", (Object)postgreSqlServer.getJdbcUrl(), (Object)"connection-user", (Object)postgreSqlServer.getUser(), (Object)"connection-password", (Object)postgreSqlServer.getPassword(), (Object)"query.reuse-connection", (Object)"false"));
        }).build();
        QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Iterable)ImmutableList.of((Object)TpchTable.CUSTOMER, (Object)TpchTable.NATION, (Object)TpchTable.REGION));
        return queryRunner;
    }

    private static BaseJdbcConnectionCreationTest.ConnectionCountingConnectionFactory getConnectionCountingConnectionFactory(TestingPostgreSqlServer postgreSqlServer) {
        Properties connectionProperties = new Properties();
        StaticCredentialProvider credentialProvider = new StaticCredentialProvider(Optional.of(postgreSqlServer.getUser()), Optional.of(postgreSqlServer.getPassword()));
        DriverConnectionFactory delegate = DriverConnectionFactory.builder((java.sql.Driver)new Driver(), (String)postgreSqlServer.getJdbcUrl(), (CredentialProvider)credentialProvider).setConnectionProperties(connectionProperties).build();
        return new BaseJdbcConnectionCreationTest.ConnectionCountingConnectionFactory(delegate);
    }

    @Test
    public void testJdbcConnectionCreations() {
        this.assertJdbcConnections("SELECT * FROM nation LIMIT 1", 5, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation ORDER BY nationkey LIMIT 1", 5, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation WHERE nationkey = 1", 5, Optional.empty());
        this.assertJdbcConnections("SELECT avg(nationkey) FROM nation", 4, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation, region", 6, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation n, region r WHERE n.regionkey = r.regionkey", 9, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation JOIN region USING(regionkey)", 10, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM information_schema.schemata", 1, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM information_schema.tables", 1, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM information_schema.columns", 7, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation", 3, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM TABLE (system.query(query => 'SELECT * FROM tpch.nation'))", 2, Optional.empty());
        this.assertJdbcConnections("CREATE TABLE copy_of_nation AS SELECT * FROM nation", 15, Optional.empty());
        this.assertJdbcConnections("INSERT INTO copy_of_nation SELECT * FROM nation", 13, Optional.empty());
        this.assertJdbcConnections("UPDATE copy_of_nation SET name = 'POLAND' WHERE nationkey = 1", 6, Optional.empty());
        this.assertJdbcConnections("DELETE FROM copy_of_nation WHERE nationkey = 3", 6, Optional.empty());
        this.assertJdbcConnections("DROP TABLE copy_of_nation", 2, Optional.empty());
        this.assertJdbcConnections("SHOW SCHEMAS", 1, Optional.empty());
        this.assertJdbcConnections("SHOW TABLES", 2, Optional.empty());
        this.assertJdbcConnections("SHOW STATS FOR nation", 4, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM system.jdbc.columns WHERE table_cat = 'counting_postgresql'", 7, Optional.empty());
        this.testJdbcMergeConnectionCreations();
    }

    private void testJdbcMergeConnectionCreations() {
        this.assertJdbcConnections("CREATE TABLE copy_of_customer_transactional AS SELECT * FROM customer", 15, Optional.empty());
        this.postgreSqlServer.execute("ALTER TABLE copy_of_customer_transactional ADD CONSTRAINT t_copy_of_customer_transactional PRIMARY KEY (custkey)");
        this.assertJdbcConnections("DELETE FROM copy_of_customer_transactional WHERE abs(custkey) = 1", 25, Optional.empty());
        this.assertJdbcConnections("UPDATE copy_of_customer_transactional SET name = 'POLAND' WHERE abs(custkey) = 1", 32, Optional.empty());
        this.assertJdbcConnections("MERGE INTO copy_of_customer_transactional n USING customer r ON r.custkey = n.custkey WHEN MATCHED THEN DELETE", 29, Optional.empty());
        Session nonTransactionalMergeSession = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "non_transactional_merge", "true").build();
        this.assertJdbcConnections(nonTransactionalMergeSession, "CREATE TABLE copy_of_customer_non_transactional AS SELECT * FROM customer", 15, Optional.empty());
        this.postgreSqlServer.execute("ALTER TABLE copy_of_customer_non_transactional ADD CONSTRAINT t_copy_of_customer_non_transactional PRIMARY KEY (custkey)");
        this.assertJdbcConnections(nonTransactionalMergeSession, "DELETE FROM copy_of_customer_non_transactional WHERE abs(custkey) = 1", 27, Optional.empty());
        this.assertJdbcConnections(nonTransactionalMergeSession, "UPDATE copy_of_customer_non_transactional SET name = 'POLAND' WHERE abs(custkey) = 1", 35, Optional.empty());
        this.assertJdbcConnections(nonTransactionalMergeSession, "MERGE INTO copy_of_customer_non_transactional c USING customer r ON r.custkey = c.custkey WHEN MATCHED THEN DELETE", 31, Optional.empty());
    }

    private static final class TestingPostgreSqlModule
    extends AbstractConfigurationAwareModule {
        private final BaseJdbcConnectionCreationTest.ConnectionCountingConnectionFactory connectionCountingConnectionFactory;

        private TestingPostgreSqlModule(BaseJdbcConnectionCreationTest.ConnectionCountingConnectionFactory connectionCountingConnectionFactory) {
            this.connectionCountingConnectionFactory = Objects.requireNonNull(connectionCountingConnectionFactory, "connectionCountingConnectionFactory is null");
        }

        protected void setup(Binder binder) {
        }

        @Provides
        @Singleton
        @ForBaseJdbc
        public ConnectionFactory getConnectionFactory() {
            return this.connectionCountingConnectionFactory;
        }
    }
}

