/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.jdbc.BaseJdbcTableStatisticsTest;
import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.TestTable;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jdbi.v3.core.HandleConsumer;
import org.jdbi.v3.core.Jdbi;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class TestPostgreSqlTableStatistics
extends BaseJdbcTableStatisticsTest {
    private TestingPostgreSqlServer postgreSqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.postgreSqlServer = (TestingPostgreSqlServer)this.closeAfterClass(new TestingPostgreSqlServer());
        return PostgreSqlQueryRunner.builder(this.postgreSqlServer).addConnectorProperties(Map.of("case-insensitive-name-matching", "true")).setInitialTables(List.of(TpchTable.ORDERS)).build();
    }

    @Test
    public void testNotAnalyzed() {
        Assumptions.abort((String)"PostgreSQL analyzes tables automatically");
    }

    @Test
    public void testBasic() {
        String tableName = "test_stats_orders";
        this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        this.computeActual(String.format("CREATE TABLE %s AS SELECT * FROM tpch.tiny.orders", tableName));
        try {
            this.gatherStats(tableName);
            this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('orderkey', null, 15000, 0, null, null, null),('custkey', null, 1000, 0, null, null, null),('orderstatus', 30000, 3, 0, null, null, null),('totalprice', null, 14996, 0, null, null, null),('orderdate', null, 2401, 0, null, null, null),('orderpriority', 135000, 5, 0, null, null, null),('clerk', 240000, 1000, 0, null, null, null),('shippriority', null, 1, 0, null, null, null),('comment', 735000, 14995, 0, null, null, null),(null, null, null, null, 15000, null, null)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testAllNulls() {
        String tableName = "test_stats_table_all_nulls";
        this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        this.computeActual(String.format("CREATE TABLE %s AS SELECT orderkey, custkey, orderpriority, comment FROM tpch.tiny.orders WHERE false", tableName));
        try {
            this.computeActual(String.format("INSERT INTO %s (orderkey) VALUES NULL, NULL, NULL", tableName));
            this.gatherStats(tableName);
            this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('orderkey', 0, 0, 1, null, null, null),('custkey', 0, 0, 1, null, null, null),('orderpriority', 0, 0, 1, null, null, null),('comment', 0, 0, 1, null, null, null),(null, null, null, null, 3, null, null)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testNullsFraction() {
        String tableName = "test_stats_table_with_nulls";
        this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT     orderkey,     if(orderkey % 3 = 0, NULL, custkey) custkey,     if(orderkey % 5 = 0, NULL, orderpriority) orderpriority FROM tpch.tiny.orders", 15000L);
        try {
            this.gatherStats(tableName);
            this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('orderkey', null, 15000, 0, null, null, null),('custkey', null, 1000, 0.3333333333333333, null, null, null),('orderpriority', 108000, 5, 0.2, null, null, null),(null, null, null, null, 15000, null, null)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testAverageColumnLength() {
        String tableName = "test_stats_table_avg_col_len";
        this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        this.computeActual("CREATE TABLE " + tableName + " AS SELECT   orderkey,   'abc' v3_in_3,   CAST('abc' AS varchar(42)) v3_in_42,   if(orderkey = 1, '0123456789', NULL) single_10v_value,   if(orderkey % 2 = 0, '0123456789', NULL) half_10v_value,   if(orderkey % 2 = 0, CAST((1000000 - orderkey) * (1000000 - orderkey) AS varchar(20)), NULL) half_distinct_20v_value,   CAST(NULL AS varchar(10)) all_nulls FROM tpch.tiny.orders ORDER BY orderkey LIMIT 100");
        try {
            this.gatherStats(tableName);
            this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('orderkey', null, 100, 0, null, null, null),('v3_in_3', 400, 1, 0, null, null, null),('v3_in_42', 400, 1, 0, null, null, null),('single_10v_value', 11, 1, 0.99, null, null, null),('half_10v_value', 550, 1, 0.5, null, null, null),('half_distinct_20v_value', 650, 50, 0.5, null, null, null),('all_nulls', 0, 0, 1, null, null, null),(null, null, null, null, 100, null, null)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionedTable() {
        String tableName = "test_stats_orders_part";
        String firstPartitionedTable = "test_stats_orders_part_1990_1994";
        String secondPartitionedTable = "test_stats_orders_part_1995_1999";
        this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        this.assertUpdate("DROP TABLE IF EXISTS " + firstPartitionedTable);
        this.assertUpdate("DROP TABLE IF EXISTS " + secondPartitionedTable);
        this.executeInPostgres("CREATE TABLE " + tableName + " (LIKE orders) PARTITION BY RANGE(orderdate)");
        try {
            this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('orderkey', null, null, null, null, null, null),('custkey', null, null, null, null, null, null),('orderstatus', null, null, null, null, null, null),('totalprice', null, null, null, null, null, null),('orderdate', null, null, null, null, null, null),('orderpriority', null, null, null, null, null, null),('clerk', null, null, null, null, null, null),('shippriority', null, null, null, null, null, null),('comment', null, null, null, null, null, null),(null, null, null, null, null, null, null)");
            this.gatherStats(tableName);
            this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('orderkey', null, null, null, null, null, null),('custkey', null, null, null, null, null, null),('orderstatus', null, null, null, null, null, null),('totalprice', null, null, null, null, null, null),('orderdate', null, null, null, null, null, null),('orderpriority', null, null, null, null, null, null),('clerk', null, null, null, null, null, null),('shippriority', null, null, null, null, null, null),('comment', null, null, null, null, null, null),(null, null, null, null, null, null, null)");
            this.executeInPostgres(String.format("CREATE TABLE %s PARTITION OF %s FOR VALUES FROM ('1990-01-01') TO ('1995-01-01')", firstPartitionedTable, tableName));
            this.executeInPostgres(String.format("CREATE TABLE %s PARTITION OF %s FOR VALUES FROM ('1995-01-01') TO ('1999-12-31')", secondPartitionedTable, tableName));
            this.executeInPostgres(String.format("INSERT INTO %s SELECT * FROM orders WHERE orderdate <= '1994-12-31'", firstPartitionedTable));
            this.executeInPostgres(String.format("INSERT INTO %s SELECT * FROM orders WHERE orderdate >= '1995-01-01'", secondPartitionedTable));
            this.gatherStats(firstPartitionedTable);
            this.gatherStats(secondPartitionedTable);
            this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('orderkey', null, null, null, null, null, null),('custkey', null, null, null, null, null, null),('orderstatus', null, null, null, null, null, null),('totalprice', null, null, null, null, null, null),('orderdate', null, null, null, null, null, null),('orderpriority', null, null, null, null, null, null),('clerk', null, null, null, null, null, null),('shippriority', null, null, null, null, null, null),('comment', null, null, null, null, null, null),(null, null, null, null, 15000, null, null)");
            this.gatherStatsPartitionedTable(tableName, (List<String>)ImmutableList.of((Object)firstPartitionedTable, (Object)secondPartitionedTable));
            this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('orderkey', null, 15000, 0, null, null, null),('custkey', null, 1000, 0, null, null, null),('orderstatus', 30000, 3, 0, null, null, null),('totalprice', null, 14996, 0, null, null, null),('orderdate', null, 2401, 0, null, null, null),('orderpriority', 135000, 5, 0, null, null, null),('clerk', 240000, 1000, 0, null, null, null),('shippriority', null, 1, 0, null, null, null),('comment', 735000, 14995, 0, null, null, null),(null, null, null, null, 15000, null, null)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testView() {
        String tableName = "test_stats_view";
        this.executeInPostgres("CREATE OR REPLACE VIEW " + tableName + " AS SELECT orderkey, custkey, orderpriority, comment FROM orders");
        try {
            this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('orderkey', null, null, null, null, null, null),('custkey', null, null, null, null, null, null),('orderpriority', null, null, null, null, null, null),('comment', null, null, null, null, null, null),(null, null, null, null, null, null, null)");
        }
        finally {
            this.executeInPostgres("DROP VIEW " + tableName);
        }
    }

    @Test
    public void testMaterializedView() {
        String tableName = "test_stats_materialized_view";
        this.executeInPostgres("DROP MATERIALIZED VIEW IF EXISTS " + tableName);
        this.executeInPostgres("CREATE MATERIALIZED VIEW " + tableName + " AS SELECT orderkey, custkey, orderpriority, comment FROM orders");
        try {
            this.gatherStats(tableName);
            this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('orderkey', null, 15000, 0, null, null, null),('custkey', null, 1000, 0, null, null, null),('orderpriority', 135000, 5, 0, null, null, null),('comment', 735000, 14995, 0, null, null, null),(null, null, null, null, 15000, null, null)");
        }
        finally {
            this.executeInPostgres("DROP MATERIALIZED VIEW " + tableName);
        }
    }

    protected void testCaseColumnNames(String tableName) {
        this.executeInPostgres("CREATE TABLE " + tableName + " AS SELECT   orderkey AS CASE_UNQUOTED_UPPER,   custkey AS case_unquoted_lower,   orderstatus AS cASe_uNQuoTeD_miXED,   totalprice AS \"CASE_QUOTED_UPPER\",   orderdate AS \"case_quoted_lower\",  orderpriority AS \"CasE_QuoTeD_miXED\" FROM orders");
        try {
            this.gatherStats(tableName);
            this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('case_unquoted_upper', null, 15000, 0, null, null, null),('case_unquoted_lower', null, 1000, 0, null, null, null),('case_unquoted_mixed', 30000, 3, 0, null, null, null),('case_quoted_upper', null, 14996, 0, null, null, null),('case_quoted_lower', null, 2401, 0, null, null, null),('case_quoted_mixed', 135000, 5, 0, null, null, null),(null, null, null, null, 15000, null, null)");
        }
        finally {
            this.executeInPostgres("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testNumericCornerCases() {
        try (TestTable table = TestTable.fromColumns(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), (String)"test_numeric_corner_cases_", (Map)ImmutableMap.builder().put((Object)"only_negative_infinity double", List.of("-infinity()", "-infinity()", "-infinity()", "-infinity()")).put((Object)"only_positive_infinity double", List.of("infinity()", "infinity()", "infinity()", "infinity()")).put((Object)"mixed_infinities double", List.of("-infinity()", "infinity()", "-infinity()", "infinity()")).put((Object)"mixed_infinities_and_numbers double", List.of("-infinity()", "infinity()", "-5.0", "7.0")).put((Object)"nans_only double", List.of("nan()", "nan()")).put((Object)"nans_and_numbers double", List.of("nan()", "nan()", "-5.0", "7.0")).put((Object)"large_doubles double", List.of("CAST(-50371909150609548946090.0 AS DOUBLE)", "CAST(50371909150609548946090.0 AS DOUBLE)")).put((Object)"short_decimals_big_fraction decimal(16,15)", List.of("-1.234567890123456", "1.234567890123456")).put((Object)"short_decimals_big_integral decimal(16,1)", List.of("-123456789012345.6", "123456789012345.6")).put((Object)"long_decimals_big_fraction decimal(38,37)", List.of("-1.2345678901234567890123456789012345678", "1.2345678901234567890123456789012345678")).put((Object)"long_decimals_middle decimal(38,16)", List.of("-1234567890123456.7890123456789012345678", "1234567890123456.7890123456789012345678")).put((Object)"long_decimals_big_integral decimal(38,1)", List.of("-1234567890123456789012345678901234567.8", "1234567890123456789012345678901234567.8")).buildOrThrow(), (String)"null");){
            this.gatherStats(table.getName());
            this.assertQuery("SHOW STATS FOR " + table.getName(), "VALUES ('only_negative_infinity', null, 1, 0, null, null, null),('only_positive_infinity', null, 1, 0, null, null, null),('mixed_infinities', null, 2, 0, null, null, null),('mixed_infinities_and_numbers', null, 4.0, 0.0, null, null, null),('nans_only', null, 1.0, 0.5, null, null, null),('nans_and_numbers', null, 3.0, 0.0, null, null, null),('large_doubles', null, 2.0, 0.5, null, null, null),('short_decimals_big_fraction', null, 2.0, 0.5, null, null, null),('short_decimals_big_integral', null, 2.0, 0.5, null, null, null),('long_decimals_big_fraction', null, 2.0, 0.5, null, null, null),('long_decimals_middle', null, 2.0, 0.5, null, null, null),('long_decimals_big_integral', null, 2.0, 0.5, null, null, null),(null, null, null, null, 4, null, null)");
        }
    }

    private void executeInPostgres(String sql) {
        this.inPostgres(handle -> handle.execute(sql, new Object[0]));
    }

    protected void gatherStats(String tableName) {
        this.inPostgres(handle -> {
            handle.execute("ANALYZE " + tableName, new Object[0]);
            for (int i = 0; i < 5; ++i) {
                long actualCount = (Long)handle.createQuery("SELECT count(*) FROM " + tableName).mapTo(Long.class).one();
                long estimatedCount = (Long)handle.createQuery(String.format("SELECT reltuples FROM pg_class WHERE oid = '%s'::regclass::oid", tableName)).mapTo(Long.class).one();
                if (actualCount == estimatedCount) {
                    return;
                }
                handle.execute("ANALYZE " + tableName, new Object[0]);
            }
            throw new IllegalStateException("Stats not gathered");
        });
    }

    private void gatherStatsPartitionedTable(String parentTableName, List<String> childTableNames) {
        String parameter = childTableNames.stream().map(tableName -> String.format("'%s'::regclass::oid", tableName)).collect(Collectors.joining(", "));
        this.inPostgres(handle -> {
            handle.execute("ANALYZE " + parentTableName, new Object[0]);
            for (int i = 0; i < 5; ++i) {
                long actualCount = (Long)handle.createQuery("SELECT count(*) FROM " + parentTableName).mapTo(Long.class).one();
                long estimatedCount = (Long)handle.createQuery(String.format("SELECT SUM(reltuples) FROM pg_class WHERE oid IN (%s)", parameter)).mapTo(Long.class).one();
                if (actualCount == estimatedCount) {
                    return;
                }
                handle.execute("ANALYZE " + parentTableName, new Object[0]);
            }
            throw new IllegalStateException("Stats not gathered");
        });
    }

    private <E extends Exception> void inPostgres(HandleConsumer<E> callback) throws E {
        Properties properties = new Properties();
        properties.setProperty("currentSchema", "tpch");
        properties.setProperty("user", this.postgreSqlServer.getUser());
        properties.setProperty("password", this.postgreSqlServer.getPassword());
        Jdbi.create((String)this.postgreSqlServer.getJdbcUrl(), (Properties)properties).useHandle(callback);
    }
}

