/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import io.trino.Session;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.datatype.CreateAndInsertDataSetup;
import io.trino.testing.datatype.CreateAndTrinoInsertDataSetup;
import io.trino.testing.datatype.CreateAsSelectDataSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.datatype.DataType;
import io.trino.testing.datatype.DataTypeTest;
import io.trino.testing.datatype.SqlDataTypeTest;
import io.trino.testing.sql.JdbcSqlExecutor;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TrinoSqlExecutor;
import io.trino.type.JsonType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestPostgreSqlTypeMapping
extends AbstractTestQueryFramework {
    protected TestingPostgreSqlServer postgreSqlServer;
    private final LocalDateTime beforeEpoch = LocalDateTime.of(1958, 1, 1, 13, 18, 3, 123000000);
    private final LocalDateTime epoch = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
    private final LocalDateTime afterEpoch = LocalDateTime.of(2019, 3, 18, 10, 1, 17, 987000000);
    private final ZoneId jvmZone = ZoneId.systemDefault();
    private final LocalDateTime timeGapInJvmZone1 = LocalDateTime.of(1932, 4, 1, 0, 13, 42);
    private final LocalDateTime timeGapInJvmZone2 = LocalDateTime.of(2018, 4, 1, 2, 13, 55, 123000000);
    private final LocalDateTime timeDoubledInJvmZone = LocalDateTime.of(2018, 10, 28, 1, 33, 17, 456000000);
    private final ZoneId vilnius = ZoneId.of("Europe/Vilnius");
    private final LocalDateTime timeGapInVilnius = LocalDateTime.of(2018, 3, 25, 3, 17, 17);
    private final LocalDateTime timeDoubledInVilnius = LocalDateTime.of(2018, 10, 28, 3, 33, 33, 333000000);
    private final ZoneId kathmandu = ZoneId.of("Asia/Kathmandu");
    private final LocalDateTime timeGapInKathmandu = LocalDateTime.of(1986, 1, 1, 0, 13, 7);
    private final ZoneOffset fixedOffsetEast = ZoneOffset.ofHoursMinutes(2, 17);
    private final ZoneOffset fixedOffsetWest = ZoneOffset.ofHoursMinutes(-7, -31);

    protected QueryRunner createQueryRunner() throws Exception {
        this.postgreSqlServer = (TestingPostgreSqlServer)this.closeAfterClass(new TestingPostgreSqlServer());
        return PostgreSqlQueryRunner.builder(this.postgreSqlServer).addConnectorProperties(Map.of("jdbc-types-mapped-to-varchar", "Tsrange, Inet")).build();
    }

    @BeforeAll
    public void setUp() {
        Preconditions.checkState((boolean)this.jvmZone.getId().equals("America/Bahia_Banderas"), (Object)"This test assumes certain JVM time zone");
        TestPostgreSqlTypeMapping.checkIsGap(this.jvmZone, this.timeGapInJvmZone1);
        TestPostgreSqlTypeMapping.checkIsGap(this.jvmZone, this.timeGapInJvmZone2);
        TestPostgreSqlTypeMapping.checkIsDoubled(this.jvmZone, this.timeDoubledInJvmZone);
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInSomeZone = LocalDate.of(1983, 4, 1);
        TestPostgreSqlTypeMapping.checkIsGap(this.vilnius, dateOfLocalTimeChangeForwardAtMidnightInSomeZone.atStartOfDay());
        LocalDate dateOfLocalTimeChangeBackwardAtMidnightInSomeZone = LocalDate.of(1983, 10, 1);
        TestPostgreSqlTypeMapping.checkIsDoubled(this.vilnius, dateOfLocalTimeChangeBackwardAtMidnightInSomeZone.atStartOfDay().minusMinutes(1L));
        TestPostgreSqlTypeMapping.checkIsGap(this.vilnius, this.timeGapInVilnius);
        TestPostgreSqlTypeMapping.checkIsDoubled(this.vilnius, this.timeDoubledInVilnius);
        TestPostgreSqlTypeMapping.checkIsGap(this.kathmandu, this.timeGapInKathmandu);
        JdbcSqlExecutor executor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        executor.execute("CREATE EXTENSION hstore WITH SCHEMA public");
    }

    @Test
    public void testBoolean() {
        SqlDataTypeTest.create().addRoundTrip("boolean", "true", (Type)BooleanType.BOOLEAN).addRoundTrip("boolean", "false", (Type)BooleanType.BOOLEAN).addRoundTrip("boolean", "NULL", (Type)BooleanType.BOOLEAN, "CAST(NULL AS BOOLEAN)").execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.test_boolean")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_boolean")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_boolean"));
    }

    @Test
    public void testTinyint() {
        SqlDataTypeTest.create().addRoundTrip("tinyint", "NULL", (Type)SmallintType.SMALLINT, "CAST(NULL AS SMALLINT)").addRoundTrip("tinyint", "-128", (Type)SmallintType.SMALLINT, "SMALLINT '-128'").addRoundTrip("tinyint", "5", (Type)SmallintType.SMALLINT, "SMALLINT '5'").addRoundTrip("tinyint", "127", (Type)SmallintType.SMALLINT, "SMALLINT '127'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_tinyint")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_tinyint"));
    }

    @Test
    public void testSmallint() {
        SqlDataTypeTest.create().addRoundTrip("smallint", "NULL", (Type)SmallintType.SMALLINT, "CAST(NULL AS SMALLINT)").addRoundTrip("smallint", "-32768", (Type)SmallintType.SMALLINT, "SMALLINT '-32768'").addRoundTrip("smallint", "32456", (Type)SmallintType.SMALLINT, "SMALLINT '32456'").addRoundTrip("smallint", "32767", (Type)SmallintType.SMALLINT, "SMALLINT '32767'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.test_smallint")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_smallint")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_smallint"));
    }

    @Test
    public void testSmallserial() {
        SqlDataTypeTest.create().addRoundTrip("smallserial", "-32768", (Type)SmallintType.SMALLINT, "SMALLINT '-32768'").addRoundTrip("smallserial", "32456", (Type)SmallintType.SMALLINT, "SMALLINT '32456'").addRoundTrip("smallserial", "32767", (Type)SmallintType.SMALLINT, "SMALLINT '32767'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.test_smallserial")).execute(this.getQueryRunner(), this.postgresCreateAndTrinoInsert("tpch.test_smallserial"));
    }

    @Test
    public void testUnsupportedSmallint() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "tpch.test_unsupported_smallint", "(data smallint)");){
            this.assertPostgreSqlQueryFails("INSERT INTO " + table.getName() + " VALUES (-32769)", "ERROR: smallint out of range");
            this.assertPostgreSqlQueryFails("INSERT INTO " + table.getName() + " VALUES (32768)", "ERROR: smallint out of range");
        }
    }

    @Test
    public void testInteger() {
        SqlDataTypeTest.create().addRoundTrip("integer", "NULL", (Type)IntegerType.INTEGER, "CAST(NULL AS INTEGER)").addRoundTrip("integer", "-2147483648", (Type)IntegerType.INTEGER, "-2147483648").addRoundTrip("integer", "1234567890", (Type)IntegerType.INTEGER, "1234567890").addRoundTrip("integer", "2147483647", (Type)IntegerType.INTEGER, "2147483647").execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.test_int")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_int")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_int"));
    }

    @Test
    public void testSerial() {
        SqlDataTypeTest.create().addRoundTrip("serial", "-2147483648", (Type)IntegerType.INTEGER, "-2147483648").addRoundTrip("serial", "1234567890", (Type)IntegerType.INTEGER, "1234567890").addRoundTrip("serial", "2147483647", (Type)IntegerType.INTEGER, "2147483647").execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.test_serial")).execute(this.getQueryRunner(), this.postgresCreateAndTrinoInsert("tpch.test_serial"));
    }

    @Test
    public void testUnsupportedInteger() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "tpch.test_unsupported_integer", "(data integer)");){
            this.assertPostgreSqlQueryFails("INSERT INTO " + table.getName() + " VALUES (-2147483649)", "ERROR: integer out of range");
            this.assertPostgreSqlQueryFails("INSERT INTO " + table.getName() + " VALUES (2147483648)", "ERROR: integer out of range");
        }
    }

    @Test
    public void testBigint() {
        SqlDataTypeTest.create().addRoundTrip("bigint", "NULL", (Type)BigintType.BIGINT, "CAST(NULL AS BIGINT)").addRoundTrip("bigint", "-9223372036854775808", (Type)BigintType.BIGINT, "-9223372036854775808").addRoundTrip("bigint", "123456789012", (Type)BigintType.BIGINT, "123456789012").addRoundTrip("bigint", "9223372036854775807", (Type)BigintType.BIGINT, "9223372036854775807").execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.test_bigint")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_bigint")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_bigint"));
    }

    @Test
    public void testBigserial() {
        SqlDataTypeTest.create().addRoundTrip("bigserial", "-9223372036854775808", (Type)BigintType.BIGINT, "-9223372036854775808").addRoundTrip("bigserial", "123456789012", (Type)BigintType.BIGINT, "123456789012").addRoundTrip("bigserial", "9223372036854775807", (Type)BigintType.BIGINT, "9223372036854775807").execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.test_bigserial")).execute(this.getQueryRunner(), this.postgresCreateAndTrinoInsert("tpch.test_bigserial"));
    }

    @Test
    public void testUnsupportedBigint() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "tpch.test_unsupported_bigint", "(data bigint)");){
            this.assertPostgreSqlQueryFails("INSERT INTO " + table.getName() + " VALUES (-9223372036854775809)", "ERROR: bigint out of range");
            this.assertPostgreSqlQueryFails("INSERT INTO " + table.getName() + " VALUES (9223372036854775808)", "ERROR: bigint out of range");
        }
    }

    @Test
    public void testReal() {
        SqlDataTypeTest.create().addRoundTrip("real", "NULL", (Type)RealType.REAL, "CAST(NULL AS real)").addRoundTrip("real", "3.14", (Type)RealType.REAL, "REAL '3.14'").addRoundTrip("real", "3.1415927", (Type)RealType.REAL, "REAL '3.1415927'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_real")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("trino_test_real")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("trino_test_real"));
        SqlDataTypeTest.create().addRoundTrip("real", "nan()", (Type)RealType.REAL, "CAST(nan() AS real)").addRoundTrip("real", "-infinity()", (Type)RealType.REAL, "CAST(-infinity() AS real)").addRoundTrip("real", "+infinity()", (Type)RealType.REAL, "CAST(+infinity() AS real)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("trino_test_special_real")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("trino_test_special_real"));
        SqlDataTypeTest.create().addRoundTrip("real", "'NaN'::real", (Type)RealType.REAL, "CAST(nan() AS real)").addRoundTrip("real", "'-Infinity'::real", (Type)RealType.REAL, "CAST(-infinity() AS real)").addRoundTrip("real", "'+Infinity'::real", (Type)RealType.REAL, "CAST(+infinity() AS real)").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_special_real"));
    }

    @Test
    public void testDouble() {
        SqlDataTypeTest.create().addRoundTrip("double precision", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS double)").addRoundTrip("double precision", "1.0E100", (Type)DoubleType.DOUBLE, "1.0E100").addRoundTrip("double precision", "123.456E10", (Type)DoubleType.DOUBLE, "123.456E10").addRoundTrip("double precision", "'NaN'::double precision", (Type)DoubleType.DOUBLE, "nan()").addRoundTrip("double precision", "'+Infinity'::double precision", (Type)DoubleType.DOUBLE, "+infinity()").addRoundTrip("double precision", "'-Infinity'::double precision", (Type)DoubleType.DOUBLE, "-infinity()").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_double"));
        SqlDataTypeTest.create().addRoundTrip("double", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS double)").addRoundTrip("double", "1.0E100", (Type)DoubleType.DOUBLE, "1.0E100").addRoundTrip("double", "123.456E10", (Type)DoubleType.DOUBLE, "123.456E10").addRoundTrip("double", "nan()", (Type)DoubleType.DOUBLE, "nan()").addRoundTrip("double", "+infinity()", (Type)DoubleType.DOUBLE, "+infinity()").addRoundTrip("double", "-infinity()", (Type)DoubleType.DOUBLE, "-infinity()").execute(this.getQueryRunner(), this.trinoCreateAsSelect("trino_test_double")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("trino_test_double"));
    }

    @Test
    public void testDecimal() {
        SqlDataTypeTest.create().addRoundTrip("decimal(3, 0)", "CAST(NULL AS decimal(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST(NULL AS decimal(3, 0))").addRoundTrip("decimal(3, 0)", "CAST('193' AS decimal(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('193' AS decimal(3, 0))").addRoundTrip("decimal(3, 0)", "CAST('19' AS decimal(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('19' AS decimal(3, 0))").addRoundTrip("decimal(3, 0)", "CAST('-193' AS decimal(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('-193' AS decimal(3, 0))").addRoundTrip("decimal(3, 1)", "CAST('10.0' AS decimal(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('10.0' AS decimal(3, 1))").addRoundTrip("decimal(3, 1)", "CAST('10.1' AS decimal(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('10.1' AS decimal(3, 1))").addRoundTrip("decimal(3, 1)", "CAST('-10.1' AS decimal(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('-10.1' AS decimal(3, 1))").addRoundTrip("decimal(4, 2)", "CAST('2' AS decimal(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST('2' AS decimal(4, 2))").addRoundTrip("decimal(4, 2)", "CAST('2.3' AS decimal(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST('2.3' AS decimal(4, 2))").addRoundTrip("decimal(24, 2)", "CAST('2' AS decimal(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('2' AS decimal(24, 2))").addRoundTrip("decimal(24, 2)", "CAST('2.3' AS decimal(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('2.3' AS decimal(24, 2))").addRoundTrip("decimal(24, 2)", "CAST('123456789.3' AS decimal(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('123456789.3' AS decimal(24, 2))").addRoundTrip("decimal(24, 4)", "CAST('12345678901234567890.31' AS decimal(24, 4))", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST('12345678901234567890.31' AS decimal(24, 4))").addRoundTrip("decimal(30, 5)", "CAST('3141592653589793238462643.38327' AS decimal(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST('3141592653589793238462643.38327' AS decimal(30, 5))").addRoundTrip("decimal(30, 5)", "CAST('-3141592653589793238462643.38327' AS decimal(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST('-3141592653589793238462643.38327' AS decimal(30, 5))").addRoundTrip("decimal(38, 0)", "CAST(NULL AS decimal(38, 0))", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST(NULL AS decimal(38, 0))").addRoundTrip("decimal(38, 0)", "CAST('27182818284590452353602874713526624977' AS decimal(38, 0))", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('27182818284590452353602874713526624977' AS decimal(38, 0))").addRoundTrip("decimal(38, 0)", "CAST('-27182818284590452353602874713526624977' AS decimal(38, 0))", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('-27182818284590452353602874713526624977' AS decimal(38, 0))").addRoundTrip("decimal(38, 38)", "CAST('0.27182818284590452353602874713526624977' AS decimal(38, 38))", (Type)DecimalType.createDecimalType((int)38, (int)38), "CAST('0.27182818284590452353602874713526624977' AS decimal(38, 38))").addRoundTrip("decimal(38, 38)", "CAST('-0.27182818284590452353602874713526624977' AS decimal(38, 38))", (Type)DecimalType.createDecimalType((int)38, (int)38), "CAST('-0.27182818284590452353602874713526624977' AS decimal(38, 38))").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_decimal")).execute(this.getQueryRunner(), this.postgresCreateAndInsert("tpch.test_decimal")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_decimal")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_decimal"));
        SqlDataTypeTest.create().addRoundTrip("numeric", "1.1", (Type)DecimalType.createDecimalType((int)38, (int)5), "CAST(1.1 AS DECIMAL(38, 5))").execute(this.getQueryRunner(), this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 5), this.postgresCreateAndInsert("test_unspecified_decimal"));
    }

    @Test
    public void testChar() {
        SqlDataTypeTest.create().addRoundTrip("char(10)", "NULL", (Type)CharType.createCharType((int)10), "CAST(NULL AS char(10))").addRoundTrip("char(10)", "'text_a'", (Type)CharType.createCharType((int)10), "CAST('text_a' AS char(10))").addRoundTrip("char(255)", "'text_b'", (Type)CharType.createCharType((int)255), "CAST('text_b' AS char(255))").addRoundTrip("char(5)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((int)5), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(5))").addRoundTrip("char(32)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((int)32), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(32))").addRoundTrip("char(1)", "'\ud83d\ude02'", (Type)CharType.createCharType((int)1), "CAST('\ud83d\ude02' AS char(1))").addRoundTrip("char(77)", "'\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'", (Type)CharType.createCharType((int)77), "CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS char(77))").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_char")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_char")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_char"));
        int length = 65537;
        String postgresqlType = String.format("char(%s)", length);
        VarcharType trinoType = VarcharType.createVarcharType((int)length);
        SqlDataTypeTest.create().addRoundTrip(postgresqlType, "'test_f'", (Type)trinoType, String.format("'test_f%s'", " ".repeat(length - 6))).addRoundTrip(postgresqlType, String.format("'%s'", "a".repeat(length)), (Type)trinoType, String.format("'%s'", "a".repeat(length))).addRoundTrip(postgresqlType, "'\ud83d\ude02'", (Type)trinoType, String.format("'\ud83d\ude02%s'", " ".repeat(length - 1))).execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_char"));
    }

    @Test
    public void testVarchar() {
        SqlDataTypeTest.create().addRoundTrip("varchar(10)", "NULL", (Type)VarcharType.createVarcharType((int)10), "CAST(NULL AS varchar(10))").addRoundTrip("varchar(10)", "'text_a'", (Type)VarcharType.createVarcharType((int)10), "CAST('text_a' AS varchar(10))").addRoundTrip("varchar(255)", "'text_b'", (Type)VarcharType.createVarcharType((int)255), "CAST('text_b' AS varchar(255))").addRoundTrip("varchar(65535)", "'text_d'", (Type)VarcharType.createVarcharType((int)65535), "CAST('text_d' AS varchar(65535))").addRoundTrip("varchar(5)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)5), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(5))").addRoundTrip("varchar(32)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)32), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(32))").addRoundTrip("varchar(20000)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)20000), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(20000))").addRoundTrip("varchar(1)", "'\ud83d\ude02'", (Type)VarcharType.createVarcharType((int)1), "CAST('\ud83d\ude02' AS varchar(1))").addRoundTrip("varchar(77)", "'\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'", (Type)VarcharType.createVarcharType((int)77), "CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS varchar(77))").addRoundTrip("varchar(10485760)", "'text_f'", (Type)VarcharType.createVarcharType((int)0xA00000), "CAST('text_f' AS varchar(10485760))").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_varchar")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_varchar")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_varchar"));
    }

    @Test
    public void testUnboundedVarchar() {
        SqlDataTypeTest.create().addRoundTrip("varchar", "NULL", (Type)VarcharType.createUnboundedVarcharType(), "CAST(NULL AS varchar)").addRoundTrip("varchar", "'text_a'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('text_a' AS varchar)").addRoundTrip("varchar", "'text_b'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('text_b' AS varchar)").addRoundTrip("varchar", "'text_d'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('text_d' AS varchar)").addRoundTrip("varchar", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar)").addRoundTrip("varchar", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar)").addRoundTrip("varchar", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar)").addRoundTrip("varchar", "'\ud83d\ude02'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('\ud83d\ude02' AS varchar)").addRoundTrip("varchar", "'\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS varchar)").addRoundTrip("varchar", "'text_f'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('text_f' AS varchar)").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_unbounded_varchar")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_unbounded_varchar")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_unbounded_varchar"));
    }

    @Test
    public void testVarbinary() {
        SqlDataTypeTest.create().addRoundTrip("bytea", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("bytea", "bytea E'\\\\x'", (Type)VarbinaryType.VARBINARY, "X''").addRoundTrip("bytea", TestPostgreSqlTypeMapping.utf8ByteaLiteral("hello"), (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("bytea", TestPostgreSqlTypeMapping.utf8ByteaLiteral("Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd"), (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("bytea", TestPostgreSqlTypeMapping.utf8ByteaLiteral("Bag full of \ud83d\udcb0"), (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("bytea", "bytea E'\\\\x0001020304050607080DF9367AA7000000'", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("bytea", "bytea E'\\\\x000000000000'", (Type)VarbinaryType.VARBINARY, "X'000000000000'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_bytea"));
        SqlDataTypeTest.create().addRoundTrip("varbinary", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("varbinary", "X''", (Type)VarbinaryType.VARBINARY, "X''").addRoundTrip("varbinary", "X'68656C6C6F'", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("varbinary", "X'5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD'", (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("varbinary", "X'4261672066756C6C206F6620F09F92B0'", (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("varbinary", "X'0001020304050607080DF9367AA7000000'", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("varbinary", "X'000000000000'", (Type)VarbinaryType.VARBINARY, "X'000000000000'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_varbinary")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_varbinary"));
    }

    private static String utf8ByteaLiteral(String string) {
        return String.format("bytea E'\\\\x%s'", BaseEncoding.base16().encode(string.getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testForcedMappingToVarchar() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        jdbcSqlExecutor.execute("CREATE TABLE test_forced_varchar_mapping(tsrange_col tsrange, inet_col inet, tsrange_arr_col tsrange[], unsupported_nonforced_column tstzrange)");
        jdbcSqlExecutor.execute("INSERT INTO test_forced_varchar_mapping(tsrange_col, inet_col, tsrange_arr_col, unsupported_nonforced_column) VALUES ('[2010-01-01 14:30, 2010-01-01 15:30)'::tsrange, '172.0.0.1'::inet, array['[2010-01-01 14:30, 2010-01-01 15:30)'::tsrange], '[2010-01-01 14:30, 2010-01-01 15:30)'::tstzrange)");
        try {
            this.assertQuery(this.sessionWithArrayAsArray(), "SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = 'test_forced_varchar_mapping'", "VALUES ('tsrange_col','varchar'),('inet_col','varchar'),('tsrange_arr_col','array(varchar)')");
            this.assertQuery(this.sessionWithArrayAsArray(), "SELECT * FROM test_forced_varchar_mapping", "VALUES ('[\"2010-01-01 14:30:00\",\"2010-01-01 15:30:00\")','172.0.0.1',ARRAY['[\"2010-01-01 14:30:00\",\"2010-01-01 15:30:00\")'])");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 1 FROM test_forced_varchar_mapping WHERE tsrange_col = '[\"2010-01-01 14:30:00\",\"2010-01-01 15:30:00\")'"))).matches("VALUES 1").isNotFullyPushedDown(FilterNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 1 FROM test_forced_varchar_mapping WHERE tsrange_col = 'some value'"))).returnsEmptyResult().isNotFullyPushedDown(FilterNode.class, new Class[0]);
            this.assertQueryFails("INSERT INTO test_forced_varchar_mapping (tsrange_col) VALUES ('some value')", "Underlying type that is mapped to VARCHAR is not supported for INSERT: tsrange");
        }
        finally {
            jdbcSqlExecutor.execute("DROP TABLE test_forced_varchar_mapping");
        }
    }

    @Test
    public void testDecimalExceedingPrecisionMaxIgnored() {
        this.testUnsupportedDataTypeAsIgnored("decimal(50,0)", "12345678901234567890123456789012345678901234567890");
    }

    @Test
    public void testDecimalExceedingPrecisionMaxConvertedToVarchar() {
        this.testUnsupportedDataTypeConvertedToVarchar(this.getSession(), "decimal(50,0)", "numeric", "12345678901234567890123456789012345678901234567890", "'12345678901234567890123456789012345678901234567890'");
    }

    @Test
    public void testDecimalExceedingPrecisionMaxWithExceedingIntegerValues() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "test_exceeding_max_decimal", "(d_col decimal(65,25))", Arrays.asList("1234567890123456789012345678901234567890.123456789", "-1234567890123456789012345678901234567890.123456789"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "Decimal overflow");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'varchar')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), "SELECT d_col FROM " + testTable.getName(), "VALUES ('1234567890123456789012345678901234567890.1234567890000000000000000'), ('-1234567890123456789012345678901234567890.1234567890000000000000000')");
        }
    }

    @Test
    public void testDecimalExceedingPrecisionMaxWithNonExceedingIntegerValues() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "test_exceeding_max_decimal", "(d_col decimal(60,20))", Arrays.asList("123456789012345678901234567890.123456789012345", "-123456789012345678901234567890.123456789012345"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "VALUES (123456789012345678901234567890), (-123456789012345678901234567890)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 8), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,8)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 8), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 8), "SELECT d_col FROM " + testTable.getName(), "VALUES (123456789012345678901234567890.12345679), (-123456789012345678901234567890.12345679)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 22), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,20)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 20), "SELECT d_col FROM " + testTable.getName(), "Decimal overflow");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 9), "SELECT d_col FROM " + testTable.getName(), "Decimal overflow");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'varchar')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), "SELECT d_col FROM " + testTable.getName(), "VALUES ('123456789012345678901234567890.12345678901234500000'), ('-123456789012345678901234567890.12345678901234500000')");
        }
    }

    @Test
    public void testDecimalExceedingPrecisionMaxWithSupportedValues() {
        this.testDecimalExceedingPrecisionMaxWithSupportedValues(40, 8);
        this.testDecimalExceedingPrecisionMaxWithSupportedValues(50, 10);
    }

    private void testDecimalExceedingPrecisionMaxWithSupportedValues(int typePrecision, int typeScale) {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "test_exceeding_max_decimal", String.format("(d_col decimal(%d,%d))", typePrecision, typeScale), Arrays.asList("12.01", "-12.01", "123", "-123", "1.12345678", "-1.12345678"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "VALUES (12), (-12), (123), (-123), (1), (-1)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 3), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,3)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 3), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.123), (-1.123)");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 3), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 8), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,8)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 8), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.12345678), (-1.12345678)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 9), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.12345678), (-1.12345678)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 8), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.12345678), (-1.12345678)");
        }
    }

    @Test
    public void testDecimalUnspecifiedPrecisionWithSupportedValues() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "test_var_decimal", "(d_col decimal)", Arrays.asList("1.12", "123456.789", "-1.12", "-123456.789"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col','decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "VALUES (1), (123457), (-1), (-123457)");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 1), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 1), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col','decimal(38,1)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 1), "SELECT d_col FROM " + testTable.getName(), "VALUES (1.1), (123456.8), (-1.1), (-123456.8)");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 2), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 2), "SELECT d_col FROM " + testTable.getName(), "VALUES (1.12), (123456.79), (-1.12), (-123456.79)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 3), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col','decimal(38,3)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 3), "SELECT d_col FROM " + testTable.getName(), "VALUES (1.12), (123456.789), (-1.12), (-123456.789)");
        }
    }

    @Test
    public void testDecimalUnspecifiedPrecisionWithExceedingValue() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "test_var_decimal_with_exceeding_value", "(key varchar(5), d_col decimal)", Arrays.asList("NULL, '1.12'", "NULL, '1234567890123456789012345678901234567890.1234567'"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('key', 'varchar(5)'),('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT * FROM " + testTable.getName(), "Rounding necessary");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT * FROM " + testTable.getName(), "Decimal overflow");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('key', 'varchar(5)'),('d_col', 'varchar')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), "SELECT * FROM " + testTable.getName(), "VALUES (NULL, '1.12'), (NULL, '1234567890123456789012345678901234567890.1234567')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.IGNORE), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('key', 'varchar(5)')");
        }
    }

    @Test
    public void testArrayDisabled() {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "array_mapping", PostgreSqlConfig.ArrayMapping.DISABLED.name()).build();
        this.testUnsupportedDataTypeAsIgnored(session, "bigint[]", "ARRAY[42]");
        this.testUnsupportedDataTypeConvertedToVarchar(session, "bigint[]", "_int8", "ARRAY[42]", "'{42}'");
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY['binary'::bytea]");
        this.testUnsupportedDataTypeConvertedToVarchar(session, "bytea[]", "_bytea", "ARRAY['binary'::bytea]", "'{\"\\\\x62696e617279\"}'");
    }

    @Test
    public void testArray() {
        Session session = this.sessionWithArrayAsArray();
        SqlDataTypeTest.create().addRoundTrip("ARRAY(boolean)", "ARRAY[true, false]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "ARRAY[true, false]").addRoundTrip("ARRAY(bigint)", "ARRAY[123456789012]", (Type)new ArrayType((Type)BigintType.BIGINT), "ARRAY[123456789012]").addRoundTrip("ARRAY(integer)", "ARRAY[1, 2, 1234567890]", (Type)new ArrayType((Type)IntegerType.INTEGER), "ARRAY[1, 2, 1234567890]").addRoundTrip("ARRAY(smallint)", "ARRAY[32456]", (Type)new ArrayType((Type)SmallintType.SMALLINT), "ARRAY[SMALLINT '32456']").addRoundTrip("ARRAY(double)", "ARRAY[123.45]", (Type)new ArrayType((Type)DoubleType.DOUBLE), "ARRAY[DOUBLE '123.45']").addRoundTrip("ARRAY(real)", "ARRAY[123.45]", (Type)new ArrayType((Type)RealType.REAL), "ARRAY[REAL '123.45']").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_basic")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_array_basic"));
        this.arrayDateTest(TestPostgreSqlTypeMapping::trinoArrayFactory).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_date")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_array_date"));
        this.arrayDateTest(TestPostgreSqlTypeMapping::postgreSqlArrayFactory).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_date"));
        this.arrayDecimalTest(TestPostgreSqlTypeMapping::trinoArrayFactory).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_decimal")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_array_decimal"));
        this.arrayDecimalTest(TestPostgreSqlTypeMapping::postgreSqlArrayFactory).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_decimal"));
        this.arrayVarcharTest(TestPostgreSqlTypeMapping::trinoArrayFactory).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_varchar")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_array_varchar"));
        this.arrayVarcharTest(TestPostgreSqlTypeMapping::postgreSqlArrayFactory).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_varchar"));
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY['binary value'::bytea]");
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY[ARRAY['binary value'::bytea]]");
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY[ARRAY[ARRAY['binary value'::bytea]]]");
        this.testUnsupportedDataTypeAsIgnored(session, "_bytea", "ARRAY['binary value'::bytea]");
        this.testUnsupportedDataTypeConvertedToVarchar(session, "bytea[]", "_bytea", "ARRAY['binary value'::bytea]", "'{\"\\\\x62696e6172792076616c7565\"}'");
        this.arrayUnicodeDataTypeTest(TestPostgreSqlTypeMapping::trinoArrayFactory).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_parameterized_char_unicode")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_array_parameterized_char_unicode"));
        this.arrayUnicodeDataTypeTest(TestPostgreSqlTypeMapping::postgreSqlArrayFactory).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_parameterized_char_unicode"));
        this.arrayVarcharUnicodeDataTypeTest(TestPostgreSqlTypeMapping::trinoArrayFactory).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_parameterized_varchar_unicode")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_array_parameterized_varchar_unicode"));
        this.arrayVarcharUnicodeDataTypeTest(TestPostgreSqlTypeMapping::postgreSqlArrayFactory).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_parameterized_varchar_unicode"));
    }

    @Test
    public void testInternalArray() {
        SqlDataTypeTest.create().addRoundTrip("_int4", "ARRAY[1, 2, 3]", (Type)new ArrayType((Type)IntegerType.INTEGER), "ARRAY[1, 2, 3]").addRoundTrip("_text", "ARRAY['a', 'b']", (Type)new ArrayType((Type)VarcharType.VARCHAR), "ARRAY[CAST('a' AS varchar), CAST('b' AS varchar)]").execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.postgresCreateAndInsert("test_array_with_native_name"));
    }

    @Test
    public void testArrayEmptyOrNulls() {
        SqlDataTypeTest.create().addRoundTrip("ARRAY(bigint)", "ARRAY[]", (Type)new ArrayType((Type)BigintType.BIGINT), "CAST(ARRAY[] AS ARRAY(BIGINT))").addRoundTrip("ARRAY(boolean)", "NULL", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "CAST(NULL AS ARRAY(BOOLEAN))").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[]", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "CAST(ARRAY[] AS ARRAY(TIMESTAMP(3)))").addRoundTrip("ARRAY(timestamp(3) with time zone)", "ARRAY[]", (Type)new ArrayType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3)), "CAST(ARRAY[] AS ARRAY(TIMESTAMP(3) WITH TIME ZONE))").execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_empty_or_nulls")).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAndInsert(this.sessionWithArrayAsArray(), "test_array_empty_or_nulls"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.realDataType()), Collections.singletonList(null)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.integerDataType()), Arrays.asList(1, null, 3, null)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.timestampDataType((int)3)), Collections.singletonList(null)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.trinoTimestampWithTimeZoneDataType(3)), Collections.singletonList(null)).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_empty_or_nulls")).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAndInsert(this.sessionWithArrayAsArray(), "test_array_empty_or_nulls"));
    }

    private SqlDataTypeTest arrayDecimalTest(Function<String, String> arrayTypeFactory) {
        return SqlDataTypeTest.create().addRoundTrip(arrayTypeFactory.apply("decimal(3, 0)"), "ARRAY[193, 19, -193]", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)0)), "ARRAY[CAST('193' AS decimal(3, 0)), CAST('19' AS decimal(3, 0)), CAST('-193' AS decimal(3, 0))]").addRoundTrip(arrayTypeFactory.apply("decimal(3, 1)"), "ARRAY[10.0, 10.1, -10.1]", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)1)), "ARRAY[CAST('10.0' AS decimal(3, 1)), CAST('10.1' AS decimal(3, 1)), CAST('-10.1' AS decimal(3, 1))]").addRoundTrip(arrayTypeFactory.apply("decimal(4, 2)"), "ARRAY[2, 2.3]", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)4, (int)2)), "ARRAY[CAST('2' AS decimal(4, 2)), CAST('2.3' AS decimal(4, 2))]").addRoundTrip(arrayTypeFactory.apply("decimal(24, 2)"), "ARRAY[2, 2.3, 123456789.3]", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)24, (int)2)), "ARRAY[CAST('2' AS decimal(24, 2)), CAST('2.3' AS decimal(24, 2)), CAST('123456789.3' AS decimal(24, 2))]").addRoundTrip(arrayTypeFactory.apply("decimal(24, 4)"), "ARRAY[12345678901234567890.31]", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)24, (int)4)), "ARRAY[CAST('12345678901234567890.31' AS decimal(24, 4))]").addRoundTrip(arrayTypeFactory.apply("decimal(30, 5)"), "ARRAY[3141592653589793238462643.38327, -3141592653589793238462643.38327]", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)30, (int)5)), "ARRAY[CAST('3141592653589793238462643.38327' AS decimal(30, 5)), CAST('-3141592653589793238462643.38327' AS decimal(30, 5))]").addRoundTrip(arrayTypeFactory.apply("decimal(38, 0)"), "ARRAY[CAST('27182818284590452353602874713526624977' AS decimal(38, 0)), CAST('-27182818284590452353602874713526624977' AS decimal(38, 0))]", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)38, (int)0)), "ARRAY[CAST('27182818284590452353602874713526624977' AS decimal(38, 0)), CAST('-27182818284590452353602874713526624977' AS decimal(38, 0))]");
    }

    private SqlDataTypeTest arrayVarcharTest(Function<String, String> arrayTypeFactory) {
        return SqlDataTypeTest.create().addRoundTrip(arrayTypeFactory.apply("varchar(10)"), "ARRAY['text_a']", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)10)), "ARRAY[CAST('text_a' AS varchar(10))]").addRoundTrip(arrayTypeFactory.apply("varchar(255)"), "ARRAY['text_b']", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)255)), "ARRAY[CAST('text_b' AS varchar(255))]").addRoundTrip(arrayTypeFactory.apply("varchar(65535)"), "ARRAY['text_d']", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)65535)), "ARRAY[CAST('text_d' AS varchar(65535))]").addRoundTrip(arrayTypeFactory.apply("varchar(10485760)"), "ARRAY['text_f']", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)0xA00000)), "ARRAY[CAST('text_f' AS varchar(10485760))]").addRoundTrip(arrayTypeFactory.apply("varchar"), "ARRAY['unbounded']", (Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType()), "ARRAY[CAST('unbounded' AS varchar)]");
    }

    private SqlDataTypeTest arrayVarcharUnicodeDataTypeTest(Function<String, String> arrayTypeFactory) {
        String sampleUnicodeText = "\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!";
        return this.arrayUnicodeDataTypeTest(arrayTypeFactory).addRoundTrip(arrayTypeFactory.apply("varchar"), String.format("ARRAY['%s']", sampleUnicodeText), (Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType()), String.format("ARRAY[CAST('%s' AS varchar)]", sampleUnicodeText));
    }

    private SqlDataTypeTest arrayUnicodeDataTypeTest(Function<String, String> arrayTypeFactory) {
        String sampleUnicodeText = "\u653b\u6bbb\u6a5f\u52d5\u968a";
        String sampleFourByteUnicodeCharacter = "\ud83d\ude02";
        return SqlDataTypeTest.create().addRoundTrip(arrayTypeFactory.apply("char(5)"), String.format("ARRAY['%s']", sampleUnicodeText), (Type)new ArrayType((Type)CharType.createCharType((int)5)), String.format("ARRAY[CAST('%s' AS char(5))]", sampleUnicodeText)).addRoundTrip(arrayTypeFactory.apply("char(32)"), String.format("ARRAY['%s']", sampleUnicodeText), (Type)new ArrayType((Type)CharType.createCharType((int)32)), String.format("ARRAY[CAST('%s' AS char(32))]", sampleUnicodeText)).addRoundTrip(arrayTypeFactory.apply("char(20000)"), String.format("ARRAY['%s']", sampleUnicodeText), (Type)new ArrayType((Type)CharType.createCharType((int)20000)), String.format("ARRAY[CAST('%s' AS char(20000))]", sampleUnicodeText)).addRoundTrip(arrayTypeFactory.apply("char(1)"), String.format("ARRAY['%s']", sampleFourByteUnicodeCharacter), (Type)new ArrayType((Type)CharType.createCharType((int)1)), String.format("ARRAY[CAST('%s' AS char(1))]", sampleFourByteUnicodeCharacter));
    }

    private SqlDataTypeTest arrayDateTest(Function<String, String> arrayTypeFactory) {
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInJvmZone = LocalDate.of(1932, 4, 1);
        TestPostgreSqlTypeMapping.checkIsGap(this.jvmZone, dateOfLocalTimeChangeForwardAtMidnightInJvmZone.atStartOfDay());
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInSomeZone = LocalDate.of(1983, 4, 1);
        TestPostgreSqlTypeMapping.checkIsGap(this.vilnius, dateOfLocalTimeChangeForwardAtMidnightInSomeZone.atStartOfDay());
        LocalDate dateOfLocalTimeChangeBackwardAtMidnightInSomeZone = LocalDate.of(1983, 10, 1);
        TestPostgreSqlTypeMapping.checkIsDoubled(this.vilnius, dateOfLocalTimeChangeBackwardAtMidnightInSomeZone.atStartOfDay().minusMinutes(1L));
        return SqlDataTypeTest.create().addRoundTrip(arrayTypeFactory.apply("date"), "ARRAY[DATE '1952-04-03']", (Type)new ArrayType((Type)DateType.DATE), "ARRAY[DATE '1952-04-03']").addRoundTrip(arrayTypeFactory.apply("date"), "ARRAY[DATE '1970-02-03']", (Type)new ArrayType((Type)DateType.DATE), "ARRAY[DATE '1970-02-03']").addRoundTrip(arrayTypeFactory.apply("date"), "ARRAY[DATE '2017-07-01']", (Type)new ArrayType((Type)DateType.DATE), "ARRAY[DATE '2017-07-01']").addRoundTrip(arrayTypeFactory.apply("date"), "ARRAY[DATE '2017-01-01']", (Type)new ArrayType((Type)DateType.DATE), "ARRAY[DATE '2017-01-01']").addRoundTrip(arrayTypeFactory.apply("date"), "ARRAY[DATE '1970-01-01']", (Type)new ArrayType((Type)DateType.DATE), "ARRAY[DATE '1970-01-01']").addRoundTrip(arrayTypeFactory.apply("date"), "ARRAY[DATE '1983-04-01']", (Type)new ArrayType((Type)DateType.DATE), "ARRAY[DATE '1983-04-01']").addRoundTrip(arrayTypeFactory.apply("date"), "ARRAY[DATE '1983-10-01']", (Type)new ArrayType((Type)DateType.DATE), "ARRAY[DATE '1983-10-01']");
    }

    @Test
    public void testArrayMultidimensional() {
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.booleanDataType())), Arrays.asList(Arrays.asList(null, null, null))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.booleanDataType())), Arrays.asList(Arrays.asList(true, null), Arrays.asList(null, null), Arrays.asList(false, false))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.integerDataType())), Arrays.asList(Arrays.asList(1, 2), Arrays.asList(null, null), Arrays.asList(3, 4))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.decimalDataType((int)3, (int)0))), Arrays.asList(Arrays.asList(new BigDecimal("193")), Arrays.asList(new BigDecimal("19")), Arrays.asList(new BigDecimal("-193")))).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_2d")).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAndInsert(this.sessionWithArrayAsArray(), "test_array_2d"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.doubleDataType()))), Arrays.asList(Arrays.asList(Arrays.asList(123.45), Arrays.asList(678.99)), Arrays.asList(Arrays.asList(543.21), Arrays.asList(998.76)), Arrays.asList(Arrays.asList(567.123), Arrays.asList(789.12)))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.dateDataType()))), Arrays.asList(Arrays.asList(Arrays.asList(LocalDate.of(1952, 4, 3), LocalDate.of(1970, 1, 1))), Arrays.asList(Arrays.asList(null, LocalDate.of(1970, 1, 1))), Arrays.asList(Arrays.asList(LocalDate.of(1970, 2, 3), LocalDate.of(2017, 7, 1))))).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_3d")).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAndInsert(this.sessionWithArrayAsArray(), "test_array_3d"));
    }

    @Test
    public void testArrayAsJson() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("postgresql.array_mapping", PostgreSqlConfig.ArrayMapping.AS_JSON.name()).build();
        SqlDataTypeTest.create().addRoundTrip("boolean[]", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("boolean[]", "ARRAY[ARRAY[true,false], ARRAY[false,true], ARRAY[true,true]]::boolean[]", (Type)JsonType.JSON, "JSON '[[true,false], [false,true], [true,true]]'").addRoundTrip("boolean[3][2]", "ARRAY[ARRAY[true,false], ARRAY[false,true], ARRAY[true,true]]::boolean[3][2]", (Type)JsonType.JSON, "JSON '[[true,false], [false,true], [true,true]]'").addRoundTrip("boolean[100][100][100]", "ARRAY[true]::boolean[100][100][100]", (Type)JsonType.JSON, "JSON '[true]'").addRoundTrip("_bool", "ARRAY[ARRAY[true,false], ARRAY[null,null]]::_bool", (Type)JsonType.JSON, "JSON '[[true,false], [null,null]]'").addRoundTrip("_bool", "ARRAY[ARRAY[ARRAY[null]]]::_bool", (Type)JsonType.JSON, "JSON '[[[null]]]'").addRoundTrip("_bool", "ARRAY[]::_bool", (Type)JsonType.JSON, "JSON '[]'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_boolean_array_as_json"));
        SqlDataTypeTest.create().addRoundTrip("integer[]", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("integer[]", "ARRAY[ARRAY[ARRAY[1,2,3], ARRAY[4,5,6]], ARRAY[ARRAY[7,8,9], ARRAY[10,11,12]]]::integer[]", (Type)JsonType.JSON, "JSON '[[[1,2,3], [4,5,6]], [[7,8,9], [10,11,12]]]'").addRoundTrip("integer[100][100][100]", "ARRAY[0]::integer[100][100][100]", (Type)JsonType.JSON, "JSON '[0]'").addRoundTrip("integer[]", "ARRAY[ARRAY[ARRAY[null,null]]]::integer[]", (Type)JsonType.JSON, "JSON '[[[null,null]]]'").addRoundTrip("integer[]", "ARRAY[]::integer[]", (Type)JsonType.JSON, "JSON '[]'").addRoundTrip("_int4", "ARRAY[]::_int4", (Type)JsonType.JSON, "JSON '[]'").addRoundTrip("_int4", "ARRAY[ARRAY[0], ARRAY[1], ARRAY[2], ARRAY[3]]::_int4", (Type)JsonType.JSON, "JSON '[[0], [1], [2], [3]]'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_integer_array_as_json"));
        SqlDataTypeTest.create().addRoundTrip("double precision[]", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("double precision[]", "ARRAY[ARRAY[ARRAY[1.1,2.2,3.3], ARRAY[4.4,5.5,6.6]]]::double precision[]", (Type)JsonType.JSON, "JSON '[[[1.1,2.2,3.3], [4.4,5.5,6.6]]]'").addRoundTrip("double precision[100][100][100]", "ARRAY[42.3]::double precision[100][100][100]", (Type)JsonType.JSON, "JSON '[42.3]'").addRoundTrip("double precision[]", "ARRAY[ARRAY[ARRAY[null,null]]]::double precision[]", (Type)JsonType.JSON, "JSON '[[[null,null]]]'").addRoundTrip("double precision[]", "ARRAY[]::double precision[]", (Type)JsonType.JSON, "JSON '[]'").addRoundTrip("_float8", "ARRAY[]::_float8", (Type)JsonType.JSON, "JSON '[]'").addRoundTrip("_float8", "ARRAY[ARRAY[1.1], ARRAY[2.2]]::_float8", (Type)JsonType.JSON, "JSON '[[1.1], [2.2]]'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_double_array_as_json"));
        SqlDataTypeTest.create().addRoundTrip("real[]", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("real[]", "ARRAY[ARRAY[ARRAY[1.1,2.2,3.3], ARRAY[4.4,5.5,6.6]]]::real[]", (Type)JsonType.JSON, "JSON '[[[1.1,2.2,3.3], [4.4,5.5,6.6]]]'").addRoundTrip("real[100][100][100]", "ARRAY[42.3]::real[100][100][100]", (Type)JsonType.JSON, "JSON '[42.3]'").addRoundTrip("real[]", "ARRAY[ARRAY[ARRAY[null,null]]]::real[]", (Type)JsonType.JSON, "JSON '[[[null,null]]]'").addRoundTrip("real[]", "ARRAY[]::real[]", (Type)JsonType.JSON, "JSON '[]'").addRoundTrip("_float4", "ARRAY[]::_float4", (Type)JsonType.JSON, "JSON '[]'").addRoundTrip("_float4", "ARRAY[ARRAY[1.1], ARRAY[2.2]]::_float4", (Type)JsonType.JSON, "JSON '[[1.1], [2.2]]'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_real_array_as_json"));
        SqlDataTypeTest.create().addRoundTrip("varchar[]", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("varchar[]", "ARRAY['text']::varchar[]", (Type)JsonType.JSON, "JSON '[\"text\"]'").addRoundTrip("_text", "ARRAY[ARRAY['one','two'], ARRAY['three','four']]::_text", (Type)JsonType.JSON, "JSON '[[\"one\",\"two\"], [\"three\",\"four\"]]'").addRoundTrip("_text", "ARRAY[ARRAY['one',null]]::_text", (Type)JsonType.JSON, "JSON '[[\"one\",null]]'").addRoundTrip("_text", "ARRAY[]::_text", (Type)JsonType.JSON, "JSON '[]'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_varchar_array_as_json"));
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY['binary value'::bytea]");
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY[ARRAY['binary value'::bytea]]");
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY[ARRAY[ARRAY['binary value'::bytea]]]");
        this.testUnsupportedDataTypeAsIgnored(session, "_bytea", "ARRAY['binary value'::bytea]");
        this.testUnsupportedDataTypeConvertedToVarchar(session, "bytea[]", "_bytea", "ARRAY['binary value'::bytea]", " '{\"\\\\x62696e6172792076616c7565\"}' ");
        SqlDataTypeTest.create().addRoundTrip("date[]", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("date[]", "ARRAY['2019-01-02']::date[]", (Type)JsonType.JSON, "JSON '[\"2019-01-02\"]'").addRoundTrip("date[]", "ARRAY[null,null]::date[]", (Type)JsonType.JSON, "JSON '[null,null]'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_timestamp_array_as_json"));
        SqlDataTypeTest.create().addRoundTrip("timestamp[]", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("timestamp[]", "ARRAY['2019-01-02 03:04:05.789000']::timestamp[]", (Type)JsonType.JSON, "JSON '[\"2019-01-02 03:04:05.789000\"]'").addRoundTrip("timestamp[]", "ARRAY[null,null]::timestamp[]", (Type)JsonType.JSON, "JSON '[null,null]'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_timestamp_array_as_json"));
        SqlDataTypeTest.create().addRoundTrip("hstore[]", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("hstore[]", "ARRAY[]::hstore[]", (Type)JsonType.JSON, "JSON '[]'").addRoundTrip("hstore[]", "ARRAY[null,null]::hstore[]", (Type)JsonType.JSON, "JSON '[null,null]'").addRoundTrip("hstore[]", "ARRAY[hstore(ARRAY['a','1','b','2']::varchar[]), hstore(ARRAY['a','3','d','4']::varchar[])]", (Type)JsonType.JSON, "JSON '[{\"a\":\"1\",\"b\":\"2\"},{\"a\":\"3\",\"d\":\"4\"}]'").addRoundTrip("hstore[]", "ARRAY[hstore(ARRAY['a',null,'b','2']::varchar[])]", (Type)JsonType.JSON, "JSON '[{\"a\":null,\"b\":\"2\"}]'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_hstore_array_as_json"));
    }

    private static String trinoArrayFactory(String elementType) {
        return String.format("ARRAY(%s)", elementType);
    }

    private static String postgreSqlArrayFactory(String elementType) {
        return elementType + "[]";
    }

    private static <E> DataType<List<E>> arrayDataType(DataType<E> elementType) {
        return TestPostgreSqlTypeMapping.arrayDataType(elementType, String.format("ARRAY(%s)", elementType.getInsertType()));
    }

    private static <E> DataType<List<E>> arrayDataType(DataType<E> elementType, String insertType) {
        return DataType.dataType((String)insertType, (Type)new ArrayType(elementType.getTrinoResultType()), valuesList -> "ARRAY" + String.valueOf(valuesList.stream().map(arg_0 -> ((DataType)elementType).toLiteral(arg_0)).collect(Collectors.toList())), valuesList -> "ARRAY" + String.valueOf(valuesList.stream().map(arg_0 -> ((DataType)elementType).toTrinoLiteral(arg_0)).collect(Collectors.toList())), valuesList -> valuesList == null ? null : valuesList.stream().map(arg_0 -> ((DataType)elementType).toTrinoQueryResult(arg_0)).collect(Collectors.toList()));
    }

    @Test
    public void testDate() {
        this.testDate(ZoneOffset.UTC);
        this.testDate(this.jvmZone);
        this.testDate(this.vilnius);
        this.testDate(this.kathmandu);
        this.testDate(TestingSession.DEFAULT_TIME_ZONE_KEY.getZoneId());
    }

    private void testDate(ZoneId sessionZone) {
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        SqlDataTypeTest.create().addRoundTrip("date", "DATE '0001-01-01'", (Type)DateType.DATE, "DATE '0001-01-01'").addRoundTrip("date", "DATE '1582-10-04'", (Type)DateType.DATE, "DATE '1582-10-04'").addRoundTrip("date", "DATE '1582-10-05'", (Type)DateType.DATE, "DATE '1582-10-05'").addRoundTrip("date", "DATE '1582-10-14'", (Type)DateType.DATE, "DATE '1582-10-14'").addRoundTrip("date", "DATE '1952-04-03'", (Type)DateType.DATE, "DATE '1952-04-03'").addRoundTrip("date", "DATE '1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "DATE '1970-02-03'", (Type)DateType.DATE, "DATE '1970-02-03'").addRoundTrip("date", "DATE '2017-07-01'", (Type)DateType.DATE, "DATE '2017-07-01'").addRoundTrip("date", "DATE '2017-01-01'", (Type)DateType.DATE, "DATE '2017-01-01'").addRoundTrip("date", "DATE '1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "DATE '1983-04-01'", (Type)DateType.DATE, "DATE '1983-04-01'").addRoundTrip("date", "DATE '1983-10-01'", (Type)DateType.DATE, "DATE '1983-10-01'").addRoundTrip("date", "DATE '5874897-12-31'", (Type)DateType.DATE, "DATE '5874897-12-31'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_date")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_date")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect("test_date")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_date")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert("test_date"));
        SqlDataTypeTest.create().addRoundTrip("DATE", "'4713-01-01 BC'", (Type)DateType.DATE, "DATE '-4712-01-01'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_date_min"));
        SqlDataTypeTest.create().addRoundTrip("DATE", "DATE '-4712-01-01'", (Type)DateType.DATE, "DATE '-4712-01-01'").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_date_min")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect("test_date_min")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_date_min")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert("test_date_min"));
    }

    @Test
    public void testEnum() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        jdbcSqlExecutor.execute("CREATE TYPE enum_t AS ENUM ('b', 'a', 'C')");
        jdbcSqlExecutor.execute("CREATE TABLE test_enum(id int, enum_column enum_t)");
        jdbcSqlExecutor.execute("INSERT INTO test_enum(id,enum_column) values (1,'a'::enum_t),(2,'b'::enum_t)");
        try {
            this.assertQuery("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = 'test_enum'", "VALUES ('id','integer'),('enum_column','varchar')");
            this.assertQuery("SELECT * FROM test_enum", "VALUES (1,'a'),(2,'b')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_enum WHERE enum_column = 'a'"))).matches("VALUES (1, VARCHAR 'a')").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_enum WHERE enum_column != 'a'"))).matches("VALUES (2, VARCHAR 'b')").isNotFullyPushedDown(FilterNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_enum WHERE enum_column <= 'a'"))).matches("VALUES (1, VARCHAR 'a')").isNotFullyPushedDown(FilterNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_enum WHERE enum_column <= 'b'"))).matches("VALUES (1, VARCHAR 'a'), (2, VARCHAR 'b')").isNotFullyPushedDown(FilterNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_enum WHERE enum_column <= 'c'"))).matches("VALUES (1, VARCHAR 'a'), (2, VARCHAR 'b')").isNotFullyPushedDown(FilterNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_enum WHERE enum_column <= 'C'"))).returnsEmptyResult().isNotFullyPushedDown(FilterNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM test_enum ORDER BY enum_column LIMIT 1"))).matches("VALUES 1").isNotFullyPushedDown(TopNNode.class, new Class[0]);
        }
        finally {
            jdbcSqlExecutor.execute("DROP TABLE test_enum");
            jdbcSqlExecutor.execute("DROP TYPE enum_t");
        }
    }

    @Test
    public void testTime() {
        this.testTime(ZoneOffset.UTC);
        this.testTime(this.jvmZone);
        this.testTime(this.vilnius);
        this.testTime(this.kathmandu);
        this.testTime(TestingSession.DEFAULT_TIME_ZONE_KEY.getZoneId());
    }

    private void testTime(ZoneId sessionZone) {
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        SqlDataTypeTest.create().addRoundTrip("time(0)", "TIME '01:12:34'", (Type)TimeType.createTimeType((int)0), "TIME '01:12:34'").addRoundTrip("time(1)", "TIME '02:12:34.1'", (Type)TimeType.createTimeType((int)1), "TIME '02:12:34.1'").addRoundTrip("time(2)", "TIME '02:12:34.01'", (Type)TimeType.createTimeType((int)2), "TIME '02:12:34.01'").addRoundTrip("time(3)", "TIME '02:12:34.001'", (Type)TimeType.createTimeType((int)3), "TIME '02:12:34.001'").addRoundTrip("time(3)", "TIME '03:12:34.000'", (Type)TimeType.createTimeType((int)3), "TIME '03:12:34.000'").addRoundTrip("time(4)", "TIME '04:12:34.0000'", (Type)TimeType.createTimeType((int)4), "TIME '04:12:34.0000'").addRoundTrip("time(5)", "TIME '05:12:34.00000'", (Type)TimeType.createTimeType((int)5), "TIME '05:12:34.00000'").addRoundTrip("time(5)", "TIME '06:12:34.00000'", (Type)TimeType.createTimeType((int)5), "TIME '06:12:34.00000'").addRoundTrip("time(6)", "TIME '09:12:34.000000'", (Type)TimeType.createTimeType((int)6), "TIME '09:12:34.000000'").addRoundTrip("time(6)", "TIME '10:12:34.000000'", (Type)TimeType.createTimeType((int)6), "TIME '10:12:34.000000'").addRoundTrip("time(6)", "TIME '15:12:34.567000'", (Type)TimeType.createTimeType((int)6), "TIME '15:12:34.567000'").addRoundTrip("time(6)", "TIME '23:59:59.000000'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.000000'").addRoundTrip("time(6)", "TIME '23:59:59.999000'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999000'").addRoundTrip("time(6)", "TIME '23:59:59.999900'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999900'").addRoundTrip("time(6)", "TIME '23:59:59.999990'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999990'").addRoundTrip("time(6)", "TIME '23:59:59.999999'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999999'").addRoundTrip("time(3)", "TIME '00:00:00.000'", (Type)TimeType.createTimeType((int)3), "TIME '00:00:00.000'").addRoundTrip("time(3)", "TIME '00:12:34.567'", (Type)TimeType.createTimeType((int)3), "TIME '00:12:34.567'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_time")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_time")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect("test_time")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_time")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert("test_time"));
    }

    @Test
    public void testTimeCoercion() {
        SqlDataTypeTest.create().addRoundTrip("TIME '00:00:00'", "TIME '00:00:00'").addRoundTrip("TIME '00:00:00.000000'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.123456'", "TIME '00:00:00.123456'").addRoundTrip("TIME '12:34:56'", "TIME '12:34:56'").addRoundTrip("TIME '12:34:56.123456'", "TIME '12:34:56.123456'").addRoundTrip("TIME '23:59:59.000000'", "TIME '23:59:59.000000'").addRoundTrip("TIME '23:59:59.900000'", "TIME '23:59:59.900000'").addRoundTrip("TIME '23:59:59.990000'", "TIME '23:59:59.990000'").addRoundTrip("TIME '23:59:59.999000'", "TIME '23:59:59.999000'").addRoundTrip("TIME '23:59:59.999900'", "TIME '23:59:59.999900'").addRoundTrip("TIME '23:59:59.999990'", "TIME '23:59:59.999990'").addRoundTrip("TIME '23:59:59.999999'", "TIME '23:59:59.999999'").addRoundTrip("TIME '23:59:59'", "TIME '23:59:59'").addRoundTrip("TIME '23:59:59.9'", "TIME '23:59:59.9'").addRoundTrip("TIME '23:59:59.99'", "TIME '23:59:59.99'").addRoundTrip("TIME '23:59:59.999'", "TIME '23:59:59.999'").addRoundTrip("TIME '23:59:59.9999'", "TIME '23:59:59.9999'").addRoundTrip("TIME '23:59:59.99999'", "TIME '23:59:59.99999'").addRoundTrip("TIME '23:59:59.999999'", "TIME '23:59:59.999999'").addRoundTrip("TIME '00:00:00.0000001'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.000000000001'", "TIME '00:00:00.000000'").addRoundTrip("TIME '12:34:56.1234561'", "TIME '12:34:56.123456'").addRoundTrip("TIME '23:59:59.9999994'", "TIME '23:59:59.999999'").addRoundTrip("TIME '23:59:59.999999499999'", "TIME '23:59:59.999999'").addRoundTrip("TIME '00:00:00.0000004'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.00000049'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.000000449'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.0000004449'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.00000044449'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.000000444449'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.0000005'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.00000050'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.000000500'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.0000005000'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.00000050000'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.000000500000'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.0000009'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.00000099'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.000000999'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.0000009999'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.00000099999'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.000000999999'", "TIME '00:00:00.000001'").addRoundTrip("TIME '23:59:59.9999995'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.99999950'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.999999500'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.9999995000'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.99999950000'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.999999500000'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.9999999'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.99999999'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.999999999'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.9999999999'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.99999999999'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.999999999999'", "TIME '00:00:00.000000'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_time_coercion")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_time_coercion"));
    }

    @Test
    public void testTime24() {
        try (TestTable testTable = new TestTable((SqlExecutor)new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties()), "test_time_24", "(a time(0), b time(3), c time(6))", List.of("TIME '00:00:00', TIME '00:00:00.000', TIME '00:00:00.000000'", "TIME '23:59:59', TIME '23:59:59.999', TIME '23:59:59.999999'", "TIME '24:00:00', TIME '24:00:00.000', TIME '24:00:00.000000'"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a, b, c FROM " + testTable.getName()))).matches("VALUES (TIME '00:00:00', TIME '00:00:00.000', TIME '00:00:00.000000'), (TIME '23:59:59', TIME '23:59:59.999', TIME '23:59:59.999999'), (TIME '23:59:59', TIME '23:59:59.999', TIME '23:59:59.999999')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM " + testTable.getName() + " WHERE a = TIME '23:59:59'"))).matches("VALUES BIGINT '2'").isNotFullyPushedDown(FilterNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM " + testTable.getName() + " WHERE b = TIME '23:59:59.999'"))).matches("VALUES BIGINT '2'").isNotFullyPushedDown(FilterNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM " + testTable.getName() + " WHERE c = TIME '23:59:59.999999'"))).matches("VALUES BIGINT '2'").isNotFullyPushedDown(FilterNode.class, new Class[0]);
        }
    }

    @Test
    public void testTimestamp() {
        this.testTimestamp(ZoneOffset.UTC);
        this.testTimestamp(this.jvmZone);
        this.testTimestamp(this.vilnius);
        this.testTimestamp(this.kathmandu);
        this.testTimestamp(TestingSession.DEFAULT_TIME_ZONE_KEY.getZoneId());
    }

    private void testTimestamp(ZoneId sessionZone) {
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        SqlDataTypeTest.create().addRoundTrip("timestamp(3)", "TIMESTAMP '1958-01-01 13:18:03.123'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1958-01-01 13:18:03.123'").addRoundTrip("timestamp(3)", "TIMESTAMP '2019-03-18 10:01:17.987'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2019-03-18 10:01:17.987'").addRoundTrip("timestamp(3)", "TIMESTAMP '2018-10-28 01:33:17.456'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2018-10-28 01:33:17.456'").addRoundTrip("timestamp(3)", "TIMESTAMP '2018-10-28 03:33:33.333'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2018-10-28 03:33:33.333'").addRoundTrip("timestamp(3)", "TIMESTAMP '1970-01-01 00:00:00.000'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1970-01-01 00:00:00.000'").addRoundTrip("timestamp(3)", "TIMESTAMP '1970-01-01 00:13:42.000'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1970-01-01 00:13:42.000'").addRoundTrip("timestamp(3)", "TIMESTAMP '2018-04-01 02:13:55.123'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2018-04-01 02:13:55.123'").addRoundTrip("timestamp(3)", "TIMESTAMP '2018-03-25 03:17:17.000'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2018-03-25 03:17:17.000'").addRoundTrip("timestamp(3)", "TIMESTAMP '1986-01-01 00:13:07.000'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1986-01-01 00:13:07.000'").addRoundTrip("timestamp(0)", "TIMESTAMP '1970-01-01 00:00:00'", (Type)TimestampType.createTimestampType((int)0), "TIMESTAMP '1970-01-01 00:00:00'").addRoundTrip("timestamp(1)", "TIMESTAMP '1970-01-01 00:00:00.1'", (Type)TimestampType.createTimestampType((int)1), "TIMESTAMP '1970-01-01 00:00:00.1'").addRoundTrip("timestamp(2)", "TIMESTAMP '1970-01-01 00:00:00.12'", (Type)TimestampType.createTimestampType((int)2), "TIMESTAMP '1970-01-01 00:00:00.12'").addRoundTrip("timestamp(3)", "TIMESTAMP '1970-01-01 00:00:00.123'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1970-01-01 00:00:00.123'").addRoundTrip("timestamp(4)", "TIMESTAMP '1970-01-01 00:00:00.1234'", (Type)TimestampType.createTimestampType((int)4), "TIMESTAMP '1970-01-01 00:00:00.1234'").addRoundTrip("timestamp(5)", "TIMESTAMP '1970-01-01 00:00:00.12345'", (Type)TimestampType.createTimestampType((int)5), "TIMESTAMP '1970-01-01 00:00:00.12345'").addRoundTrip("timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:00.123456'").addRoundTrip("timestamp(6)", "TIMESTAMP '1969-12-31 23:59:59.123000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1969-12-31 23:59:59.123000'").addRoundTrip("timestamp(6)", "TIMESTAMP '1969-12-31 23:59:59.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1969-12-31 23:59:59.123456'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_timestamp")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_timestamp")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect("test_timestamp")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_timestamp")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert("test_timestamp"));
    }

    @Test
    public void testTimestampCoercion() {
        SqlDataTypeTest.create().addRoundTrip("TIMESTAMP '1970-01-01 00:00:00'", "TIMESTAMP '1970-01-01 00:00:00'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1'", "TIMESTAMP '1970-01-01 00:00:00.1'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.9'", "TIMESTAMP '1970-01-01 00:00:00.9'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123'", "TIMESTAMP '1970-01-01 00:00:00.123'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123000'", "TIMESTAMP '1970-01-01 00:00:00.123000'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.999'", "TIMESTAMP '1970-01-01 00:00:00.999'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456'", "TIMESTAMP '1970-01-01 00:00:00.123456'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.1'", "TIMESTAMP '2020-09-27 12:34:56.1'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.9'", "TIMESTAMP '2020-09-27 12:34:56.9'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123'", "TIMESTAMP '2020-09-27 12:34:56.123'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123000'", "TIMESTAMP '2020-09-27 12:34:56.123000'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.999'", "TIMESTAMP '2020-09-27 12:34:56.999'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123456'", "TIMESTAMP '2020-09-27 12:34:56.123456'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234561'", "TIMESTAMP '1970-01-01 00:00:00.123456'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456499'", "TIMESTAMP '1970-01-01 00:00:00.123456'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456499999'", "TIMESTAMP '1970-01-01 00:00:00.123456'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234565'", "TIMESTAMP '1970-01-01 00:00:00.123457'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.111222333444'", "TIMESTAMP '1970-01-01 00:00:00.111222'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.9999995'", "TIMESTAMP '1970-01-01 00:00:01.000000'").addRoundTrip("TIMESTAMP '1970-01-01 23:59:59.9999995'", "TIMESTAMP '1970-01-02 00:00:00.000000'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.9999995'", "TIMESTAMP '1970-01-01 00:00:00.000000'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.999999499999'", "TIMESTAMP '1969-12-31 23:59:59.999999'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.9999994'", "TIMESTAMP '1969-12-31 23:59:59.999999'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_timestamp_coercion")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_timestamp_coercion"));
    }

    @Test
    public void testArrayTimestamp() {
        this.testArrayTimestamp(ZoneOffset.UTC);
        this.testArrayTimestamp(this.jvmZone);
        this.testArrayTimestamp(this.vilnius);
        this.testArrayTimestamp(this.kathmandu);
        this.testArrayTimestamp(TestingSession.DEFAULT_TIME_ZONE_KEY.getZoneId());
    }

    private void testArrayTimestamp(ZoneId sessionZone) {
        Session session = Session.builder((Session)this.sessionWithArrayAsArray()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        SqlDataTypeTest.create().addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '1958-01-01 13:18:03.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1958-01-01 13:18:03.123']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '2019-03-18 10:01:17.987']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2019-03-18 10:01:17.987']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '2018-10-28 01:33:17.456']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-10-28 01:33:17.456']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '2018-10-28 03:33:33.333']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-10-28 03:33:33.333']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '1970-01-01 00:00:00.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 00:00:00.000']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '1970-01-01 00:13:42.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 00:13:42.000']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '2018-04-01 02:13:55.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-04-01 02:13:55.123']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '2018-03-25 03:17:17.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-03-25 03:17:17.000']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '1986-01-01 00:13:07.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1986-01-01 00:13:07.000']").addRoundTrip("ARRAY(timestamp(1))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)1)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1']").addRoundTrip("ARRAY(timestamp(2))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)2)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123']").addRoundTrip("ARRAY(timestamp(4))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1234']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)4)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1234']").addRoundTrip("ARRAY(timestamp(5))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12345']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)5)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12345']").addRoundTrip("ARRAY(timestamp(6))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123456']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)6)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123456']").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_timestamp"));
        SqlDataTypeTest.create().addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '1958-01-01 13:18:03.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1958-01-01 13:18:03.123']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '2019-03-18 10:01:17.987']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2019-03-18 10:01:17.987']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '2018-10-28 01:33:17.456']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-10-28 01:33:17.456']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '2018-10-28 03:33:33.333']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-10-28 03:33:33.333']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '1970-01-01 00:00:00.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 00:00:00.000']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '1970-01-01 00:13:42.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 00:13:42.000']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '2018-04-01 02:13:55.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-04-01 02:13:55.123']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '2018-03-25 03:17:17.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-03-25 03:17:17.000']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '1986-01-01 00:13:07.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1986-01-01 00:13:07.000']").addRoundTrip("timestamp(1)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)1)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1']").addRoundTrip("timestamp(2)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)2)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123']").addRoundTrip("timestamp(4)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1234']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)4)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1234']").addRoundTrip("timestamp(5)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12345']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)5)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12345']").addRoundTrip("timestamp(6)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123456']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)6)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123456']").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_timestamp"));
    }

    @Test
    public void testTimestampWithTimeZone() {
        this.testTimestampWithTimeZone(true);
        this.testTimestampWithTimeZone(false);
    }

    private void testTimestampWithTimeZone(boolean insertWithTrino) {
        DataTypeTest tests = DataTypeTest.create((boolean)true);
        for (int precision : List.of(Integer.valueOf(3), Integer.valueOf(6))) {
            DataType<ZonedDateTime> dataType = TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(precision, insertWithTrino);
            tests.addRoundTrip(dataType, (Object)this.epoch.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.epoch.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.epoch.atZone(this.fixedOffsetEast));
            tests.addRoundTrip(dataType, (Object)this.epoch.atZone(this.fixedOffsetWest));
            tests.addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(this.fixedOffsetEast));
            tests.addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(this.fixedOffsetWest));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(this.fixedOffsetEast));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(this.fixedOffsetWest));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneId.of("GMT")));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneId.of("UTC")));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneId.of("UTC+00:00")));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInJvmZone.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInJvmZone.atZone(this.jvmZone));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInJvmZone.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInVilnius.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInVilnius.atZone(this.vilnius));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInVilnius.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.timeGapInJvmZone1.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.timeGapInJvmZone1.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.timeGapInJvmZone2.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.timeGapInJvmZone2.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.timeGapInVilnius.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.timeGapInKathmandu.atZone(this.vilnius));
        }
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(1, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 100000000, this.kathmandu));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(2, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 120000000, this.kathmandu));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(3, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123000000, this.kathmandu));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(4, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123400000, this.kathmandu));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(5, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123450000, this.kathmandu));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(6, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123456000, this.kathmandu));
        if (insertWithTrino) {
            tests.execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_timestamp_with_time_zone"));
            tests.execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_timestamp_with_time_zone"));
        } else {
            tests.execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_timestamp_with_time_zone"));
        }
    }

    @Test
    public void testTimestampWithTimeZoneCoercion() {
        SqlDataTypeTest.create().addRoundTrip("TIMESTAMP '1970-01-01 00:00:00 UTC'", "TIMESTAMP '1970-01-01 00:00:00 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1 UTC'", "TIMESTAMP '1970-01-01 00:00:00.1 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.9 UTC'", "TIMESTAMP '1970-01-01 00:00:00.9 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123000 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123000 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.999 UTC'", "TIMESTAMP '1970-01-01 00:00:00.999 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123456 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.1 UTC'", "TIMESTAMP '2020-09-27 12:34:56.1 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.9 UTC'", "TIMESTAMP '2020-09-27 12:34:56.9 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123 UTC'", "TIMESTAMP '2020-09-27 12:34:56.123 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123000 UTC'", "TIMESTAMP '2020-09-27 12:34:56.123000 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.999 UTC'", "TIMESTAMP '2020-09-27 12:34:56.999 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123456 UTC'", "TIMESTAMP '2020-09-27 12:34:56.123456 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234561 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123456 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456499 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123456 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456499999 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123456 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234565 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123457 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.111222333444 UTC'", "TIMESTAMP '1970-01-01 00:00:00.111222 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.9999995 UTC'", "TIMESTAMP '1970-01-01 00:00:01.000000 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 23:59:59.9999995 UTC'", "TIMESTAMP '1970-01-02 00:00:00.000000 UTC'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.9999995 UTC'", "TIMESTAMP '1970-01-01 00:00:00.000000 UTC'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.999999499999 UTC'", "TIMESTAMP '1969-12-31 23:59:59.999999 UTC'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.9999994 UTC'", "TIMESTAMP '1969-12-31 23:59:59.999999 UTC'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_timestamp_tz_coercion")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("test_timestamp_tz_coercion"));
    }

    @Test
    public void testArrayTimestampWithTimeZone() {
        this.testArrayTimestampWithTimeZone(true);
        this.testArrayTimestampWithTimeZone(false);
    }

    private void testArrayTimestampWithTimeZone(boolean insertWithTrino) {
        DataTypeTest tests = DataTypeTest.create();
        for (int precision : List.of(Integer.valueOf(3), Integer.valueOf(6))) {
            DataType<List<ZonedDateTime>> dataType = TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(precision, insertWithTrino);
            tests.addRoundTrip(dataType, Arrays.asList(this.beforeEpoch.atZone(this.jvmZone), this.beforeEpoch.atZone(ZoneOffset.UTC)));
            tests.addRoundTrip(dataType, Arrays.asList(this.afterEpoch.atZone(ZoneOffset.UTC), this.afterEpoch.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeDoubledInJvmZone.atZone(ZoneOffset.UTC)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeDoubledInJvmZone.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeDoubledInVilnius.atZone(ZoneOffset.UTC), this.timeDoubledInVilnius.atZone(this.vilnius), this.timeDoubledInVilnius.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeGapInJvmZone1.atZone(ZoneOffset.UTC), this.timeGapInJvmZone1.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeGapInJvmZone2.atZone(ZoneOffset.UTC), this.timeGapInJvmZone2.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeGapInVilnius.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeGapInKathmandu.atZone(this.vilnius)));
            if (insertWithTrino) continue;
            tests.addRoundTrip(dataType, Arrays.asList(this.timeDoubledInJvmZone.atZone(this.jvmZone)));
        }
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(1, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 100000000, this.kathmandu)));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(2, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 120000000, this.kathmandu)));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(3, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123000000, this.kathmandu)));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(4, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123400000, this.kathmandu)));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(5, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123450000, this.kathmandu)));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(6, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123456000, this.kathmandu)));
        if (insertWithTrino) {
            tests.execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_timestamp_with_time_zone"));
            tests.execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAndInsert(this.sessionWithArrayAsArray(), "test_array_timestamp_with_time_zone"));
        } else {
            tests.execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.postgresCreateAndInsert("test_array_timestamp_with_time_zone"));
        }
    }

    @Test
    public void testJson() {
        SqlDataTypeTest.create().addRoundTrip("json", "JSON '{}'", (Type)JsonType.JSON, "JSON '{}'").addRoundTrip("json", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("json", "JSON 'null'", (Type)JsonType.JSON, "JSON 'null'").addRoundTrip("json", "JSON '123.4'", (Type)JsonType.JSON, "JSON '123.4'").addRoundTrip("json", "JSON '\"abc\"'", (Type)JsonType.JSON, "JSON '\"abc\"'").addRoundTrip("json", "JSON '\"text with '' apostrophes\"'", (Type)JsonType.JSON, "JSON '\"text with '' apostrophes\"'").addRoundTrip("json", "JSON '\"\"'", (Type)JsonType.JSON, "JSON '\"\"'").addRoundTrip("json", "JSON '{\"a\":1,\"b\":2}'", (Type)JsonType.JSON, "JSON '{\"a\":1,\"b\":2}'").addRoundTrip("json", "JSON '{\"a\":[1,2,3],\"b\":{\"aa\":11,\"bb\":[{\"a\":1,\"b\":2},{\"a\":0}]}}'", (Type)JsonType.JSON, "JSON '{\"a\":[1,2,3],\"b\":{\"aa\":11,\"bb\":[{\"a\":1,\"b\":2},{\"a\":0}]}}'").addRoundTrip("json", "JSON '[]'", (Type)JsonType.JSON, "JSON '[]'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_json")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("trino_test_json")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("trino_test_json"));
    }

    @Test
    public void testJsonb() {
        SqlDataTypeTest.create().addRoundTrip("jsonb", "JSON '{}'", (Type)JsonType.JSON, "JSON '{}'").addRoundTrip("jsonb", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("jsonb", "JSON 'null'", (Type)JsonType.JSON, "JSON 'null'").addRoundTrip("jsonb", "JSON '123.4'", (Type)JsonType.JSON, "JSON '123.4'").addRoundTrip("jsonb", "JSON '\"abc\"'", (Type)JsonType.JSON, "JSON '\"abc\"'").addRoundTrip("jsonb", "JSON '\"text with '' apostrophes\"'", (Type)JsonType.JSON, "JSON '\"text with '' apostrophes\"'").addRoundTrip("jsonb", "JSON '\"\"'", (Type)JsonType.JSON, "JSON '\"\"'").addRoundTrip("jsonb", "JSON '{\"a\":1,\"b\":2}'", (Type)JsonType.JSON, "JSON '{\"a\":1,\"b\":2}'").addRoundTrip("jsonb", "JSON '{\"a\":[1,2,3],\"b\":{\"aa\":11,\"bb\":[{\"a\":1,\"b\":2},{\"a\":0}]}}'", (Type)JsonType.JSON, "JSON '{\"a\":[1,2,3],\"b\":{\"aa\":11,\"bb\":[{\"a\":1,\"b\":2},{\"a\":0}]}}'").addRoundTrip("jsonb", "JSON '[]'", (Type)JsonType.JSON, "JSON '[]'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_jsonb"));
    }

    @Test
    public void testHstore() {
        Type mapOfVarcharToVarchar = this.getQueryRunner().getPlannerContext().getTypeManager().getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        SqlDataTypeTest.create().addRoundTrip("hstore", "NULL", mapOfVarcharToVarchar, "CAST(NULL AS MAP(VARCHAR, VARCHAR))").addRoundTrip("hstore", "hstore(ARRAY[]::varchar[])", mapOfVarcharToVarchar, "CAST(MAP() AS MAP(VARCHAR, VARCHAR))").addRoundTrip("hstore", "hstore(ARRAY['key1','value1'])", mapOfVarcharToVarchar, "CAST(MAP(ARRAY['key1'], ARRAY['value1']) AS MAP(VARCHAR, VARCHAR))").addRoundTrip("hstore", "hstore(ARRAY['key1','value1','key2','value2','key3','value3'])", mapOfVarcharToVarchar, "CAST(MAP(ARRAY['key1','key2','key3'], ARRAY['value1','value2','value3']) AS MAP(VARCHAR, VARCHAR))").addRoundTrip("hstore", "hstore(ARRAY['key1',' \" ','key2',' '' ','key3',' ]) '])", mapOfVarcharToVarchar, "CAST(MAP(ARRAY['key1','key2','key3'], ARRAY[' \" ',' '' ',' ]) ']) AS MAP(VARCHAR, VARCHAR))").addRoundTrip("hstore", "hstore(ARRAY['key1',null])", mapOfVarcharToVarchar, "CAST(MAP(ARRAY['key1'], ARRAY[null]) AS MAP(VARCHAR, VARCHAR))").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_hstore"));
        SqlDataTypeTest.create().addRoundTrip("hstore", "NULL", mapOfVarcharToVarchar, "CAST(NULL AS MAP(VARCHAR, VARCHAR))").addRoundTrip("hstore", "MAP()", mapOfVarcharToVarchar, "CAST(MAP() AS MAP(VARCHAR, VARCHAR))").addRoundTrip("hstore", "MAP(ARRAY['key1'], ARRAY['value1'])", mapOfVarcharToVarchar, "CAST(MAP(ARRAY['key1'], ARRAY['value1']) AS MAP(VARCHAR, VARCHAR))").addRoundTrip("hstore", "MAP(ARRAY['key1','key2','key3'], ARRAY['value1','value2','value3'])", mapOfVarcharToVarchar, "CAST(MAP(ARRAY['key1','key2','key3'], ARRAY['value1','value2','value3']) AS MAP(VARCHAR, VARCHAR))").addRoundTrip("hstore", "MAP(ARRAY['key1','key2','key3'], ARRAY[' \" ',' '' ',' ]) '])", mapOfVarcharToVarchar, "CAST(MAP(ARRAY['key1','key2','key3'], ARRAY[' \" ',' '' ',' ]) ']) AS MAP(VARCHAR, VARCHAR))").addRoundTrip("hstore", "MAP(ARRAY['key1'], ARRAY[null])", mapOfVarcharToVarchar, "CAST(MAP(ARRAY['key1'], ARRAY[null]) AS MAP(VARCHAR, VARCHAR))").execute(this.getQueryRunner(), this.postgresCreateAndTrinoInsert("postgresql_test_hstore"));
    }

    @Test
    public void testUuid() {
        SqlDataTypeTest.create().addRoundTrip("uuid", "UUID '00000000-0000-0000-0000-000000000000'", (Type)UuidType.UUID, "UUID '00000000-0000-0000-0000-000000000000'").addRoundTrip("uuid", "UUID '123e4567-e89b-12d3-a456-426655440000'", (Type)UuidType.UUID, "UUID '123e4567-e89b-12d3-a456-426655440000'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_uuid")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("trino_test_uuid")).execute(this.getQueryRunner(), this.trinoCreateAndInsert("trino_test_uuid"));
    }

    @Test
    public void testArrayUuid() {
        Session session = this.sessionWithArrayAsArray();
        SqlDataTypeTest.create().addRoundTrip("uuid[]", "NULL", (Type)new ArrayType((Type)UuidType.UUID), "CAST(NULL AS ARRAY(UUID))").addRoundTrip("uuid[]", "ARRAY[]::uuid[]", (Type)new ArrayType((Type)UuidType.UUID), "CAST(ARRAY[] AS ARRAY(UUID))").addRoundTrip("uuid[]", "ARRAY[UUID 'a0ee-bc99-9c0b-4ef8-bb6d-6bb9-bd38-0a11', UUID '00000000-0000-0000-0000-000000000000']", (Type)new ArrayType((Type)UuidType.UUID), "ARRAY[UUID 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11', UUID '00000000-0000-0000-0000-000000000000']").addRoundTrip("uuid[]", "ARRAY[UUID 'a0eebc999c0b4ef8bb6d6bb9bd380a11', UUID '00000000-0000-0000-0000-000000000000']", (Type)new ArrayType((Type)UuidType.UUID), "ARRAY[UUID 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11', UUID '00000000-0000-0000-0000-000000000000']").addRoundTrip("uuid[]", "ARRAY[UUID '{a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11}', UUID '00000000-0000-0000-0000-000000000000']", (Type)new ArrayType((Type)UuidType.UUID), "ARRAY[UUID 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11', UUID '00000000-0000-0000-0000-000000000000']").addRoundTrip("uuid[]", "ARRAY[UUID '{a0eebc99-9c0b4ef8-bb6d6bb9-bd380a11}', UUID '00000000-0000-0000-0000-000000000000']", (Type)new ArrayType((Type)UuidType.UUID), "ARRAY[UUID 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11', UUID '00000000-0000-0000-0000-000000000000']").addRoundTrip("uuid[]", "ARRAY[UUID '00000000-0000-0000-0000-000000000000', UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59']", (Type)new ArrayType((Type)UuidType.UUID), "ARRAY[UUID '00000000-0000-0000-0000-000000000000', UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59']").addRoundTrip("uuid[]", "ARRAY[UUID '123e4567-e89b-12d3-a456-426655440000', UUID 'c9c0b3f4-3e7e-4e1a-83eb-bb3e1a2c3c7e']", (Type)new ArrayType((Type)UuidType.UUID), "ARRAY[UUID '123e4567-e89b-12d3-a456-426655440000', UUID 'c9c0b3f4-3e7e-4e1a-83eb-bb3e1a2c3c7e']").addRoundTrip("uuid[]", "ARRAY[UUID 'f47ac10b-58cc-4372-a567-0e02b2c3d479', UUID '3c6f4b8e-7a3e-4d7c-bc8e-3a0fbc1c6ad1']", (Type)new ArrayType((Type)UuidType.UUID), "ARRAY[UUID 'f47ac10b-58cc-4372-a567-0e02b2c3d479', UUID '3c6f4b8e-7a3e-4d7c-bc8e-3a0fbc1c6ad1']").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("postgresql_test_array_uuid_or_empty_or_nulls"));
        SqlDataTypeTest.create().addRoundTrip("ARRAY(uuid)", "NULL", (Type)new ArrayType((Type)UuidType.UUID), "CAST(NULL AS ARRAY(UUID))").addRoundTrip("ARRAY(uuid)", "ARRAY[]", (Type)new ArrayType((Type)UuidType.UUID), "CAST(ARRAY[] AS ARRAY(UUID))").addRoundTrip("ARRAY(uuid)", "ARRAY[UUID '00000000-0000-0000-0000-000000000000', UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59']", (Type)new ArrayType((Type)UuidType.UUID), "ARRAY[UUID '00000000-0000-0000-0000-000000000000', UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59']").addRoundTrip("ARRAY(uuid)", "ARRAY[UUID '123e4567-e89b-12d3-a456-426655440000', UUID 'c9c0b3f4-3e7e-4e1a-83eb-bb3e1a2c3c7e']", (Type)new ArrayType((Type)UuidType.UUID), "ARRAY[UUID '123e4567-e89b-12d3-a456-426655440000', UUID 'c9c0b3f4-3e7e-4e1a-83eb-bb3e1a2c3c7e']").addRoundTrip("ARRAY(uuid)", "ARRAY[UUID 'f47ac10b-58cc-4372-a567-0e02b2c3d479', UUID '3c6f4b8e-7a3e-4d7c-bc8e-3a0fbc1c6ad1']", (Type)new ArrayType((Type)UuidType.UUID), "ARRAY[UUID 'f47ac10b-58cc-4372-a567-0e02b2c3d479', UUID '3c6f4b8e-7a3e-4d7c-bc8e-3a0fbc1c6ad1']").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "trino_test_array_uuid_or_empty_or_nulls")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "trino_test_array_uuid_or_empty_or_nulls"));
    }

    @Test
    public void testArrayNulls() {
        Session session = this.sessionWithArrayAsArray();
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_array_nulls", "(col_boolean boolean[], col_smallint smallint[], col_integer integer[], col_bigint bigint[], col_real real[], col_double double precision[], col_uuid uuid[])");){
            this.assertUpdate(session, String.format("INSERT INTO %s VALUES(%s, %s, %s, %s, %s, %s, %s)", table.getName(), "ARRAY[NULL, true]", "ARRAY[NULL, 123]", "ARRAY[NULL, 123]", "ARRAY[NULL, 123]", "ARRAY[NULL, 123.45]", "ARRAY[NULL, 123.45]", "ARRAY[NULL, UUID 'f47ac10b-58cc-4372-a567-0e02b2c3d479']"), 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT col_boolean FROM " + table.getName()))).matches("VALUES CAST(ARRAY[NULL, true] AS ARRAY(boolean))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT col_smallint FROM " + table.getName()))).matches("VALUES CAST(ARRAY[NULL, 123] AS ARRAY(smallint))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT col_integer FROM " + table.getName()))).matches("VALUES CAST(ARRAY[NULL, 123] AS ARRAY(integer))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT col_bigint FROM " + table.getName()))).matches("VALUES CAST(ARRAY[NULL, 123] AS ARRAY(bigint))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT col_real FROM " + table.getName()))).matches("VALUES CAST(ARRAY[NULL, 123.45] AS ARRAY(real))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT col_double FROM " + table.getName()))).matches("VALUES CAST(ARRAY[NULL, 123.45] AS ARRAY(double))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT col_uuid FROM " + table.getName()))).matches("VALUES CAST(ARRAY[NULL, UUID 'f47ac10b-58cc-4372-a567-0e02b2c3d479'] AS ARRAY(uuid))");
        }
    }

    @Test
    public void testMoney() {
        SqlDataTypeTest.create().addRoundTrip("money", "NULL", (Type)VarcharType.createUnboundedVarcharType(), "CAST(NULL AS VARCHAR)").addRoundTrip("money", "10.0", (Type)VarcharType.createUnboundedVarcharType(), "CAST('$10.00' AS VARCHAR)").addRoundTrip("money", "10.54", (Type)VarcharType.createUnboundedVarcharType(), "CAST('$10.54' AS VARCHAR)").addRoundTrip("money", "1.000000042E7", (Type)VarcharType.createUnboundedVarcharType(), "CAST('$10,000,000.42' AS VARCHAR)").execute(this.getQueryRunner(), this.postgresCreateAndInsert("trino_test_money"));
    }

    private void testUnsupportedDataTypeAsIgnored(String dataTypeName, String databaseValue) {
        this.testUnsupportedDataTypeAsIgnored(this.getSession(), dataTypeName, databaseValue);
    }

    private void testUnsupportedDataTypeAsIgnored(Session session, String dataTypeName, String databaseValue) {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable table = new TestTable((SqlExecutor)jdbcSqlExecutor, "unsupported_type", String.format("(key varchar(5), unsupported_column %s)", dataTypeName), (List)ImmutableList.of((Object)"'1', NULL", (Object)("'2', " + databaseValue)));){
            this.assertQuery(session, "SELECT * FROM " + table.getName(), "VALUES 1, 2");
            this.assertQuery(session, "DESC " + table.getName(), "VALUES ('key', 'varchar(5)','', '')");
            this.assertUpdate(session, String.format("INSERT INTO %s VALUES '3'", table.getName()), 1L);
            this.assertQuery(session, "SELECT * FROM " + table.getName(), "VALUES '1', '2', '3'");
        }
    }

    private void testUnsupportedDataTypeConvertedToVarchar(Session session, String dataTypeName, String internalDataTypeName, String databaseValue, String trinoValue) {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable table = new TestTable((SqlExecutor)jdbcSqlExecutor, "unsupported_type", String.format("(key varchar(5), unsupported_column %s)", dataTypeName), (List)ImmutableList.of((Object)"1, NULL", (Object)("2, " + databaseValue)));){
            Session convertToVarchar = Session.builder((Session)session).setCatalogSessionProperty("postgresql", "unsupported_type_handling", UnsupportedTypeHandling.CONVERT_TO_VARCHAR.name()).build();
            this.assertQuery(convertToVarchar, "SELECT * FROM " + table.getName(), String.format("VALUES ('1', NULL), ('2', %s)", trinoValue));
            this.assertQuery(convertToVarchar, String.format("SELECT key FROM %s WHERE unsupported_column = %s", table.getName(), trinoValue), "VALUES '2'");
            this.assertQuery(convertToVarchar, "DESC " + table.getName(), "VALUES ('key', 'varchar(5)', '', ''), ('unsupported_column', 'varchar', '', '')");
            this.assertUpdate(convertToVarchar, String.format("INSERT INTO %s (key, unsupported_column) VALUES ('3', NULL)", table.getName()), 1L);
            this.assertQueryFails(convertToVarchar, String.format("INSERT INTO %s (key, unsupported_column) VALUES ('4', %s)", table.getName(), trinoValue), "\\QUnderlying type that is mapped to VARCHAR is not supported for INSERT: " + internalDataTypeName);
            this.assertUpdate(convertToVarchar, String.format("INSERT INTO %s (key) VALUES '5'", table.getName()), 1L);
            this.assertQuery(convertToVarchar, "SELECT * FROM " + table.getName(), String.format("VALUES ('1', NULL), ('2', %s), ('3', NULL), ('5', NULL)", trinoValue));
        }
    }

    public static DataType<ZonedDateTime> timestampWithTimeZoneDataType(int precision, boolean insertWithTrino) {
        if (insertWithTrino) {
            return TestPostgreSqlTypeMapping.trinoTimestampWithTimeZoneDataType(precision);
        }
        return TestPostgreSqlTypeMapping.postgreSqlTimestampWithTimeZoneDataType(precision);
    }

    public static DataType<ZonedDateTime> trinoTimestampWithTimeZoneDataType(int precision) {
        return DataType.dataType((String)String.format("timestamp(%d) with time zone", precision), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), zonedDateTime -> DateTimeFormatter.ofPattern("'TIMESTAMP '''uuuu-MM-dd HH:mm:ss.SSSSSS VV''").format((TemporalAccessor)zonedDateTime), zonedDateTime -> zonedDateTime.withZoneSameInstant(ZoneId.of("UTC")));
    }

    public static DataType<ZonedDateTime> postgreSqlTimestampWithTimeZoneDataType(int precision) {
        return DataType.dataType((String)String.format("timestamp(%d) with time zone", precision), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), zonedDateTime -> {
            String pattern = String.format("'TIMESTAMP (%d) WITH TIME ZONE '''uuuu-MM-dd HH:mm:ss.SSSSSS VV''", precision);
            return DateTimeFormatter.ofPattern(pattern).format(zonedDateTime.withZoneSameInstant(ZoneOffset.UTC));
        }, zonedDateTime -> DateTimeFormatter.ofPattern("'TIMESTAMP '''uuuu-MM-dd HH:mm:ss.SSSSSS VV''").format((TemporalAccessor)zonedDateTime), zonedDateTime -> zonedDateTime.withZoneSameInstant(ZoneId.of("UTC")));
    }

    public static DataType<List<ZonedDateTime>> arrayOfTimestampWithTimeZoneDataType(int precision, boolean insertWithTrino) {
        if (insertWithTrino) {
            return TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.trinoTimestampWithTimeZoneDataType(precision));
        }
        return TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.postgreSqlTimestampWithTimeZoneDataType(precision), String.format("timestamptz(%d)[]", precision));
    }

    private Session sessionWithArrayAsArray() {
        return Session.builder((Session)this.getSession()).setSystemProperty("postgresql.array_mapping", PostgreSqlConfig.ArrayMapping.AS_ARRAY.name()).build();
    }

    private Session sessionWithDecimalMappingAllowOverflow(RoundingMode roundingMode, int scale) {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "decimal_mapping", DecimalConfig.DecimalMapping.ALLOW_OVERFLOW.name()).setCatalogSessionProperty("postgresql", "decimal_rounding_mode", roundingMode.name()).setCatalogSessionProperty("postgresql", "decimal_default_scale", Integer.valueOf(scale).toString()).build();
    }

    private Session sessionWithDecimalMappingStrict(UnsupportedTypeHandling unsupportedTypeHandling) {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "decimal_mapping", DecimalConfig.DecimalMapping.STRICT.name()).setCatalogSessionProperty("postgresql", "unsupported_type_handling", unsupportedTypeHandling.name()).build();
    }

    private DataSetup trinoCreateAsSelect(String tableNamePrefix) {
        return this.trinoCreateAsSelect(this.getSession(), tableNamePrefix);
    }

    private DataSetup trinoCreateAsSelect(Session session, String tableNamePrefix) {
        return new CreateAsSelectDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    private DataSetup trinoCreateAndInsert(String tableNamePrefix) {
        return this.trinoCreateAndInsert(this.getSession(), tableNamePrefix);
    }

    private DataSetup trinoCreateAndInsert(Session session, String tableNamePrefix) {
        return new CreateAndInsertDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    private DataSetup postgresCreateAndInsert(String tableNamePrefix) {
        return new CreateAndInsertDataSetup((SqlExecutor)new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties()), tableNamePrefix);
    }

    private DataSetup postgresCreateAndTrinoInsert(String tableNamePrefix) {
        return new CreateAndTrinoInsertDataSetup((SqlExecutor)new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties()), new TrinoSqlExecutor(this.getQueryRunner()), tableNamePrefix);
    }

    private static void checkIsGap(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((boolean)TestPostgreSqlTypeMapping.isGap(zone, dateTime), (String)"Expected %s to be a gap in %s", (Object)dateTime, (Object)zone);
    }

    private static boolean isGap(ZoneId zone, LocalDateTime dateTime) {
        return zone.getRules().getValidOffsets(dateTime).isEmpty();
    }

    private static void checkIsDoubled(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((zone.getRules().getValidOffsets(dateTime).size() == 2 ? 1 : 0) != 0, (String)"Expected %s to be doubled in %s", (Object)dateTime, (Object)zone);
    }

    private void assertPostgreSqlQueryFails(@Language(value="SQL") String sql, String expectedMessage) {
        Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute(sql)).cause().hasMessageContaining(expectedMessage);
    }
}

