/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import io.trino.Session;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TestView;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

final class TestPostgreSqlVectorType
extends AbstractTestQueryFramework {
    private TestingPostgreSqlServer postgreSqlServer;

    TestPostgreSqlVectorType() {
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.postgreSqlServer = (TestingPostgreSqlServer)this.closeAfterClass(new TestingPostgreSqlServer("pgvector/pgvector:0.7.2-pg16", false));
        this.postgreSqlServer.execute("CREATE EXTENSION vector SCHEMA public");
        return PostgreSqlQueryRunner.builder(this.postgreSqlServer).build();
    }

    @Test
    void testVector() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(v vector(1))");){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES ('[1]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES ARRAY[REAL '1.0']");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE v = ARRAY[REAL '1.0']"))).matches("VALUES ARRAY[REAL '1.0']");
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table.getName() + " WHERE v = ARRAY[REAL '2.0']");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES ('[NaN]')")).hasMessageContaining("NaN not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES ('[-Infinity]')")).hasMessageContaining("infinite value not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES ('[+Infinity]')")).hasMessageContaining("infinite value not allowed in vector");
        }
        table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(v vector(2))");
        try {
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES ('[1.1,2.2]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES ARRAY[REAL '1.1', REAL '2.2']");
        }
        finally {
            table.close();
        }
        table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(v vector(3))");
        try {
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES ('[1.11,2.22,3.33]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES ARRAY[REAL '1.11', REAL '2.22', REAL '3.33']");
        }
        finally {
            table.close();
        }
    }

    @Test
    void testVectorArray() {
        Session arrayAsArray = this.arrayMappingSession(PostgreSqlConfig.ArrayMapping.AS_ARRAY);
        Session arrayAsJson = this.arrayMappingSession(PostgreSqlConfig.ArrayMapping.AS_JSON);
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector_array", "(v vector(1)[])");){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (array['[1]'::vector])");
            this.assertQueryFails(arrayAsArray, "INSERT INTO " + table.getName() + " VALUES ARRAY[ARRAY[REAL '2']]", "(?s).*invalid input syntax for type vector.*");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(arrayAsArray, "SELECT * FROM " + table.getName()))).matches("VALUES ARRAY[ARRAY[REAL '1.0']]");
            this.assertQueryFails(arrayAsJson, "INSERT INTO " + table.getName() + " VALUES JSON '[[2]]'", "Writing to array type is unsupported");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(arrayAsJson, "SELECT * FROM " + table.getName()))).matches("VALUES JSON '[[1.0]]'");
        }
    }

    private Session arrayMappingSession(PostgreSqlConfig.ArrayMapping arrayMapping) {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "array_mapping", arrayMapping.name()).build();
    }

    @Test
    void testVectorUnsupportedWrite() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector_writes", "(v vector(1))");){
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES ARRAY[REAL '1.0']", "Writing to vector type is unsupported");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES ARRAY[REAL '1.0', REAL '2.0']", "Writing to vector type is unsupported");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES ARRAY[]", "Writing to vector type is unsupported");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES ARRAY[nan()]", "Writing to vector type is unsupported");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES ARRAY[-infinity()]", "Writing to vector type is unsupported");
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES ARRAY[+infinity()]", "Writing to vector type is unsupported");
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table.getName());
        }
    }

    @Test
    void testVectorNull() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector_null", "(id int, v1 vector(1), v2 vector(2))");){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (1, NULL, NULL), (2, '[1]', '[1,2]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT v1 FROM " + table.getName()))).matches("VALUES CAST(NULL AS ARRAY(REAL)), ARRAY[REAL '1.0']");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE v1 IS NULL"))).matches("VALUES 1");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE v1 IS NOT NULL"))).matches("VALUES 2");
        }
    }

    @Test
    void testVectorArbitraryDimension() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector_arbitrary", "(id int, v vector)");){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (1, '[1]'), (2, '[1,2]'), (3, '[1,2,3]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT v FROM " + table.getName()))).matches("VALUES ARRAY[REAL '1.0'], ARRAY[REAL '1.0', REAL '2.0'], ARRAY[REAL '1.0', REAL '2.0', REAL '3.0']");
            this.postgreSqlServer.execute("SELECT v <-> '[4,5,6]' FROM " + table.getName() + " WHERE id = 3");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <-> '[4,5,6]' FROM " + table.getName())).hasMessageContaining("different vector dimensions");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (4, '[]')")).hasMessageContaining("vector must have at least 1 dimension");
        }
    }

    @Test
    void testVectorMaxDimension() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector_max", "(v vector(16000))");){
            String postgresValue = IntStream.rangeClosed(1, 16000).mapToObj(String::valueOf).collect(Collectors.joining(","));
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES ('[" + postgresValue + "]')");
            String string = "REAL '%s'";
            String trinoValue = IntStream.rangeClosed(1, 16000).mapToObj(arg_0 -> TestPostgreSqlVectorType.lambda$testVectorMaxDimension$0("REAL '%s'", arg_0)).collect(Collectors.joining(","));
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT v FROM " + table.getName()))).matches("VALUES ARRAY[" + trinoValue + "]");
        }
    }

    @Test
    void testVectorUnsupportedDimension() {
        Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("CREATE TABLE test_vector_unsupported (v vector(-1))")).hasMessageContaining("dimensions for type vector must be at least 1");
        Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("CREATE TABLE test_vector_unsupported (v vector(0))")).hasMessageContaining("dimensions for type vector must be at least 1");
        Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("CREATE TABLE test_vector_unsupported (v vector(16001))")).hasMessageContaining("dimensions for type vector cannot exceed 16000");
    }

    @Test
    void testEuclideanDistanceCompatibility() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(id int, v vector(3))");
             TestView view = new TestView(this.postgreSqlServer::execute, "test_euclidean_distance", "SELECT v <-> '[7,8,9]' FROM " + table.getName());){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (1, '[1,2,3]'), (2, '[4,5,6]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT euclidean_distance(v, ARRAY[7,8,9]) FROM " + table.getName()))).matches("SELECT * FROM tpch." + view.getName()).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY euclidean_distance(v, ARRAY[7,8,9]) LIMIT 1"))).isFullyPushedDown();
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <-> '[NaN]' FROM " + table.getName())).hasMessageContaining("NaN not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <-> '[-Infinity]' FROM " + table.getName())).hasMessageContaining("infinite value not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <-> '[+Infinity]' FROM " + table.getName())).hasMessageContaining("infinite value not allowed in vector");
        }
    }

    @Test
    void testEuclideanDistanceUnsupportedPushdown() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(id int, v vector(1))");){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (1, '[10]'), (2, '[20]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE euclidean_distance(v, ARRAY[1]) < 1"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY euclidean_distance(v, ARRAY[DOUBLE '1.7976931348623157E+309']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY euclidean_distance(v, ARRAY[DOUBLE '-1.7976931348623157E+308']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY euclidean_distance(v, ARRAY[REAL 'Infinity']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY euclidean_distance(v, ARRAY[REAL '-Infinity']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY euclidean_distance(v, ARRAY[REAL 'NaN']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY euclidean_distance(v, ARRAY[CAST(NULL AS REAL)]) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY euclidean_distance(v, NULL) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
        }
    }

    @Test
    void testPgVectorUnsupportedEuclideanDistance() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(v vector(1))");){
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <-> '[1.7976931348623157E+309]' FROM " + table.getName())).hasMessageContaining("out of range for type vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <-> '[NaN]' FROM " + table.getName())).hasMessageContaining("NaN not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <-> '[-Infinity]' FROM " + table.getName())).hasMessageContaining("infinite value not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <-> '[+Infinity]' FROM " + table.getName())).hasMessageContaining("infinite value not allowed in vector");
        }
    }

    @Test
    void testDotProductCompatibility() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(id int, v vector(3))");
             TestView view = new TestView(this.postgreSqlServer::execute, "test_dot_product", "SELECT v <#> '[7,8,9]' FROM " + table.getName());){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (1, '[1,2,3]'), (2, '[4,5,6]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT -dot_product(v, ARRAY[7,8,9]) FROM " + table.getName()))).matches("SELECT * FROM tpch." + view.getName()).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY -dot_product(v, ARRAY[7,8,9]) LIMIT 1"))).isFullyPushedDown();
        }
    }

    @Test
    void testPgVectorUnsupportedNegativeInnerProduct() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(v vector(1))");){
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <#> '[1.7976931348623157E+309]' FROM " + table.getName())).hasMessageContaining("out of range for type vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <#> '[NaN]' FROM " + table.getName())).hasMessageContaining("NaN not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <#> '[-Infinity]' FROM " + table.getName())).hasMessageContaining("infinite value not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <#> '[+Infinity]' FROM " + table.getName())).hasMessageContaining("infinite value not allowed in vector");
        }
    }

    @Test
    void testDotProductUnsupportedPushdown() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(id int, v vector(1))");){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (1, '[10]'), (2, '[20]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE -dot_product(v, ARRAY[1]) < 1"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY -dot_product(v, ARRAY[DOUBLE '1.7976931348623157E+309']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY -dot_product(v, ARRAY[DOUBLE '-1.7976931348623157E+308']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY -dot_product(v, ARRAY[REAL 'Infinity']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY -dot_product(v, ARRAY[REAL '-Infinity']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY -dot_product(v, ARRAY[REAL 'NaN']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY -dot_product(v, ARRAY[CAST(NULL AS REAL)]) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY -dot_product(v, NULL) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
        }
    }

    @Test
    void testCosineDistanceCompatibility() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(id int, v vector(3))");
             TestView view = new TestView(this.postgreSqlServer::execute, "test_cosine_distance", "SELECT v <=> '[7,8,9]' FROM " + table.getName());){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (1, '[1,2,3]'), (2, '[4,5,6]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT cosine_distance(v, ARRAY[7,8,9]) FROM " + table.getName()))).matches("SELECT * FROM tpch." + view.getName()).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY cosine_distance(v, ARRAY[4,5,6]) LIMIT 1"))).isFullyPushedDown();
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <=> '[NaN]' FROM " + table.getName())).hasMessageContaining("NaN not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <=> '[-Infinity]' FROM " + table.getName())).hasMessageContaining("infinite value not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <=> '[+Infinity]' FROM " + table.getName())).hasMessageContaining("infinite value not allowed in vector");
        }
    }

    @Test
    void testCosineDistanceUnsupportedPushdown() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(id int, v vector(1))");){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (1, '[10]'), (2, '[20]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE cosine_distance(v, ARRAY[1]) < 1"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY cosine_distance(v, ARRAY[DOUBLE '1.7976931348623157E+309']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY cosine_distance(v, ARRAY[DOUBLE '-1.7976931348623157E+308']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY cosine_distance(v, ARRAY[REAL 'Infinity']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY cosine_distance(v, ARRAY[REAL '-Infinity']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY cosine_distance(v, ARRAY[REAL 'NaN']) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY cosine_distance(v, ARRAY[CAST(NULL AS REAL)]) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " ORDER BY cosine_distance(v, NULL) LIMIT 1"))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
        }
    }

    @Test
    void testPgVectorUnsupportedCosineDistance() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_vector", "(v vector(1))");){
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <=> '[1.7976931348623157E+309]' FROM " + table.getName())).hasMessageContaining("out of range for type vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <=> '[-1.7976931348623157E+308]' FROM " + table.getName())).hasMessageContaining("out of range for type vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <=> '[NaN]' FROM " + table.getName())).hasMessageContaining("NaN not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <=> '[-Infinity]' FROM " + table.getName())).hasMessageContaining("infinite value not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <=> '[+Infinity]' FROM " + table.getName())).hasMessageContaining("infinite value not allowed in vector");
            Assertions.assertThatThrownBy(() -> this.postgreSqlServer.execute("SELECT v <=> '[NULL]' FROM " + table.getName())).hasMessageContaining("invalid input");
        }
    }

    @RepeatedTest(value=10)
    void testDuplicateColumnWithUnion() {
        try (TestTable table = new TestTable(this.postgreSqlServer::execute, "test_union", "(id int, v vector(3))");){
            this.postgreSqlServer.execute("INSERT INTO " + table.getName() + " VALUES (1, '[1,2,3]'), (2, '[4,5,6]')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " UNION ALL (SELECT id FROM " + table.getName() + " ORDER BY cosine_distance(v, ARRAY[4,5,6]) LIMIT 1)"))).matches("VALUES 1, 2, 2");
        }
    }

    private static /* synthetic */ String lambda$testVectorMaxDimension$0(String rec$, Object xva$0) {
        return "REAL '%s'".formatted(xva$0);
    }
}

