/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestRemoteQueryCommentLogging
extends AbstractTestQueryFramework {
    private TestingPostgreSqlServer postgreSqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.postgreSqlServer = (TestingPostgreSqlServer)this.closeAfterClass(new TestingPostgreSqlServer());
        return PostgreSqlQueryRunner.builder(this.postgreSqlServer).addConnectorProperties(Map.of("query.comment-format", "query executed by $USER")).setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.CUSTOMER, (Object)TpchTable.NATION)).build();
    }

    @Test
    public void testShouldLogContextInComment() {
        ((ListAssert)Assertions.assertThat(this.postgreSqlServer.recordEventsForOperations(() -> this.getQueryRunner().execute("CREATE TABLE postgresql.tpch.log_nation_test_table AS (SELECT * FROM postgresql.tpch.nation)")).stopEventsRecording().streamQueriesContaining("\"tpch\".\"tpch\".\"tmp_trino_", new String[0])).allMatch(query -> query.endsWith("/*query executed by user*/"))).size().isGreaterThanOrEqualTo(3);
        ((ListAssert)Assertions.assertThat(this.postgreSqlServer.recordEventsForOperations(() -> this.getQueryRunner().execute("SELECT * FROM postgresql.tpch.log_nation_test_table")).stopEventsRecording().streamQueriesContaining("log_nation_test_table", new String[0])).allMatch(query -> query.endsWith("/*query executed by user*/"))).size().isEqualTo(1);
        ((ListAssert)Assertions.assertThat(this.postgreSqlServer.recordEventsForOperations(() -> this.getQueryRunner().execute("DELETE FROM postgresql.tpch.log_nation_test_table")).stopEventsRecording().streamQueriesContaining("\"log_nation_test_table\"", new String[0])).allMatch(query -> query.endsWith("/*query executed by user*/"))).size().isEqualTo(1);
        ((ListAssert)Assertions.assertThat(this.postgreSqlServer.recordEventsForOperations(() -> this.getQueryRunner().execute("INSERT INTO postgresql.tpch.log_nation_test_table VALUES (1, 'nation', 1, 'nation')")).stopEventsRecording().streamQueriesContaining("log_nation_test_table", "\"tpch\".\"tpch\".\"tmp_trino_")).allMatch(query -> query.endsWith("/*query executed by user*/"))).size().isGreaterThanOrEqualTo(1);
        ((ListAssert)Assertions.assertThat(this.postgreSqlServer.recordEventsForOperations(() -> this.getQueryRunner().execute("DROP TABLE postgresql.tpch.log_nation_test_table")).stopEventsRecording().streamQueriesContaining("log_nation_test_table", new String[0])).allMatch(query -> query.endsWith("/*query executed by user*/"))).size().isEqualTo(1);
    }

    @Test
    public void testShouldLogContextInCommentForTableFunctionsQueryPassthrough() {
        ((ListAssert)((ListAssert)Assertions.assertThat(this.postgreSqlServer.recordEventsForOperations(() -> this.getQueryRunner().execute("SELECT * FROM TABLE( postgresql.system.query(query => 'SELECT name FROM tpch.nation WHERE nationkey = 0'))")).stopEventsRecording().streamQueriesContaining("tpch.nation", new String[0])).allMatch(query -> query.contains("SELECT name FROM tpch.nation WHERE nationkey = 0"))).allMatch(query -> query.endsWith("/*query executed by user*/"))).size().isEqualTo(1);
    }
}

