/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import io.airlift.concurrent.Threads;
import io.airlift.testing.Closeables;
import io.trino.plugin.jdbc.RemoteDatabaseEvent;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.testing.assertions.Assert;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTestingPostgreSqlServer {
    private final ExecutorService threadPool = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"TestTestingPostgreSqlServer-%d"));
    private final TestingPostgreSqlServer postgreSqlServer = new TestingPostgreSqlServer();

    @AfterAll
    public void tearDown() throws Exception {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        autoCloseableArray[0] = this.postgreSqlServer;
        autoCloseableArray[1] = this.threadPool::shutdownNow;
        Closeables.closeAll((AutoCloseable[])autoCloseableArray);
    }

    @Test
    public void testCapturingSuccessfulStatement() {
        String sql = "SELECT 1";
        RemoteDatabaseEvent event = new RemoteDatabaseEvent(sql, RemoteDatabaseEvent.Status.RUNNING);
        Assertions.assertThat(this.postgreSqlServer.getRemoteDatabaseEvents()).doesNotContain((Object[])new RemoteDatabaseEvent[]{event});
        this.postgreSqlServer.execute(sql);
        Assert.assertEventually(() -> Assertions.assertThat(this.postgreSqlServer.getRemoteDatabaseEvents()).contains((Object[])new RemoteDatabaseEvent[]{event}));
    }

    @Test
    @Timeout(value=60L)
    public void testCapturingCancelledStatement() throws Exception {
        String sql = "SELECT pg_sleep(60)";
        RemoteDatabaseEvent running = new RemoteDatabaseEvent(sql, RemoteDatabaseEvent.Status.RUNNING);
        RemoteDatabaseEvent cancelled = new RemoteDatabaseEvent(sql, RemoteDatabaseEvent.Status.CANCELLED);
        Assertions.assertThat(this.postgreSqlServer.getRemoteDatabaseEvents()).doesNotContain((Object[])new RemoteDatabaseEvent[]{running, cancelled});
        try (Connection connection = DriverManager.getConnection(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
             Statement statement = connection.createStatement();){
            Future<Boolean> executeFuture = this.threadPool.submit(() -> statement.execute(sql));
            Assert.assertEventually(() -> Assertions.assertThat(this.postgreSqlServer.getRemoteDatabaseEvents()).contains((Object[])new RemoteDatabaseEvent[]{running}));
            statement.cancel();
            Assertions.assertThatThrownBy(executeFuture::get).hasRootCauseInstanceOf(SQLException.class).hasRootCauseMessage("ERROR: canceling statement due to user request");
        }
        Assert.assertEventually(() -> Assertions.assertThat(this.postgreSqlServer.getRemoteDatabaseEvents()).contains((Object[])new RemoteDatabaseEvent[]{cancelled}));
    }
}

