/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.trino.plugin.jdbc.RemoteDatabaseEvent;
import io.trino.plugin.jdbc.RemoteLogTracingEvent;
import io.trino.testing.containers.TestContainers;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Language;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.utility.DockerImageName;

public class TestingPostgreSqlServer
implements AutoCloseable {
    public static final String DEFAULT_IMAGE_NAME = "postgres:12";
    private static final String USER = "test";
    private static final String PASSWORD = "test";
    private static final String DATABASE = "tpch";
    private static final String LOG_PREFIX_REGEXP = "^([-:0-9. ]+UTC \\[[0-9]+\\] )";
    private static final String LOG_RUNNING_STATEMENT_PREFIX = "LOG:  execute <unnamed>";
    private static final String LOG_CANCELLATION_EVENT = "ERROR:  canceling statement due to user request";
    private static final Pattern SQL_QUERY_FIND_PATTERN = Pattern.compile("^(: |/C_\\d: )(.*)");
    private static final String LOG_CANCELLED_STATEMENT_PREFIX = "STATEMENT:  ";
    private final PostgreSQLContainer<?> dockerContainer;
    private final Set<RemoteLogTracingEvent> tracingEvents = Sets.newConcurrentHashSet();
    private final Closeable cleanup;

    public TestingPostgreSqlServer() {
        this(false);
    }

    public TestingPostgreSqlServer(boolean shouldExposeFixedPorts) {
        this(DEFAULT_IMAGE_NAME, shouldExposeFixedPorts);
    }

    public TestingPostgreSqlServer(String dockerImageName, boolean shouldExposeFixedPorts) {
        this(DockerImageName.parse((String)dockerImageName), shouldExposeFixedPorts);
    }

    public TestingPostgreSqlServer(DockerImageName dockerImageName, boolean shouldExposeFixedPorts) {
        this.dockerContainer = (PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(dockerImageName).withStartupAttempts(3)).withDatabaseName(DATABASE).withUsername("test").withPassword("test").withLogConsumer((Consumer)new RemoteDatabaseEventLogConsumer())).withCommand(new String[]{"postgres", "-c", "log_destination=stderr", "-c", "log_statement=all"});
        if (shouldExposeFixedPorts) {
            TestContainers.exposeFixedPorts(this.dockerContainer);
        }
        this.cleanup = TestContainers.startOrReuse(this.dockerContainer);
        this.execute("CREATE SCHEMA IF NOT EXISTS tpch");
    }

    protected void startTracingDatabaseEvent(RemoteLogTracingEvent event) {
        this.tracingEvents.add(event);
    }

    protected void stopTracingDatabaseEvent(RemoteLogTracingEvent event) {
        this.tracingEvents.remove(event);
    }

    public void execute(@Language(value="SQL") String sql) {
        TestingPostgreSqlServer.execute(this.getJdbcUrl(), this.getProperties(), sql);
    }

    private static void execute(String url, Properties properties, String sql) {
        try (Connection connection = DriverManager.getConnection(url, properties);
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    DatabaseEventsRecorder recordEventsForOperations(Runnable operation) {
        DatabaseEventsRecorder events = DatabaseEventsRecorder.startRecording(this);
        operation.run();
        return events;
    }

    protected List<RemoteDatabaseEvent> getRemoteDatabaseEvents() {
        List<String> logs = this.getLogs();
        Iterator<String> logsIterator = logs.iterator();
        ImmutableList.Builder events = ImmutableList.builder();
        while (logsIterator.hasNext()) {
            String cancelledStatementLogLine;
            Matcher matcher;
            String logLine = logsIterator.next().replaceAll(LOG_PREFIX_REGEXP, "");
            if (logLine.startsWith(LOG_RUNNING_STATEMENT_PREFIX) && (matcher = SQL_QUERY_FIND_PATTERN.matcher(logLine.substring(LOG_RUNNING_STATEMENT_PREFIX.length()))).find()) {
                String sqlStatement = matcher.group(2);
                events.add((Object)new RemoteDatabaseEvent(sqlStatement, RemoteDatabaseEvent.Status.RUNNING));
            }
            if (!logLine.equals(LOG_CANCELLATION_EVENT) || !(cancelledStatementLogLine = logsIterator.next().replaceAll(LOG_PREFIX_REGEXP, "")).startsWith(LOG_CANCELLED_STATEMENT_PREFIX)) continue;
            events.add((Object)new RemoteDatabaseEvent(cancelledStatementLogLine.substring(LOG_CANCELLED_STATEMENT_PREFIX.length()), RemoteDatabaseEvent.Status.CANCELLED));
        }
        return events.build();
    }

    private List<String> getLogs() {
        return (List)Stream.of(this.dockerContainer.getLogs().split("\n")).filter(Predicate.not(String::isBlank)).collect(ImmutableList.toImmutableList());
    }

    public String getUser() {
        return "test";
    }

    public String getPassword() {
        return "test";
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("user", "test");
        properties.setProperty("password", "test");
        properties.setProperty("currentSchema", "tpch,public");
        return properties;
    }

    public String getJdbcUrl() {
        return String.format("jdbc:postgresql://%s:%s/%s", this.dockerContainer.getHost(), this.dockerContainer.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue()), DATABASE);
    }

    @Override
    public void close() {
        try {
            this.cleanup.close();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private class RemoteDatabaseEventLogConsumer
    implements Consumer<OutputFrame> {
        private boolean cancellationHit;

        private RemoteDatabaseEventLogConsumer() {
        }

        @Override
        public void accept(OutputFrame outputFrame) {
            if (TestingPostgreSqlServer.this.tracingEvents.isEmpty()) {
                return;
            }
            this.buildEvent(outputFrame).ifPresent(remoteDatabaseEvent -> TestingPostgreSqlServer.this.tracingEvents.forEach(tracingEvent -> tracingEvent.accept(remoteDatabaseEvent)));
        }

        private Optional<RemoteDatabaseEvent> buildEvent(OutputFrame outputFrame) {
            Matcher matcher;
            String logLine = outputFrame.getUtf8StringWithoutLineEnding().replaceAll(TestingPostgreSqlServer.LOG_PREFIX_REGEXP, "");
            if (this.cancellationHit) {
                this.cancellationHit = false;
                if (logLine.startsWith(TestingPostgreSqlServer.LOG_CANCELLED_STATEMENT_PREFIX)) {
                    return Optional.of(new RemoteDatabaseEvent(logLine.substring(TestingPostgreSqlServer.LOG_CANCELLED_STATEMENT_PREFIX.length()), RemoteDatabaseEvent.Status.CANCELLED));
                }
            }
            if (logLine.equals(TestingPostgreSqlServer.LOG_CANCELLATION_EVENT)) {
                this.cancellationHit = true;
            }
            if (logLine.startsWith(TestingPostgreSqlServer.LOG_RUNNING_STATEMENT_PREFIX) && (matcher = SQL_QUERY_FIND_PATTERN.matcher(logLine.substring(TestingPostgreSqlServer.LOG_RUNNING_STATEMENT_PREFIX.length()))).find()) {
                String sqlStatement = matcher.group(2);
                return Optional.of(new RemoteDatabaseEvent(sqlStatement, RemoteDatabaseEvent.Status.RUNNING));
            }
            return Optional.empty();
        }
    }

    public static class DatabaseEventsRecorder {
        private final Supplier<Stream<String>> loggedQueriesSource;

        private DatabaseEventsRecorder(Supplier<Stream<String>> loggedQueriesSource) {
            this.loggedQueriesSource = Objects.requireNonNull(loggedQueriesSource, "loggedQueriesSource is null");
        }

        static DatabaseEventsRecorder startRecording(TestingPostgreSqlServer server) {
            int startingEventsCount = server.getRemoteDatabaseEvents().size();
            return new DatabaseEventsRecorder(() -> server.getRemoteDatabaseEvents().stream().skip(startingEventsCount).map(RemoteDatabaseEvent::getQuery));
        }

        public DatabaseEventsRecorder stopEventsRecording() {
            List queries = (List)this.loggedQueriesSource.get().collect(ImmutableList.toImmutableList());
            return new DatabaseEventsRecorder(queries::stream);
        }

        public Stream<String> streamQueriesContaining(String queryPart, String ... alternativeQueryParts) {
            ImmutableList queryParts = ImmutableList.builder().add((Object)queryPart).addAll((Iterable)ImmutableList.copyOf((Object[])alternativeQueryParts)).build();
            return this.loggedQueriesSource.get().filter(arg_0 -> DatabaseEventsRecorder.lambda$streamQueriesContaining$0((List)queryParts, arg_0));
        }

        private static /* synthetic */ boolean lambda$streamQueriesContaining$0(List queryParts, String query) {
            return queryParts.stream().anyMatch(query::contains);
        }
    }
}

