/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.mapper.CaseStrategy;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;

public final class ReflectionMapperUtil {
    private ReflectionMapperUtil() {
        throw new UtilityClassException();
    }

    @Deprecated(since="3.34.0", forRemoval=true)
    public static List<String> getColumnNames(ResultSet rs) throws SQLException {
        return ReflectionMapperUtil.getColumnNames(rs, CaseStrategy.LOCALE_LOWER);
    }

    public static List<String> getColumnNames(ResultSet rs, UnaryOperator<String> caseStrategy) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        int count = metadata.getColumnCount();
        ArrayList<String> columnNames = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            columnNames.add((String)caseStrategy.apply(metadata.getColumnLabel(i + 1)));
        }
        return columnNames;
    }

    public static OptionalInt findColumnIndex(String paramName, List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers, Supplier<String> debugName) {
        OptionalInt result = OptionalInt.empty();
        block0: for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            for (ColumnNameMatcher strategy : columnNameMatchers) {
                if (!strategy.columnNameMatches(columnName, paramName)) continue;
                if (result.isPresent()) {
                    throw new IllegalArgumentException(String.format("'%s' (%s) matches multiple columns: '%s' (%d) and '%s' (%d)", debugName.get(), paramName, columnNames.get(result.getAsInt()), result.getAsInt(), columnNames.get(i), i));
                }
                result = OptionalInt.of(i);
                continue block0;
            }
        }
        return result;
    }

    public static boolean anyColumnsStartWithPrefix(Collection<String> columnNames, String prefix, List<ColumnNameMatcher> columnNameMatchers) {
        return columnNames.stream().anyMatch(columnName -> columnNameMatchers.stream().anyMatch(matcher -> matcher.columnNameStartsWith((String)columnName, prefix)));
    }

    public static String addPropertyNamePrefix(String prefix, String name) {
        if (prefix.isEmpty()) {
            return name;
        }
        return prefix + "." + name;
    }
}

