/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Throwables;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.function.CheckedRunnable;
import dev.failsafe.function.CheckedSupplier;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.ForRetrying;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.RetryStrategy;
import io.trino.plugin.jdbc.RetryingConnectionFactory;
import io.trino.plugin.jdbc.RetryingJdbcClient;
import io.trino.plugin.jdbc.jmx.StatisticsAwareConnectionFactory;
import io.trino.plugin.jdbc.jmx.StatisticsAwareJdbcClient;
import io.trino.spi.TrinoException;
import java.sql.SQLTransientException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Set;

public class RetryingModule
extends AbstractModule {
    public void configure() {
        this.bind(ConnectionFactory.class).annotatedWith(ForRetrying.class).to(Key.get(StatisticsAwareConnectionFactory.class)).in(Scopes.SINGLETON);
        this.bind(RetryingConnectionFactory.class).in(Scopes.SINGLETON);
        this.bind(JdbcClient.class).annotatedWith(ForRetrying.class).to(Key.get(StatisticsAwareJdbcClient.class)).in(Scopes.SINGLETON);
        this.bind(RetryingJdbcClient.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), RetryStrategy.class).addBinding().to(OnSqlTransientExceptionRetryStrategy.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public RetryPolicy<Object> createRetryPolicy(Set<RetryStrategy> retryStrategies) {
        return ((RetryPolicyBuilder)RetryPolicy.builder().withMaxDuration(Duration.of(30L, ChronoUnit.SECONDS)).withMaxAttempts(5).withBackoff(50L, 5000L, ChronoUnit.MILLIS, 4.0).handleIf(throwable -> RetryingModule.isExceptionRecoverable(retryStrategies, throwable))).abortOn(TrinoException.class).build();
    }

    public static <T> T retry(RetryPolicy<Object> policy, CheckedSupplier<T> supplier) {
        return (T)Failsafe.with(policy, (Policy[])new RetryPolicy[0]).get(supplier);
    }

    public static void retry(RetryPolicy<Object> policy, CheckedRunnable runnable) {
        Failsafe.with(policy, (Policy[])new RetryPolicy[0]).run(runnable);
    }

    private static boolean isExceptionRecoverable(Set<RetryStrategy> retryStrategies, Throwable throwable) {
        return retryStrategies.stream().anyMatch(retryStrategy -> retryStrategy.isExceptionRecoverable(throwable));
    }

    private static class OnSqlTransientExceptionRetryStrategy
    implements RetryStrategy {
        private OnSqlTransientExceptionRetryStrategy() {
        }

        @Override
        public boolean isExceptionRecoverable(Throwable exception) {
            return Throwables.getCausalChain((Throwable)exception).stream().anyMatch(SQLTransientException.class::isInstance);
        }
    }
}

