/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.aggregation;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.aggregation.AggregateFunctionPatterns;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import java.util.Objects;
import java.util.Optional;

public class ImplementCount
implements AggregateFunctionRule<JdbcExpression, ParameterizedExpression> {
    private static final Capture<Variable> ARGUMENT = Capture.newCapture();
    private final JdbcTypeHandle bigintTypeHandle;

    public ImplementCount(JdbcTypeHandle bigintTypeHandle) {
        this.bigintTypeHandle = Objects.requireNonNull(bigintTypeHandle, "bigintTypeHandle is null");
    }

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"count")).with(AggregateFunctionPatterns.singleArgument().matching(ConnectorExpressionPatterns.variable().capturedAs(ARGUMENT)));
    }

    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext<ParameterizedExpression> context) {
        Variable argument = (Variable)captures.get(ARGUMENT);
        Verify.verify((aggregateFunction.getOutputType() == BigintType.BIGINT ? 1 : 0) != 0);
        ParameterizedExpression rewrittenArgument = (ParameterizedExpression)context.rewriteExpression((ConnectorExpression)argument).orElseThrow();
        return Optional.of(new JdbcExpression(String.format("count(%s)", rewrittenArgument.expression()), rewrittenArgument.parameters(), this.bigintTypeHandle));
    }
}

