/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.expression.GenericRewrite;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.expression.RewriteAnd;
import io.trino.plugin.jdbc.expression.RewriteExactNumericConstant;
import io.trino.plugin.jdbc.expression.RewriteOr;
import io.trino.plugin.jdbc.expression.RewriteVarcharConstant;
import io.trino.plugin.jdbc.expression.RewriteVariable;
import io.trino.spi.connector.ConnectorSession;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class JdbcConnectorExpressionRewriterBuilder {
    private final ImmutableSet.Builder<ConnectorExpressionRule<?, ParameterizedExpression>> rules = ImmutableSet.builder();
    private final Map<String, Set<String>> typeClasses = new HashMap<String, Set<String>>();

    public static JdbcConnectorExpressionRewriterBuilder newBuilder() {
        return new JdbcConnectorExpressionRewriterBuilder();
    }

    private JdbcConnectorExpressionRewriterBuilder() {
    }

    public JdbcConnectorExpressionRewriterBuilder addStandardRules(Function<String, String> identifierQuote) {
        this.add(new RewriteVariable(identifierQuote));
        this.add(new RewriteVarcharConstant());
        this.add(new RewriteExactNumericConstant());
        this.add(new RewriteAnd());
        this.add(new RewriteOr());
        return this;
    }

    public JdbcConnectorExpressionRewriterBuilder add(ConnectorExpressionRule<?, ParameterizedExpression> rule) {
        this.rules.add(rule);
        return this;
    }

    public JdbcConnectorExpressionRewriterBuilder withTypeClass(String typeClass, Set<String> typeNames) {
        Objects.requireNonNull(typeClass, "typeClass is null");
        Preconditions.checkArgument((!typeNames.isEmpty() ? 1 : 0) != 0, (Object)"No typeNames");
        Preconditions.checkState((!this.typeClasses.containsKey(typeClass) ? 1 : 0) != 0, (Object)"typeClass already defined");
        this.typeClasses.put(typeClass, (Set<String>)ImmutableSet.copyOf(typeNames));
        return this;
    }

    public ExpectSourceExpression when(Predicate<ConnectorSession> condition) {
        return new GenericRewriteBuilder().when(condition);
    }

    public ExpectRewriteTarget map(String expressionPattern) {
        return new GenericRewriteBuilder().map(expressionPattern);
    }

    public ConnectorExpressionRewriter<ParameterizedExpression> build() {
        return new ConnectorExpressionRewriter((Set)this.rules.build());
    }

    private class GenericRewriteBuilder
    implements ExpectSourceExpression,
    ExpectRewriteTarget {
        private Predicate<ConnectorSession> condition = session -> true;
        private String expressionPattern;

        private GenericRewriteBuilder() {
        }

        GenericRewriteBuilder when(Predicate<ConnectorSession> condition) {
            this.condition = Objects.requireNonNull(condition, "condition is null");
            return this;
        }

        @Override
        public ExpectRewriteTarget map(String expressionPattern) {
            this.expressionPattern = Objects.requireNonNull(expressionPattern, "expressionPattern is null");
            return this;
        }

        @Override
        public JdbcConnectorExpressionRewriterBuilder to(String rewritePattern) {
            JdbcConnectorExpressionRewriterBuilder.this.rules.add((Object)new GenericRewrite((Map<String, Set<String>>)ImmutableMap.copyOf(JdbcConnectorExpressionRewriterBuilder.this.typeClasses), this.condition, this.expressionPattern, rewritePattern));
            return JdbcConnectorExpressionRewriterBuilder.this;
        }
    }

    public static interface ExpectRewriteTarget {
        public JdbcConnectorExpressionRewriterBuilder to(String var1);
    }

    public static interface ExpectSourceExpression {
        public ExpectRewriteTarget map(String var1);
    }
}

