/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.slice.Slice;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorTableFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTransactionManager;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Query
implements Provider<ConnectorTableFunction> {
    public static final String SCHEMA_NAME = "system";
    public static final String NAME = "query";
    private final JdbcTransactionManager transactionManager;

    @Inject
    public Query(JdbcTransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    public ConnectorTableFunction get() {
        return new ClassLoaderSafeConnectorTableFunction((ConnectorTableFunction)new QueryFunction(this.transactionManager), this.getClass().getClassLoader());
    }

    public static class QueryFunction
    extends AbstractConnectorTableFunction {
        private final JdbcTransactionManager transactionManager;

        public QueryFunction(JdbcTransactionManager transactionManager) {
            super(Query.SCHEMA_NAME, Query.NAME, List.of(ScalarArgumentSpecification.builder().name("QUERY").type((Type)VarcharType.VARCHAR).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            ScalarArgument argument = (ScalarArgument)Iterables.getOnlyElement(arguments.values());
            String query = ((Slice)argument.getValue()).toStringUtf8();
            PreparedQuery preparedQuery = new PreparedQuery(query, (List<QueryParameter>)ImmutableList.of());
            JdbcMetadata metadata = this.transactionManager.getMetadata(transaction);
            JdbcTableHandle tableHandle = metadata.getTableHandle(session, preparedQuery);
            List<JdbcColumnHandle> columns = tableHandle.getColumns().orElseThrow(() -> new IllegalStateException("Handle doesn't have columns info"));
            Descriptor returnedType = new Descriptor((List)columns.stream().map(column -> new Descriptor.Field(column.getColumnName(), Optional.of(column.getColumnType()))).collect(ImmutableList.toImmutableList()));
            QueryFunctionHandle handle = new QueryFunctionHandle(tableHandle);
            return TableFunctionAnalysis.builder().returnedType(returnedType).handle((ConnectorTableFunctionHandle)handle).build();
        }
    }

    public static class QueryFunctionHandle
    implements ConnectorTableFunctionHandle {
        private final JdbcTableHandle tableHandle;

        @JsonCreator
        public QueryFunctionHandle(@JsonProperty(value="tableHandle") JdbcTableHandle tableHandle) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        }

        @JsonProperty
        public ConnectorTableHandle getTableHandle() {
            return this.tableHandle;
        }
    }
}

