/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.geospatial.KdbTree;
import io.trino.geospatial.KdbTreeUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

public final class KdbTreeType
extends AbstractVariableWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(KdbTreeType.class, (MethodHandles.Lookup)MethodHandles.lookup(), Object.class);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    public static final KdbTreeType KDB_TREE = new KdbTreeType();

    private KdbTreeType() {
        super(new TypeSignature("KdbTree", new TypeSignatureParameter[0]), Object.class);
    }

    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        return this.getObject(block, position);
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        byte[] jsonBytes = KdbTreeUtils.toJsonBytes((KdbTree)((KdbTree)value));
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(jsonBytes, 0, jsonBytes.length);
    }

    public Object getObject(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        VariableWidthBlock valueBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        return KdbTreeUtils.fromJson((Slice)valueBlock.getSlice(valuePosition));
    }

    public int getFlatFixedSize() {
        return 4;
    }

    public int getFlatVariableWidthSize(Block block, int position) {
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        return variableWidthBlock.getSliceLength(block.getUnderlyingValuePosition(position));
    }

    public int getFlatVariableWidthLength(byte[] fixedSizeSlice, int fixedSizeOffset) {
        return INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static Object readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] variableSizeSlice, @FlatVariableOffset int variableSizeOffset) {
        int length = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
        return KdbTreeUtils.fromJson((Slice)Slices.wrappedBuffer((byte[])variableSizeSlice, (int)variableSizeOffset, (int)length));
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void readFlatToBlock(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] variableSizeSlice, @FlatVariableOffset int variableSizeOffset, BlockBuilder blockBuilder) {
        int length = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(Slices.wrappedBuffer((byte[])variableSizeSlice, (int)variableSizeOffset, (int)length));
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(Object value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableWidthSlice, int variableSizeOffset) {
        byte[] bytes = KdbTreeUtils.toJsonBytes((KdbTree)((KdbTree)value));
        System.arraycopy(bytes, 0, variableWidthSlice, variableSizeOffset, bytes.length);
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset, bytes.length);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeBlockToFlat(@BlockPosition VariableWidthBlock block, @BlockIndex int position, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset) {
        VariableWidthBlock valueBlock = block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        Slice bytes = valueBlock.getSlice(valuePosition);
        bytes.getBytes(0, variableSizeSlice, variableSizeOffset, bytes.length());
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset, bytes.length());
    }
}

