/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableMap;
import io.trino.tempto.fulfillment.ldap.LdapObjectDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ImmutableLdapObjectDefinitions {
    private static final String DOMAIN = "dc=presto,dc=testldap,dc=com";
    private static final String AMERICA_DISTINGUISHED_NAME = String.format("ou=America,%s", "dc=presto,dc=testldap,dc=com");
    private static final String ASIA_DISTINGUISHED_NAME = String.format("ou=Asia,%s", "dc=presto,dc=testldap,dc=com");
    private static final String LDAP_PASSWORD = "LDAPPass123";
    private static final String MEMBER_OF = "memberOf";
    private static final String MEMBER = "member";
    public static final LdapObjectDefinition AMERICA_ORG = ImmutableLdapObjectDefinitions.buildLdapOrganizationObject("America", AMERICA_DISTINGUISHED_NAME, "America");
    public static final LdapObjectDefinition ASIA_ORG = ImmutableLdapObjectDefinitions.buildLdapOrganizationObject("Asia", ASIA_DISTINGUISHED_NAME, "Asia");
    public static final LdapObjectDefinition DEFAULT_GROUP = ImmutableLdapObjectDefinitions.buildLdapGroupObject("DefaultGroup", "DefaultGroupUser", Optional.of(Arrays.asList("ChildGroup")));
    public static final LdapObjectDefinition PARENT_GROUP = ImmutableLdapObjectDefinitions.buildLdapGroupObject("ParentGroup", "ParentGroupUser", Optional.of(Arrays.asList("DefaultGroup")));
    public static final LdapObjectDefinition CHILD_GROUP = ImmutableLdapObjectDefinitions.buildLdapGroupObject("ChildGroup", "ChildGroupUser", Optional.empty());
    public static final LdapObjectDefinition DEFAULT_GROUP_USER = ImmutableLdapObjectDefinitions.buildLdapUserObject("DefaultGroupUser", Optional.of(Arrays.asList("DefaultGroup")), "LDAPPass123");
    public static final LdapObjectDefinition PARENT_GROUP_USER = ImmutableLdapObjectDefinitions.buildLdapUserObject("ParentGroupUser", Optional.of(Arrays.asList("ParentGroup")), "LDAPPass123");
    public static final LdapObjectDefinition CHILD_GROUP_USER = ImmutableLdapObjectDefinitions.buildLdapUserObject("ChildGroupUser", Optional.of(Arrays.asList("ChildGroup")), "LDAPPass123");
    public static final LdapObjectDefinition ORPHAN_USER = ImmutableLdapObjectDefinitions.buildLdapUserObject("OrphanUser", Optional.empty(), "LDAPPass123");
    public static final LdapObjectDefinition SPECIAL_USER = ImmutableLdapObjectDefinitions.buildLdapUserObject("User WithSpecialPwd", Optional.of(Arrays.asList("DefaultGroup")), "LDAP:Pass ~!@#$%^&*()_+{}|:\"<>?/.,';\\][=-`");
    public static final LdapObjectDefinition USER_IN_MULTIPLE_GROUPS = ImmutableLdapObjectDefinitions.buildLdapUserObject("UserInMultipleGroups", Optional.of(Arrays.asList("DefaultGroup", "ParentGroup")), "LDAPPass123");

    private ImmutableLdapObjectDefinitions() {
    }

    public static LdapObjectDefinition buildLdapOrganizationObject(String id, String distinguishedName, String unit) {
        return LdapObjectDefinition.builder((String)id).setDistinguishedName(distinguishedName).setAttributes((Map)ImmutableMap.of((Object)"ou", (Object)unit)).setObjectClasses(Arrays.asList("top", "organizationalUnit")).build();
    }

    public static LdapObjectDefinition buildLdapGroupObject(String groupName, String userName, Optional<List<String>> childGroupNames) {
        if (childGroupNames.isPresent()) {
            return ImmutableLdapObjectDefinitions.buildLdapGroupObject(groupName, AMERICA_DISTINGUISHED_NAME, userName, ASIA_DISTINGUISHED_NAME, childGroupNames, Optional.of(AMERICA_DISTINGUISHED_NAME));
        }
        return ImmutableLdapObjectDefinitions.buildLdapGroupObject(groupName, AMERICA_DISTINGUISHED_NAME, userName, ASIA_DISTINGUISHED_NAME, Optional.empty(), Optional.empty());
    }

    public static LdapObjectDefinition buildLdapGroupObject(String groupName, String groupOrganizationName, String userName, String userOrganizationName, Optional<List<String>> childGroupNames, Optional<String> childGroupOrganizationName) {
        if (childGroupNames.isPresent() && childGroupOrganizationName.isPresent()) {
            return LdapObjectDefinition.builder((String)groupName).setDistinguishedName(String.format("cn=%s,%s", groupName, groupOrganizationName)).setAttributes((Map)ImmutableMap.of((Object)"cn", (Object)groupName, (Object)MEMBER, (Object)String.format("uid=%s,%s", userName, userOrganizationName))).setModificationAttributes(ImmutableLdapObjectDefinitions.getAttributes(childGroupNames.get(), childGroupOrganizationName.get(), MEMBER)).setObjectClasses(Arrays.asList("groupOfNames")).build();
        }
        return LdapObjectDefinition.builder((String)groupName).setDistinguishedName(String.format("cn=%s,%s", groupName, groupOrganizationName)).setAttributes((Map)ImmutableMap.of((Object)"cn", (Object)groupName, (Object)MEMBER, (Object)String.format("uid=%s,%s", userName, userOrganizationName))).setObjectClasses(Arrays.asList("groupOfNames")).build();
    }

    public static LdapObjectDefinition buildLdapUserObject(String userName, Optional<List<String>> groupNames, String password) {
        if (groupNames.isPresent()) {
            return ImmutableLdapObjectDefinitions.buildLdapUserObject(userName, ASIA_DISTINGUISHED_NAME, groupNames, Optional.of(AMERICA_DISTINGUISHED_NAME), password);
        }
        return ImmutableLdapObjectDefinitions.buildLdapUserObject(userName, ASIA_DISTINGUISHED_NAME, Optional.empty(), Optional.empty(), password);
    }

    public static LdapObjectDefinition buildLdapUserObject(String userName, String userOrganizationName, Optional<List<String>> groupNames, Optional<String> groupOrganizationName, String password) {
        if (groupNames.isPresent() && groupOrganizationName.isPresent()) {
            return LdapObjectDefinition.builder((String)userName).setDistinguishedName(String.format("uid=%s,%s", userName, userOrganizationName)).setAttributes((Map)ImmutableMap.of((Object)"cn", (Object)userName, (Object)"sn", (Object)userName, (Object)"userPassword", (Object)password)).setObjectClasses(Arrays.asList("person", "inetOrgPerson")).setModificationAttributes(ImmutableLdapObjectDefinitions.getAttributes(groupNames.get(), groupOrganizationName.get(), MEMBER_OF)).build();
        }
        return LdapObjectDefinition.builder((String)userName).setDistinguishedName(String.format("uid=%s,%s", userName, userOrganizationName)).setAttributes((Map)ImmutableMap.of((Object)"cn", (Object)userName, (Object)"sn", (Object)userName, (Object)"userPassword", (Object)password)).setObjectClasses(Arrays.asList("person", "inetOrgPerson")).build();
    }

    private static ImmutableMap<String, List<String>> getAttributes(List<String> groupNames, String groupOrganizationName, String relation) {
        return ImmutableMap.of((Object)relation, groupNames.stream().map(groupName -> String.format("cn=%s,%s", groupName, groupOrganizationName)).collect(Collectors.toList()));
    }
}

