/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import io.trino.tempto.ProductTest;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.context.ContextDsl;
import io.trino.tempto.context.ContextProvider;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tempto.sql.SqlContexts;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
public class TestCreateDropView
extends ProductTest {
    @Test(groups={"create_drop_view"})
    public void createSimpleView() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT * FROM nation"), view -> QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", view.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(25));
    }

    @Test(groups={"create_drop_view"})
    public void querySimpleViewQualified() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT * FROM nation"), view -> QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT %s.n_regionkey FROM %s", view.getName(), view.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(25));
    }

    @Test(groups={"create_drop_view"})
    public void createViewWithAggregate() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT n_regionkey, count(*) countries FROM nation GROUP BY n_regionkey ORDER BY n_regionkey"), view -> QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", view.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(5));
    }

    @Test(groups={"create_drop_view", "smoke"})
    public void createOrReplaceSimpleView() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT * FROM nation"), view -> {
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("CREATE OR REPLACE VIEW %s AS SELECT * FROM nation", view.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", view.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(25);
        });
    }

    @Test(groups={"create_drop_view"})
    public void createSimpleViewTwiceShouldFail() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT * FROM nation"), view -> {
            QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("CREATE VIEW %s AS SELECT * FROM nation", view.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("View already exists");
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", view.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(25);
        });
    }

    @Test(groups={"create_drop_view", "smoke"})
    public void dropViewTest() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT * FROM nation"), view -> {
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", view.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(25);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("DROP VIEW %s", view.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1);
            QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s", view.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("does not exist");
        });
    }
}

