/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.cassandra;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.fulfillment.table.hive.tpch.TpchTable;
import io.trino.tempto.fulfillment.table.jdbc.RelationalDataSource;
import io.trino.tempto.internal.fulfillment.table.cassandra.CassandraTableDefinition;
import io.trino.tempto.internal.fulfillment.table.cassandra.tpch.CassandraTpchDataSource;
import java.sql.JDBCType;
import java.util.List;

public final class CassandraTpchTableDefinitions {
    public static final ImmutableList<JDBCType> NATION_TYPES = ImmutableList.of((Object)JDBCType.BIGINT, (Object)JDBCType.VARCHAR, (Object)JDBCType.BIGINT, (Object)JDBCType.VARCHAR);
    public static final CassandraTableDefinition CASSANDRA_NATION = CassandraTableDefinition.cassandraBuilder((String)"nation").withDatabase("cassandra").withSchema("test").setCreateTableDDLTemplate("CREATE TABLE %NAME%(   n_nationkey     BIGINT,   n_name          VARCHAR,   n_regionkey     BIGINT,   n_comment       VARCHAR,   primary key(n_nationkey))").setDataSource((RelationalDataSource)new CassandraTpchDataSource(TpchTable.NATION, (List)ImmutableList.of((Object)0, (Object)2, (Object)3, (Object)1), NATION_TYPES, 1.0)).build();
    public static final ImmutableList<JDBCType> SUPPLIER_TYPES = ImmutableList.of((Object)JDBCType.BIGINT, (Object)JDBCType.VARCHAR, (Object)JDBCType.VARCHAR, (Object)JDBCType.BIGINT, (Object)JDBCType.VARCHAR, (Object)JDBCType.DOUBLE, (Object)JDBCType.VARCHAR);
    public static final CassandraTableDefinition CASSANDRA_SUPPLIER = CassandraTableDefinition.cassandraBuilder((String)"supplier").withDatabase("cassandra").withSchema("test").setCreateTableDDLTemplate("CREATE TABLE %NAME%(   s_suppkey     BIGINT,   s_name        VARCHAR,   s_address     VARCHAR,   s_nationkey   BIGINT,   s_phone       VARCHAR,   s_acctbal     DOUBLE,   s_comment     VARCHAR,   primary key(s_suppkey))").setDataSource((RelationalDataSource)new CassandraTpchDataSource(TpchTable.SUPPLIER, (List)ImmutableList.of((Object)0, (Object)4, (Object)2, (Object)5, (Object)6, (Object)1, (Object)3), SUPPLIER_TYPES, 1.0)).build();

    private CassandraTpchTableDefinitions() {
    }
}

