/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.cassandra;

import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.cassandra.CassandraTpchTableDefinitions;
import org.testng.annotations.Test;

public class TestInvalidSelect
extends ProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)CassandraTpchTableDefinitions.CASSANDRA_NATION);
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInvalidTable() {
        String tableName = String.format("%s.%s.%s", "cassandra", "test", "bogus");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Table '%s' does not exist", tableName));
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInvalidSchema() {
        String tableName = String.format("%s.%s.%s", "cassandra", "does_not_exist", "bogus");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Schema 'does_not_exist' does not exist");
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInvalidColumn() {
        String tableName = String.format("%s.%s.%s", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT bogus FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Column 'bogus' cannot be resolved");
    }
}

