/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.cli;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.airlift.log.Logger;
import io.trino.tempto.ProductTest;
import io.trino.tests.cli.TrinoCliProcess;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class TrinoCliLauncher
extends ProductTest {
    private static final Logger log = Logger.get(TrinoCliLauncher.class);
    protected static final long TIMEOUT = 300000L;
    protected final List<String> nationTableInteractiveLines = Resources.readLines((URL)Resources.getResource((String)"io/trino/tests/cli/interactive_query.results"), (Charset)StandardCharsets.UTF_8);
    protected final List<String> nationTableBatchLines = Resources.readLines((URL)Resources.getResource((String)"io/trino/tests/cli/batch_query.results"), (Charset)StandardCharsets.UTF_8);
    @Inject
    @Named(value="databases.presto.host")
    protected String serverHost;
    @Inject
    @Named(value="databases.presto.server_address")
    protected String serverAddress;
    protected TrinoCliProcess trino;

    protected TrinoCliLauncher() throws IOException {
    }

    protected void stopPresto() throws InterruptedException {
        if (this.trino != null) {
            this.trino.close();
            this.trino = null;
        }
    }

    protected void launchTrinoCli(String ... arguments) throws IOException {
        this.launchTrinoCli(Arrays.asList(arguments));
    }

    protected void launchTrinoCli(List<String> arguments) throws IOException {
        this.trino = new TrinoCliProcess(this.getProcessBuilder(arguments).start());
    }

    protected ProcessBuilder getProcessBuilder(List<String> arguments) {
        ImmutableList command = ImmutableList.builder().add((Object)"/docker/trino-cli").addAll(arguments).build();
        log.info("Running command %s", new Object[]{command});
        return new ProcessBuilder((List<String>)command);
    }
}

