/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.hive.HiveProductTest;
import io.trino.tests.utils.QueryExecutors;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class, ImmutableTpchTablesRequirements.ImmutableOrdersTable.class})
public abstract class AbstractTestHiveViews
extends HiveProductTest {
    @Test(groups={"hive_views"})
    public void testSelectOnView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_test_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM hive_test_view", queryAssert -> queryAssert.hasRowsCount(25));
        AbstractTestHiveViews.assertViewQuery("SELECT n_nationkey, n_name, n_regionkey, n_comment FROM hive_test_view WHERE n_nationkey < 3", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, "ALGERIA", 0, " haggle. carefully final deposits detect slyly agai"}), QueryAssert.Row.row((Object[])new Object[]{1, "ARGENTINA", 1, "al foxes promise slyly according to the regular accounts. bold requests alon"}), QueryAssert.Row.row((Object[])new Object[]{2, "BRAZIL", 1, "y alongside of the pending deposits. carefully special packages are about the ironic forges. slyly special "})}));
    }

    @Test(groups={"hive_views"})
    public void testArrayIndexingInView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_zero_index_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS hive_table_dummy", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE hive_table_dummy(a int)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_zero_index_view AS SELECT array('presto','hive')[1] AS sql_dialect FROM hive_table_dummy", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE hive_table_dummy VALUES (1)", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM hive_zero_index_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive"})}));
    }

    @Test(groups={"hive_views"})
    public void testSelectOnViewFromDifferentSchema() {
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_schema CASCADE", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE SCHEMA test_schema", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_schema.hive_test_view_1 AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM test_schema.hive_test_view_1", queryAssert -> queryAssert.hasRowsCount(25));
    }

    @Test(groups={"hive_views"})
    public void testViewWithUnsupportedCoercion() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS view_with_unsupported_coercion", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW view_with_unsupported_coercion AS SELECT length(n_comment) FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)"SELECT COUNT(*) FROM view_with_unsupported_coercion", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("View 'hive.default.view_with_unsupported_coercion' is stale or in invalid state: a column of type bigint projected from query view at position 0 has no name");
    }

    @Test(groups={"hive_views"})
    public void testWithUnsupportedFunction() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS view_with_repeat_function", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW view_with_repeat_function AS SELECT REPEAT(n_comment,2) FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)"SELECT COUNT(*) FROM view_with_repeat_function", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("View 'hive.default.view_with_repeat_function' is stale or in invalid state: a column of type array(varchar(152)) projected from query view at position 0 has no name");
    }

    @Test(groups={"hive_views"})
    public void testExistingView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_duplicate_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_duplicate_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)"CREATE VIEW hive_duplicate_view AS SELECT * FROM nation", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("View already exists");
    }

    @Test(groups={"hive_views"})
    public void testShowCreateView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_show_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_show_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        String showCreateViewSql = "SHOW CREATE VIEW %s.default.hive_show_view";
        String expectedResult = "CREATE VIEW %s.default.hive_show_view SECURITY DEFINER AS\nSELECT\n  \"n_nationkey\"\n, \"n_name\"\n, \"n_regionkey\"\n, \"n_comment\"\nFROM\n  \"default\".\"nation\"";
        QueryResult actualResult = QueryExecutor.query((String)String.format(showCreateViewSql, "hive"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)actualResult).hasRowsCount(1);
        Assert.assertEquals((String)((String)actualResult.row(0).get(0)), (String)String.format(expectedResult, "hive"));
        actualResult = QueryExecutor.query((String)String.format(showCreateViewSql, "hive_with_external_writes"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)actualResult).hasRowsCount(1);
        Assert.assertEquals((String)((String)actualResult.row(0).get(0)), (String)String.format(expectedResult, "hive_with_external_writes"));
    }

    @Test(groups={"hive_views"})
    public void testLateralViewExplode() {
        QueryExecutors.onPresto().executeQuery("DROP TABLE IF EXISTS pageAds", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE TABLE pageAds(pageid, adid_list) WITH (format='TEXTFILE') AS VALUES   (CAST('two' AS varchar), ARRAY[11, 22]),   ('nothing', NULL),   ('zero', ARRAY[]),   ('one', ARRAY[42])", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_lateral_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_lateral_view as SELECT pageid, adid FROM pageAds LATERAL VIEW explode(adid_list) adTable AS adid", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM hive_lateral_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"two", 11}), QueryAssert.Row.row((Object[])new Object[]{"two", 22}), QueryAssert.Row.row((Object[])new Object[]{"one", 42})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_lateral_view_outer_explode", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_lateral_view_outer_explode as SELECT pageid, adid FROM pageAds LATERAL VIEW OUTER explode(adid_list) adTable AS adid", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM hive_lateral_view_outer_explode", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"two", 11}), QueryAssert.Row.row((Object[])new Object[]{"two", 22}), QueryAssert.Row.row((Object[])new Object[]{"one", 42}), QueryAssert.Row.row((Object[])new Object[]{"nothing", null}), QueryAssert.Row.row((Object[])new Object[]{"zero", null})}));
    }

    @Test(groups={"hive_views"})
    public void testRichSqlSyntax() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS view_with_rich_syntax", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW view_with_rich_syntax AS SELECT \n   `n_nationkey`, \n   n_name, \n   `n_regionkey` AS `n_regionkey`, \n   n_regionkey BETWEEN 1 AND 2 AS region_between_1_2, \n   IF(`n`.`n_name` IN ('ALGERIA', 'ARGENTINA'), 1, 0) AS `starts_with_a`, \n   IF(`n`.`n_name` != 'PERU', 1, 0) `not_peru`, \n   IF(`n`.`n_name` LIKE '%N%', 1, 0) `CONTAINS_N`, \n   CASE WHEN n_name = \"BRAZIL\" THEN 'is BRAZIL' WHEN n_name = \"ALGERIA\" THEN 'is ALGERIA' ELSE \"\" END is_something,\n   COALESCE(IF(n_name LIKE 'A%', NULL, n_name), 'A%') AS coalesced_name, \n   round(tan(n_nationkey), 3) AS rounded_tan, \n   o_orderdate AS the_orderdate, \n   `n`.`n_nationkey` + `n_nationkey` + n.n_nationkey + n_nationkey + 10000 - -1 AS arithmetic--some comment without leading space \nFROM `default`.`nation` AS `n` \nLEFT JOIN (SELECT * FROM orders WHERE o_custkey > 1000) `o` ON `o`.`o_orderkey` = `n`.`n_nationkey` ", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT   n_nationkey, n_name, region_between_1_2, starts_with_a, not_peru, contains_n, is_something, coalesced_name,   rounded_tan, the_orderdate, arithmetic FROM view_with_rich_syntax WHERE n_regionkey < 3 AND (n_nationkey < 5 OR n_nationkey IN (12, 17))", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, "ALGERIA", false, 1, 1, 0, "is ALGERIA", "A%", 0.0, null, 10001}), QueryAssert.Row.row((Object[])new Object[]{1, "ARGENTINA", true, 1, 1, 1, "", "A%", 1.557, AbstractTestHiveViews.sqlDate(1996, 1, 2), 10005}), QueryAssert.Row.row((Object[])new Object[]{2, "BRAZIL", true, 0, 1, 0, "is BRAZIL", "BRAZIL", -2.185, AbstractTestHiveViews.sqlDate(1996, 12, 1), 10009}), QueryAssert.Row.row((Object[])new Object[]{3, "CANADA", true, 0, 1, 1, "", "CANADA", -0.143, AbstractTestHiveViews.sqlDate(1993, 10, 14), 10013}), QueryAssert.Row.row((Object[])new Object[]{12, "JAPAN", true, 0, 1, 1, "", "JAPAN", -0.636, null, 10049}), QueryAssert.Row.row((Object[])new Object[]{17, "PERU", true, 0, 0, 0, "", "PERU", 3.494, null, 10069})}));
    }

    @Test(groups={"hive_views"})
    public void testIdentifierThatStartWithDigit() {
        QueryExecutors.onPresto().executeQuery("DROP TABLE IF EXISTS \"7_table_with_number\"", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE TABLE \"7_table_with_number\" WITH (format='TEXTFILE') AS SELECT CAST('abc' AS varchar) x", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS view_on_identifiers_starting_with_numbers", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW view_on_identifiers_starting_with_numbers AS SELECT * FROM 7_table_with_number", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM view_on_identifiers_starting_with_numbers", queryAssert -> queryAssert.contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"abc"})}));
    }

    @Test(groups={"hive_views"})
    public void testHiveViewInInformationSchema() {
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_schema CASCADE;", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE SCHEMA test_schema;", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_schema.hive_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_schema.hive_table(a string)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE TABLE test_schema.trino_table(a int)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE VIEW test_schema.trino_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        boolean hiveWithTableNamesByType = this.getHiveVersionMajor() >= 3 || this.getHiveVersionMajor() == 2 && this.getHiveVersionMinor() >= 3;
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT * FROM information_schema.tables WHERE table_schema = 'test_schema'", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "trino_table", "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "hive_table", "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "hive_test_view", hiveWithTableNamesByType ? "VIEW" : "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "trino_test_view", "VIEW"})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT view_definition FROM information_schema.views WHERE table_schema = 'test_schema' and table_name = 'hive_test_view'", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"SELECT \"n_nationkey\", \"n_name\", \"n_regionkey\", \"n_comment\"\nFROM \"default\".\"nation\""})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"DESCRIBE test_schema.hive_test_view", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"n_nationkey", "bigint", "", ""})});
    }

    @Test(groups={"hive_views"})
    public void testHiveViewWithParametrizedTypes() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_view_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS hive_table_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE hive_table_parametrized(a decimal(20,4), b bigint, c varchar(20))", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_view_parametrized AS SELECT * FROM hive_table_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE hive_table_parametrized VALUES (1.2345, 42, 'bar')", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM hive_view_parametrized", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{new BigDecimal("1.2345"), 42, "bar"})}));
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT data_type FROM information_schema.columns WHERE table_name = 'hive_view_parametrized'", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"decimal(20,4)"}), QueryAssert.Row.row((Object[])new Object[]{"bigint"}), QueryAssert.Row.row((Object[])new Object[]{"varchar"})});
    }

    @Test(groups={"hive_views"})
    public void testNestedHiveViews() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS nested_base_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS nested_middle_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS nested_top_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW nested_base_view AS SELECT n_nationkey as k, n_name as n, n_regionkey as r, n_comment as c FROM nation", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW nested_middle_view AS SELECT n, c FROM nested_base_view WHERE k = 14", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW nested_top_view AS SELECT n AS n_renamed FROM nested_middle_view", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT n_renamed FROM nested_top_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"KENYA"})}));
    }

    @Test
    public void testSelectFromHiveViewWithoutDefaultCatalogAndSchema() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS no_catalog_schema_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW no_catalog_schema_view AS SELECT * FROM nation WHERE n_nationkey = 1", new QueryExecutor.QueryParam[0]);
        QueryExecutor executor = this.connectToPresto("presto_no_default_catalog");
        QueryAssert.assertThat(() -> executor.executeQuery("SELECT count(*) FROM no_catalog_schema_view", new QueryExecutor.QueryParam[0])).failsWithMessageMatching(".*Schema must be specified when session schema is not set.*");
        QueryAssert.assertThat((QueryResult)executor.executeQuery("SELECT count(*) FROM hive.default.no_catalog_schema_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1L})});
    }

    @Test
    public void testTimestampHiveView() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS timestamp_hive_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE timestamp_hive_table AS SELECT cast('1990-01-02 12:13:14.123456789' AS timestamp) ts", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS timestamp_hive_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW timestamp_hive_view AS SELECT * FROM timestamp_hive_table", new QueryExecutor.QueryParam[0]);
        this.unsetSessionProperty("hive.timestamp_precision");
        this.unsetSessionProperty("hive_timestamp_nanos.timestamp_precision");
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT CAST(ts AS varchar) FROM timestamp_hive_view", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123"})});
        Assertions.assertThatThrownBy(() -> QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT CAST(ts AS varchar) FROM hive_timestamp_nanos.default.timestamp_hive_view", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123456789"})})).hasMessageContaining("timestamp(9) projected from query view at position 0 cannot be coerced to column [ts] of type timestamp(3) stored in view definition");
        this.setSessionProperty("hive.timestamp_precision", "'MILLISECONDS'");
        this.setSessionProperty("hive_timestamp_nanos.timestamp_precision", "'MILLISECONDS'");
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT CAST(ts AS varchar) FROM timestamp_hive_view", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123"})});
        Assertions.assertThatThrownBy(() -> QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT CAST(ts AS varchar) FROM hive_timestamp_nanos.default.timestamp_hive_view", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123"})})).hasMessageContaining("timestamp(9) projected from query view at position 0 cannot be coerced to column [ts] of type timestamp(3) stored in view definition");
        this.setSessionProperty("hive.timestamp_precision", "'NANOSECONDS'");
        this.setSessionProperty("hive_timestamp_nanos.timestamp_precision", "'NANOSECONDS'");
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT CAST(ts AS varchar) FROM timestamp_hive_view", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123"})});
        Assertions.assertThatThrownBy(() -> QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT CAST(ts AS varchar) FROM hive_timestamp_nanos.default.timestamp_hive_view", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123456789"})})).hasMessageContaining("timestamp(9) projected from query view at position 0 cannot be coerced to column [ts] of type timestamp(3) stored in view definition");
    }

    @Test
    public void testCurrentUser() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS current_user_hive_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW current_user_hive_view as SELECT current_user() AS cu FROM nation LIMIT 1", new QueryExecutor.QueryParam[0]);
        String testQuery = "SELECT cu FROM current_user_hive_view";
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)testQuery, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive"})});
        QueryAssert.assertThat((QueryResult)this.connectToPresto("alice@presto").executeQuery(testQuery, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice"})});
    }

    protected static void assertViewQuery(String query, Consumer<QueryAssert> assertion) {
        assertion.accept(QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery(query, new QueryExecutor.QueryParam[0])));
        assertion.accept(QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery(query, new QueryExecutor.QueryParam[0])));
    }

    protected static Date sqlDate(int year, int month, int day) {
        return Date.valueOf(LocalDate.of(year, month, day));
    }

    protected QueryExecutor connectToPresto(String catalog) {
        return QueryExecutors.connectToPresto(catalog);
    }

    protected void setSessionProperty(String key, String value) {
        QueryExecutors.onPresto().executeQuery(String.format("SET SESSION %s = %s", key, value), new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("SET SESSION %s = %s", key, value), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    protected void unsetSessionProperty(String key) {
        QueryExecutors.onPresto().executeQuery("RESET SESSION " + key, new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("RESET SESSION " + key), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }
}

