/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import com.google.inject.name.Named;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.utils.QueryExecutors;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.inject.Inject;
import org.testng.annotations.Test;

public class TestAvroSymlinkInputFormat
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;

    @Test(groups={"avro", "storage_formats"})
    public void testSymlinkTable() throws Exception {
        String table = "test_avro_symlink";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + table, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + table + " ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe' WITH SERDEPROPERTIES ('avro.schema.literal'='{\"namespace\": \"io.trino.tests.hive\",\"name\": \"test_avro_symlink\",\"type\": \"record\",\"fields\": [{ \"name\":\"string_col\", \"type\":\"string\"},{ \"name\":\"int_col\", \"type\":\"int\" }]}') STORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'", new QueryExecutor.QueryParam[0]);
        String tableRoot = this.warehouseDirectory + "/" + table;
        String dataDir = this.warehouseDirectory + "/data_test_avro_symlink";
        this.saveResourceOnHdfs("avro/original_data.avro", dataDir + "/original_data.avro");
        this.hdfsClient.saveFile(dataDir + "/dontread.txt", "This file will cause an error if read as avro.");
        this.hdfsClient.saveFile(tableRoot + "/symlink.txt", String.format("hdfs:%s/original_data.avro", dataDir));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM " + table, new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"someValue", 1})});
        QueryExecutors.onHive().executeQuery("DROP TABLE " + table, new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(dataDir);
    }

    @Test(groups={"avro", "storage_formats"})
    public void testSymlinkTableWithMultipleParentDirectories() throws Exception {
        String table = "test_avro_symlink_with_multiple_parents";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + table, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + table + " ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe' WITH SERDEPROPERTIES ('avro.schema.literal'='{\"namespace\": \"io.trino.tests.hive\",\"name\": \"test_avro_symlink\",\"type\": \"record\",\"fields\": [{ \"name\":\"string_col\", \"type\":\"string\"},{ \"name\":\"int_col\", \"type\":\"int\" }]}') STORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'", new QueryExecutor.QueryParam[0]);
        String tableRoot = this.warehouseDirectory + "/" + table;
        String dataDir = this.warehouseDirectory + "/data_test_avro_symlink_with_multiple_parents";
        String anotherDataDir = this.warehouseDirectory + "/data2_test_avro_symlink_with_multiple_parents";
        this.saveResourceOnHdfs("avro/original_data.avro", dataDir + "/original_data.avro");
        this.saveResourceOnHdfs("avro/original_data.avro", anotherDataDir + "/more_data.avro");
        this.hdfsClient.saveFile(dataDir + "/dontread.txt", "This file will cause an error if read as avro.");
        this.hdfsClient.saveFile(tableRoot + "/symlink.txt", String.format("hdfs:%s/original_data.avro\nhdfs:%s/more_data.avro", dataDir, anotherDataDir));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT COUNT(*) as cnt FROM " + table, new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
        QueryExecutors.onHive().executeQuery("DROP TABLE " + table, new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(dataDir);
        this.hdfsClient.delete(anotherDataDir);
    }

    @Test(groups={"avro", "storage_formats"})
    public void testSymlinkTableWithNestedDirectory() throws Exception {
        String table = "test_avro_symlink_with_nested_directory";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + table, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + table + " ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe' WITH SERDEPROPERTIES ('avro.schema.literal'='{\"namespace\": \"io.trino.tests.hive\",\"name\": \"test_avro_symlink\",\"type\": \"record\",\"fields\": [{ \"name\":\"string_col\", \"type\":\"string\"},{ \"name\":\"int_col\", \"type\":\"int\" }]}') STORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'", new QueryExecutor.QueryParam[0]);
        String tableRoot = this.warehouseDirectory + "/" + table;
        String dataDir = this.warehouseDirectory + "/data_test_avro_symlink_with_nested_directory";
        this.saveResourceOnHdfs("avro/original_data.avro", dataDir + "/original_data.avro");
        this.hdfsClient.saveFile(tableRoot + "/symlink.txt", String.format("hdfs://%s/", dataDir));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM " + table, new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"someValue", 1})});
        QueryExecutors.onHive().executeQuery("DROP TABLE " + table, new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(dataDir);
    }

    private void saveResourceOnHdfs(String resource, String location) throws IOException {
        this.hdfsClient.delete(location);
        try (InputStream inputStream = Files.newInputStream(Paths.get("/docker/presto-product-tests", resource), new OpenOption[0]);){
            this.hdfsClient.saveFile(location, inputStream);
        }
    }
}

