/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestComments
extends ProductTest {
    private static final String COMMENT_TABLE_NAME = "comment_test";
    private static final String COMMENT_COLUMN_NAME = "comment_column_test";

    @BeforeTestWithContext
    @AfterTestWithContext
    public void dropTestTable() {
        QueryExecutor.query((String)"DROP TABLE IF EXISTS comment_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)"DROP TABLE IF EXISTS comment_column_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"comment"})
    public void testCommentTable() {
        String createTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint\n)\nCOMMENT 'old comment'\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_TABLE_NAME);
        QueryExecutor.query((String)createTableSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryResult actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)createTableSql);
        String commentedCreateTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint\n)\nCOMMENT 'new comment'\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_TABLE_NAME);
        QueryExecutor.query((String)String.format("COMMENT ON TABLE %s IS 'new comment'", COMMENT_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)commentedCreateTableSql);
        commentedCreateTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint\n)\nCOMMENT ''\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_TABLE_NAME);
        QueryExecutor.query((String)String.format("COMMENT ON TABLE %s IS ''", COMMENT_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)commentedCreateTableSql);
        commentedCreateTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint\n)\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_TABLE_NAME);
        QueryExecutor.query((String)String.format("COMMENT ON TABLE %s IS NULL", COMMENT_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)commentedCreateTableSql);
    }

    @Test(groups={"comment"})
    public void testCommentColumn() {
        String createTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint COMMENT 'test comment',\n   c2 bigint COMMENT '',\n   c3 bigint\n)\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_COLUMN_NAME);
        QueryExecutor.query((String)createTableSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryResult actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_column_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)createTableSql);
        String commentedCreateTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint COMMENT 'new comment',\n   c2 bigint COMMENT '',\n   c3 bigint\n)\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_COLUMN_NAME);
        QueryExecutor.query((String)String.format("COMMENT ON COLUMN %s.c1 IS 'new comment'", COMMENT_COLUMN_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_column_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)commentedCreateTableSql);
        commentedCreateTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint COMMENT '',\n   c2 bigint COMMENT '',\n   c3 bigint\n)\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_COLUMN_NAME);
        QueryExecutor.query((String)String.format("COMMENT ON COLUMN %s.c1 IS ''", COMMENT_COLUMN_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_column_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)commentedCreateTableSql);
        commentedCreateTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint,\n   c2 bigint COMMENT '',\n   c3 bigint\n)\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_COLUMN_NAME);
        QueryExecutor.query((String)String.format("COMMENT ON COLUMN %s.c1 IS NULL", COMMENT_COLUMN_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_column_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)commentedCreateTableSql);
    }
}

