/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.utils.QueryExecutors;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestCompression
extends ProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.ORDERS);
    }

    @Test(groups={"hive_compression", "skip_on_cdh"})
    public void testReadTextfileWithLzop() {
        this.testReadCompressedTable("STORED AS TEXTFILE", "com.hadoop.compression.lzo.LzopCodec", ".*\\.lzo");
    }

    @Test(groups={"hive_compression", "skip_on_cdh"})
    public void testReadSequencefileWithLzo() {
        this.testReadCompressedTable("STORED AS SEQUENCEFILE", "com.hadoop.compression.lzo.LzoCodec", "\\d+_0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadCompressedTable(String tableStorageDefinition, String compressionCodec, @Language(value="RegExp") String expectedFileNamePattern) {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_read_compressed", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onHive().executeQuery("SET hive.exec.compress.output=true", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("SET mapreduce.output.fileoutputformat.compress=true", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("SET mapreduce.output.fileoutputformat.compress.codec=" + compressionCodec, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("CREATE TABLE test_read_compressed " + tableStorageDefinition + " AS SELECT * FROM orders", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT count(*) FROM test_read_compressed", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1500000})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT sum(o_orderkey) FROM test_read_compressed", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{4499987250000L})});
            Assertions.assertThat((String)((String)QueryExecutors.onPresto().executeQuery("SELECT regexp_replace(\"$path\", '.*/') FROM test_read_compressed LIMIT 1", new QueryExecutor.QueryParam[0]).row(0).get(0))).matches((CharSequence)expectedFileNamePattern);
        }
        finally {
            QueryExecutors.onHive().executeQuery("RESET", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_read_compressed", new QueryExecutor.QueryParam[0]);
        }
    }
}

