/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.utils.QueryExecutors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCreateDropSchema
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;
    @javax.inject.Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;

    @Test
    public void testCreateDropSchema() {
        QueryExecutors.onHive().executeQuery("DROP DATABASE IF EXISTS test_drop_schema CASCADE", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE SCHEMA test_drop_schema", new QueryExecutor.QueryParam[0]);
        Assert.assertTrue((boolean)this.hdfsClient.exist(this.warehouseDirectory + "/test_drop_schema.db"));
        QueryExecutors.onPresto().executeQuery("CREATE TABLE test_drop_schema.test_drop (col1 int)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)"DROP SCHEMA test_drop_schema", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Schema not empty: test_drop_schema");
        QueryExecutors.onPresto().executeQuery("DROP TABLE test_drop_schema.test_drop", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("DROP SCHEMA test_drop_schema", new QueryExecutor.QueryParam[0]);
        Assert.assertFalse((boolean)this.hdfsClient.exist(this.warehouseDirectory + "/test_drop_schema.db"));
    }
}

