/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.Assertions;
import io.trino.jdbc.Row;
import io.trino.jdbc.TrinoArray;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.context.ThreadLocalTestContextHolder;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.MutableTablesState;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableHandle;
import io.trino.tempto.fulfillment.table.TableInstance;
import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.hive.HiveProductTest;
import io.trino.tests.utils.QueryExecutors;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveCoercion
extends HiveProductTest {
    public static final HiveTableDefinition HIVE_COERCION_TEXTFILE = TestHiveCoercion.tableDefinitionBuilder("TEXTFILE", Optional.empty(), Optional.of("DELIMITED FIELDS TERMINATED BY '|'")).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_PARQUET = TestHiveCoercion.tableDefinitionBuilder("PARQUET", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_AVRO = TestHiveCoercion.avroTableDefinitionBuilder().setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_ORC = TestHiveCoercion.tableDefinitionBuilder("ORC", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_RCTEXT = TestHiveCoercion.tableDefinitionBuilder("RCFILE", Optional.of("RCTEXT"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe'")).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_RCBINARY = TestHiveCoercion.tableDefinitionBuilder("RCFILE", Optional.of("RCBINARY"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe'")).setNoData().build();

    private static HiveTableDefinition.HiveTableDefinitionBuilder tableDefinitionBuilder(String fileFormat, Optional<String> recommendTableName, Optional<String> rowFormat) {
        String tableName = String.format("%s_hive_coercion", recommendTableName.orElse(fileFormat).toLowerCase(Locale.ENGLISH));
        String floatType = fileFormat.toLowerCase(Locale.ENGLISH).contains("parquet") ? "DOUBLE" : "FLOAT";
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate("CREATE TABLE %NAME%(    row_to_row                 STRUCT<keep: STRING, ti2si: TINYINT, si2int: SMALLINT, int2bi: INT, bi2vc: BIGINT>,     list_to_list               ARRAY<STRUCT<ti2int: TINYINT, si2bi: SMALLINT, bi2vc: BIGINT, remove: STRING>>,     map_to_map                 MAP<TINYINT, STRUCT<ti2bi: TINYINT, int2bi: INT, float2double: " + floatType + ">>,     tinyint_to_smallint        TINYINT,    tinyint_to_int             TINYINT,    tinyint_to_bigint          TINYINT,    smallint_to_int            SMALLINT,    smallint_to_bigint         SMALLINT,    int_to_bigint              INT,    bigint_to_varchar          BIGINT,    float_to_double            " + floatType + ",    shortdecimal_to_shortdecimal          DECIMAL(10,2),    shortdecimal_to_longdecimal           DECIMAL(10,2),    longdecimal_to_shortdecimal           DECIMAL(20,12),    longdecimal_to_longdecimal            DECIMAL(20,12),    decimal_to_float           DECIMAL(10,5),    decimal_to_double          DECIMAL(10,5),    varchar_to_bigger_varchar  VARCHAR(3),    varchar_to_smaller_varchar VARCHAR(3)) PARTITIONED BY (id BIGINT) " + rowFormat.map(s -> String.format("ROW FORMAT %s ", s)).orElse("") + "STORED AS " + fileFormat);
    }

    private static HiveTableDefinition.HiveTableDefinitionBuilder avroTableDefinitionBuilder() {
        return HiveTableDefinition.builder((String)"avro_hive_coercion").setCreateTableDDLTemplate("CREATE TABLE %NAME%(    int_to_bigint              INT,    float_to_double            DOUBLE) PARTITIONED BY (id BIGINT) STORED AS AVRO");
    }

    @Requires(value={TextRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionTextFile() {
        this.doTestHiveCoercion(HIVE_COERCION_TEXTFILE);
    }

    @Requires(value={OrcRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionOrc() {
        this.doTestHiveCoercion(HIVE_COERCION_ORC);
    }

    @Requires(value={RcTextRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionRcText() {
        this.doTestHiveCoercion(HIVE_COERCION_RCTEXT);
    }

    @Requires(value={RcBinaryRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionRcBinary() {
        this.doTestHiveCoercion(HIVE_COERCION_RCBINARY);
    }

    @Requires(value={ParquetRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionParquet() {
        this.doTestHiveCoercion(HIVE_COERCION_PARQUET);
    }

    @Requires(value={AvroRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionAvro() {
        String tableName = TestHiveCoercion.mutableTableInstanceOf((TableDefinition)HIVE_COERCION_AVRO).getNameInDatabase();
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION (id=1) VALUES(2323, 0.5),(-2323, -1.5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_bigint int_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_double float_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW COLUMNS FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]).project(new int[]{1, 2})).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"int_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"id", "bigint"})});
        QueryResult queryResult = QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.BIGINT, JDBCType.DOUBLE, JDBCType.BIGINT});
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2323L, 0.5, 1}), QueryAssert.Row.row((Object[])new Object[]{-2323L, -1.5, 1})});
    }

    private void doTestHiveCoercion(HiveTableDefinition tableDefinition) {
        String tableName = TestHiveCoercion.mutableTableInstanceOf((TableDefinition)tableDefinition).getNameInDatabase();
        String floatToDoubleType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "DOUBLE" : "REAL";
        String decimalToFloatVal = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "12345.12345" : "12345.124";
        this.insertTableRows(tableName, floatToDoubleType);
        TestHiveCoercion.alterTableColumnTypes(tableName);
        this.assertProperAlteredTableSchema(tableName);
        ImmutableList prestoReadColumns = ImmutableList.of((Object)"row_to_row", (Object)"list_to_list", (Object)"map_to_map", (Object)"tinyint_to_smallint", (Object)"tinyint_to_int", (Object)"tinyint_to_bigint", (Object)"smallint_to_int", (Object)"smallint_to_bigint", (Object)"int_to_bigint", (Object)"bigint_to_varchar", (Object)"float_to_double", (Object)"shortdecimal_to_shortdecimal", (Object[])new String[]{"shortdecimal_to_longdecimal", "longdecimal_to_shortdecimal", "longdecimal_to_longdecimal", "decimal_to_float", "decimal_to_double", "varchar_to_bigger_varchar", "varchar_to_smaller_varchar", "id"});
        Function<Engine, Map> expected = engine -> this.expectedValuesForEngineProvider((Engine)((Object)engine), tableName, decimalToFloatVal);
        Map expectedPrestoResults = expected.apply(Engine.PRESTO);
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)prestoReadColumns), expectedPrestoResults.keySet());
        String prestoSelectQuery = String.format("SELECT %s FROM %s", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)prestoReadColumns), tableName);
        this.assertQueryResults(Engine.PRESTO, prestoSelectQuery, expectedPrestoResults, (List<String>)prestoReadColumns, 2, tableName);
        List<String> hiveReadColumns = this.removeUnsupportedColumnsForHive((List<String>)prestoReadColumns, tableName);
        Map expectedHiveResults = expected.apply(Engine.HIVE);
        String hiveSelectQuery = String.format("SELECT %s FROM %s", String.join((CharSequence)", ", hiveReadColumns), tableName);
        this.assertQueryResults(Engine.HIVE, hiveSelectQuery, expectedHiveResults, hiveReadColumns, 2, tableName);
    }

    protected void insertTableRows(String tableName, String floatToDoubleType) {
        QueryExecutor.query((String)String.format("INSERT INTO %1$s VALUES (  CAST(ROW ('as is', -1, 100, 2323, 12345) AS ROW(keep VARCHAR, ti2si TINYINT, si2int SMALLINT, int2bi INTEGER, bi2vc BIGINT)),   ARRAY [CAST(ROW (2, -101, 12345, 'removed') AS ROW (ti2int TINYINT, si2bi SMALLINT, bi2vc BIGINT, remove VARCHAR))],   MAP (ARRAY [TINYINT '2'], ARRAY [CAST(ROW (-3, 2323, REAL '0.5') AS ROW (ti2bi TINYINT, int2bi INTEGER, float2double %2$s))]),   TINYINT '-1',   TINYINT '2',   TINYINT '-3',   SMALLINT '100',   SMALLINT '-101',   INTEGER '2323',   12345,   REAL '0.5',   DECIMAL '12345678.12',   DECIMAL '12345678.12',   DECIMAL '12345678.123456123456',   DECIMAL '12345678.123456123456',   DECIMAL '12345.12345',   DECIMAL '12345.12345',   'abc',   'abc',   1), (  CAST(ROW (NULL, 1, -100, -2323, -12345) AS ROW(keep VARCHAR, ti2si TINYINT, si2int SMALLINT, int2bi INTEGER, bi2vc BIGINT)),   ARRAY [CAST(ROW (-2, 101, -12345, NULL) AS ROW (ti2int TINYINT, si2bi SMALLINT, bi2vc BIGINT, remove VARCHAR))],   MAP (ARRAY [TINYINT '-2'], ARRAY [CAST(ROW (null, -2323, REAL '-1.5') AS ROW (ti2bi TINYINT, int2bi INTEGER, float2double %2$s))]),   TINYINT '1',   TINYINT '-2',   NULL,   SMALLINT '-100',   SMALLINT '101',   INTEGER '-2323',   -12345,   REAL '-1.5',   DECIMAL '-12345678.12',   DECIMAL '-12345678.12',   DECIMAL '-12345678.123456123456',   DECIMAL '-12345678.123456123456',   DECIMAL '-12345.12345',   DECIMAL '-12345.12345',   '\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0',   '\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0',   1)", tableName, floatToDoubleType), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    protected Map<String, List<Object>> expectedValuesForEngineProvider(Engine engine, String tableName, String decimalToFloatVal) {
        return ImmutableMap.builder().put((Object)"row_to_row", Arrays.asList(engine == Engine.PRESTO ? this.rowBuilder().addField("keep", (Object)"as is").addField("ti2si", (Object)-1).addField("si2int", (Object)100).addField("int2bi", (Object)2323L).addField("bi2vc", (Object)"12345").build() : "{\"keep\":\"as is\",\"ti2si\":-1,\"si2int\":100,\"int2bi\":2323,\"bi2vc\":\"12345\"}", engine == Engine.PRESTO ? this.rowBuilder().addField("keep", null).addField("ti2si", (Object)1).addField("si2int", (Object)-100).addField("int2bi", (Object)-2323L).addField("bi2vc", (Object)"-12345").build() : "{\"keep\":null,\"ti2si\":1,\"si2int\":-100,\"int2bi\":-2323,\"bi2vc\":\"-12345\"}")).put((Object)"list_to_list", Arrays.asList(engine == Engine.PRESTO ? ImmutableList.of((Object)this.rowBuilder().addField("ti2int", (Object)2).addField("si2bi", (Object)-101L).addField("bi2vc", (Object)"12345").build()) : "[{\"ti2int\":2,\"si2bi\":-101,\"bi2vc\":\"12345\"}]", engine == Engine.PRESTO ? ImmutableList.of((Object)this.rowBuilder().addField("ti2int", (Object)-2).addField("si2bi", (Object)101L).addField("bi2vc", (Object)"-12345").build()) : "[{\"ti2int\":-2,\"si2bi\":101,\"bi2vc\":\"-12345\"}]")).put((Object)"map_to_map", Arrays.asList(engine == Engine.PRESTO ? ImmutableMap.of((Object)2, (Object)this.rowBuilder().addField("ti2bi", (Object)-3L).addField("int2bi", (Object)2323L).addField("float2double", (Object)0.5).addField("add", null).build()) : "{2:{\"ti2bi\":-3,\"int2bi\":2323,\"float2double\":0.5,\"add\":null}}", engine == Engine.PRESTO ? ImmutableMap.of((Object)-2, (Object)this.rowBuilder().addField("ti2bi", null).addField("int2bi", (Object)-2323L).addField("float2double", (Object)-1.5).addField("add", null).build()) : "{-2:{\"ti2bi\":null,\"int2bi\":-2323,\"float2double\":-1.5,\"add\":null}}")).put((Object)"tinyint_to_smallint", Arrays.asList(-1, 1)).put((Object)"tinyint_to_int", Arrays.asList(2, -2)).put((Object)"tinyint_to_bigint", Arrays.asList(-3L, null)).put((Object)"smallint_to_int", Arrays.asList(100, -100)).put((Object)"smallint_to_bigint", Arrays.asList(-101L, 101L)).put((Object)"int_to_bigint", Arrays.asList(2323L, -2323L)).put((Object)"bigint_to_varchar", Arrays.asList("12345", "-12345")).put((Object)"float_to_double", Arrays.asList(0.5, -1.5)).put((Object)"shortdecimal_to_shortdecimal", Arrays.asList(new BigDecimal("12345678.1200"), new BigDecimal("-12345678.1200"))).put((Object)"shortdecimal_to_longdecimal", Arrays.asList(new BigDecimal("12345678.1200"), new BigDecimal("-12345678.1200"))).put((Object)"longdecimal_to_shortdecimal", Arrays.asList(new BigDecimal("12345678.12"), new BigDecimal("-12345678.12"))).put((Object)"longdecimal_to_longdecimal", Arrays.asList(new BigDecimal("12345678.12345612345600"), new BigDecimal("-12345678.12345612345600"))).put((Object)"decimal_to_float", Arrays.asList(Float.valueOf(Float.parseFloat(decimalToFloatVal)), Float.valueOf(-Float.parseFloat(decimalToFloatVal)))).put((Object)"decimal_to_double", Arrays.asList(12345.12345, -12345.12345)).put((Object)"varchar_to_bigger_varchar", Arrays.asList("abc", "\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0")).put((Object)"varchar_to_smaller_varchar", Arrays.asList("ab", "\ud83d\udcb0\ud83d\udcb0")).put((Object)"id", Arrays.asList(1, 1)).build();
    }

    private List<String> removeUnsupportedColumnsForHive(List<String> columns, String tableName) {
        Map<ColumnContext, String> expectedExceptions = this.expectedExceptionsWithContext();
        String hiveVersion = this.getHiveVersionMajor() + "." + this.getHiveVersionMinor();
        Set unsupportedColumns = (Set)expectedExceptions.keySet().stream().filter(context -> context.getHiveVersion().equals(hiveVersion) && tableName.contains(context.getFormat())).map(ColumnContext::getColumn).collect(ImmutableSet.toImmutableSet());
        return (List)columns.stream().filter(column -> !unsupportedColumns.contains(column)).collect(ImmutableList.toImmutableList());
    }

    protected Map<ColumnContext, String> expectedExceptionsWithContext() {
        return ImmutableMap.builder().put((Object)ColumnContext.columnContext("1.1", "parquet", "row_to_row"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)ColumnContext.columnContext("1.1", "parquet", "list_to_list"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)ColumnContext.columnContext("1.1", "parquet", "map_to_map"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)ColumnContext.columnContext("1.1", "parquet", "tinyint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)ColumnContext.columnContext("1.1", "parquet", "smallint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)ColumnContext.columnContext("1.1", "parquet", "int_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)ColumnContext.columnContext("1.1", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)ColumnContext.columnContext("1.1", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)ColumnContext.columnContext("1.1", "rcbinary", "map_to_map"), (Object)"java.util.HashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").put((Object)ColumnContext.columnContext("1.2", "orc", "map_to_map"), (Object)"Unknown encoding kind: DIRECT_V2").put((Object)ColumnContext.columnContext("1.2", "parquet", "list_to_list"), (Object)"java.lang.UnsupportedOperationException: Cannot inspect java.util.ArrayList").put((Object)ColumnContext.columnContext("1.2", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)ColumnContext.columnContext("1.2", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)ColumnContext.columnContext("1.2", "rcbinary", "map_to_map"), (Object)"java.util.HashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").put((Object)ColumnContext.columnContext("2.1", "parquet", "row_to_row"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)ColumnContext.columnContext("2.1", "parquet", "list_to_list"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)ColumnContext.columnContext("2.1", "parquet", "map_to_map"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)ColumnContext.columnContext("2.1", "parquet", "tinyint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)ColumnContext.columnContext("2.1", "parquet", "smallint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)ColumnContext.columnContext("2.1", "parquet", "int_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)ColumnContext.columnContext("2.1", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)ColumnContext.columnContext("2.1", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)ColumnContext.columnContext("2.1", "rcbinary", "map_to_map"), (Object)"java.util.HashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").put((Object)ColumnContext.columnContext("3.1", "parquet", "row_to_row"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)ColumnContext.columnContext("3.1", "parquet", "list_to_list"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)ColumnContext.columnContext("3.1", "parquet", "map_to_map"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)ColumnContext.columnContext("3.1", "parquet", "tinyint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)ColumnContext.columnContext("3.1", "parquet", "smallint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)ColumnContext.columnContext("3.1", "parquet", "int_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)ColumnContext.columnContext("3.1", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)ColumnContext.columnContext("3.1", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)ColumnContext.columnContext("3.1", "rcbinary", "map_to_map"), (Object)"java.util.LinkedHashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").build();
    }

    private void assertQueryResults(Engine engine, String query, Map<String, List<Object>> expected, List<String> columns, int rowCount, String tableName) {
        QueryResult actual = TestHiveCoercion.execute(engine, query, new QueryExecutor.QueryParam[0]);
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (int row = 0; row < rowCount; ++row) {
            ArrayList<Object> currentRow = new ArrayList<Object>();
            for (int column = 0; column < columns.size(); ++column) {
                String columnName = columns.get(column);
                Preconditions.checkArgument((boolean)expected.containsKey(columnName), (Object)"columnName should be present in expected results");
                currentRow.add(expected.get(columnName).get(row));
            }
            rowsBuilder.add((Object)new QueryAssert.Row(currentRow));
        }
        ImmutableList expectedRows = rowsBuilder.build();
        this.assertColumnTypes(actual, tableName, engine, columns);
        for (int sqlIndex = 1; sqlIndex <= columns.size(); ++sqlIndex) {
            String column = columns.get(sqlIndex - 1);
            if (column.equals("row_to_row") || column.equals("map_to_map")) {
                Assertions.assertEqualsIgnoreOrder((Iterable)actual.column(sqlIndex), TestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, sqlIndex), (String)String.format("%s field is not equal", column));
                continue;
            }
            if (column.equals("list_to_list")) {
                Assertions.assertEqualsIgnoreOrder(engine == Engine.PRESTO ? TestHiveCoercion.extract(actual.column(sqlIndex)) : actual.column(sqlIndex), TestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, sqlIndex), (String)"list_to_list field is not equal");
                continue;
            }
            QueryAssert.assertThat((QueryResult)actual.project(new int[]{sqlIndex})).containsOnly(TestHiveCoercion.project((List<QueryAssert.Row>)expectedRows, sqlIndex));
        }
    }

    private void assertProperAlteredTableSchema(String tableName) {
        String floatType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "double" : "real";
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW COLUMNS FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]).project(new int[]{1, 2})).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"row_to_row", "row(keep varchar, ti2si smallint, si2int integer, int2bi bigint, bi2vc varchar)"}), QueryAssert.Row.row((Object[])new Object[]{"list_to_list", "array(row(ti2int integer, si2bi bigint, bi2vc varchar))"}), QueryAssert.Row.row((Object[])new Object[]{"map_to_map", "map(integer, row(ti2bi bigint, int2bi bigint, float2double double, add tinyint))"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"int_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"bigint_to_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_shortdecimal", "decimal(18,4)"}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_longdecimal", "decimal(20,4)"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_shortdecimal", "decimal(12,2)"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_longdecimal", "decimal(38,14)"}), QueryAssert.Row.row((Object[])new Object[]{"decimal_to_float", floatType}), QueryAssert.Row.row((Object[])new Object[]{"decimal_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_bigger_varchar", "varchar(4)"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_smaller_varchar", "varchar(2)"}), QueryAssert.Row.row((Object[])new Object[]{"id", "bigint"})});
    }

    private void assertColumnTypes(QueryResult queryResult, String tableName, Engine engine, List<String> columns) {
        JDBCType floatType = engine == Engine.PRESTO ? (tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? JDBCType.DOUBLE : JDBCType.REAL) : (tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? JDBCType.DOUBLE : JDBCType.FLOAT);
        ImmutableMap expectedTypes = ImmutableMap.builder().put((Object)"row_to_row", (Object)(engine == Engine.PRESTO ? JDBCType.JAVA_OBJECT : JDBCType.STRUCT)).put((Object)"list_to_list", (Object)JDBCType.ARRAY).put((Object)"map_to_map", (Object)JDBCType.JAVA_OBJECT).put((Object)"tinyint_to_smallint", (Object)JDBCType.SMALLINT).put((Object)"tinyint_to_int", (Object)JDBCType.INTEGER).put((Object)"tinyint_to_bigint", (Object)JDBCType.BIGINT).put((Object)"smallint_to_int", (Object)JDBCType.INTEGER).put((Object)"smallint_to_bigint", (Object)JDBCType.BIGINT).put((Object)"int_to_bigint", (Object)JDBCType.BIGINT).put((Object)"bigint_to_varchar", (Object)JDBCType.VARCHAR).put((Object)"float_to_double", (Object)JDBCType.DOUBLE).put((Object)"shortdecimal_to_shortdecimal", (Object)JDBCType.DECIMAL).put((Object)"shortdecimal_to_longdecimal", (Object)JDBCType.DECIMAL).put((Object)"longdecimal_to_shortdecimal", (Object)JDBCType.DECIMAL).put((Object)"longdecimal_to_longdecimal", (Object)JDBCType.DECIMAL).put((Object)"decimal_to_float", (Object)floatType).put((Object)"decimal_to_double", (Object)JDBCType.DOUBLE).put((Object)"varchar_to_bigger_varchar", (Object)JDBCType.VARCHAR).put((Object)"varchar_to_smaller_varchar", (Object)JDBCType.VARCHAR).put((Object)"id", (Object)JDBCType.BIGINT).build();
        QueryAssert.assertThat((QueryResult)queryResult).hasColumns((List)columns.stream().map(((Map)expectedTypes)::get).collect(ImmutableList.toImmutableList()));
    }

    private static void alterTableColumnTypes(String tableName) {
        String floatType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "double" : "float";
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN row_to_row row_to_row struct<keep:string, ti2si:smallint, si2int:int, int2bi:bigint, bi2vc:string>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN list_to_list list_to_list array<struct<ti2int:int, si2bi:bigint, bi2vc:string>>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN map_to_map map_to_map map<int,struct<ti2bi:bigint, int2bi:bigint, float2double:double, add:tinyint>>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_smallint tinyint_to_smallint smallint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_int tinyint_to_int int", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_bigint tinyint_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_int smallint_to_int int", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_bigint smallint_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_bigint int_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN bigint_to_varchar bigint_to_varchar string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_double float_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_shortdecimal shortdecimal_to_shortdecimal DECIMAL(18,4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_longdecimal shortdecimal_to_longdecimal DECIMAL(20,4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_shortdecimal longdecimal_to_shortdecimal DECIMAL(12,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_longdecimal longdecimal_to_longdecimal DECIMAL(38,14)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN decimal_to_float decimal_to_float %s", tableName, floatType), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN decimal_to_double decimal_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_bigger_varchar varchar_to_bigger_varchar varchar(4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_smaller_varchar varchar_to_smaller_varchar varchar(2)", tableName), new QueryExecutor.QueryParam[0]);
    }

    private static TableInstance<?> mutableTableInstanceOf(TableDefinition tableDefinition) {
        if (tableDefinition.getDatabase().isPresent()) {
            return TestHiveCoercion.mutableTableInstanceOf(tableDefinition, (String)tableDefinition.getDatabase().get());
        }
        return TestHiveCoercion.mutableTableInstanceOf(TestHiveCoercion.tableHandleInSchema(tableDefinition));
    }

    private static TableInstance<?> mutableTableInstanceOf(TableDefinition tableDefinition, String database) {
        return TestHiveCoercion.mutableTableInstanceOf(TestHiveCoercion.tableHandleInSchema(tableDefinition).inDatabase(database));
    }

    private static TableInstance<?> mutableTableInstanceOf(TableHandle tableHandle) {
        return ((MutableTablesState)ThreadLocalTestContextHolder.testContext().getDependency(MutableTablesState.class)).get(tableHandle);
    }

    private static TableHandle tableHandleInSchema(TableDefinition tableDefinition) {
        TableHandle tableHandle = TableHandle.tableHandle((String)tableDefinition.getName());
        if (tableDefinition.getSchema().isPresent()) {
            tableHandle = tableHandle.inSchema((String)tableDefinition.getSchema().get());
        }
        return tableHandle;
    }

    private Row.Builder rowBuilder() {
        return Row.builder();
    }

    private static QueryAssert.Row project(QueryAssert.Row row, int ... columns) {
        return new QueryAssert.Row(Arrays.stream(columns).mapToObj(column -> row.getValues().get(column - 1)).collect(Collectors.toList()));
    }

    private static List<QueryAssert.Row> project(List<QueryAssert.Row> rows, int ... columns) {
        return (List)rows.stream().map(row -> TestHiveCoercion.project(row, columns)).collect(ImmutableList.toImmutableList());
    }

    private static List<?> column(List<QueryAssert.Row> rows, int sqlColumnIndex) {
        return rows.stream().map(row -> TestHiveCoercion.project(row, sqlColumnIndex).getValues().get(0)).collect(Collectors.toList());
    }

    private static List<List<?>> extract(List<TrinoArray> arrays) {
        return (List)arrays.stream().map(trinoArray -> Arrays.asList((Object[])trinoArray.getArray())).collect(ImmutableList.toImmutableList());
    }

    private static QueryResult execute(Engine engine, String sql, QueryExecutor.QueryParam ... params) {
        return TestHiveCoercion.executorFor(engine).executeQuery(sql, params);
    }

    private static QueryExecutor executorFor(Engine engine) {
        switch (engine) {
            case HIVE: {
                return QueryExecutors.onHive();
            }
            case PRESTO: {
                return QueryExecutors.onPresto();
            }
        }
        throw new IllegalStateException("Unknown enum value " + engine);
    }

    public static enum Engine {
        HIVE,
        PRESTO;

    }

    public static class ColumnContext {
        private final String hiveVersion;
        private final String format;
        private final String column;

        public ColumnContext(String hiveVersion, String format, String column) {
            this.hiveVersion = Objects.requireNonNull(hiveVersion, "hiveVersion is null");
            this.format = Objects.requireNonNull(format, "format is null");
            this.column = Objects.requireNonNull(column, "column is null");
        }

        public static ColumnContext columnContext(String version, String format, String column) {
            return new ColumnContext(version, format, column);
        }

        public String getHiveVersion() {
            return this.hiveVersion;
        }

        public String getFormat() {
            return this.format;
        }

        public String getColumn() {
            return this.column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnContext that = (ColumnContext)o;
            return Objects.equals(this.hiveVersion, that.hiveVersion) && Objects.equals(this.format, that.format) && Objects.equals(this.column, that.column);
        }

        public int hashCode() {
            return Objects.hash(this.hiveVersion, this.format, this.column);
        }
    }

    public static final class AvroRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_AVRO).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class ParquetRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_PARQUET).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class RcBinaryRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_RCBINARY).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class RcTextRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_RCTEXT).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class OrcRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_ORC).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class TextRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_TEXTFILE).withState(MutableTableRequirement.State.CREATED).build();
        }
    }
}

