/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import com.google.inject.Inject;
import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.MutableTablesState;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.hive.HiveTableDefinitions;
import io.trino.tests.hive.util.TableLocationUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveIgnoreAbsentPartitions
extends ProductTest
implements RequirementsProvider {
    @Inject
    private MutableTablesState tablesState;
    @Inject
    private HdfsClient hdfsClient;

    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.mutableTable((TableDefinition)HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY, (String)"test_table", (MutableTableRequirement.State)MutableTableRequirement.State.LOADED);
    }

    @Test
    public void testIgnoreAbsentPartitions() throws Exception {
        String tableNameInDatabase = this.tablesState.get("test_table").getNameInDatabase();
        String tablePath = TableLocationUtils.getTablePath(tableNameInDatabase, 1);
        String partitionPath = String.format("%s/p_regionkey=9999", tablePath);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT count(*) FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{15})});
        Assert.assertFalse((boolean)this.hdfsClient.exist(partitionPath), (String)String.format("Expected partition %s to not exist", tableNameInDatabase));
        QueryExecutor.query((String)String.format("CALL hive.system.create_empty_partition('default', '%s', array['p_regionkey'], array['9999'])", tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)"SET SESSION hive.ignore_absent_partitions = false", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(partitionPath);
        Assert.assertFalse((boolean)this.hdfsClient.exist(partitionPath), (String)String.format("Expected partition %s to not exist", partitionPath));
        QueryAssert.assertThat(() -> QueryExecutor.query((String)("SELECT count(*) FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Partition location does not exist");
        QueryExecutor.query((String)"SET SESSION hive.ignore_absent_partitions = true", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT count(*) FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{15})});
    }

    @Test
    public void testShouldThrowErrorOnUnpartitionedTableMissingData() throws Exception {
        String tableName = "unpartitioned_absent_table_data";
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]));
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("CREATE TABLE %s AS SELECT * FROM (VALUES 1,2,3) t(dummy_col)", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT count(*) FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
        String tablePath = TableLocationUtils.getTablePath(tableName, 0);
        Assert.assertTrue((boolean)this.hdfsClient.exist(tablePath));
        this.hdfsClient.delete(tablePath);
        QueryExecutor.query((String)"SET SESSION hive.ignore_absent_partitions = false", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)("SELECT count(*) FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Partition location does not exist");
        QueryExecutor.query((String)"SET SESSION hive.ignore_absent_partitions = true", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)("SELECT count(*) FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Partition location does not exist");
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]));
    }
}

