/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.plugin.hive.authentication.HiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.NoHiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.Transport;
import java.net.URI;
import java.util.Optional;
import org.apache.thrift.TException;

public final class TestHiveMetastoreClientFactory {
    private static final String LOCALHOST = "localhost";
    @Inject
    @Named(value="databases.hive.metastore.host")
    private String metastoreHost;
    @Inject
    @Named(value="databases.hive.metastore.port")
    private int metastorePort;

    ThriftHiveMetastoreClient createMetastoreClient() throws TException {
        URI metastore = URI.create("thrift://" + this.metastoreHost + ":" + this.metastorePort);
        return new ThriftHiveMetastoreClient(Transport.create((HostAndPort)HostAndPort.fromParts((String)metastore.getHost(), (int)metastore.getPort()), Optional.empty(), Optional.empty(), (int)10000, (HiveMetastoreAuthentication)new NoHiveMetastoreAuthentication(), Optional.empty()), LOCALHOST);
    }
}

