/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.HiveDataSource;
import io.trino.tempto.fulfillment.table.hive.InlineDataSource;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.internal.hadoop.hdfs.HdfsDataSourceWriter;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testng.services.Flaky;
import io.trino.tests.hive.util.TableLocationUtils;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHivePartitionProcedures
extends ProductTest {
    private static final String OUTSIDE_TABLES_DIRECTORY_PATH = "/user/hive/dangling";
    private static final String FIRST_TABLE = "first_table";
    private static final String SECOND_TABLE = "second_table";
    private static final String VIEW_TABLE = "view_table";
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    private HdfsDataSourceWriter hdfsDataSourceWriter;

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testUnregisterPartition() throws URISyntaxException {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        Assertions.assertThat((Long)this.getTableCount(FIRST_TABLE)).isEqualTo(3L);
        Assertions.assertThat(this.getPartitionValues(FIRST_TABLE)).containsOnly((Object[])new String[]{"a", "b", "c"});
        this.dropPartition(FIRST_TABLE, "col", "a");
        Assertions.assertThat((Long)this.getTableCount(FIRST_TABLE)).isEqualTo(2L);
        Assertions.assertThat(this.getPartitionValues(FIRST_TABLE)).containsOnly((Object[])new String[]{"b", "c"});
        Assertions.assertThat((boolean)this.hdfsClient.exist(TableLocationUtils.getTablePath(FIRST_TABLE, 1) + "/col=a/")).isTrue();
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testUnregisterViewTableShouldFail() {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        TestHivePartitionProcedures.createView(VIEW_TABLE, FIRST_TABLE);
        QueryAssert.assertThat(() -> this.dropPartition(VIEW_TABLE, "col", "a")).failsWithMessage("Table is a view: default.view_table");
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testUnregisterMissingTableShouldFail() {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        QueryAssert.assertThat(() -> this.dropPartition("missing_table", "col", "f")).failsWithMessage("Table 'default.missing_table' not found");
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testUnregisterUnpartitionedTableShouldFail() {
        TestHivePartitionProcedures.createUnpartitionedTable(SECOND_TABLE);
        QueryAssert.assertThat(() -> this.dropPartition(SECOND_TABLE, "col", "a")).failsWithMessage("Table is not partitioned: default.second_table");
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testUnregisterInvalidPartitionColumnsShouldFail() {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        QueryAssert.assertThat(() -> this.dropPartition(FIRST_TABLE, "not_existing_partition_col", "a")).failsWithMessage("Provided partition column names do not match actual partition column names: [col]");
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testUnregisterMissingPartitionShouldFail() {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        QueryAssert.assertThat(() -> this.dropPartition(FIRST_TABLE, "col", "f")).failsWithMessage("Partition 'col=f' does not exist");
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testRegisterPartitionMissingTableShouldFail() {
        QueryAssert.assertThat(() -> this.addPartition("missing_table", "col", "f", "/")).failsWithMessage("Table 'default.missing_table' not found");
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testRegisterUnpartitionedTableShouldFail() {
        TestHivePartitionProcedures.createUnpartitionedTable(SECOND_TABLE);
        QueryAssert.assertThat(() -> this.addPartition(SECOND_TABLE, "col", "a", "/")).failsWithMessage("Table is not partitioned: default.second_table");
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testRegisterViewTableShouldFail() {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        TestHivePartitionProcedures.createView(VIEW_TABLE, FIRST_TABLE);
        QueryAssert.assertThat(() -> this.addPartition(VIEW_TABLE, "col", "a", "/")).failsWithMessage("Table is a view: default.view_table");
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testRegisterPartitionCollisionShouldFail() {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        QueryAssert.assertThat(() -> this.addPartition(FIRST_TABLE, "col", "a", "/")).failsWithMessage("Partition [col=a] is already registered");
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testRegisterPartitionInvalidPartitionColumnsShouldFail() {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        QueryAssert.assertThat(() -> this.addPartition(FIRST_TABLE, "not_existing_partition_col", "a", "/")).failsWithMessage("Provided partition column names do not match actual partition column names: [col]");
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testRegisterPartitionInvalidLocationShouldFail() {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        QueryAssert.assertThat(() -> this.addPartition(FIRST_TABLE, "col", "f", "/some/non/existing/path")).failsWithMessage("Partition location does not exist: /some/non/existing/path");
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testRegisterPartitionWithDefaultPartitionLocation() {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        this.dropPartition(FIRST_TABLE, "col", "a");
        this.dropPartition(FIRST_TABLE, "col", "c");
        Assertions.assertThat((Long)this.getTableCount(FIRST_TABLE)).isEqualTo(1L);
        Assertions.assertThat(this.getPartitionValues(FIRST_TABLE)).containsOnly((Object[])new String[]{"b"});
        this.addPartition(FIRST_TABLE, "col", "c");
        Assertions.assertThat((Long)this.getTableCount(FIRST_TABLE)).isEqualTo(2L);
        Assertions.assertThat(this.getPartitionValues(FIRST_TABLE)).containsOnly((Object[])new String[]{"b", "c"});
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testRegisterPartition() throws URISyntaxException {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        TestHivePartitionProcedures.createPartitionedTable(SECOND_TABLE);
        Assertions.assertThat(this.getPartitionValues(FIRST_TABLE)).containsOnly((Object[])new String[]{"a", "b", "c"});
        QueryExecutor.query((String)String.format("INSERT INTO %s (val, col) VALUES (10, 'f')", SECOND_TABLE), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assertions.assertThat(this.getPartitionValues(SECOND_TABLE)).containsOnly((Object[])new String[]{"a", "b", "c", "f"});
        this.addPartition(FIRST_TABLE, "col", "f", TableLocationUtils.getTablePath(SECOND_TABLE, 1) + "/col=f");
        this.dropPartition(SECOND_TABLE, "col", "f");
        Assertions.assertThat(this.getPartitionValues(SECOND_TABLE)).containsOnly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat(this.getPartitionValues(FIRST_TABLE)).containsOnly((Object[])new String[]{"a", "b", "c", "f"});
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testRegisterPartitionFromAnyLocation() {
        TestHivePartitionProcedures.createPartitionedTable(FIRST_TABLE);
        this.createDanglingLocationWithData(OUTSIDE_TABLES_DIRECTORY_PATH, "dangling");
        Assertions.assertThat(this.getPartitionValues(FIRST_TABLE)).containsOnly((Object[])new String[]{"a", "b", "c"});
        this.addPartition(FIRST_TABLE, "col", "f", OUTSIDE_TABLES_DIRECTORY_PATH);
        Assertions.assertThat(this.getPartitionValues(FIRST_TABLE)).containsOnly((Object[])new String[]{"a", "b", "c", "f"});
        Assertions.assertThat(this.getValues(FIRST_TABLE)).containsOnly((Object[])new Integer[]{1, 2, 3, 42});
        this.dropPartition(FIRST_TABLE, "col", "f");
        Assertions.assertThat(this.getPartitionValues(FIRST_TABLE)).containsOnly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat(this.getValues(FIRST_TABLE)).containsOnly((Object[])new Integer[]{1, 2, 3});
    }

    private QueryResult dropPartition(String tableName, String partitionCol, String partition) {
        return QueryExecutor.query((String)String.format("CALL system.unregister_partition(\n    schema_name => '%s',\n    table_name => '%s',\n    partition_columns => ARRAY['%s'],\n    partition_values => ARRAY['%s'])", "default", tableName, partitionCol, partition), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private QueryResult addPartition(String tableName, String partitionCol, String partition, String location) {
        return QueryExecutor.query((String)String.format("CALL system.register_partition(\n    schema_name => '%s',\n    table_name => '%s',\n    partition_columns => ARRAY['%s'],\n    partition_values => ARRAY['%s'],\n    location => '%s')", "default", tableName, partitionCol, partition, location), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private QueryResult addPartition(String tableName, String partitionCol, String partition) {
        return QueryExecutor.query((String)String.format("CALL system.register_partition(\n    schema_name => '%s',\n    table_name => '%s',\n    partition_columns => ARRAY['%s'],\n    partition_values => ARRAY['%s'])", "default", tableName, partitionCol, partition), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private void createDanglingLocationWithData(String path, String tableName) {
        this.hdfsClient.createDirectory(path);
        HiveDataSource dataSource = InlineDataSource.createResourceDataSource((String)tableName, (String)"io/trino/tests/hive/data/single_int_column/data.textfile");
        this.hdfsDataSourceWriter.ensureDataOnHdfs(path, dataSource);
    }

    private static void createPartitionedTable(String tableName) {
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("CREATE TABLE " + tableName + " (val int, col varchar) WITH (format = 'TEXTFILE', partitioned_by = ARRAY['col'])"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("INSERT INTO " + tableName + " VALUES (1, 'a'), (2, 'b'), (3, 'c')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private static void createView(String viewName, String tableName) {
        QueryExecutor.query((String)("DROP VIEW IF EXISTS " + viewName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("CREATE VIEW %s AS SELECT val, col FROM %s", viewName, tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private static void createUnpartitionedTable(String tableName) {
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("CREATE TABLE " + tableName + " (val int, col varchar) WITH (format = 'TEXTFILE')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("INSERT INTO " + tableName + " VALUES (1, 'a'), (2, 'b'), (3, 'c')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private Long getTableCount(String tableName) {
        QueryResult countResult = QueryExecutor.query((String)("SELECT count(*) FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        return (Long)countResult.row(0).get(0);
    }

    private Set<String> getPartitionValues(String tableName) {
        return QueryExecutor.query((String)("SELECT col FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]).rows().stream().map(row -> row.get(0)).map(String.class::cast).collect(Collectors.toSet());
    }

    private Set<Integer> getValues(String tableName) {
        return (Set)QueryExecutor.query((String)("SELECT val FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]).column(1).stream().map(Integer.class::cast).collect(ImmutableSet.toImmutableSet());
    }
}

